/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-12 11:31:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `ac_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=177 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4279 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_cky_banners` (
  `banner_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL DEFAULT 0,
  `settings` longtext NOT NULL DEFAULT '',
  `banner_default` int(11) NOT NULL DEFAULT 0,
  `contents` longtext NOT NULL DEFAULT '',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`banner_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cky_cookies` (
  `cookie_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(190) NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `description` longtext NOT NULL DEFAULT '',
  `duration` text NOT NULL DEFAULT '',
  `domain` varchar(190) NOT NULL DEFAULT '',
  `category` bigint(20) NOT NULL,
  `type` text NOT NULL DEFAULT '',
  `discovered` int(11) NOT NULL DEFAULT 0,
  `url_pattern` varchar(190) DEFAULT '',
  `meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`cookie_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cky_cookie_categories` (
  `category_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL DEFAULT '',
  `slug` varchar(190) NOT NULL DEFAULT '',
  `description` longtext NOT NULL DEFAULT '',
  `prior_consent` int(11) NOT NULL DEFAULT 0,
  `visibility` int(11) NOT NULL DEFAULT 1,
  `priority` int(11) NOT NULL DEFAULT 0,
  `sell_personal_data` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT '',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `slug` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cli_cookie_scan` (
  `id_cli_cookie_scan` int(11) NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` int(11) NOT NULL DEFAULT 0,
  `total_url` int(11) NOT NULL DEFAULT 0,
  `total_cookies` int(11) NOT NULL DEFAULT 0,
  `current_action` varchar(50) NOT NULL,
  `current_offset` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_cli_cookie_scan`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cli_cookie_scan_categories` (
  `id_cli_cookie_category` int(11) NOT NULL AUTO_INCREMENT,
  `cli_cookie_category_name` varchar(100) NOT NULL,
  `cli_cookie_category_description` text DEFAULT NULL,
  PRIMARY KEY (`id_cli_cookie_category`),
  UNIQUE KEY `cookie` (`cli_cookie_category_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cli_cookie_scan_cookies` (
  `id_cli_cookie_scan_cookies` int(11) NOT NULL AUTO_INCREMENT,
  `id_cli_cookie_scan` int(11) NOT NULL DEFAULT 0,
  `id_cli_cookie_scan_url` int(11) NOT NULL DEFAULT 0,
  `cookie_id` varchar(255) NOT NULL,
  `expiry` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `category_id` int(11) NOT NULL,
  `description` text DEFAULT '',
  PRIMARY KEY (`id_cli_cookie_scan_cookies`),
  UNIQUE KEY `cookie` (`id_cli_cookie_scan`,`cookie_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `ac_cli_cookie_scan_cookies_ibfk_1` FOREIGN KEY (`category_id`) REFERENCES `ac_cli_cookie_scan_categories` (`id_cli_cookie_category`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cli_cookie_scan_url` (
  `id_cli_cookie_scan_url` int(11) NOT NULL AUTO_INCREMENT,
  `id_cli_cookie_scan` int(11) NOT NULL DEFAULT 0,
  `url` text NOT NULL,
  `scanned` int(11) NOT NULL DEFAULT 0,
  `total_cookies` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id_cli_cookie_scan_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_cli_scripts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cliscript_title` text NOT NULL,
  `cliscript_category` varchar(100) NOT NULL,
  `cliscript_type` int(11) DEFAULT 0,
  `cliscript_status` varchar(100) NOT NULL,
  `cliscript_description` longtext NOT NULL,
  `cliscript_key` varchar(100) NOT NULL,
  `type` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_duplicator_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `sub_type` varchar(100) NOT NULL,
  `severity` int(8) NOT NULL,
  `title` text NOT NULL,
  `data` longtext NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `sub_type_idx` (`sub_type`),
  KEY `severity_idx` (`severity`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_duplicator_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `archive_name` varchar(350) NOT NULL DEFAULT '',
  `status` int(11) NOT NULL,
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE','TEMPORARY') NOT NULL DEFAULT '',
  `package` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`(191)),
  KEY `archive_name` (`archive_name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_duplicator_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `value_1` varchar(255) NOT NULL DEFAULT '',
  `value_2` varchar(255) NOT NULL DEFAULT '',
  `value_3` varchar(255) NOT NULL DEFAULT '',
  `value_4` varchar(255) NOT NULL DEFAULT '',
  `value_5` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `version` varchar(30) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`(191)),
  KEY `value_2` (`value_2`(191)),
  KEY `value_3` (`value_3`(191)),
  KEY `value_4` (`value_4`(191)),
  KEY `value_5` (`value_5`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_cache` (
  `feed_id` varchar(20) NOT NULL,
  `last_update` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `errors` blob DEFAULT NULL,
  `settings` blob DEFAULT NULL,
  `enabled` tinyint(1) DEFAULT 0,
  `system_enabled` tinyint(1) DEFAULT 1,
  `changed_time` int(11) DEFAULT 0,
  `cache_lifetime` int(11) DEFAULT 60,
  `send_email` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`feed_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_comments` (
  `id` varchar(50) NOT NULL,
  `post_id` varchar(50) NOT NULL,
  `from` blob DEFAULT NULL,
  `text` longblob DEFAULT NULL,
  `created_time` int(11) DEFAULT NULL,
  `updated_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_image_cache` (
  `url` varchar(50) NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `creation_time` timestamp NOT NULL DEFAULT current_timestamp(),
  `original_url` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_options` (
  `id` varchar(50) NOT NULL,
  `value` longblob DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_posts` (
  `feed_id` varchar(20) NOT NULL,
  `post_id` varchar(50) NOT NULL,
  `post_type` varchar(10) NOT NULL,
  `post_text` blob DEFAULT NULL,
  `post_permalink` varchar(300) DEFAULT NULL,
  `post_header` varchar(200) DEFAULT NULL,
  `user_nickname` varchar(100) DEFAULT NULL,
  `user_screenname` varchar(200) DEFAULT NULL,
  `user_pic` varchar(300) NOT NULL,
  `user_link` varchar(300) DEFAULT NULL,
  `rand_order` double DEFAULT NULL,
  `creation_index` int(11) NOT NULL DEFAULT 0,
  `image_url` text DEFAULT NULL,
  `image_width` int(11) DEFAULT NULL,
  `image_height` int(11) DEFAULT NULL,
  `media_url` text DEFAULT NULL,
  `media_width` int(11) DEFAULT NULL,
  `media_height` int(11) DEFAULT NULL,
  `media_type` varchar(100) DEFAULT NULL,
  `post_timestamp` int(11) DEFAULT NULL,
  `smart_order` int(11) DEFAULT NULL,
  `post_status` varchar(15) DEFAULT NULL,
  `post_source` varchar(300) DEFAULT NULL,
  `post_additional` varchar(300) DEFAULT NULL,
  `user_bio` text DEFAULT NULL,
  `user_counts_media` int(11) DEFAULT NULL,
  `user_counts_follows` int(11) DEFAULT NULL,
  `user_counts_followed_by` int(11) DEFAULT NULL,
  `location` varchar(300) DEFAULT NULL,
  `carousel_size` int(11) DEFAULT NULL,
  PRIMARY KEY (`post_id`,`post_type`,`feed_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_post_media` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(20) NOT NULL,
  `post_id` varchar(50) NOT NULL,
  `post_type` varchar(10) NOT NULL,
  `media_url` text DEFAULT NULL,
  `media_width` int(11) DEFAULT NULL,
  `media_height` int(11) DEFAULT NULL,
  `media_type` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_snapshots` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` varchar(20) DEFAULT NULL,
  `creation_time` timestamp NOT NULL DEFAULT current_timestamp(),
  `settings` longtext NOT NULL,
  `fb_settings` longtext DEFAULT NULL,
  `version` varchar(10) NOT NULL DEFAULT '2.0',
  `dump` blob DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_streams` (
  `id` int(11) NOT NULL,
  `name` varchar(250) DEFAULT NULL,
  `value` longblob DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_ff_streams_sources` (
  `feed_id` varchar(20) NOT NULL,
  `stream_id` int(11) NOT NULL,
  PRIMARY KEY (`feed_id`,`stream_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ac_FinalTiles_gallery` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `configuration` varchar(5000) DEFAULT NULL,
  UNIQUE KEY `Id` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_FinalTiles_gallery_images` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `gid` int(11) NOT NULL,
  `type` varchar(10) NOT NULL DEFAULT 'image',
  `imageId` int(11) NOT NULL,
  `imagePath` longtext NOT NULL,
  `filters` varchar(1500) DEFAULT NULL,
  `link` longtext DEFAULT NULL,
  `title` longtext DEFAULT NULL,
  `target` varchar(50) DEFAULT NULL,
  `blank` enum('T','F') NOT NULL DEFAULT 'F',
  `description` longtext NOT NULL,
  `sortOrder` int(11) NOT NULL,
  `group` text DEFAULT NULL,
  `hidden` enum('T','F') NOT NULL DEFAULT 'F',
  `alt` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`Id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(127) NOT NULL,
  `type` varchar(100) NOT NULL,
  `mail` longtext NOT NULL,
  `form_front` longtext NOT NULL,
  `theme` int(11) NOT NULL,
  `javascript` text NOT NULL,
  `submit_text` longtext NOT NULL,
  `url` varchar(200) NOT NULL,
  `submit_text_type` tinyint(4) NOT NULL,
  `script_mail` text NOT NULL,
  `script_mail_user` text NOT NULL,
  `counter` int(11) NOT NULL,
  `published` int(11) NOT NULL DEFAULT 1,
  `label_order` longtext NOT NULL,
  `label_order_current` longtext NOT NULL,
  `article_id` varchar(500) NOT NULL,
  `pagination` varchar(128) NOT NULL,
  `show_title` varchar(128) NOT NULL,
  `show_numbers` varchar(128) NOT NULL,
  `public_key` varchar(50) NOT NULL,
  `private_key` varchar(50) NOT NULL,
  `recaptcha_theme` varchar(20) NOT NULL,
  `paypal_mode` int(2) NOT NULL,
  `checkout_mode` varchar(20) NOT NULL,
  `paypal_email` varchar(50) NOT NULL,
  `payment_currency` varchar(20) NOT NULL,
  `tax` float NOT NULL,
  `form_fields` longtext NOT NULL,
  `savedb` tinyint(4) NOT NULL DEFAULT 1,
  `sendemail` tinyint(4) NOT NULL DEFAULT 1,
  `requiredmark` varchar(20) NOT NULL DEFAULT '*',
  `from_mail` varchar(128) NOT NULL,
  `from_name` varchar(128) NOT NULL,
  `reply_to` varchar(128) NOT NULL,
  `send_to` varchar(128) NOT NULL,
  `autogen_layout` tinyint(4) NOT NULL DEFAULT 1,
  `custom_front` longtext NOT NULL,
  `mail_from_user` varchar(128) NOT NULL,
  `mail_from_name_user` varchar(128) NOT NULL,
  `reply_to_user` varchar(128) NOT NULL,
  `condition` text NOT NULL,
  `mail_cc` varchar(128) NOT NULL,
  `mail_cc_user` varchar(128) NOT NULL,
  `mail_bcc` varchar(128) NOT NULL,
  `mail_bcc_user` varchar(128) NOT NULL,
  `mail_subject` varchar(128) NOT NULL,
  `mail_subject_user` varchar(128) NOT NULL,
  `mail_mode` tinyint(4) NOT NULL DEFAULT 1,
  `mail_mode_user` tinyint(4) NOT NULL DEFAULT 1,
  `mail_attachment` tinyint(4) NOT NULL DEFAULT 1,
  `mail_attachment_user` tinyint(4) NOT NULL DEFAULT 1,
  `user_id_wd` varchar(220) NOT NULL,
  `sortable` int(11) NOT NULL,
  `frontend_submit_fields` text NOT NULL,
  `frontend_submit_stat_fields` text NOT NULL,
  `mail_emptyfields` tinyint(4) NOT NULL DEFAULT 0,
  `mail_verify` tinyint(4) NOT NULL DEFAULT 0,
  `mail_verify_expiretime` float NOT NULL,
  `mail_verification_post_id` int(11) NOT NULL,
  `save_uploads` tinyint(4) NOT NULL DEFAULT 1,
  `header_title` varchar(255) NOT NULL,
  `header_description` text NOT NULL,
  `header_image_url` varchar(255) NOT NULL,
  `header_image_animation` varchar(200) NOT NULL,
  `header_hide_image` tinyint(4) NOT NULL DEFAULT 1,
  `jsversion` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_backup` (
  `backup_id` int(11) NOT NULL AUTO_INCREMENT,
  `cur` int(1) NOT NULL,
  `id` int(11) NOT NULL,
  `title` varchar(127) NOT NULL,
  `type` varchar(100) NOT NULL,
  `mail` varchar(128) NOT NULL,
  `form_front` longtext NOT NULL,
  `theme` int(11) NOT NULL,
  `javascript` text NOT NULL,
  `submit_text` longtext NOT NULL,
  `url` varchar(200) NOT NULL,
  `submit_text_type` tinyint(4) NOT NULL,
  `script_mail` text NOT NULL,
  `script_mail_user` text NOT NULL,
  `counter` int(11) NOT NULL,
  `published` int(11) NOT NULL DEFAULT 1,
  `label_order` longtext NOT NULL,
  `label_order_current` longtext NOT NULL,
  `article_id` varchar(500) NOT NULL,
  `pagination` varchar(128) NOT NULL,
  `show_title` varchar(128) NOT NULL,
  `show_numbers` varchar(128) NOT NULL,
  `public_key` varchar(50) NOT NULL,
  `private_key` varchar(50) NOT NULL,
  `recaptcha_theme` varchar(20) NOT NULL,
  `paypal_mode` int(2) NOT NULL,
  `checkout_mode` varchar(20) NOT NULL,
  `paypal_email` varchar(50) NOT NULL,
  `payment_currency` varchar(20) NOT NULL,
  `tax` float NOT NULL,
  `form_fields` longtext NOT NULL,
  `savedb` tinyint(4) NOT NULL DEFAULT 1,
  `sendemail` tinyint(4) NOT NULL DEFAULT 1,
  `requiredmark` varchar(20) NOT NULL DEFAULT '*',
  `from_mail` varchar(128) NOT NULL,
  `from_name` varchar(128) NOT NULL,
  `reply_to` varchar(128) NOT NULL,
  `send_to` varchar(128) NOT NULL,
  `autogen_layout` tinyint(4) NOT NULL DEFAULT 1,
  `custom_front` longtext NOT NULL,
  `mail_from_user` varchar(128) NOT NULL,
  `mail_from_name_user` varchar(128) NOT NULL,
  `reply_to_user` varchar(128) NOT NULL,
  `condition` text NOT NULL,
  `mail_cc` varchar(128) NOT NULL,
  `mail_cc_user` varchar(128) NOT NULL,
  `mail_bcc` varchar(128) NOT NULL,
  `mail_bcc_user` varchar(128) NOT NULL,
  `mail_subject` varchar(128) NOT NULL,
  `mail_subject_user` varchar(128) NOT NULL,
  `mail_mode` tinyint(4) NOT NULL DEFAULT 1,
  `mail_mode_user` tinyint(4) NOT NULL DEFAULT 1,
  `mail_attachment` tinyint(4) NOT NULL DEFAULT 1,
  `mail_attachment_user` tinyint(4) NOT NULL DEFAULT 1,
  `user_id_wd` varchar(220) NOT NULL,
  `sortable` int(11) NOT NULL,
  `frontend_submit_fields` text NOT NULL,
  `frontend_submit_stat_fields` text NOT NULL,
  `mail_emptyfields` tinyint(4) NOT NULL DEFAULT 0,
  `mail_verify` tinyint(4) NOT NULL DEFAULT 0,
  `mail_verify_expiretime` float NOT NULL,
  `mail_verification_post_id` int(11) NOT NULL,
  `save_uploads` tinyint(4) NOT NULL DEFAULT 1,
  `header_title` varchar(255) NOT NULL,
  `header_description` text NOT NULL,
  `header_image_url` varchar(255) NOT NULL,
  `header_image_animation` varchar(200) NOT NULL,
  `header_hide_image` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`backup_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_blocked` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_display_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `type` varchar(100) NOT NULL,
  `popover_animate_effect` varchar(255) NOT NULL,
  `popover_loading_delay` int(11) NOT NULL,
  `popover_frequency` int(4) NOT NULL,
  `topbar_position` tinyint(4) NOT NULL,
  `topbar_remain_top` tinyint(4) NOT NULL,
  `topbar_closing` tinyint(4) NOT NULL,
  `topbar_hide_duration` int(4) NOT NULL,
  `scrollbox_position` tinyint(4) NOT NULL,
  `scrollbox_trigger_point` float NOT NULL,
  `scrollbox_hide_duration` int(4) NOT NULL,
  `scrollbox_auto_hide` tinyint(4) NOT NULL,
  `scrollbox_closing` tinyint(4) NOT NULL DEFAULT 1,
  `scrollbox_minimize` tinyint(4) NOT NULL,
  `scrollbox_minimize_text` varchar(300) NOT NULL,
  `display_on` text NOT NULL,
  `posts_include` text NOT NULL,
  `pages_include` text NOT NULL,
  `display_on_categories` text NOT NULL,
  `current_categories` text NOT NULL,
  `scrollbox_loading_delay` tinyint(4) NOT NULL,
  `hide_mobile` tinyint(4) NOT NULL DEFAULT 1,
  `show_for_admin` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_query` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `query` text NOT NULL,
  `details` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_sessions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(20) NOT NULL,
  `group_id` int(20) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `ord_date` datetime NOT NULL,
  `ord_last_modified` datetime NOT NULL,
  `status` varchar(50) NOT NULL,
  `full_name` varchar(100) NOT NULL,
  `email` varchar(50) NOT NULL,
  `phone` varchar(50) NOT NULL,
  `mobile_phone` varchar(255) NOT NULL,
  `fax` varchar(255) NOT NULL,
  `address` varchar(300) NOT NULL,
  `paypal_info` text NOT NULL,
  `without_paypal_info` text NOT NULL,
  `ipn` varchar(20) NOT NULL,
  `checkout_method` varchar(20) NOT NULL,
  `tax` float NOT NULL,
  `shipping` float NOT NULL,
  `shipping_type` varchar(200) NOT NULL,
  `read` int(11) NOT NULL,
  `total` float NOT NULL,
  `currency` varchar(24) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_submits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `element_label` varchar(128) NOT NULL,
  `element_value` longtext NOT NULL,
  `group_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `ip` varchar(128) NOT NULL,
  `user_id_wd` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `css` text NOT NULL,
  `default` tinyint(4) NOT NULL,
  `version` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_formmaker_views` (
  `form_id` int(11) NOT NULL,
  `views` int(50) NOT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `author` int(10) NOT NULL DEFAULT 0,
  `name` varchar(100) DEFAULT '',
  `slug` varchar(100) DEFAULT '',
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT 0,
  `schedule_end` int(10) NOT NULL DEFAULT 0,
  `flag_hidden` tinyint(1) NOT NULL DEFAULT 0,
  `flag_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `flag_popup` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT 0,
  `data` mediumtext NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=723145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_photoblocks` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `name` tinytext NOT NULL,
  `data` longtext DEFAULT NULL,
  `blocks` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8523 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4274 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_shepherd_tec_tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `class_hash` varchar(191) NOT NULL,
  `args_hash` varchar(191) NOT NULL,
  `data` text DEFAULT NULL,
  `current_try` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action_id` (`action_id`),
  KEY `class_hash` (`class_hash`),
  KEY `args_hash` (`args_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_shepherd_tec_task_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) unsigned NOT NULL,
  `action_id` bigint(20) unsigned NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `level` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `entry` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `action_id` (`action_id`),
  KEY `level` (`level`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_tec_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` varchar(19) NOT NULL,
  `end_date` varchar(19) DEFAULT NULL,
  `timezone` varchar(30) NOT NULL DEFAULT 'UTC',
  `start_date_utc` varchar(19) NOT NULL,
  `end_date_utc` varchar(19) DEFAULT NULL,
  `duration` mediumint(30) DEFAULT 7200,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `hash` varchar(40) NOT NULL,
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_tec_kv_cache` (
  `cache_key` varchar(191) NOT NULL,
  `value` longtext DEFAULT NULL,
  `expiration` bigint(20) unsigned DEFAULT 0,
  PRIMARY KEY (`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_tec_occurrences` (
  `occurrence_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` datetime NOT NULL,
  `start_date_utc` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `end_date_utc` datetime NOT NULL,
  `duration` mediumint(30) DEFAULT 7200,
  `hash` varchar(40) NOT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`occurrence_id`),
  UNIQUE KEY `hash` (`hash`),
  KEY `event_id` (`event_id`),
  KEY `idx_wp_tec_occurrences_post_id_dates` (`post_id`,`end_date`,`start_date`),
  KEY `idx_wp_tec_occurrences_post_id_dates_utc` (`post_id`,`end_date_utc`,`start_date_utc`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `ac_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_wd_fb_data` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fb_id` int(11) NOT NULL,
  `from` varchar(32) NOT NULL,
  `object_id` varchar(64) NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `type` varchar(32) NOT NULL,
  `message` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL,
  `story` mediumtext NOT NULL,
  `place` mediumtext NOT NULL,
  `message_tags` mediumtext NOT NULL,
  `with_tags` mediumtext NOT NULL,
  `story_tags` mediumtext NOT NULL,
  `status_type` mediumtext NOT NULL,
  `link` mediumtext NOT NULL,
  `source` mediumtext NOT NULL,
  `thumb_url` varchar(512) NOT NULL,
  `main_url` varchar(512) NOT NULL,
  `width` varchar(32) NOT NULL,
  `height` varchar(32) NOT NULL,
  `created_time` varchar(64) NOT NULL,
  `updated_time` varchar(64) NOT NULL,
  `created_time_number` bigint(255) NOT NULL,
  `reactions` text NOT NULL,
  `comments` text NOT NULL,
  `shares` text NOT NULL,
  `attachments` text NOT NULL,
  `who_post` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wd_fb_info` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(10) NOT NULL,
  `content_type` varchar(15) NOT NULL,
  `content` varchar(256) NOT NULL,
  `content_url` varchar(512) NOT NULL,
  `timeline_type` varchar(16) NOT NULL,
  `from` varchar(32) NOT NULL,
  `limit` int(11) NOT NULL,
  `app_id` varchar(128) NOT NULL,
  `app_secret` varchar(256) NOT NULL,
  `exist_access` tinyint(1) NOT NULL,
  `access_token` varchar(256) NOT NULL,
  `order` bigint(20) DEFAULT NULL,
  `published` tinyint(1) NOT NULL,
  `update_mode` varchar(16) NOT NULL,
  `fb_view_type` varchar(25) NOT NULL,
  `theme` int(11) DEFAULT NULL,
  `masonry_hor_ver` varchar(255) DEFAULT NULL,
  `image_max_columns` int(11) DEFAULT NULL,
  `thumb_width` int(11) DEFAULT NULL,
  `thumb_height` int(11) DEFAULT NULL,
  `thumb_comments` int(11) DEFAULT NULL,
  `thumb_likes` int(11) DEFAULT NULL,
  `thumb_name` int(11) DEFAULT NULL,
  `blog_style_width` int(11) DEFAULT NULL,
  `blog_style_height` varchar(15) DEFAULT NULL,
  `blog_style_view_type` int(11) DEFAULT NULL,
  `blog_style_comments` int(11) DEFAULT NULL,
  `blog_style_likes` int(11) DEFAULT NULL,
  `blog_style_message_desc` int(11) DEFAULT NULL,
  `blog_style_shares` int(11) DEFAULT NULL,
  `blog_style_shares_butt` int(11) DEFAULT NULL,
  `blog_style_facebook` int(11) DEFAULT NULL,
  `blog_style_twitter` int(11) DEFAULT NULL,
  `blog_style_google` int(11) DEFAULT NULL,
  `blog_style_author` int(11) DEFAULT NULL,
  `blog_style_name` int(11) DEFAULT NULL,
  `blog_style_place_name` int(11) DEFAULT NULL,
  `fb_name` int(11) DEFAULT NULL,
  `fb_plugin` int(11) DEFAULT NULL,
  `album_max_columns` int(11) DEFAULT NULL,
  `album_title` varchar(15) DEFAULT NULL,
  `album_thumb_width` int(11) DEFAULT NULL,
  `album_thumb_height` int(11) DEFAULT NULL,
  `album_image_max_columns` int(11) DEFAULT NULL,
  `album_image_thumb_width` int(11) DEFAULT NULL,
  `album_image_thumb_height` int(11) DEFAULT NULL,
  `pagination_type` int(11) DEFAULT NULL,
  `objects_per_page` int(11) DEFAULT NULL,
  `popup_fullscreen` int(11) DEFAULT NULL,
  `popup_width` int(11) NOT NULL,
  `popup_height` int(11) DEFAULT NULL,
  `popup_effect` varchar(255) DEFAULT NULL,
  `popup_autoplay` int(11) DEFAULT NULL,
  `open_commentbox` int(11) DEFAULT NULL,
  `popup_interval` int(11) DEFAULT NULL,
  `popup_enable_filmstrip` int(11) DEFAULT NULL,
  `popup_filmstrip_height` int(11) DEFAULT NULL,
  `popup_comments` int(11) DEFAULT NULL,
  `popup_likes` int(11) DEFAULT NULL,
  `popup_shares` int(11) DEFAULT NULL,
  `popup_author` int(11) DEFAULT NULL,
  `popup_name` int(11) DEFAULT NULL,
  `popup_place_name` int(11) DEFAULT NULL,
  `popup_enable_ctrl_btn` int(11) DEFAULT NULL,
  `popup_enable_fullscreen` int(11) DEFAULT NULL,
  `popup_enable_info_btn` int(11) DEFAULT NULL,
  `popup_message_desc` int(11) DEFAULT NULL,
  `popup_enable_facebook` int(11) DEFAULT NULL,
  `popup_enable_twitter` int(11) DEFAULT NULL,
  `popup_enable_google` int(11) DEFAULT NULL,
  `view_on_fb` tinyint(1) NOT NULL,
  `post_text_length` bigint(20) NOT NULL,
  `event_street` tinyint(1) NOT NULL,
  `event_city` tinyint(1) NOT NULL,
  `event_country` tinyint(1) NOT NULL,
  `event_zip` tinyint(1) NOT NULL,
  `event_map` tinyint(1) NOT NULL,
  `event_date` tinyint(1) NOT NULL,
  `event_desp_length` bigint(20) NOT NULL,
  `comments_replies` tinyint(1) NOT NULL,
  `comments_filter` varchar(32) NOT NULL,
  `comments_order` varchar(32) NOT NULL,
  `page_plugin_pos` varchar(8) NOT NULL,
  `page_plugin_fans` tinyint(1) NOT NULL,
  `page_plugin_cover` tinyint(1) NOT NULL,
  `page_plugin_header` tinyint(1) NOT NULL,
  `page_plugin_width` int(4) NOT NULL,
  `image_onclick_action` varchar(32) NOT NULL,
  `event_order` tinyint(4) NOT NULL,
  `upcoming_events` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wd_fb_option` (
  `id` bigint(20) NOT NULL,
  `autoupdate_interval` int(4) NOT NULL,
  `app_id` varchar(255) NOT NULL,
  `app_secret` varchar(255) NOT NULL,
  `access_token` varchar(255) NOT NULL,
  `date_timezone` varchar(64) NOT NULL,
  `post_date_format` varchar(64) NOT NULL,
  `event_date_format` varchar(64) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wd_fb_shortcode` (
  `id` bigint(20) NOT NULL,
  `tagtext` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wd_fb_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `params` longtext DEFAULT NULL,
  `default_theme` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=172943 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=10258 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11417 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=1736 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=88457 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_wpgdprc_consents` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `site_id` bigint(20) NOT NULL,
  `title` text NOT NULL,
  `description` longtext NOT NULL,
  `snippet` longtext NOT NULL,
  `wrap` tinyint(1) NOT NULL DEFAULT 1,
  `placement` varchar(20) NOT NULL,
  `plugins` longtext NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `date_modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00' ON UPDATE current_timestamp(),
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=507 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE IF NOT EXISTS `ac_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `ac_users` VALUES 
("1","root","$wp$2y$10$PWX9jgJx9Cdc/laAcwsaLOD0gnqWXlmXY7pVyh5Dp96mjawd8whm2","root","davidrgb@hotmail.com","","2018-05-05 10:02:56","","0","root"),
("4","admin","$P$Bp2rsgjXg1f.Szs/gQuX3h07qk65bs1","admin","anec.cullera.oficial@gmail.com","","2018-05-31 10:51:55","","0","ANEC Cullera");

INSERT IGNORE INTO `ac_usermeta` VALUES 
("1","1","nickname","root"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","ac_user_level","10"),
("14","1","dismissed_wp_pointers","wp496_privacy"),
("15","1","show_welcome_panel","0"),
("17","1","ac_dashboard_quick_press_last_post_id","4273"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"92.58.202.0\";}"),
("19","1","_woocommerce_persistent_cart_1","a:1:{s:4:\"cart\";a:0:{}}"),
("21","1","dismissed_install_notice","1"),
("22","1","ls-show-support-notice-timestamp","1527261932"),
("23","1","ls-store-last-viewed","2018-05-08"),
("24","1","layerslider_help_wp_pointer","1"),
("25","1","wpseo-dismiss-configuration-notice","yes"),
("56","1","_yoast_wpseo_profile_updated","1525777456"),
("57","1","nav_menu_recently_edited","29"),
("58","1","managenav-menuscolumnshidden","a:4:{i:0;s:15:\"title-attribute\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";}"),
("59","1","metaboxhidden_nav-menus","a:11:{i:0;s:21:\"add-post-type-product\";i:1;s:21:\"add-post-type-project\";i:2;s:21:\"add-post-type-profile\";i:3;s:26:\"add-post-type-tribe_events\";i:4;s:12:\"add-post_tag\";i:5;s:15:\"add-post_format\";i:6;s:15:\"add-product_cat\";i:7;s:15:\"add-product_tag\";i:8;s:13:\"add-pj-categs\";i:9;s:11:\"add-pj-tags\";i:10;s:13:\"add-pl-categs\";}"),
("60","1","tribe_setDefaultNavMenuBoxes","1"),
("61","1","tgmpa_dismissed_notice_cmsmasters","1"),
("62","1","ac_user-settings","libraryContent=browse&editor=html&hidetb=1&align=none&advImgDetails=show&imgsize=full"),
("63","1","ac_user-settings-time","1753781180"),
("64","1","tribe-dismiss-notice","archive-slug-conflict"),
("70","4","nickname","admin"),
("71","4","first_name","ANEC"),
("72","4","last_name","Cullera"),
("73","4","description",""),
("74","4","rich_editing","true"),
("75","4","syntax_highlighting","true"),
("76","4","comment_shortcuts","false"),
("77","4","admin_color","fresh"),
("78","4","use_ssl","0"),
("79","4","show_admin_bar_front","true"),
("80","4","locale",""),
("81","4","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("82","4","ac_user_level","10"),
("83","4","dismissed_wp_pointers","wp496_privacy"),
("84","1","tribe-dismiss-notice","tribe-events-utc-timezone"),
("85","1","tribe-dismiss-notice","tribe-events-upcoming-survey"),
("88","1","tribe-dismiss-notice","tribe-events-gutenberg"),
("91","1","show_try_gutenberg_panel","0"),
("92","1","closedpostboxes_dashboard","a:2:{i:0;s:32:\"wordfence_activity_report_widget\";i:1;s:22:\"tribe_dashboard_widget\";}"),
("93","1","metaboxhidden_dashboard","a:0:{}"),
("94","5","nickname","t2trollherten"),
("95","5","first_name",""),
("96","5","last_name",""),
("97","5","description",""),
("98","5","rich_editing","true"),
("99","5","syntax_highlighting","true"),
("100","5","comment_shortcuts","false"),
("101","5","admin_color","fresh"),
("102","5","use_ssl","0"),
("103","5","show_admin_bar_front","true"),
("104","5","locale",""),
("105","5","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("106","5","ac_user_level","10"),
("107","5","default_password_nag",""),
("108","6","nickname","t3trollherten"),
("109","6","first_name",""),
("110","6","last_name",""),
("111","6","description",""),
("112","6","rich_editing","true"),
("113","6","syntax_highlighting","true"),
("114","6","comment_shortcuts","false"),
("115","6","admin_color","fresh"),
("116","6","use_ssl","0"),
("117","6","show_admin_bar_front","true"),
("118","6","locale",""),
("119","6","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("120","6","ac_user_level","10"),
("121","6","default_password_nag","1"),
("122","5","session_tokens","a:2:{s:64:\"2b9fb6ce26784f3094435e61925dec826f2bfbbee81f3ae333ca716c57dd0d12\";a:4:{s:10:\"expiration\";i:1541870303;s:2:\"ip\";s:14:\"109.234.37.214\";s:2:\"ua\";s:109:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.143 Safari/537.36\";s:5:\"login\";i:1541697503;}s:64:\"d1ad0cb3501226fec7e056c8ccaa2a04bded4a35571ba0227b4b20ec54efa13f\";a:4:{s:10:\"expiration\";i:1541871382;s:2:\"ip\";s:14:\"109.234.37.214\";s:2:\"ua\";s:109:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.143 Safari/537.36\";s:5:\"login\";i:1541698582;}}"),
("123","7","nickname","bringasr"),
("124","7","first_name",""),
("125","7","last_name",""),
("126","7","description",""),
("127","7","rich_editing","true"),
("128","7","syntax_highlighting","true"),
("129","7","comment_shortcuts","false"),
("130","7","admin_color","fresh"),
("131","7","use_ssl","0"),
("132","7","show_admin_bar_front","true"),
("133","7","locale",""),
("134","7","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("135","7","ac_user_level","10"),
("136","7","default_password_nag","1"),
("137","8","nickname","recmytempla"),
("138","8","first_name",""),
("139","8","last_name",""),
("140","8","description",""),
("141","8","rich_editing","true"),
("142","8","syntax_highlighting","true"),
("143","8","comment_shortcuts","false"),
("144","8","admin_color","fresh"),
("145","8","use_ssl","0"),
("146","8","show_admin_bar_front","true"),
("147","8","locale",""),
("148","8","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("149","8","ac_user_level","10"),
("150","8","default_password_nag","1"),
("151","9","nickname","j1enifferulka"),
("152","9","first_name",""),
("153","9","last_name",""),
("154","9","description",""),
("155","9","rich_editing","true"),
("156","9","syntax_highlighting","true"),
("157","9","comment_shortcuts","false"),
("158","9","admin_color","fresh"),
("159","9","use_ssl","0"),
("160","9","show_admin_bar_front","true"),
("161","9","locale",""),
("162","9","ac_capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("163","9","ac_user_level","10"),
("164","9","default_password_nag",""),
("165","9","session_tokens","a:1:{s:64:\"b11b41f5c17a88b220d21564171be64a4ec25d01bb5f1e7574a42fb3984ce676\";a:4:{s:10:\"expiration\";i:1543323727;s:2:\"ip\";s:13:\"185.212.131.7\";s:2:\"ua\";s:109:\"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/36.0.1985.143 Safari/537.36\";s:5:\"login\";i:1543150927;}}"),
("169","1","wfls-last-captcha-score",""),
("171","1","wfls-last-login","1604044928"),
("173","4","session_tokens","a:1:{s:64:\"841f4043ffd6e7765cec26aebf754f7d222cea5ef1ebfb2b85a91d7fa18aa7dc\";a:4:{s:10:\"expiration\";i:1717667141;s:2:\"ip\";s:14:\"178.237.230.14\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.0.0 Safari/537.36\";s:5:\"login\";i:1716457541;}}"),
("174","1","session_tokens","a:1:{s:64:\"3289611c53b4e1c15354b83d6f51485600e4995876e1dda0f7a00395234442a2\";a:4:{s:10:\"expiration\";i:1765710511;s:2:\"ip\";s:13:\"92.58.202.159\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36\";s:5:\"login\";i:1765537711;}}"),
("175","4","ac_dashboard_quick_press_last_post_id","4202"),
("176","4","community-events-location","a:1:{s:2:\"ip\";s:13:\"178.237.230.0\";}");

INSERT IGNORE INTO `ac_actionscheduler_actions` VALUES 
("4275","tec_clear_expired_key_value_cache","pending","2025-12-12 23:26:58","2025-12-12 23:26:58","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765582018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765582018;}","1","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL),
("4276","action_scheduler/migration_hook","complete","2025-12-12 11:27:58","2025-12-12 11:27:58","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1765538878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1765538878;}","2","1","2025-12-12 11:28:01","2025-12-12 11:28:01","2",NULL),
("4277","action_scheduler_run_recurring_actions_schedule_hook","complete","2025-12-12 11:28:46","2025-12-12 11:28:46","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765538926;s:18:\"\0*\0first_timestamp\";i:1765538926;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765538926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","1","2025-12-12 11:28:58","2025-12-12 11:28:58","5",NULL),
("4278","action_scheduler_run_recurring_actions_schedule_hook","pending","2025-12-13 11:28:58","2025-12-13 11:28:58","20","[]","O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1765625338;s:18:\"\0*\0first_timestamp\";i:1765538926;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1765625338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}","3","0","0000-00-00 00:00:00","0000-00-00 00:00:00","0",NULL);

INSERT IGNORE INTO `ac_actionscheduler_groups` VALUES 
("1",""),
("2","action-scheduler-migration"),
("3","ActionScheduler");

INSERT IGNORE INTO `ac_actionscheduler_logs` VALUES 
("1","4275","action created","2025-12-12 11:26:58","2025-12-12 11:26:58"),
("2","4276","action created","2025-12-12 11:26:58","2025-12-12 11:26:58"),
("3","4276","action started via Async Request","2025-12-12 11:28:01","2025-12-12 11:28:01"),
("4","4276","action complete via Async Request","2025-12-12 11:28:01","2025-12-12 11:28:01"),
("5","4277","action created","2025-12-12 11:28:46","2025-12-12 11:28:46"),
("6","4277","action started via WP Cron","2025-12-12 11:28:58","2025-12-12 11:28:58"),
("7","4277","action complete via WP Cron","2025-12-12 11:28:58","2025-12-12 11:28:58"),
("8","4278","action created","2025-12-12 11:28:58","2025-12-12 11:28:58");

INSERT IGNORE INTO `ac_cky_banners` VALUES 
("1","GDPR","gdpr-1","1","{\"settings\":{\"id\":\"banner-1\",\"type\":\"box\",\"preferenceCenterType\":\"sidebar-left\",\"position\":\"bottom-left\",\"versionID\":\"6.0.0\",\"applicableLaw\":\"gdpr\",\"languages\":{\"default\":\"en\",\"selected\":[\"en\"]},\"templateGroup\":\"default\",\"customHtml\":{\"status\":false},\"theme\":\"light\",\"consentExpiry\":{\"status\":true,\"value\":\"365\"},\"ruleSet\":[{\"code\":\"ALL\",\"regions\":[]}]},\"behaviours\":{\"reloadBannerOnAccept\":{\"status\":false},\"loadAnalyticsByDefault\":{\"status\":false},\"animations\":{\"onLoad\":\"animate\",\"onHide\":\"sticky\"},\"legacyFunctions\":{\"accept\":{\"action\":\"acceptClose\",\"newTab\":false},\"reject\":{\"action\":\"rejectClose\",\"newTab\":false},\"idle\":{\"action\":\"acceptClose\",\"delay\":\"1000\"},\"navigation\":{\"action\":\"acceptClose\"},\"pageScroll\":{\"action\":\"acceptClose\"}},\"respectGPC\":{\"status\":false}},\"config\":{\"notice\":{\"status\":true,\"tag\":\"notice\",\"type\":\"container\",\"styles\":{\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"brandLogo\":{\"status\":false,\"tag\":\"brand-logo\",\"meta\":{\"url\":\"#\"}},\"buttons\":{\"status\":true,\"tag\":\"notice-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"settings\":{\"status\":true,\"tag\":\"settings-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"readMore\":{\"status\":false,\"tag\":\"readmore-button\",\"type\":\"link\",\"meta\":{\"noFollow\":true,\"newTab\":true},\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}},\"donotSell\":{\"status\":false,\"tag\":\"donotsell-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}}}},\"closeButton\":{\"status\":false,\"tag\":\"close-button\"}}},\"categoryPreview\":{\"status\":false,\"type\":\"container\",\"tag\":\"detail-category-preview\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-preview-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-preview-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-category-preview-buttons\",\"elements\":{\"save\":{\"status\":true,\"tag\":\"detail-category-preview-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}}}},\"preferenceCenter\":{\"status\":true,\"tag\":\"detail\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"closeButton\":{\"status\":true,\"type\":\"button\",\"tag\":\"detail-close\"},\"categories\":{\"status\":true,\"tag\":\"detail-categories\",\"type\":\"container\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-category-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"detail-accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"detail-reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"save\":{\"status\":true,\"tag\":\"detail-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"detail-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}}}},\"optoutPopup\":{\"status\":false,\"tag\":\"optout-popup\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"optout-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"optout-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"optOption\":{\"status\":true,\"tag\":\"optout-option\",\"type\":\"container\",\"elements\":{\"toggle\":{\"status\":true,\"tag\":\"optout-option-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863dc\"}},\"inactive\":{\"styles\":{\"background-color\":\"#FFFFFF\"}}}},\"title\":{\"type\":\"text\",\"tag\":\"optout-option-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"gpcOption\":{\"type\":\"container\",\"tag\":\"optout-gpc-option\",\"status\":false,\"elements\":{\"description\":{\"type\":\"text\",\"tag\":\"optout-gpc-option-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"optout-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}},\"buttons\":{\"status\":true,\"tag\":\"optout-buttons\",\"type\":\"container\",\"elements\":{\"confirm\":{\"status\":true,\"tag\":\"optout-confirm-button\",\"type\":\"button\",\"styles\":{\"color\":\"#f4f4f4\",\"background-color\":\"#1863dc\",\"border-color\":\"#1863dc\"}},\"cancel\":{\"status\":true,\"tag\":\"optout-cancel-button\",\"type\":\"button\",\"styles\":{\"color\":\"#858585\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#dedfe0\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"optout-close\",\"type\":\"button\"}}},\"auditTable\":{\"status\":true,\"tag\":\"audit-table\",\"type\":\"table\",\"meta\":{\"headers\":[\"id\",\"duration\",\"description\"]},\"styles\":{\"color\":\"#212121\",\"background-color\":\"#f4f4f4\",\"border-color\":\"#ebebeb\"}},\"revisitConsent\":{\"status\":false,\"tag\":\"revisit-consent\",\"position\":\"bottom-left\",\"meta\":{\"url\":\"#\"},\"styles\":{\"background-color\":\"#0056A7\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"revisit-consent-title\",\"status\":true,\"styles\":{\"color\":\"#0056a7\"}}}},\"videoPlaceholder\":{\"status\":true,\"tag\":\"video-placeholder\",\"styles\":{\"background-color\":\"#000000\",\"border-color\":\"#000000\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"placeholder-title\",\"status\":true,\"styles\":{\"color\":\"#ffffff\"}}}},\"accessibilityOverrides\":{\"status\":true,\"tag\":\"accessibility-overrides\",\"elements\":{\"preferenceCenter\":{\"elements\":{\"alwaysActive\":{\"status\":true,\"tag\":\"always-active\",\"styles\":{\"color\":\"#008000\"}},\"showMore\":{\"status\":true,\"tag\":\"show-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}},\"showLess\":{\"status\":true,\"tag\":\"hide-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}}}},\"optoutPopup\":{\"elements\":{\"showMore\":{\"status\":true,\"tag\":\"optout-show-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}},\"showLess\":{\"status\":true,\"tag\":\"optout-hide-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}}}},\"manualLinks\":{\"status\":true,\"tag\":\"manual-links\",\"type\":\"link\",\"styles\":{\"color\":\"#1863DC\"}}}}},\"meta\":{\"customCSS\":\"\",\"customHTML\":\"\"}}","1","{\"en\":{\"notice\":{\"elements\":{\"title\":\"Valoramos su privacidad\",\"description\":\"<p>We use cookies to enhance your browsing experience, serve personalised ads or content, and analyse our traffic. By clicking \\\"Accept All\\\", you consent to our use of cookies.<\\/p>\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Aceptar\",\"reject\":\"Rechazar\",\"settings\":\"Personalizar\",\"readMore\":\"Pol\\u00edtica de cookies\",\"donotSell\":\"Do Not Sell or Share My Personal Information\"}},\"closeButton\":\"Close\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Save My Preferences\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Preferencias cookies\",\"description\":\"<p>Utilizamos cookies para ayudarle a navegar eficientemente y realizar ciertas funciones. A continuaci\\u00f3n, encontrar\\u00e1 informaci\\u00f3n detallada sobre todas las cookies en cada categor\\u00eda de consentimiento.<\\/p>\\n<p>Las cookies categorizadas como \\\"Necesarias\\\" se almacenan en su navegador, ya que son esenciales para habilitar las funcionalidades b\\u00e1sicas del sitio.<\\/p>\\n<p>Tambi\\u00e9n utilizamos cookies de terceros que nos ayudan a analizar c\\u00f3mo utiliza este sitio web, almacenar sus preferencias y ofrecerle contenido y anuncios relevantes. Estas cookies solo se almacenar\\u00e1n en su navegador con su consentimiento previo.<\\/p>\\n<p>Puede habilitar o deshabilitar algunas o todas estas cookies, pero deshabilitar algunas de ellas puede afectar su experiencia de navegaci\\u00f3n.<\\/p>\",\"showMore\":\"mostrar m\\u00e1s\",\"showLess\":\"mostrar menos\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Siempre activas\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"buttons\":{\"elements\":{\"accept\":\"Aceptar\",\"save\":\"Guardar preferencias\",\"reject\":\"Rechazar\"}},\"closeButton\":\"Close\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Opt-out Preferences\",\"description\":\"<p>We use third-party cookies that help us analyse how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button. Once you opt out, you can opt in again at any time by unchecking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"Do Not Sell or Share My Personal Information\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>\"}},\"showLess\":\"Show less\",\"showMore\":\"Show more\",\"buttons\":{\"elements\":{\"cancel\":\"Cancel\",\"confirm\":\"Save My Preferences\"}},\"closeButton\":\"Close\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Preferencias cookies\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duraci\\u00f3n\",\"description\":\"Descripci\\u00f3n\"}},\"message\":\"No mostrar cookies\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Por favor acepte las cookies para acceder a este contenido\"}}}}","2025-07-29 09:00:27","2025-07-29 09:00:27"),
("2","CCPA","ccpa-2","0","{\"settings\":{\"id\":\"banner-1\",\"type\":\"box\",\"preferenceCenterType\":\"popup\",\"position\":\"bottom-left\",\"versionID\":\"6.0.0\",\"applicableLaw\":\"ccpa\",\"languages\":{\"default\":\"en\",\"selected\":[\"en\"]},\"templateGroup\":\"default\",\"customHtml\":{\"status\":false},\"theme\":\"light\",\"consentExpiry\":{\"status\":true,\"value\":\"365\"},\"ruleSet\":[{\"code\":\"ALL\",\"regions\":[]}]},\"behaviours\":{\"reloadBannerOnAccept\":{\"status\":false},\"loadAnalyticsByDefault\":{\"status\":false},\"animations\":{\"onLoad\":\"animate\",\"onHide\":\"sticky\"},\"legacyFunctions\":{\"accept\":{\"action\":\"acceptClose\",\"newTab\":false},\"reject\":{\"action\":\"rejectClose\",\"newTab\":false},\"idle\":{\"action\":\"acceptClose\",\"delay\":\"1000\"},\"navigation\":{\"action\":\"acceptClose\"},\"pageScroll\":{\"action\":\"acceptClose\"}},\"respectGPC\":{\"status\":false}},\"config\":{\"notice\":{\"status\":true,\"tag\":\"notice\",\"type\":\"container\",\"styles\":{\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"brandLogo\":{\"status\":false,\"tag\":\"brand-logo\",\"meta\":{\"url\":\"#\"}},\"buttons\":{\"status\":true,\"tag\":\"notice-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":false,\"tag\":\"accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":false,\"tag\":\"reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"settings\":{\"status\":false,\"tag\":\"settings-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"readMore\":{\"status\":false,\"tag\":\"readmore-button\",\"type\":\"link\",\"meta\":{\"noFollow\":true,\"newTab\":true},\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}},\"donotSell\":{\"status\":true,\"tag\":\"donotsell-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"transparent\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"close-button\"}}},\"categoryPreview\":{\"status\":false,\"type\":\"container\",\"tag\":\"detail-category-preview\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-preview-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-preview-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-category-preview-buttons\",\"elements\":{\"save\":{\"status\":true,\"tag\":\"detail-category-preview-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}}}},\"preferenceCenter\":{\"status\":false,\"tag\":\"detail\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"closeButton\":{\"status\":true,\"type\":\"button\",\"tag\":\"detail-close\"},\"categories\":{\"status\":true,\"tag\":\"detail-categories\",\"type\":\"container\",\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"detail-category-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"detail-category-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"toggle\":{\"status\":true,\"tag\":\"detail-category-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863DC\"}},\"inactive\":{\"styles\":{\"background-color\":\"#D0D5D2\"}}}}}},\"buttons\":{\"status\":true,\"tag\":\"detail-buttons\",\"type\":\"container\",\"elements\":{\"accept\":{\"status\":true,\"tag\":\"detail-accept-button\",\"type\":\"button\",\"styles\":{\"color\":\"#FFFFFF\",\"background-color\":\"#1863DC\",\"border-color\":\"#1863DC\"}},\"reject\":{\"status\":true,\"tag\":\"detail-reject-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}},\"save\":{\"status\":true,\"tag\":\"detail-save-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\",\"background-color\":\"transparent\",\"border-color\":\"#1863DC\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"detail-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}}}},\"optoutPopup\":{\"status\":true,\"tag\":\"optout-popup\",\"type\":\"container\",\"styles\":{\"color\":\"#212121\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#F4F4F4\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"optout-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"description\":{\"type\":\"text\",\"tag\":\"optout-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}},\"optOption\":{\"status\":true,\"tag\":\"optout-option\",\"type\":\"container\",\"elements\":{\"toggle\":{\"status\":true,\"tag\":\"optout-option-toggle\",\"type\":\"toggle\",\"states\":{\"active\":{\"styles\":{\"background-color\":\"#1863dc\"}},\"inactive\":{\"styles\":{\"background-color\":\"#FFFFFF\"}}}},\"title\":{\"type\":\"text\",\"tag\":\"optout-option-title\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"gpcOption\":{\"type\":\"container\",\"tag\":\"optout-gpc-option\",\"status\":false,\"elements\":{\"description\":{\"type\":\"text\",\"tag\":\"optout-gpc-option-description\",\"status\":true,\"styles\":{\"color\":\"#212121\"}}}},\"poweredBy\":{\"status\":true,\"tag\":\"optout-powered-by\",\"styles\":{\"background-color\":\"#EDEDED\",\"color\":\"#293C5B\"}},\"buttons\":{\"status\":true,\"tag\":\"optout-buttons\",\"type\":\"container\",\"elements\":{\"confirm\":{\"status\":true,\"tag\":\"optout-confirm-button\",\"type\":\"button\",\"styles\":{\"color\":\"#f4f4f4\",\"background-color\":\"#1863dc\",\"border-color\":\"#1863dc\"}},\"cancel\":{\"status\":true,\"tag\":\"optout-cancel-button\",\"type\":\"button\",\"styles\":{\"color\":\"#858585\",\"background-color\":\"#FFFFFF\",\"border-color\":\"#dedfe0\"}}}},\"closeButton\":{\"status\":true,\"tag\":\"optout-close\",\"type\":\"button\"}}},\"auditTable\":{\"status\":false,\"tag\":\"audit-table\",\"type\":\"table\",\"meta\":{\"headers\":[\"id\",\"duration\",\"description\"]},\"styles\":{\"color\":\"#212121\",\"background-color\":\"#f4f4f4\",\"border-color\":\"#ebebeb\"}},\"revisitConsent\":{\"status\":true,\"tag\":\"revisit-consent\",\"position\":\"bottom-left\",\"meta\":{\"url\":\"#\"},\"styles\":{\"background-color\":\"#0056A7\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"revisit-consent-title\",\"status\":true,\"styles\":{\"color\":\"#0056a7\"}}}},\"videoPlaceholder\":{\"status\":true,\"tag\":\"video-placeholder\",\"styles\":{\"background-color\":\"#000000\",\"border-color\":\"#000000\"},\"elements\":{\"title\":{\"type\":\"text\",\"tag\":\"placeholder-title\",\"status\":true,\"styles\":{\"color\":\"#ffffff\"}}}},\"accessibilityOverrides\":{\"status\":true,\"tag\":\"accessibility-overrides\",\"elements\":{\"preferenceCenter\":{\"elements\":{\"alwaysActive\":{\"status\":true,\"tag\":\"always-active\",\"styles\":{\"color\":\"#008000\"}},\"showMore\":{\"status\":true,\"tag\":\"show-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}},\"showLess\":{\"status\":true,\"tag\":\"hide-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}}}},\"optoutPopup\":{\"elements\":{\"showMore\":{\"status\":true,\"tag\":\"optout-show-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}},\"showLess\":{\"status\":true,\"tag\":\"optout-hide-desc-button\",\"type\":\"button\",\"styles\":{\"color\":\"#1863DC\"}}}},\"manualLinks\":{\"status\":true,\"tag\":\"manual-links\",\"type\":\"link\",\"styles\":{\"color\":\"#1863DC\"}}}}},\"meta\":{\"customCSS\":\"\",\"customHTML\":\"\"}}","0","{\"en\":{\"notice\":{\"elements\":{\"title\":\"We value your privacy\",\"description\":\"<p>This website or its third-party tools process personal data. You can opt out of the sale of your personal information by clicking on the \\\"Do Not Sell or Share My Personal Information\\\" link.<\\/p>\",\"privacyLink\":\"\",\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"reject\":\"Reject All\",\"settings\":\"Customise\",\"readMore\":\"Cookie Policy\",\"donotSell\":\"Do Not Sell or Share My Personal Information\"}},\"closeButton\":\"Close\"}},\"categoryPreview\":{\"elements\":{\"buttons\":{\"elements\":{\"save\":\"Save My Preferences\"}}}},\"preferenceCenter\":{\"elements\":{\"title\":\"Customise Consent Preferences\",\"description\":\"<p>We use cookies to help you navigate efficiently and perform certain functions. You will find detailed information about all cookies under each consent category below.<\\/p><p>The cookies that are categorised as \\\"Necessary\\\" are stored on your browser as they are essential for enabling the basic functionalities of the site. <\\/p><p>We also use third-party cookies that help us analyse how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. These cookies will only be stored in your browser with your prior consent.<\\/p><p>You can choose to enable or disable some or all of these cookies but disabling some of them may affect your browsing experience.<\\/p>\",\"showMore\":\"Show more\",\"showLess\":\"Show less\",\"category\":{\"elements\":{\"alwaysEnabled\":\"Always Active\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"buttons\":{\"elements\":{\"accept\":\"Accept All\",\"save\":\"Save My Preferences\",\"reject\":\"Reject All\"}},\"closeButton\":\"Close\"}},\"optoutPopup\":{\"elements\":{\"title\":\"Opt-out Preferences\",\"description\":\"<p>We use third-party cookies that help us analyse how you use this website, store your preferences, and provide the content and advertisements that are relevant to you. However, you can opt out of these cookies by checking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button. Once you opt out, you can opt in again at any time by unchecking \\\"Do Not Sell or Share My Personal Information\\\" and clicking the \\\"Save My Preferences\\\" button.<\\/p>\",\"optOption\":{\"elements\":{\"title\":\"Do Not Sell or Share My Personal Information\",\"enable\":\"Enable\",\"disable\":\"Disable\"}},\"gpcOption\":{\"elements\":{\"description\":\"<p>Your opt-out settings for this website have been respected since we detected a <b>Global Privacy Control<\\/b> signal from your browser and, therefore, you cannot change this setting.<\\/p>\"}},\"showLess\":\"Show less\",\"showMore\":\"Show more\",\"buttons\":{\"elements\":{\"cancel\":\"Cancel\",\"confirm\":\"Save My Preferences\"}},\"closeButton\":\"Close\"}},\"revisitConsent\":{\"elements\":{\"title\":\"Consent Preferences\"}},\"auditTable\":{\"elements\":{\"headers\":{\"elements\":{\"id\":\"Cookie\",\"duration\":\"Duration\",\"description\":\"Description\"}},\"message\":\"No cookies to display.\"}},\"videoPlaceholder\":{\"elements\":{\"title\":\"Please accept cookies to access this content\"}}}}","2025-07-29 09:00:27","2025-07-29 09:00:27");

INSERT IGNORE INTO `ac_cky_cookie_categories` VALUES 
("1","{\"en\":\"Necesarias\"}","necessary","{\"en\":\"<p>Las cookies necesarias son necesarias para habilitar las funciones b\\u00e1sicas de este sitio, como proporcionar un inicio de sesi\\u00f3n seguro o ajustar tus preferencias de consentimiento. Estas cookies no almacenan datos personales identificables.<\\/p>\"}","1","1","0","1","[]","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("2","{\"en\":\"Funcionales\"}","functional","{\"en\":\"<p>Las cookies funcionales ayudan a realizar ciertas funcionalidades, como compartir el contenido del sitio web en plataformas de redes sociales, recopilar comentarios y otras caracter\\u00edsticas de terceros.<\\/p>\"}","0","1","0","1","[]","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("3","{\"en\":\"Analiticas\"}","analytics","{\"en\":\"<p>Las cookies anal\\u00edticas se utilizan para comprender c\\u00f3mo interact\\u00faan los visitantes con el sitio web. Estas cookies ayudan a proporcionar informaci\\u00f3n sobre m\\u00e9tricas como el n\\u00famero de visitantes, la tasa de rebote, la fuente de tr\\u00e1fico, etc.<\\/p>\"}","0","1","0","1","[]","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("4","{\"en\":\"Rendimiento\"}","performance","{\"en\":\"<p>Las cookies de rendimiento se utilizan para comprender y analizar los \\u00edndices de rendimiento clave del sitio web, lo que ayuda a ofrecer una mejor experiencia de usuario a los visitantes.<\\/p>\"}","0","1","0","1","[]","0000-00-00 00:00:00","0000-00-00 00:00:00"),
("5","{\"en\":\"Publicidad (no usamos)\"}","advertisement","{\"en\":\"<p>Las cookies publicitarias se utilizan para proporcionar a los visitantes anuncios personalizados basados en las p\\u00e1ginas que visit\\u00f3 anteriormente y para analizar la efectividad de las campa\\u00f1as publicitarias.<\\/p>\"}","0","1","0","1","[]","0000-00-00 00:00:00","0000-00-00 00:00:00");

INSERT IGNORE INTO `ac_cli_scripts` VALUES 
("1","Official Facebook Pixel","analytics","1","","Official Facebook Pixel","facebook-for-wordpress","0"),
("2","Smash Balloon Twitter Feed","analytics","1","","Twitter Feed By Smash Balloon","twitter-feed","0"),
("3","Smash Balloon Instagram Feed","advertisement","1","","Instagram Feed By Smash Balloon","instagram-feed","0"),
("4","Google Analytics for WordPress by MonsterInsights","analytics","1","","Google Analytics Dashboard Plugin for WordPress by MonsterInsights","google-analytics-for-wordpress","0");

INSERT IGNORE INTO `ac_duplicator_activity_logs` VALUES 
("1","websites_scan","scan_start","10","Scan","{\n    \"packageId\": 1,\n    \"packageName\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 0,\n    \"dirCount\": 0,\n    \"size\": 0,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 0,\n    \"dbSize\": 0,\n    \"dbRowCount\": 0\n}","0","4.5.24.1","2025-12-12 11:29:13","2025-12-12 11:29:13"),
("2","websites_scan","scan_end","10","Scan Completed","{\n    \"packageId\": 1,\n    \"packageName\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 26254,\n    \"dirCount\": 4866,\n    \"size\": 464807843,\n    \"dbExcluded\": false,\n    \"dbTableCount\": 107,\n    \"dbSize\": 18366464,\n    \"dbRowCount\": 32408\n}","1","4.5.24.1","2025-12-12 11:29:33","2025-12-12 11:29:33"),
("3","backup_create","start","10","Backup creation: 20251212_associaciodenecessitatsespecialsdec","{\n    \"packageId\": 2,\n    \"packageName\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"packageStatus\": 10,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911\",\n    \"logFileName\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 26254,\n    \"dirCount\": 4866,\n    \"size\": 464807843,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 107,\n    \"dbSizeDisplay\": \"17.52MB\",\n    \"execution_start_time\": 1765539071.9510069\n}","0","4.5.24.1","2025-12-12 11:31:11","2025-12-12 11:31:11"),
("4","backup_create","db_dump","10","Backup creation: 20251212_associaciodenecessitatsespecialsdec - Database Dump","{\n    \"packageId\": 2,\n    \"packageName\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"packageStatus\": 20,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"nameHash\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911\",\n    \"logFileName\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_log.txt\",\n    \"filterOn\": false,\n    \"filterDirs\": [],\n    \"filterExts\": [],\n    \"filterFiles\": [],\n    \"fileCount\": 26254,\n    \"dirCount\": 4866,\n    \"size\": 464807843,\n    \"dbFilterOn\": false,\n    \"dbFilterTables\": [],\n    \"dbPrefixFilter\": false,\n    \"archiveEngine\": \"Zip Archive\",\n    \"databaseEngine\": \"PHPCHUNKING\",\n    \"execType\": \"Manual\",\n    \"scheduleName\": \"\",\n    \"storageNames\": [\n        \"Default\"\n    ],\n    \"archiveSizeDisplay\": \"\",\n    \"uploadSummaries\": [],\n    \"dbExcluded\": false,\n    \"dbTableCount\": 107,\n    \"dbSizeDisplay\": \"17.52MB\",\n    \"execution_start_time\": 1765539071.9510069\n}","3","4.5.24.1","2025-12-12 11:31:11","2025-12-12 11:31:11");

INSERT IGNORE INTO `ac_duplicator_backups` VALUES 
("1","Standard","20251212_associaciodenecessitatsespecialsdec","01bc294366acf69e4092_20251212112911","20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_archive.zip","5","MANUAL,ZIP_ARCHIVE,TEMPORARY","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.11.13\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"hash\": \"01bc294366acf69e4092_20251212112911\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.aneccullera.org\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_scan.json\",\n    \"timer_start\": -1,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.opcache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.tmb\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/ai1wm-backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-lite\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backupwordpress\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/bps-backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/content\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/contents\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/managewp\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/old-cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/updraft\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wfcache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wishlist-backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wpvividbackups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.htaccess\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.user.ini\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/php.ini\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/web.config\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-config.php\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/\",\n        \"Size\": 464807843,\n        \"Dirs\": [],\n        \"DirCount\": 4866,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 26254,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 215680201,\n                        \"bytes\": \"205.69MB\",\n                        \"nodes\": 22597,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 383165823,\n                        \"bytes\": \"365.42MB\",\n                        \"nodes\": 27995,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-snapshots\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.opcache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.tmb\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-lite\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/ai1wm-backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backupwordpress\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/content\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/contents\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/managewp\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/old-cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/updraft\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wpvividbackups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wishlist-backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wfcache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/bps-backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 8222019,\n                        \"bytes\": \"7.84MB\",\n                        \"nodes\": 1,\n                        \"name\": \"estatutoscompulsadosMIA.pdf\",\n                        \"dir\": \"documents\",\n                        \"path\": \"documents\\/estatutoscompulsadosMIA.pdf\"\n                    },\n                    {\n                        \"ubytes\": 8558657,\n                        \"bytes\": \"8.16MB\",\n                        \"nodes\": 1,\n                        \"name\": \"mcarmenherrera.pdf\",\n                        \"dir\": \"documents\",\n                        \"path\": \"documents\\/mcarmenherrera.pdf\"\n                    },\n                    {\n                        \"ubytes\": 4857404,\n                        \"bytes\": \"4.63MB\",\n                        \"nodes\": 1,\n                        \"name\": \"LayerSlider.zip\",\n                        \"dir\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/LayerSlider.zip\"\n                    },\n                    {\n                        \"ubytes\": 7537294,\n                        \"bytes\": \"7.19MB\",\n                        \"nodes\": 1,\n                        \"name\": \"revslider.zip\",\n                        \"dir\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/revslider.zip\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.htaccess\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.user.ini\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/php.ini\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/web.config\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/debug.log\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"text\": \"\\/usr\\/home\\/aneccullera.org\\/web <span class=\\\"size\\\" >443.28MB<\\/span> <span class=\\\"nodes\\\" >31120<\\/span>\",\n                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\",\n                \"type\": \"folder\",\n                \"state\": {\n                    \"opened\": true,\n                    \"disabled\": false,\n                    \"selected\": false,\n                    \"checked\": false,\n                    \"checkbox_disabled\": true\n                },\n                \"children\": [\n                    {\n                        \"text\": \"wp-content <span class=\\\"size\\\" >365.42MB<\\/span> <span class=\\\"nodes\\\" >27995<\\/span>\",\n                        \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"plugins <span class=\\\"size\\\" >205.69MB<\\/span> <span class=\\\"nodes\\\" >22597<\\/span>\",\n                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": true,\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"themes <span class=\\\"size\\\" >39.06MB<\\/span> <span class=\\\"nodes\\\" >1102<\\/span>\",\n                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\",\n                                \"type\": \"folder\",\n                                \"state\": {\n                                    \"opened\": true,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": [\n                                    {\n                                        \"text\": \"econature <span class=\\\"size\\\" >19.12MB<\\/span> <span class=\\\"nodes\\\" >517<\\/span>\",\n                                        \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\",\n                                        \"type\": \"folder\",\n                                        \"state\": {\n                                            \"opened\": true,\n                                            \"disabled\": false,\n                                            \"selected\": false,\n                                            \"checked\": false,\n                                            \"checkbox_disabled\": false\n                                        },\n                                        \"children\": [\n                                            {\n                                                \"text\": \"framework <span class=\\\"size\\\" >13.79MB<\\/span> <span class=\\\"nodes\\\" >198<\\/span>\",\n                                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\",\n                                                \"type\": \"folder\",\n                                                \"state\": {\n                                                    \"opened\": true,\n                                                    \"disabled\": false,\n                                                    \"selected\": false,\n                                                    \"checked\": false,\n                                                    \"checkbox_disabled\": false\n                                                },\n                                                \"children\": [\n                                                    {\n                                                        \"text\": \"admin <span class=\\\"size\\\" >12.81MB<\\/span> <span class=\\\"nodes\\\" >81<\\/span>\",\n                                                        \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\\/admin\",\n                                                        \"type\": \"folder\",\n                                                        \"state\": {\n                                                            \"opened\": true,\n                                                            \"disabled\": false,\n                                                            \"selected\": false,\n                                                            \"checked\": false,\n                                                            \"checkbox_disabled\": false\n                                                        },\n                                                        \"children\": [\n                                                            {\n                                                                \"text\": \"inc <span class=\\\"size\\\" >12.5MB<\\/span> <span class=\\\"nodes\\\" >49<\\/span>\",\n                                                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\",\n                                                                \"type\": \"folder\",\n                                                                \"state\": {\n                                                                    \"opened\": true,\n                                                                    \"disabled\": false,\n                                                                    \"selected\": false,\n                                                                    \"checked\": false,\n                                                                    \"checkbox_disabled\": false\n                                                                },\n                                                                \"children\": [\n                                                                    {\n                                                                        \"text\": \"plugins <span class=\\\"size\\\" >12.07MB<\\/span> <span class=\\\"nodes\\\" >7<\\/span>\",\n                                                                        \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\",\n                                                                        \"type\": \"folder\",\n                                                                        \"state\": {\n                                                                            \"opened\": true,\n                                                                            \"disabled\": false,\n                                                                            \"selected\": false,\n                                                                            \"checked\": false,\n                                                                            \"checkbox_disabled\": false\n                                                                        },\n                                                                        \"children\": [\n                                                                            {\n                                                                                \"text\": \"LayerSlider.zip <span class=\\\"size\\\" >4.63MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/LayerSlider.zip\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            },\n                                                                            {\n                                                                                \"text\": \"revslider.zip <span class=\\\"size\\\" >7.19MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                                                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/revslider.zip\",\n                                                                                \"type\": \"file\",\n                                                                                \"state\": {\n                                                                                    \"opened\": false,\n                                                                                    \"disabled\": false,\n                                                                                    \"selected\": false,\n                                                                                    \"checked\": false,\n                                                                                    \"checkbox_disabled\": false\n                                                                                },\n                                                                                \"children\": null,\n                                                                                \"li_attr\": {\n                                                                                    \"class\": \" warning-node\"\n                                                                                },\n                                                                                \"a_attr\": []\n                                                                            }\n                                                                        ],\n                                                                        \"li_attr\": {\n                                                                            \"data-full-loaded\": false,\n                                                                            \"class\": \" warning-childs\"\n                                                                        },\n                                                                        \"a_attr\": []\n                                                                    }\n                                                                ],\n                                                                \"li_attr\": {\n                                                                    \"data-full-loaded\": false,\n                                                                    \"class\": \" warning-childs\"\n                                                                },\n                                                                \"a_attr\": []\n                                                            }\n                                                        ],\n                                                        \"li_attr\": {\n                                                            \"data-full-loaded\": false,\n                                                            \"class\": \" warning-childs\"\n                                                        },\n                                                        \"a_attr\": []\n                                                    }\n                                                ],\n                                                \"li_attr\": {\n                                                    \"data-full-loaded\": false,\n                                                    \"class\": \" warning-childs\"\n                                                },\n                                                \"a_attr\": []\n                                            }\n                                        ],\n                                        \"li_attr\": {\n                                            \"data-full-loaded\": false,\n                                            \"class\": \" warning-childs\"\n                                        },\n                                        \"a_attr\": []\n                                    }\n                                ],\n                                \"li_attr\": {\n                                    \"data-full-loaded\": false,\n                                    \"class\": \" warning-childs\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-node\"\n                        },\n                        \"a_attr\": []\n                    },\n                    {\n                        \"text\": \"documents <span class=\\\"size\\\" >18.76MB<\\/span> <span class=\\\"nodes\\\" >19<\\/span>\",\n                        \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/documents\",\n                        \"type\": \"folder\",\n                        \"state\": {\n                            \"opened\": true,\n                            \"disabled\": false,\n                            \"selected\": false,\n                            \"checked\": false,\n                            \"checkbox_disabled\": false\n                        },\n                        \"children\": [\n                            {\n                                \"text\": \"estatutoscompulsadosMIA.pdf <span class=\\\"size\\\" >7.84MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/documents\\/estatutoscompulsadosMIA.pdf\",\n                                \"type\": \"file\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": null,\n                                \"li_attr\": {\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            },\n                            {\n                                \"text\": \"mcarmenherrera.pdf <span class=\\\"size\\\" >8.16MB<\\/span> <span class=\\\"nodes\\\" >&nbsp;<\\/span>\",\n                                \"fullPath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/documents\\/mcarmenherrera.pdf\",\n                                \"type\": \"file\",\n                                \"state\": {\n                                    \"opened\": false,\n                                    \"disabled\": false,\n                                    \"selected\": false,\n                                    \"checked\": false,\n                                    \"checkbox_disabled\": false\n                                },\n                                \"children\": null,\n                                \"li_attr\": {\n                                    \"class\": \" warning-node\"\n                                },\n                                \"a_attr\": []\n                            }\n                        ],\n                        \"li_attr\": {\n                            \"data-full-loaded\": false,\n                            \"class\": \" warning-childs\"\n                        },\n                        \"a_attr\": []\n                    }\n                ],\n                \"li_attr\": {\n                    \"data-full-loaded\": false,\n                    \"class\": \" root-node core-node warning-childs\"\n                },\n                \"a_attr\": {\n                    \"title\": \"Core WordPress directories should not be filtered. Use caution when excluding files.\"\n                }\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"emZ7BDtLyz9G4i3Z3a12ejvZncuJAaDiBqQMoIU6yTTegbfP++5zGGlT39h9KMYydkbg6239ph0NJw6\\/wdsNqA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"anecbd1\",\n            \"tablesBaseCount\": 107,\n            \"tablesFinalCount\": 107,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32408,\n            \"tablesSizeOnDisk\": 18366464,\n            \"tablesList\": {\n                \"ac_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cky_banners\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cky_cookies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cky_cookie_categories\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_cli_cookie_scan\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cli_cookie_scan_categories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_cli_cookie_scan_cookies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cli_cookie_scan_url\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cli_scripts\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"ac_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"ac_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_ff_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_comments\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_image_cache\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_options\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_posts\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_ff_post_media\": {\n                    \"inaccurateRows\": \"51\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_snapshots\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_streams\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_streams_sources\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_FinalTiles_gallery\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_FinalTiles_gallery_images\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"ac_formmaker_backup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_blocked\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_display_options\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_formmaker_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_query\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_submits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_themes\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"ac_formmaker_views\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_layerslider\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_layerslider_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_options\": {\n                    \"inaccurateRows\": \"956\",\n                    \"insertedRows\": 0,\n                    \"size\": 2588672\n                },\n                \"ac_photoblocks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_postmeta\": {\n                    \"inaccurateRows\": \"2941\",\n                    \"insertedRows\": 0,\n                    \"size\": 770048\n                },\n                \"ac_posts\": {\n                    \"inaccurateRows\": \"775\",\n                    \"insertedRows\": 0,\n                    \"size\": 3915776\n                },\n                \"ac_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"ac_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_shepherd_tec_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_shepherd_tec_task_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_tec_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_tec_kv_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_tec_occurrences\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_terms\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_term_relationships\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_term_taxonomy\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_usermeta\": {\n                    \"inaccurateRows\": \"127\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wd_fb_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_info\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_option\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_shortcode\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_theme\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfblockediplog\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wfconfig\": {\n                    \"inaccurateRows\": \"272\",\n                    \"insertedRows\": 0,\n                    \"size\": 1589248\n                },\n                \"ac_wfcrawlers\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wffilemods\": {\n                    \"inaccurateRows\": \"11349\",\n                    \"insertedRows\": 0,\n                    \"size\": 2637824\n                },\n                \"ac_wfhits\": {\n                    \"inaccurateRows\": \"1860\",\n                    \"insertedRows\": 0,\n                    \"size\": 770048\n                },\n                \"ac_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wfissues\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_wfknownfilelist\": {\n                    \"inaccurateRows\": \"11370\",\n                    \"insertedRows\": 0,\n                    \"size\": 1589248\n                },\n                \"ac_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wflogins\": {\n                    \"inaccurateRows\": \"819\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"ac_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wfls_settings\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfnotifications\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 0,\n                    \"size\": 229376\n                },\n                \"ac_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_wpgdprc_consents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_yoast_seo_links\": {\n                    \"inaccurateRows\": \"240\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.13\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 5,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 464807843,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:29:11\",\n    \"updated\": \"2025-12-12 11:29:33\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\",\n        \"TEMPORARY\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 0\n}","4.5.24.1","2025-12-12 11:29:11","2025-12-12 11:29:33"),
("2","Standard","20251212_associaciodenecessitatsespecialsdec","01bc294366acf69e4092_20251212112911","20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_archive.zip","20","MANUAL,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.8.3\",\n    \"VersionDB\": \"10.11.13\",\n    \"VersionPHP\": \"7.4.33\",\n    \"VersionOS\": \"Linux\",\n    \"name\": \"20251212_associaciodenecessitatsespecialsdec\",\n    \"hash\": \"01bc294366acf69e4092_20251212112911\",\n    \"execType\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/www.aneccullera.org\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_scan.json\",\n    \"timer_start\": 1765539071.9510069,\n    \"Runtime\": \"\",\n    \"ExeSize\": \"0\",\n    \"ZipSize\": \"0\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.opcache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.tmb\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/ai1wm-backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-lite\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backupwordpress\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/bps-backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/content\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/contents\\/cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/managewp\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/old-cache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/updraft\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wfcache\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wishlist-backup\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wpvividbackups\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.htaccess\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/.user.ini\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/php.ini\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/web.config\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-config.php\",\n            \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/\",\n        \"Size\": 464807843,\n        \"Dirs\": [],\n        \"DirCount\": 4866,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 26254,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [\n                    {\n                        \"ubytes\": 215680201,\n                        \"bytes\": \"205.69MB\",\n                        \"nodes\": 22597,\n                        \"name\": \"plugins\",\n                        \"dir\": \"wp-content\",\n                        \"path\": \"wp-content\\/plugins\"\n                    },\n                    {\n                        \"ubytes\": 383165823,\n                        \"bytes\": \"365.42MB\",\n                        \"nodes\": 27995,\n                        \"name\": \"wp-content\",\n                        \"dir\": \".\",\n                        \"path\": \"wp-content\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-snapshots\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.opcache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.tmb\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-lite\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/ai1wm-backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backupwordpress\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/content\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/contents\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/infinitewp\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/managewp\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/old-cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/updraft\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wpvividbackups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wishlist-backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/wfcache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/bps-backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/cache\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/aiowps_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_temp\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backupbuddy_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/mainwp\\/backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/pb_backupbuddy\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/snapshots\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/sucuri\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp-clone\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wp_all_backup\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/wpbackitup_backups\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/uploads\\/backup-guard\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/plugins\\/wordfence\\/tmp\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Files\": {\n                \"Size\": [\n                    {\n                        \"ubytes\": 8222019,\n                        \"bytes\": \"7.84MB\",\n                        \"nodes\": 1,\n                        \"name\": \"estatutoscompulsadosMIA.pdf\",\n                        \"dir\": \"documents\",\n                        \"path\": \"documents\\/estatutoscompulsadosMIA.pdf\"\n                    },\n                    {\n                        \"ubytes\": 8558657,\n                        \"bytes\": \"8.16MB\",\n                        \"nodes\": 1,\n                        \"name\": \"mcarmenherrera.pdf\",\n                        \"dir\": \"documents\",\n                        \"path\": \"documents\\/mcarmenherrera.pdf\"\n                    },\n                    {\n                        \"ubytes\": 4857404,\n                        \"bytes\": \"4.63MB\",\n                        \"nodes\": 1,\n                        \"name\": \"LayerSlider.zip\",\n                        \"dir\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/LayerSlider.zip\"\n                    },\n                    {\n                        \"ubytes\": 7537294,\n                        \"bytes\": \"7.19MB\",\n                        \"nodes\": 1,\n                        \"name\": \"revslider.zip\",\n                        \"dir\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\",\n                        \"path\": \"wp-content\\/themes\\/econature\\/framework\\/admin\\/inc\\/plugins\\/revslider.zip\"\n                    }\n                ],\n                \"Core\": [],\n                \"Global\": [\n                    \"error_log\",\n                    \"debug_log\",\n                    \"ws_ftp.log\",\n                    \"dbcache\",\n                    \"pgcache\",\n                    \"objectcache\",\n                    \".DS_Store\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.htaccess\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/.user.ini\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/php.ini\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/web.config\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/debug.log\",\n                    \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-config.php\"\n                ],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": [],\n                \"Unknown\": []\n            },\n            \"TreeSize\": {\n                \"treeList\": []\n            }\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"5F+kqvcqkL0nOguyPr2Y54xIzH1Q8o+GgJXFIrPsdFFFNaNFAKrc0SR0NSvZ5ZzpOledqcDLir6LPfaWb4CRLg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\",\n                \"utf8mb4_unicode_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": true,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"anecbd1\",\n            \"tablesBaseCount\": 107,\n            \"tablesFinalCount\": 107,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 32408,\n            \"tablesSizeOnDisk\": 18366464,\n            \"tablesList\": {\n                \"ac_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cky_banners\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cky_cookies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cky_cookie_categories\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_cli_cookie_scan\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cli_cookie_scan_categories\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_cli_cookie_scan_cookies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_cli_cookie_scan_url\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_cli_scripts\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"ac_duplicator_activity_logs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 114688\n                },\n                \"ac_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_duplicator_entities\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 0,\n                    \"size\": 163840\n                },\n                \"ac_ff_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_comments\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_image_cache\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_options\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_posts\": {\n                    \"inaccurateRows\": \"50\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_ff_post_media\": {\n                    \"inaccurateRows\": \"51\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_snapshots\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_streams\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_ff_streams_sources\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_FinalTiles_gallery\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_FinalTiles_gallery_images\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"ac_formmaker_backup\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_blocked\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_display_options\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_formmaker_groups\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_query\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_sessions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_submits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_formmaker_themes\": {\n                    \"inaccurateRows\": \"15\",\n                    \"insertedRows\": 0,\n                    \"size\": 147456\n                },\n                \"ac_formmaker_views\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_layerslider\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_layerslider_revisions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_options\": {\n                    \"inaccurateRows\": \"956\",\n                    \"insertedRows\": 0,\n                    \"size\": 2588672\n                },\n                \"ac_photoblocks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_postmeta\": {\n                    \"inaccurateRows\": \"2941\",\n                    \"insertedRows\": 0,\n                    \"size\": 770048\n                },\n                \"ac_posts\": {\n                    \"inaccurateRows\": \"775\",\n                    \"insertedRows\": 0,\n                    \"size\": 3915776\n                },\n                \"ac_revslider_css\": {\n                    \"inaccurateRows\": \"109\",\n                    \"insertedRows\": 0,\n                    \"size\": 131072\n                },\n                \"ac_revslider_layer_animations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_navigations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_sliders\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_revslider_static_slides\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_shepherd_tec_tasks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_shepherd_tec_task_logs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_tec_events\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_tec_kv_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_tec_occurrences\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_termmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_terms\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_term_relationships\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_term_taxonomy\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_usermeta\": {\n                    \"inaccurateRows\": \"127\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_users\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wc_download_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_wc_webhooks\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wd_fb_data\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_info\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_option\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_shortcode\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wd_fb_theme\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfblockediplog\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wfconfig\": {\n                    \"inaccurateRows\": \"272\",\n                    \"insertedRows\": 0,\n                    \"size\": 1589248\n                },\n                \"ac_wfcrawlers\": {\n                    \"inaccurateRows\": \"20\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wffilemods\": {\n                    \"inaccurateRows\": \"11349\",\n                    \"insertedRows\": 0,\n                    \"size\": 2637824\n                },\n                \"ac_wfhits\": {\n                    \"inaccurateRows\": \"1860\",\n                    \"insertedRows\": 0,\n                    \"size\": 770048\n                },\n                \"ac_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wfissues\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_wfknownfilelist\": {\n                    \"inaccurateRows\": \"11370\",\n                    \"insertedRows\": 0,\n                    \"size\": 1589248\n                },\n                \"ac_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wflogins\": {\n                    \"inaccurateRows\": \"819\",\n                    \"insertedRows\": 0,\n                    \"size\": 262144\n                },\n                \"ac_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_wfls_settings\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfnotifications\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 0,\n                    \"size\": 229376\n                },\n                \"ac_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_api_keys\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_attribute_taxonomies\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_downloadable_product_permissions\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_woocommerce_log\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_order_itemmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_order_items\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_payment_tokenmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_payment_tokens\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"ac_woocommerce_sessions\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_woocommerce_shipping_zones\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_shipping_zone_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_woocommerce_shipping_zone_methods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_woocommerce_tax_rates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"ac_woocommerce_tax_rate_locations\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"ac_wpgdprc_consents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"ac_yoast_seo_links\": {\n                    \"inaccurateRows\": \"240\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"ac_yoast_seo_meta\": {\n                    \"inaccurateRows\": \"204\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                }\n            },\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.11.13\",\n            \"versionComment\": \"mariadb.org binary distribution\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"mariadb.org binary distribution\",\n        \"dbStorePathPublic\": \"\\/usr\\/home\\/aneccullera.org\\/web\\/wp-content\\/backups-dup-pro\\/tmp\\/20251212_associaciodenecessitatsespecialsdec_01bc294366acf69e4092_20251212112911_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"status\": 20,\n    \"schedule_id\": -1,\n    \"descriptorsMng\": null,\n    \"build_progress\": {\n        \"thread_start_time\": 1765539076,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"expected_archive_size\": 464807843,\n        \"processed_archive_size\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"ac_users\",\n            \"ac_usermeta\",\n            \"ac_actionscheduler_actions\",\n            \"ac_actionscheduler_claims\",\n            \"ac_actionscheduler_groups\",\n            \"ac_actionscheduler_logs\",\n            \"ac_cky_banners\",\n            \"ac_cky_cookies\",\n            \"ac_cky_cookie_categories\",\n            \"ac_cli_cookie_scan\",\n            \"ac_cli_cookie_scan_categories\",\n            \"ac_cli_cookie_scan_cookies\",\n            \"ac_cli_cookie_scan_url\",\n            \"ac_cli_scripts\",\n            \"ac_commentmeta\",\n            \"ac_comments\",\n            \"ac_duplicator_activity_logs\",\n            \"ac_duplicator_backups\",\n            \"ac_duplicator_entities\",\n            \"ac_ff_cache\",\n            \"ac_ff_comments\",\n            \"ac_ff_image_cache\",\n            \"ac_ff_options\",\n            \"ac_ff_posts\",\n            \"ac_ff_post_media\",\n            \"ac_ff_snapshots\",\n            \"ac_ff_streams\",\n            \"ac_ff_streams_sources\",\n            \"ac_FinalTiles_gallery\",\n            \"ac_FinalTiles_gallery_images\",\n            \"ac_formmaker\",\n            \"ac_formmaker_backup\",\n            \"ac_formmaker_blocked\",\n            \"ac_formmaker_display_options\",\n            \"ac_formmaker_groups\",\n            \"ac_formmaker_query\",\n            \"ac_formmaker_sessions\",\n            \"ac_formmaker_submits\",\n            \"ac_formmaker_themes\",\n            \"ac_formmaker_views\",\n            \"ac_layerslider\",\n            \"ac_layerslider_revisions\",\n            \"ac_links\",\n            \"ac_options\",\n            \"ac_photoblocks\",\n            \"ac_postmeta\",\n            \"ac_posts\",\n            \"ac_revslider_css\",\n            \"ac_revslider_layer_animations\",\n            \"ac_revslider_navigations\",\n            \"ac_revslider_sliders\",\n            \"ac_revslider_slides\",\n            \"ac_revslider_static_slides\",\n            \"ac_shepherd_tec_tasks\",\n            \"ac_shepherd_tec_task_logs\",\n            \"ac_tec_events\",\n            \"ac_tec_kv_cache\",\n            \"ac_tec_occurrences\",\n            \"ac_termmeta\",\n            \"ac_terms\",\n            \"ac_term_relationships\",\n            \"ac_term_taxonomy\",\n            \"ac_wc_download_log\",\n            \"ac_wc_webhooks\",\n            \"ac_wd_fb_data\",\n            \"ac_wd_fb_info\",\n            \"ac_wd_fb_option\",\n            \"ac_wd_fb_shortcode\",\n            \"ac_wd_fb_theme\",\n            \"ac_wfblockediplog\",\n            \"ac_wfblocks7\",\n            \"ac_wfconfig\",\n            \"ac_wfcrawlers\",\n            \"ac_wffilechanges\",\n            \"ac_wffilemods\",\n            \"ac_wfhits\",\n            \"ac_wfhoover\",\n            \"ac_wfissues\",\n            \"ac_wfknownfilelist\",\n            \"ac_wflivetraffichuman\",\n            \"ac_wflocs\",\n            \"ac_wflogins\",\n            \"ac_wfls_2fa_secrets\",\n            \"ac_wfls_settings\",\n            \"ac_wfnotifications\",\n            \"ac_wfpendingissues\",\n            \"ac_wfreversecache\",\n            \"ac_wfsnipcache\",\n            \"ac_wfstatus\",\n            \"ac_wftrafficrates\",\n            \"ac_woocommerce_api_keys\",\n            \"ac_woocommerce_attribute_taxonomies\",\n            \"ac_woocommerce_downloadable_product_permissions\",\n            \"ac_woocommerce_log\",\n            \"ac_woocommerce_order_itemmeta\",\n            \"ac_woocommerce_order_items\",\n            \"ac_woocommerce_payment_tokenmeta\",\n            \"ac_woocommerce_payment_tokens\",\n            \"ac_woocommerce_sessions\",\n            \"ac_woocommerce_shipping_zones\",\n            \"ac_woocommerce_shipping_zone_locations\",\n            \"ac_woocommerce_shipping_zone_methods\",\n            \"ac_woocommerce_tax_rates\",\n            \"ac_woocommerce_tax_rate_locations\",\n            \"ac_wpgdprc_consents\",\n            \"ac_yoast_seo_links\",\n            \"ac_yoast_seo_meta\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1765539071.9761331,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 32412,\n            \"tables\": {\n                \"ac_users\": {\n                    \"start\": \"2\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cky_banners\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cky_cookies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cky_cookie_categories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cli_cookie_scan\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cli_cookie_scan_categories\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cli_cookie_scan_cookies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cli_cookie_scan_url\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_cli_scripts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_duplicator_activity_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_duplicator_backups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_duplicator_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_image_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_post_media\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_snapshots\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_streams\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_ff_streams_sources\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_FinalTiles_gallery\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_FinalTiles_gallery_images\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_backup\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_blocked\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_display_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_query\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_submits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_themes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_formmaker_views\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_layerslider\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_layerslider_revisions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_photoblocks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_css\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_layer_animations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_navigations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_sliders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_revslider_static_slides\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_shepherd_tec_tasks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_shepherd_tec_task_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_tec_events\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_tec_kv_cache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_tec_occurrences\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wc_download_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wc_webhooks\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wd_fb_data\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wd_fb_info\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wd_fb_option\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wd_fb_shortcode\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wd_fb_theme\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfblockediplog\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfblocks7\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfconfig\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfcrawlers\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wffilechanges\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wffilemods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfhits\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfhoover\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfknownfilelist\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wflivetraffichuman\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wflocs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wflogins\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfls_2fa_secrets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfls_settings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfnotifications\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfpendingissues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfreversecache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfsnipcache\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wfstatus\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wftrafficrates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_attribute_taxonomies\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_downloadable_product_permissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_order_itemmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_order_items\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_payment_tokenmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_payment_tokens\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_sessions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_shipping_zones\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_shipping_zone_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_shipping_zone_methods\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_tax_rates\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_woocommerce_tax_rate_locations\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_wpgdprc_consents\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_yoast_seo_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"ac_yoast_seo_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 3,\n            \"storageClass\": \"Duplicator\\\\Models\\\\Storages\\\\AbstractStorageEntity\",\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 0,\n            \"stopped_timestamp\": 0,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": [],\n            \"generalExtraData\": []\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": -1,\n    \"buildEmailSent\": false,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:29:11\",\n    \"updated\": \"2025-12-12 11:31:16\",\n    \"flags\": [\n        \"MANUAL\",\n        \"ZIP_ARCHIVE\"\n    ],\n    \"flagUpdatedAfterLoad\": false,\n    \"mainScanLogId\": 1,\n    \"mainActivityLogId\": 3\n}","4.5.24.1","2025-12-12 11:29:11","2025-12-12 11:31:16");

INSERT IGNORE INTO `ac_duplicator_entities` VALUES 
("1","DUP_PRO_Global_Entity","","","","","","{\n    \"email_summary_frequency\": \"weekly\",\n    \"email_summary_recipients\": [\n        \"davidrgb@hotmail.com\"\n    ],\n    \"usageTracking\": true,\n    \"amNotices\": true,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"packageMysqldumpOptions\": [\n        {\n            \"option\": \"quick\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"extended-insert\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"routines\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": true,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"disable-keys\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        },\n        {\n            \"option\": \"compact\",\n            \"inputGroupPrefix\": \"package_mysqldump_\",\n            \"possibleArguments\": [],\n            \"enabled\": false,\n            \"arguments\": []\n        }\n    ],\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"max_package_transfer_time_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"davidrgb@hotmail.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/www.aneccullera.org\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"purgeBackupRecords\": 0,\n    \"manual_mode_storage_ids\": [\n        3\n    ],\n    \"license_key_visible\": 1,\n    \"last_system_check_timestamp\": 0,\n    \"initial_activation_timestamp\": 1765538370,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"recoveryCustomPath\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 1,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:29:11\"\n}","4.5.24.1","2025-12-12 11:19:30","2025-12-12 11:29:11"),
("2","Dynamic_Entity","","","","","","{\n    \"data\": \"QadIHYG2F+v+prGwd\\/84UmTcBCWuMH4+7R5XAfr+ZCv2nTBMNXYifeMORwJj6k5Fjo1A2aPCUOs01enllUuWuiAXMjLh\\/H8z\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 2,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:28:52\",\n    \"dataIsEncrypted\": true\n}","4.5.24.1","2025-12-12 11:19:30","2025-12-12 11:28:52"),
("3","DUP_PRO_Storage_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"notes\": \"The default location for storage on this server.\",\n    \"storage_type\": -2,\n    \"config\": \"bj729fdl+oUC6smWuIeK7gUDrMrOTqwir\\/JIatwAGuYwE41Qrg6UsIRX9ZD7gw2T9hKTNQeMQNZnpHnv3c26sFjj\\/610Y+ayUzuzWzAY154Zl+yLqnKpTzueGpIsMECT+\\/dUIPfNG9iFWrRWHZfAcWm1bTBosOSpOmY2z3BhZqb+osEqfvoOb1k7Qip\\/261\\/46kKi\\/MCqvLDpPkH5dPonDVCz\\/iOq5AsKHFx69irt63mTwEhD46YTJc66fVPqaTV\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 3,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:28:52\"\n}","4.5.24.1","2025-12-12 11:19:30","2025-12-12 11:28:52"),
("4","EmailSummary","","","","","","{\n    \"manualPackageIds\": [],\n    \"scheduledPackageIds\": [],\n    \"failedPackageIds\": [],\n    \"failedUploads\": [],\n    \"cancelledUploads\": [],\n    \"successfulUploads\": [],\n    \"scheduleIds\": [],\n    \"storageIds\": [],\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 4,\n    \"version\": \"4.5.23.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:19:30\"\n}","4.5.23.1","2025-12-12 11:19:30","2025-12-12 11:19:30"),
("5","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"Default\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"d23fsszm8qBOOM8g0Z3anINc6InjZwiFIi4tBB70K8WXTVk5PkPLo\\/G2EM6JRyWkmBj\\/TBmq1xibWS0XzVJJ6A==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 5,\n    \"version\": \"4.5.23.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:19:30\"\n}","4.5.23.1","2025-12-12 11:19:30","2025-12-12 11:19:30"),
("6","DUP_PRO_Package_Template_Entity","","","","","","{\n    \"name\": \"[Manual Mode]\",\n    \"package_name_format\": \"%year%%month%%day%_%sitetitle%\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": false,\n    \"archive_filter_on\": false,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"database_filter_on\": false,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installerPassowrd\": \"Hv2HNuOZvZt5j9U\\/nh2p2NHwGPBOP9TRCc2Cyyf5FC+lD5HDlE\\/s7NP4wFi2IY8XYYP9bLvKHHNG5FbJnOFLkg==\",\n    \"installer_opts_skip_scan\": false,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -1,\n    \"is_default\": false,\n    \"is_manual\": true,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 6,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:29:11\"\n}","4.5.24.1","2025-12-12 11:19:30","2025-12-12 11:29:11"),
("7","LicenseDataEntity","","","","","","{\n    \"licenseKey\": \"uHDirsct+wssb9Nzq0NyFvPpEuNh2svOSW2eVcE6NWTS5y2AJXAxP3i9fKK89Xt+mng1S\\/bQYVRpPswrsQ2o\\/K3XyxUz0Wgx5DKeX5UC+u3Cj9gogqPj9A9szFko223t\",\n    \"status\": \"VLRAjEdCpUf+odheqk5RMAyYHHs2Ef8STihlkz4oBPqyI0BfZ1A8QMeNqGFx0F\\/h4nTmuT3EJ9cTvIU9LYsfAAy96WbmqVEK\",\n    \"type\": \"3cB5R7VAsz9ocewTBq9yHjrJ8YKhlogfclcQvsKBnKoviq1C3QdgiRve0XlX6qsC\\/c9Z4G26gHT1bz9D78v+exECPWvYvvtx\",\n    \"data\": \"gHw72rqqoirgCs4Hna2A57uptU7sAsCskz6ejZb5eRcCFSbl3xo776hV6Vi7UmlUGcJ7AC41SPv7vNlz4QuRTUwkjbb+zz7UIvdL9v6hsrRgRoOzsLJSLvR7KQqkDsyrD2Ai9rR7qyF46e98\\/PXl9k724bhc0C61+7gjIfqExAH\\/PEGw8vRJF6z1I4zu3sAw6b0iBhd2QdTTEdxDVQMUrAyO1y2R6K95zSiXKoXm8rOUYLOeWpuLNRnCewAuNUj7FPqEOpcnhY0V8eKhx47I3E2FdMPWNMTH91XUH\\/3ddNJmk7Z1jj2X1DYJOYp+VOHN2q\\/OcgFuxTGlHJu8ldJPw2sUnATwpvinM6qVh27ioVFWM0Bsct3JEjShRfHRKx7OkwcbY0edFssZzk+qFHxyiQ2R\\/ARN7e5Qxjg2eoyfC\\/0=\",\n    \"lastRemoteUpdate\": \"\",\n    \"lastFailureTime\": \"\",\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 7,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:30\",\n    \"updated\": \"2025-12-12 11:31:16\"\n}","4.5.24.1","2025-12-12 11:19:30","2025-12-12 11:31:16"),
("8","DUP_PRO_System_Global_Entity","","","","","","{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1765539070,\n    \"value1\": \"\",\n    \"value2\": \"\",\n    \"value3\": \"\",\n    \"value4\": \"\",\n    \"value5\": \"\",\n    \"id\": 8,\n    \"version\": \"4.5.24.1\",\n    \"created\": \"2025-12-12 11:19:31\",\n    \"updated\": \"2025-12-12 11:31:10\"\n}","4.5.24.1","2025-12-12 11:19:31","2025-12-12 11:31:10");

INSERT IGNORE INTO `ac_ff_cache` VALUES 
("ti46417","1528474050","1","a:0:{}","O:8:\"stdClass\":7:{s:13:\"timeline-type\";s:13:\"page_timeline\";s:7:\"content\";s:16:\"2103235553236858\";s:5:\"posts\";s:2:\"10\";s:3:\"mod\";s:4:\"nope\";s:4:\"type\";s:8:\"facebook\";s:7:\"include\";s:0:\"\";s:15:\"filter-by-words\";s:0:\"\";}","1","1","1528474027","60","0");

INSERT IGNORE INTO `ac_ff_comments` VALUES 
("534774033590399_534936736907462","337652796635858_534774033590399","","preciosaaas😍","1525505039","1525505039"),
("534774033590399_535478100186659","337652796635858_534774033590399","","que xulassss!!! preciosas!!!","1525618237","1525618237"),
("534774033590399_535478123519990","337652796635858_534774033590399","","","1525618241","1525618241"),
("534774033590399_535556350178834","337652796635858_534774033590399","","Preciosas que precio tienen son acrílico o gel?","1525632526","1525632526");

INSERT IGNORE INTO `ac_ff_image_cache` VALUES 
("0a42b10ec5b14ebf142fbe76d591ffe2","720","720","2018-05-28 11:59:46",""),
("36fadc137da62440ebf60e4f29b06e39","1280","720","2018-05-28 11:59:46",""),
("6bb8b9fe6257b133dc589b65243dc792","1080","1080","2018-05-28 11:59:44",""),
("84e3691ed04e5f7732023643e6a76595","1280","720","2018-05-28 11:59:45",""),
("90a6980546c0f20102afafcb17209fee","720","720","2018-05-28 11:59:44",""),
("a9af422fc8a4598916b87f6952251328","360","360","2018-05-28 11:59:44",""),
("c4b754830f25a7e3313f43092304abf6","100","100","2018-05-28 11:59:46","");

INSERT IGNORE INTO `ac_ff_options` VALUES 
("flow_flow_db_version","3.6"),
("flow_flow_fb_auth_options","a:4:{s:20:\"facebook_use_own_app\";s:3:\"yep\";s:21:\"facebook_access_token\";s:212:\"EAACEdEose0cBAJXjPUZBvanxxA1oZAj2iSZBLpffaR9qFBunTjmK2nvG40fFvMT9TOw1YSan9BXf7QRpmvta36qKFNdcMZB6mtsDrEnAzsZAZA2BerThCc0YJDlM08dCJelBe5o5ZAyMsgc34BerZCvomU6e3JWpno93LuIatKLTnpiyXg5LSBSKZCNmA4B35xI5NAiyGBJ7S5wZDZD\";s:15:\"facebook_app_id\";s:16:\"1619010888205509\";s:19:\"facebook_app_secret\";s:32:\"4055ecbfc290bb7d2997e8160226d4e1\";}"),
("flow_flow_fb_limit_counter","a:1:{i:1528474045;i:3;}"),
("flow_flow_options","a:34:{s:22:\"mod-role-administrator\";s:3:\"yep\";s:28:\"general-settings-date-format\";s:11:\"wpStyleDate\";s:41:\"general-settings-open-links-in-new-window\";s:3:\"yep\";s:32:\"general-settings-feed-post-count\";s:3:\"100\";s:12:\"consumer_key\";s:0:\"\";s:15:\"consumer_secret\";s:0:\"\";s:18:\"oauth_access_token\";s:0:\"\";s:25:\"oauth_access_token_secret\";s:0:\"\";s:22:\"instagram_access_token\";s:0:\"\";s:14:\"google_api_key\";s:0:\"\";s:23:\"foursquare_access_token\";s:0:\"\";s:20:\"foursquare_client_id\";s:0:\"\";s:24:\"foursquare_client_secret\";s:0:\"\";s:16:\"linkedin_api_key\";s:0:\"\";s:19:\"linkedin_secret_key\";s:0:\"\";s:21:\"linkedin_access_token\";s:0:\"\";s:18:\"soundcloud_api_key\";s:0:\"\";s:21:\"dribbble_access_token\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:13:\"company_email\";s:0:\"\";s:13:\"purchase_code\";s:0:\"\";s:15:\"mod-role-editor\";s:4:\"nope\";s:15:\"mod-role-author\";s:4:\"nope\";s:20:\"mod-role-contributor\";s:4:\"nope\";s:19:\"mod-role-subscriber\";s:4:\"nope\";s:17:\"mod-role-customer\";s:4:\"nope\";s:21:\"mod-role-shop_manager\";s:4:\"nope\";s:19:\"mod-role-translator\";s:4:\"nope\";s:37:\"general-settings-disable-proxy-server\";s:4:\"nope\";s:40:\"general-settings-disable-follow-location\";s:4:\"nope\";s:21:\"general-settings-ipv4\";s:4:\"nope\";s:22:\"general-settings-https\";s:4:\"nope\";s:21:\"general-notifications\";s:4:\"nope\";s:17:\"news_subscription\";s:4:\"nope\";}");

INSERT IGNORE INTO `ac_ff_posts` VALUES 
("ti46417","2103235553236858_2245199425707136","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2245199425707136","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.44258589804413345","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-0/p180x540/27164467_10208499505125641_7012386551624965705_o.jpg?_nc_cat=0&oh=a2b9bf27974fb856f3b31419a1ffd3ee&oe=5BB09E8C","300","225","https://scontent.xx.fbcdn.net/v/t31.0-0/p180x540/27164467_10208499505125641_7012386551624965705_o.jpg?_nc_cat=0&oh=a2b9bf27974fb856f3b31419a1ffd3ee&oe=5BB09E8C","720","540","image","1517164653","49","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"1\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2246218265605252","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2246218265605252","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.16018036022799123","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/p720x720/27067120_10208510757526944_5206550342245801167_n.jpg?_nc_cat=0&oh=51baaf36ae5ac1aeb3bba9c781d5d8de&oe=5BC061CF","300","300","https://scontent.xx.fbcdn.net/v/t1.0-9/p720x720/27067120_10208510757526944_5206550342245801167_n.jpg?_nc_cat=0&oh=51baaf36ae5ac1aeb3bba9c781d5d8de&oe=5BC061CF","720","720","image","1517315538","48","approved","","{\"likes\":\"2\",\"comments\":\"0\",\"shares\":\"1\"}","","0","0","0","","3"),
("ti46417","2103235553236858_2246218472271898","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2246218472271898","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.47314413774120073","1528474045","https://scontent.xx.fbcdn.net/v/t15.0-10/s720x720/26709959_10208505987767703_6529818047748767744_n.jpg?_nc_cat=0&oh=34deab4895c09cfdbdca20a4e5e7c47e&oe=5B7EAD12","300","170","http://www.facebook.com/video/embed?video_id=10208505983687601","600","339","video","1517315571","47","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2247286458831766","facebook","Mirad en enlace. Es un vídeo de Youtube, los niños hablan de sus emociones y como se calman con la respiración","https://www.facebook.com/2103235553236858/posts/2247286458831766","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.8851796387556751","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27332612_563122630690852_8570769226129081685_n.png?_nc_cat=0&oh=9aa7d14c0dff3cc60a513e0d31ca2cca&oe=5B788738","300","500","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27332612_563122630690852_8570769226129081685_n.png?_nc_cat=0&oh=9aa7d14c0dff3cc60a513e0d31ca2cca&oe=5B788738","432","720","image","1517469313","46","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2247550582138687","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2247550582138687","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.0064658112884180725","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","300","300","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","100","100","image","1517508339","45","approved","https://www.facebook.com/groups/636032229830391/permalink/1255493047884303/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2249848851908860","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2249848851908860","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.37679017090871014","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/27654929_565914110411704_5832670433203448739_n.jpg?_nc_cat=0&oh=3ad164d618805a945510b1b4dd40110c&oe=5B7E6D27","300","300","https://scontent.xx.fbcdn.net/v/t1.0-9/27654929_565914110411704_5832670433203448739_n.jpg?_nc_cat=0&oh=3ad164d618805a945510b1b4dd40110c&oe=5B7E6D27","677","677","image","1517859923","44","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2250375498522862","facebook","Hui hem passat un mati d\\\'allò més bonic!!  molt emocionant i divertit.... <br>Taller de Risoteràpia CB impartit per Maricarmen Herrera i Vicki García, risoterapeutes d\\\'ANEC","https://www.facebook.com/2103235553236858/posts/2250375498522862","Alzheimer Afacu","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.8645534514119415","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27540089_1688719657851671_268099742341853335_n.jpg?_nc_cat=0&oh=fcb3c2db87008fa1ad7731e0687fb6b0&oe=5BB0E528","300","169","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27540089_1688719657851671_268099742341853335_n.jpg?_nc_cat=0&oh=fcb3c2db87008fa1ad7731e0687fb6b0&oe=5BB0E528","720","405","image","1517938326","43","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","10"),
("ti46417","2103235553236858_2250386745188404","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2250386745188404","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.1923967750672221","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/27654929_565914110411704_5832670433203448739_n.jpg?_nc_cat=0&oh=3ad164d618805a945510b1b4dd40110c&oe=5B7E6D27","300","300","https://scontent.xx.fbcdn.net/v/t1.0-9/27654929_565914110411704_5832670433203448739_n.jpg?_nc_cat=0&oh=3ad164d618805a945510b1b4dd40110c&oe=5B7E6D27","677","677","image","1517940073","42","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2250477645179314","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2250477645179314","Música para el Autismo","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.36832355183393095","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/27503836_1711425855574870_460804822766010398_o.jpg?_nc_cat=0&oh=6521bc1c23afc0cf6b40eacd7d6fcee4&oe=5BB22406","300","442","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/27503836_1711425855574870_460804822766010398_o.jpg?_nc_cat=0&oh=6521bc1c23afc0cf6b40eacd7d6fcee4&oe=5BB22406","489","720","image","1517954869","41","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2253679084859170","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2253679084859170","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.2644274647016334","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/27867021_567939823542466_7288530831343760086_n.jpg?_nc_cat=0&oh=5a2989ccbfe8b84ffaa02d66a67fcfbd&oe=5BBECB44","300","300","https://scontent.xx.fbcdn.net/v/t1.0-9/27867021_567939823542466_7288530831343760086_n.jpg?_nc_cat=0&oh=5a2989ccbfe8b84ffaa02d66a67fcfbd&oe=5BBECB44","689","689","image","1518420762","40","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2254601214766957","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2254601214766957","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.21716669874001918","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQDNwbf4NIcbWhfA&w=720&h=720&url=http%3A%2F%2Fpsiquepositiva.com%2Fwp-content%2Fuploads%2F2016%2F08%2Fkids-girl-pencil-drawing-159823-1.jpeg&cfs=1&sx=1073&sy=0&sw=3456&sh=3456&_nc_hash=AQDa6kWBjRRNuRNo","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQDNwbf4NIcbWhfA&w=720&h=720&url=http%3A%2F%2Fpsiquepositiva.com%2Fwp-content%2Fuploads%2F2016%2F08%2Fkids-girl-pencil-drawing-159823-1.jpeg&cfs=1&sx=1073&sy=0&sw=3456&sh=3456&_nc_hash=AQDa6kWBjRRNuRNo","600","600","image","1518546265","39","approved","http://psiquepositiva.com/reeducacion-pedagogica/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2256851121208633","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2256851121208633","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.2925511303288407","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","300","300","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","100","100","image","1518872223","38","approved","https://www.facebook.com/groups/636032229830391/permalink/1269009783199296/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2257103951183350","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2257103951183350","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.8112555861577909","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","300","300","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","100","100","image","1518901508","37","approved","https://www.facebook.com/groups/636032229830391/permalink/1269365289830412/","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2257802627780149","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2257802627780149","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.17862457053607755","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1518981914","36","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2258033824423696","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2258033824423696","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.45935612494065997","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQC3yARR0Bl0ujRQ&w=720&h=720&url=https%3A%2F%2Fdades.naciodigital.cat%2Fredaccio%2Farxius%2Fimatges%2F201602%2F990_1455534431mar.jpg%3F1518985658&cfs=1&_nc_hash=AQCOnbMWGDlr-EKJ","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQC3yARR0Bl0ujRQ&w=720&h=720&url=https%3A%2F%2Fdades.naciodigital.cat%2Fredaccio%2Farxius%2Fimatges%2F201602%2F990_1455534431mar.jpg%3F1518985658&cfs=1&_nc_hash=AQCOnbMWGDlr-EKJ","600","600","image","1519018031","35","approved","http://www.catorze.cat/noticia/2270/teu/mon?rlc=a2","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2258033924423686","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2258033924423686","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.7609069438287122","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQC_pY_PVfgcXXXr&w=720&h=720&url=https%3A%2F%2Fdades.naciodigital.cat%2Fredaccio%2Farxius%2Fimatges%2F201802%2F1200_151898032730390230045_42f126d3d5_o%281%29.jpg%3F1518981712&cfs=1&_nc_hash=AQBWYxG4gp0-VUbK","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQC_pY_PVfgcXXXr&w=720&h=720&url=https%3A%2F%2Fdades.naciodigital.cat%2Fredaccio%2Farxius%2Fimatges%2F201802%2F1200_151898032730390230045_42f126d3d5_o%281%29.jpg%3F1518981712&cfs=1&_nc_hash=AQBWYxG4gp0-VUbK","600","600","image","1519018056","34","approved","http://www.catorze.cat/noticia/9063/si/no/parl/tu","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2258034027757009","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2258034027757009","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.4264663750552259","1528474045","https://scontent.xx.fbcdn.net/v/t15.0-10/27599951_10208632390887702_3462089372558426112_n.jpg?_nc_cat=0&oh=4e18f15f70763b9e03ee5c19b90e7f55&oe=5B81992E","300","300","http://www.facebook.com/video/embed?video_id=10208632387647621","400","400","video","1519018073","33","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2264861007074311","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2264861007074311","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.849611074523638","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/28337066_577557555914026_8399189709228724892_o.jpg?_nc_cat=0&oh=7719e7e9a8f59824dae4422a637031b8&oe=5BACF9D6","300","533","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/28337066_577557555914026_8399189709228724892_o.jpg?_nc_cat=0&oh=7719e7e9a8f59824dae4422a637031b8&oe=5BACF9D6","405","720","image","1519972859","32","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2277584339135311","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2277584339135311","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.9686562781861576","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQAxWIUluehIV29V&w=1280&h=720&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2Fcw3axrHwL6U%2Fmaxresdefault.jpg&crop&sx=0&sy=0&sw=1280&sh=720&_nc_hash=AQCAxGfMaKWlU8zu","300","169","https://www.youtube.com/embed/cw3axrHwL6U?autoplay=1","600","338","video","1521801592","31","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2278626935697718","facebook","ANEC ha compartit un vídeo.","https://www.facebook.com/2103235553236858/posts/2278626935697718","Literland","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.2944481980935188","1528474045","https://scontent.xx.fbcdn.net/v/t15.0-10/15971082_369640590071046_1262564817013571584_n.jpg?_nc_cat=0&oh=f8467edbf4b1e10b505e45b711e7b622&oe=5BADA74E","300","169","http://www.facebook.com/video/embed?video_id=369639210071184","600","338","video","1521953072","30","approved","","{\"likes\":\"2\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2278627825697629","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2278627825697629","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.5662721866427661","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQCkXgNnJwQXayLd&w=1280&h=720&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2FzmzBvU3n5Hc%2Fmaxresdefault.jpg&crop&_nc_hash=AQBu4NasujmT_ylW","300","300","https://www.youtube.com/embed/zmzBvU3n5Hc?autoplay=1","600","600","video","1521953237","29","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2280031565557255","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2280031565557255","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.9480163696669195","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQBEqh0zFsmo1guA&w=720&h=720&url=https%3A%2F%2Fsilviacabrerapsicologia.files.wordpress.com%2F2015%2F01%2F14118718629_47e570b012_o.jpg%3Fw%3D660&cfs=1&_nc_hash=AQCC0NG01wHo0x8i","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQBEqh0zFsmo1guA&w=720&h=720&url=https%3A%2F%2Fsilviacabrerapsicologia.files.wordpress.com%2F2015%2F01%2F14118718629_47e570b012_o.jpg%3Fw%3D660&cfs=1&_nc_hash=AQCC0NG01wHo0x8i","440","440","image","1522146788","28","approved","https://silviacabrerapsicologia.com/2015/01/11/reeducacion-psicopedagogica-o-refuerzo-escolar/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2280146368879108","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2280146368879108","AutismoDiario","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.04126531913994375","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQBSP8xbPawQ4YXI&w=720&h=720&url=https%3A%2F%2Fwww.educaciontrespuntocero.com%2Fwp-content%2Fuploads%2F2018%2F03%2Fsamsung-empatia-escolar-5.jpg&cfs=1&_nc_hash=AQDz5bWaRtUyelUS","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQBSP8xbPawQ4YXI&w=720&h=720&url=https%3A%2F%2Fwww.educaciontrespuntocero.com%2Fwp-content%2Fuploads%2F2018%2F03%2Fsamsung-empatia-escolar-5.jpg&cfs=1&_nc_hash=AQDz5bWaRtUyelUS","600","600","image","1522162423","27","approved","https://www.educaciontrespuntocero.com/novedades2/asignatura-empatia-iniciativa-acoso-escolar-samsung/74959.html","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2280211298872615","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2280211298872615","Cristina","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3622775174326054","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/p720x720/29542526_1620654621305171_1877622379749383959_n.jpg?_nc_cat=0&oh=a0a212b27da9fdaaa353541f5156616d&oe=5B80B30A","300","300","https://scontent.xx.fbcdn.net/v/t1.0-9/p720x720/29542526_1620654621305171_1877622379749383959_n.jpg?_nc_cat=0&oh=a0a212b27da9fdaaa353541f5156616d&oe=5B80B30A","720","720","image","1522169249","26","approved","","{\"likes\":\"2\",\"comments\":\"0\",\"shares\":\"1\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2284944708399274","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2284944708399274","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.6875916604768407","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/29598263_10208914317575693_184855651889104412_n.jpg?_nc_cat=0&oh=56facd1c3f0037329de1ca7b5c12cb26&oe=5BB6002E","300","227","https://scontent.xx.fbcdn.net/v/t1.0-9/29598263_10208914317575693_184855651889104412_n.jpg?_nc_cat=0&oh=56facd1c3f0037329de1ca7b5c12cb26&oe=5BB6002E","475","360","image","1522862720","25","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","2"),
("ti46417","2103235553236858_2285250411702037","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2285250411702037","Aspau","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3511257808200324","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/29791739_10156181008338116_1090171919951597466_n.jpg?_nc_cat=0&oh=6c787a60cadf52f1c94dd93a1c421baa&oe=5BB7A2EA","300","298","https://scontent.xx.fbcdn.net/v/t1.0-9/29791739_10156181008338116_1090171919951597466_n.jpg?_nc_cat=0&oh=6c787a60cadf52f1c94dd93a1c421baa&oe=5BB7A2EA","720","715","image","1522911339","24","approved","","{\"likes\":\"5\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2287587208135024","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2287587208135024","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.6928539534032847","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","300","300","https://scontent.xx.fbcdn.net/v/t1.0-1/p100x100/11222803_10203189123809427_7011087466125716442_n.jpg?_nc_cat=0&oh=89415660bdbdedcd0aa3fafc7264fce5&oe=5B7C7E85","100","100","image","1523266759","23","approved","https://www.facebook.com/groups/636032229830391/permalink/1315253318574942/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2288624461364632","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2288624461364632","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.4108924552899715","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","300","169","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","720","405","image","1523426774","22","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2289283651298713","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2289283651298713","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.9759004469736483","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","300","169","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","600","338","image","1523535518","21","approved","https://www.facebook.com/groups/636032229830391/permalink/1318070944959846/","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2289315254628886","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2289315254628886","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.6468248997319722","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30653072_10208955822813298_7654892552767555531_n.jpg?_nc_cat=0&oh=fb3e803d3178e6cc50c9121362fc9520&oe=5BACBEF4","300","533","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30653072_10208955822813298_7654892552767555531_n.jpg?_nc_cat=0&oh=fb3e803d3178e6cc50c9121362fc9520&oe=5BACBEF4","405","720","image","1523540892","20","approved","","{\"likes\":\"2\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","12"),
("ti46417","2103235553236858_2289394354620976","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2289394354620976","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3064231884725608","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30226136_595171774152604_4325344107863920282_n.jpg?_nc_cat=0&oh=f0f34c95fd36a040e0fddab2908b45be&oe=5BB91AED","300","235","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30226136_595171774152604_4325344107863920282_n.jpg?_nc_cat=0&oh=f0f34c95fd36a040e0fddab2908b45be&oe=5BB91AED","720","565","image","1523550515","19","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2289694781257600","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2289694781257600","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.5916412739005324","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","300","169","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30167699_10208948656794152_7051803972482439145_o.jpg?_nc_cat=0&oh=8449aa4237460b7b15369cc4b833aa9b&oe=5BB61052","600","338","image","1523603556","18","approved","https://www.facebook.com/groups/636032229830391/permalink/1318791361554471/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2289923067901438","facebook","Mañana a la 10!!!!","https://www.facebook.com/2103235553236858/posts/2289923067901438","Surfinclusion","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.03893683481862474","1528474045","https://scontent.xx.fbcdn.net/v/t15.0-10/s720x720/27862035_731645513710368_5357086272777093120_n.jpg?_nc_cat=0&oh=306931f144156b944c08fd06c12b14b9&oe=5B7FF021","300","169","http://www.facebook.com/video/embed?video_id=731644333710486","600","338","video","1523632919","17","approved","","{\"likes\":\"2\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2290620237831721","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2290620237831721","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.41976038312517144","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1523734638","16","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2290620391165039","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2290620391165039","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.9819914419036279","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1523734658","15","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2290620504498361","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2290620504498361","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.6506760908762702","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30714902_10208965939146200_4179591364064837704_n.jpg?_nc_cat=0&oh=0cf620eba86ade269c586e040cbbc140&oe=5B7A4113","300","169","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30714902_10208965939146200_4179591364064837704_n.jpg?_nc_cat=0&oh=0cf620eba86ade269c586e040cbbc140&oe=5B7A4113","720","405","image","1523734686","14","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","12"),
("ti46417","2103235553236858_2290620664498345","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2290620664498345","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3074061594041122","1528474045","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30729376_10208965896385131_5389909962001480337_n.jpg?_nc_cat=0&oh=d76b2ae69d9eee3a3b65eb3c1536d40d&oe=5BAC5793","300","225","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30729376_10208965896385131_5389909962001480337_n.jpg?_nc_cat=0&oh=d76b2ae69d9eee3a3b65eb3c1536d40d&oe=5BAC5793","720","540","image","1523734715","13","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","12"),
("ti46417","2103235553236858_2290620744498337","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2290620744498337","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.5850025551253953","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1523734733","12","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2291850024375409","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2291850024375409","Risoterapia-ANEC Cullera","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.0027943281482852326","1528474045","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30072726_599425567060558_1317800471405666488_o.jpg?_nc_cat=0&oh=61c0e78f155cd97eb8d0e2f696ca8a47&oe=5BC26208","300","424","https://scontent.xx.fbcdn.net/v/t31.0-8/s720x720/30072726_599425567060558_1317800471405666488_o.jpg?_nc_cat=0&oh=61c0e78f155cd97eb8d0e2f696ca8a47&oe=5BC26208","509","720","image","1523909521","11","approved","","{\"likes\":\"1\",\"comments\":\"0\",\"shares\":\"1\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2296713730555705","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2296713730555705","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.2589640060988851","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQDUeBxHrg27jBJP&w=385&h=385&url=http%3A%2F%2Fstatic2.ideal.es%2Fubeda%2Fmultimedia%2F201802%2F13%2Fmedia%2Fcortadas%2FARV_creactivity-kNaF-U50962015390d4D-624x385%40Ideal.jpg&cfs=1&sx=222&sy=0&sw=385&sh=385&_nc_hash=AQC2EyyUh0EUg4CX","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQDUeBxHrg27jBJP&w=385&h=385&url=http%3A%2F%2Fstatic2.ideal.es%2Fubeda%2Fmultimedia%2F201802%2F13%2Fmedia%2Fcortadas%2FARV_creactivity-kNaF-U50962015390d4D-624x385%40Ideal.jpg&cfs=1&sx=222&sy=0&sw=385&sh=385&_nc_hash=AQC2EyyUh0EUg4CX","385","385","image","1524666554","10","approved","http://ubeda.ideal.es/ubeda/exposicion-despertar-ingenio-20180213132304-nt.html","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2297113083849103","facebook","ANEC ha compartit un enllaç.","https://www.facebook.com/2103235553236858/posts/2297113083849103","New video by ANEC Associació Necessitats Especials","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.2864370767832148","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQDeHeGAVU1IRQ0H&w=600&h=315&url=https%3A%2F%2Fscontent.xx.fbcdn.net%2Fv%2Ft45.1600-4%2F31263256_6091154526484_7602754805898936320_n.png%3Foh%3D4f5392d0454df5518be35985ba726e0b%26oe%3D5BC0A707&crop&_nc_hash=AQAt7ir3DEDBKOol","300","300","https://lh3.googleusercontent.com/g0eN9nJjb3VyUSWBb4bW0qq-_ZHoPIH1wfGb3LPjgA9Ob6Kfu5guFaX8dQ5kyvdKv_G1ZwMptyS2UTJe1kLOIpIEQm6PcEuf98Zj6hDwATFWTdWYl_N-UPyinfZA73aoM9tKuM6A5A=w600-h315-k-no-m18","600","600","video","1524720139","9","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2298229910404087","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2298229910404087","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.6552933963530635","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQDGuZysO_DKJAmO&w=1280&h=720&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2FWMtpjuXv6M8%2Fmaxresdefault.jpg&crop&sx=0&sy=0&sw=1280&sh=720&_nc_hash=AQAyTt1PUkbHJXbZ","300","169","https://www.youtube.com/embed/WMtpjuXv6M8?autoplay=1","600","338","video","1524896396","8","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2301861500040928","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2301861500040928","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.4171557821493184","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQDLR2w4FM8EsY-L&w=1286&h=720&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2FOsVqEFg7cPo%2Fmaxresdefault.jpg&crop&_nc_hash=AQAq_Wc5j_XB7pDO","300","300","https://www.youtube.com/embed/OsVqEFg7cPo?autoplay=1","600","600","video","1525411114","7","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314931702067241","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314931702067241","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.11989875242104638","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQATb9H5c193kEZw&w=1920&h=1080&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2FMpFMBFJ09AM%2Fmaxresdefault.jpg&crop&_nc_hash=AQAKSfpzVuC4XIEa","300","300","https://www.youtube.com/embed/MpFMBFJ09AM?autoplay=1","600","600","video","1527499733","6","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314931828733895","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314931828733895","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3480264463909217","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQAp37DJaMuQCSP6&w=720&h=720&url=http%3A%2F%2Fwww.todostenemostalento.es%2Fdocuments%2F333392%2F0%2Fbg-destacado-libro-blanco_imagen.png&cfs=1&_nc_hash=AQBb3EhWtPCY-bcX","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQAp37DJaMuQCSP6&w=720&h=720&url=http%3A%2F%2Fwww.todostenemostalento.es%2Fdocuments%2F333392%2F0%2Fbg-destacado-libro-blanco_imagen.png&cfs=1&_nc_hash=AQBb3EhWtPCY-bcX","171","171","image","1527499758","5","approved","http://www.todostenemostalento.es/capitulos-libro-blanco","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314931912067220","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314931912067220","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.3804360054251142","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1527499775","4","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314932012067210","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314932012067210","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.858100718686451","1528474045",NULL,NULL,NULL,NULL,NULL,NULL,NULL,"1527499798","3","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314932135400531","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314932135400531","Victoria","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.14919560789055714","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQBhMmRbMJUIFLkU&w=480&h=360&url=https%3A%2F%2Fi.ytimg.com%2Fvi%2Fz7jJNppebDo%2Fhqdefault.jpg&crop&_nc_hash=AQBrY5jOWJ2cJSmD","300","300","https://www.youtube.com/embed/z7jJNppebDo?autoplay=1","600","600","video","1527499815","2","approved","","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314932232067188","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314932232067188","Antonia","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.17167591412707783","1528474045","https://scontent.xx.fbcdn.net/v/t15.0-10/p720x720/27856140_1997202613652938_5398872357492228096_n.jpg?_nc_cat=0&oh=3ef689c59f8cf3d2aa7e833ae03b3faa&oe=5BB4278C","300","300","https://scontent.xx.fbcdn.net/v/t15.0-10/p720x720/27856140_1997202613652938_5398872357492228096_n.jpg?_nc_cat=0&oh=3ef689c59f8cf3d2aa7e833ae03b3faa&oe=5BB4278C","600","600","image","1527499837","1","approved","https://www.facebook.com/groups/636032229830391/permalink/1354145838019023/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0"),
("ti46417","2103235553236858_2314932372067174","facebook","ANEC ha compartit una publicació.","https://www.facebook.com/2103235553236858/posts/2314932372067174","Antonia","","ANEC","https://graph.facebook.com/2103235553236858/picture?width=80&height=80","https://www.facebook.com/2103235553236858","0.4107927776973627","1528474045","https://external.xx.fbcdn.net/safe_image.php?d=AQCr0ZUN3v70xP-5&w=720&h=720&url=http%3A%2F%2Feldiariodelaeducacion.com%2Fwp-content%2Fuploads%2F2018%2F05%2Fmarta-medina.jpg&cfs=1&sx=224&sy=0&sw=815&sh=815&_nc_hash=AQCDRsfw4PaEzHP6","300","300","https://external.xx.fbcdn.net/safe_image.php?d=AQCr0ZUN3v70xP-5&w=720&h=720&url=http%3A%2F%2Feldiariodelaeducacion.com%2Fwp-content%2Fuploads%2F2018%2F05%2Fmarta-medina.jpg&cfs=1&sx=224&sy=0&sw=815&sh=815&_nc_hash=AQCDRsfw4PaEzHP6","600","600","image","1527499863","0","approved","http://eldiariodelaeducacion.com/blog/2018/05/21/la-educacion-inclusiva-aporta-mas-a-persona-sin-discapacidad-que-a-quienes-la-tienen/","{\"likes\":\"0\",\"comments\":\"0\",\"shares\":\"0\"}","","0","0","0","","0");

INSERT IGNORE INTO `ac_ff_post_media` VALUES 
("58","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30729376_10208965896385131_5389909962001480337_n.jpg?_nc_cat=0&oh=d76b2ae69d9eee3a3b65eb3c1536d40d&oe=5BAC5793","720","540","image"),
("59","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30705534_10208965897065148_7330678773884938956_n.jpg?_nc_cat=0&oh=063917e7e6ea6c623153192678e659a2&oe=5BAF453D","720","540","image"),
("60","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30728875_10208965897705164_8833228376789598007_n.jpg?_nc_cat=0&oh=f7613f6ef8c24584766b12971e3b7bd4&oe=5BAEA49A","720","540","image"),
("61","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30710742_10208965898305179_375701948540543102_n.jpg?_nc_cat=0&oh=4a52878f9183c191430d50fee155c61c&oe=5BBB96E0","720","540","image"),
("62","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30729307_10208965898585186_2709480652708555325_n.jpg?_nc_cat=0&oh=69a6f5ac98d14ec46cfbfee9a1c226c2&oe=5B81408A","720","540","image"),
("63","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30710887_10208965899225202_5128570340853231429_n.jpg?_nc_cat=0&oh=a1b98ddc5f063b2092a8bb4aeef33b0b&oe=5BB712E0","720","540","image"),
("64","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30707307_10208965899665213_3138268661169281345_n.jpg?_nc_cat=0&oh=3f4641ece8080df15e6f520f58bdd360&oe=5BAA387E","720","540","image"),
("65","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30704557_10208965900225227_8818086174946081319_n.jpg?_nc_cat=0&oh=42dd3d38844db852bb2ec06b0349b3fd&oe=5BB7A20B","720","540","image"),
("66","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30715824_10208965900625237_885039310148694436_n.jpg?_nc_cat=0&oh=123a82aea8471bc1f99932c5d68d00f0&oe=5B7D444C","720","540","image"),
("67","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30704510_10208965901705264_7659670655836794566_n.jpg?_nc_cat=0&oh=44924890f2f0902c3ae8865ca639ee48&oe=5BABA03B","720","540","image"),
("68","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30712478_10208965902585286_2869087770588446312_n.jpg?_nc_cat=0&oh=944294ba945bcf1879883808186c1ec3&oe=5B7C9104","720","540","image"),
("69","ti46417","2103235553236858_2290620664498345","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30714438_10208965902985296_3915287888859386782_n.jpg?_nc_cat=0&oh=d866b22a7a6cd45b743af7af28fb9724&oe=5B7C1D17","720","540","image"),
("70","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30714902_10208965939146200_4179591364064837704_n.jpg?_nc_cat=0&oh=0cf620eba86ade269c586e040cbbc140&oe=5B7A4113","720","405","image"),
("71","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30704915_10208965939706214_5709510991772246869_n.jpg?_nc_cat=0&oh=280e2a67157a8f8ee181f8fb13ad6de2&oe=5BBFBE7B","720","405","image"),
("72","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30709284_10208965940626237_2768477863759543436_n.jpg?_nc_cat=0&oh=aa215eca8f8a922b77f832207c16f535&oe=5BBA73F6","720","405","image"),
("73","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30715830_10208965941906269_8149193350626047289_n.jpg?_nc_cat=0&oh=cc7716e199f758813c638c8acdea2e44&oe=5BAD6CD5","405","720","image"),
("74","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30705467_10208965943906319_4967676770160106121_n.jpg?_nc_cat=0&oh=1c0a5e984f5cb6a0e67cdb91b1b10c3d&oe=5B802E6A","720","405","image"),
("75","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30728463_10208965945146350_1059421600755328652_n.jpg?_nc_cat=0&oh=2137d41e7f2f84cdcf81eaefabf71040&oe=5BC3E0BE","720","405","image"),
("76","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30708165_10208965946386381_4731305591484302435_n.jpg?_nc_cat=0&oh=bdf647717ee85dcd50c22d83bdad72d5&oe=5BB8648F","720","405","image"),
("77","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30711968_10208965948186426_7584187437726607718_n.jpg?_nc_cat=0&oh=771162b6bb53a1f8471d6355bf3ca882&oe=5BB2E33C","405","720","image"),
("78","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/30708767_10208965950666488_5020007981866758375_n.jpg?_nc_cat=0&oh=c6b5fee92b2957e25d5512a6bb2634b7&oe=5BAB446A","720","540","image"),
("79","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30739303_10208965951706514_323147165641432451_n.jpg?_nc_cat=0&oh=507db99de4e90245979e8ba164ccfeff&oe=5B81FF90","720","405","image"),
("80","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30713944_10208965955226602_1198388092644376205_n.jpg?_nc_cat=0&oh=b9b60dadb6567f0468bd1f1df299b992&oe=5B783BFA","405","720","image"),
("81","ti46417","2103235553236858_2290620504498361","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30715284_10208965955666613_813003946077615538_n.jpg?_nc_cat=0&oh=5915d0a8cdd7961a02b75ee6a0324aa9&oe=5B7B82F4","720","405","image"),
("82","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30653072_10208955822813298_7654892552767555531_n.jpg?_nc_cat=0&oh=fb3e803d3178e6cc50c9121362fc9520&oe=5BACBEF4","405","720","image"),
("83","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30624580_10208955823173307_5235219953981560732_n.jpg?_nc_cat=0&oh=201a7ad839f47c38031e5339cf9b185f&oe=5BB4E926","405","720","image"),
("84","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30705921_10208955823413313_2753502834522236359_n.jpg?_nc_cat=0&oh=c246fad8551d91adfa17ac7643a3d9ac&oe=5BBD8C93","405","720","image"),
("85","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30629512_10208955823813323_8017526878098039608_n.jpg?_nc_cat=0&oh=040ef7dc955db70005a4cf783828235f&oe=5B795978","405","720","image"),
("86","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30629694_10208955824253334_980125510133338041_n.jpg?_nc_cat=0&oh=90a1f68e61cfc4bfb9ea9ceb1f64edcb&oe=5BC2E215","405","720","image"),
("87","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30689148_10208955824493340_6902935100605802377_n.jpg?_nc_cat=0&oh=ced4caa7bf0f64bc4208c783e4e7f5cc&oe=5BAEEABA","405","720","image"),
("88","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30714283_10208955824733346_2867501046140864922_n.jpg?_nc_cat=0&oh=a70e8ad542eb8d08f9c65339050a7bf6&oe=5BABD091","405","720","image"),
("89","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30624425_10208955825093355_6773850527339361515_n.jpg?_nc_cat=0&oh=84e739ab8ac96c1cb6530bf0e164f713&oe=5BAEC389","720","405","image"),
("90","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30698241_10208955825413363_115969657394407298_n.jpg?_nc_cat=0&oh=9e9383f293aecb76635173656dea7efa&oe=5BB30CCD","720","405","image"),
("91","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30629563_10208955825773372_1521642935497581318_n.jpg?_nc_cat=0&oh=d449e8d8e461219992b6882f2ad865c4&oe=5BAF3551","720","405","image"),
("92","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30715578_10208955826133381_3123348779103925763_n.jpg?_nc_cat=0&oh=595b092a6f3dbe98380260bb83b122b0&oe=5BC45322","405","720","image"),
("93","ti46417","2103235553236858_2289315254628886","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/30656583_10208955826453389_7359785825167198523_n.jpg?_nc_cat=0&oh=f752712e85fb433cf61968fbd7d3dce3&oe=5BAE228B","720","405","image"),
("94","ti46417","2103235553236858_2284944708399274","image","https://scontent.xx.fbcdn.net/v/t1.0-9/29598263_10208914317575693_184855651889104412_n.jpg?_nc_cat=0&oh=56facd1c3f0037329de1ca7b5c12cb26&oe=5BB6002E","475","360","image"),
("95","ti46417","2103235553236858_2284944708399274","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/29695382_10208914317895701_2216392273321334241_n.jpg?_nc_cat=0&oh=4c1b54c2186cda84c3142a42476e7048&oe=5BAE8735","720","543","image"),
("96","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27540089_1688719657851671_268099742341853335_n.jpg?_nc_cat=0&oh=fcb3c2db87008fa1ad7731e0687fb6b0&oe=5BB0E528","720","405","image"),
("97","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27654464_1688719667851670_4667575632282487318_n.jpg?_nc_cat=0&oh=52841e6145be14de16d72186b13c3c90&oe=5B7B8B34","720","405","image"),
("98","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27540693_1688719674518336_411778402520126780_n.jpg?_nc_cat=0&oh=c5e5b884527150d13cdcaad747de6f51&oe=5BB45BFB","720","405","image"),
("99","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27459622_1688719671185003_6724324717880792260_n.jpg?_nc_cat=0&oh=8c7a8560abd44280a416be9c5914472e&oe=5BB4DB0A","720","405","image"),
("100","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27459427_1688719744518329_7325430785152990680_n.jpg?_nc_cat=0&oh=8df93d9923b1e977bb3ff386bc1387e1&oe=5B7F7CDE","720","405","image"),
("101","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27459805_1688719731184997_8959356625201251221_n.jpg?_nc_cat=0&oh=6b64f05136a27285b01d50d67fba3a92&oe=5BABAF28","720","405","image"),
("102","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27459928_1688719764518327_4315683862136336821_n.jpg?_nc_cat=0&oh=de982e67014d1c136e74f83c2a591df9&oe=5BB54621","720","405","image"),
("103","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27657200_1688719794518324_1028491124385397824_n.jpg?_nc_cat=0&oh=7807c4f0d367249a7268929f7cf510f9&oe=5BBAD4E7","720","405","image"),
("104","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27751822_1688719834518320_8276444875820851098_n.jpg?_nc_cat=0&oh=21295b68adf5a8c37f52a5198eaa614a&oe=5BAABEF8","720","405","image"),
("105","ti46417","2103235553236858_2250375498522862","image","https://scontent.xx.fbcdn.net/v/t1.0-9/s720x720/27655426_1688719851184985_7311227238655911786_n.jpg?_nc_cat=0&oh=22c58c8451a290362a566ca1463d3806&oe=5B7C35A4","720","405","image"),
("106","ti46417","2103235553236858_2246218265605252","image","https://scontent.xx.fbcdn.net/v/t1.0-9/p720x720/27067120_10208510757526944_5206550342245801167_n.jpg?_nc_cat=0&oh=51baaf36ae5ac1aeb3bba9c781d5d8de&oe=5BC061CF","720","720","image"),
("107","ti46417","2103235553236858_2246218265605252","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/26994367_10208510757886953_5474842928935311418_n.jpg?_nc_cat=0&oh=a42027be3304b0e1be11f272017a23af&oe=5B7EACA0","720","540","image"),
("108","ti46417","2103235553236858_2246218265605252","image","https://scontent.xx.fbcdn.net/v/t1.0-0/p180x540/27067088_10208510758446967_2970546428679001158_n.jpg?_nc_cat=0&oh=10b8668b49f9daf5a9f2427af0ef10dd&oe=5B7CAB0E","720","540","image");

INSERT IGNORE INTO `ac_ff_streams` VALUES 
("1","","O:8:\"stdClass\":97:{s:4:\"name\";s:0:\"\";s:10:\"moderation\";s:4:\"nope\";s:5:\"order\";s:12:\"smartCompare\";s:5:\"posts\";s:2:\"30\";s:4:\"days\";s:0:\"\";s:10:\"page-posts\";s:2:\"15\";s:5:\"cache\";s:3:\"yep\";s:14:\"cache_lifetime\";s:2:\"10\";s:7:\"gallery\";s:3:\"yep\";s:7:\"private\";s:4:\"nope\";s:15:\"hide-on-desktop\";s:4:\"nope\";s:14:\"hide-on-mobile\";s:4:\"nope\";s:7:\"max-res\";s:3:\"yep\";s:21:\"show-only-media-posts\";s:4:\"nope\";s:6:\"titles\";s:3:\"yep\";s:8:\"hidemeta\";s:4:\"nope\";s:8:\"hidetext\";s:4:\"nope\";s:7:\"heading\";s:0:\"\";s:12:\"headingcolor\";s:15:\"rgb(59, 61, 64)\";s:10:\"subheading\";s:0:\"\";s:15:\"subheadingcolor\";s:18:\"rgb(114, 112, 114)\";s:7:\"hhalign\";s:6:\"center\";s:7:\"bgcolor\";s:18:\"rgb(255, 255, 255)\";s:6:\"filter\";s:4:\"nope\";s:11:\"filtercolor\";s:18:\"rgb(205, 205, 205)\";s:12:\"mobileslider\";s:4:\"nope\";s:10:\"viewportin\";s:4:\"nope\";s:5:\"width\";s:3:\"260\";s:6:\"margin\";s:2:\"20\";s:6:\"layout\";s:7:\"masonry\";s:5:\"theme\";s:7:\"classic\";s:8:\"gc-style\";s:7:\"style-1\";s:8:\"upic-pos\";s:9:\"timestamp\";s:10:\"upic-style\";s:5:\"round\";s:10:\"icon-style\";s:3:\"off\";s:9:\"cardcolor\";s:18:\"rgb(255, 255, 255)\";s:9:\"namecolor\";s:15:\"rgb(59, 61, 64)\";s:9:\"textcolor\";s:18:\"rgb(131, 141, 143)\";s:10:\"linkscolor\";s:17:\"rgb(94, 159, 202)\";s:9:\"restcolor\";s:18:\"rgb(132, 118, 129)\";s:6:\"shadow\";s:19:\"rgba(0, 0, 0, 0.05)\";s:6:\"bcolor\";s:19:\"rgba(0, 0, 0, 0.75)\";s:6:\"talign\";s:4:\"left\";s:11:\"icons-style\";s:4:\"fill\";s:9:\"cards-num\";s:1:\"3\";s:9:\"scrolltop\";s:3:\"yep\";s:9:\"c-desktop\";s:1:\"5\";s:8:\"c-laptop\";s:1:\"4\";s:10:\"c-tablet-l\";s:1:\"3\";s:10:\"c-tablet-p\";s:1:\"2\";s:9:\"c-smart-l\";s:1:\"2\";s:9:\"c-smart-p\";s:1:\"1\";s:9:\"s-desktop\";s:2:\"15\";s:8:\"s-laptop\";s:2:\"15\";s:10:\"s-tablet-l\";s:2:\"10\";s:10:\"s-tablet-p\";s:2:\"10\";s:9:\"s-smart-l\";s:1:\"5\";s:9:\"s-smart-p\";s:1:\"5\";s:11:\"m-c-desktop\";s:1:\"5\";s:10:\"m-c-laptop\";s:1:\"4\";s:12:\"m-c-tablet-l\";s:1:\"3\";s:12:\"m-c-tablet-p\";s:1:\"2\";s:11:\"m-c-smart-l\";s:1:\"2\";s:11:\"m-c-smart-p\";s:1:\"1\";s:11:\"m-s-desktop\";s:2:\"15\";s:10:\"m-s-laptop\";s:2:\"15\";s:12:\"m-s-tablet-l\";s:2:\"10\";s:12:\"m-s-tablet-p\";s:2:\"10\";s:11:\"m-s-smart-l\";s:1:\"5\";s:11:\"m-s-smart-p\";s:1:\"5\";s:11:\"j-h-desktop\";s:3:\"260\";s:10:\"j-h-laptop\";s:3:\"240\";s:12:\"j-h-tablet-l\";s:3:\"220\";s:12:\"j-h-tablet-p\";s:3:\"200\";s:11:\"j-h-smart-l\";s:3:\"180\";s:11:\"j-h-smart-p\";s:3:\"160\";s:11:\"j-s-desktop\";s:1:\"0\";s:10:\"j-s-laptop\";s:1:\"0\";s:12:\"j-s-tablet-l\";s:1:\"0\";s:12:\"j-s-tablet-p\";s:1:\"0\";s:11:\"j-s-smart-l\";s:1:\"0\";s:11:\"j-s-smart-p\";s:1:\"0\";s:9:\"g-ratio-w\";s:1:\"1\";s:9:\"g-ratio-h\";s:1:\"2\";s:11:\"g-ratio-img\";s:3:\"1/2\";s:9:\"g-overlay\";s:4:\"nope\";s:9:\"m-overlay\";s:4:\"nope\";s:3:\"css\";s:0:\"\";s:8:\"template\";a:4:{i:0;s:5:\"image\";i:1;s:6:\"header\";i:2;s:4:\"text\";i:3;s:4:\"meta\";}s:2:\"tv\";s:4:\"nope\";s:6:\"tv-int\";s:1:\"5\";s:7:\"tv-logo\";s:0:\"\";s:5:\"tv-bg\";s:0:\"\";s:3:\"big\";s:4:\"nope\";s:2:\"id\";s:1:\"1\";s:12:\"last_changes\";i:1528457976;s:6:\"status\";s:1:\"1\";}");

INSERT IGNORE INTO `ac_formmaker` VALUES 
("1","Contact Us","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - Name%</div><div wdid=\"3\" class=\"wdform_row\">%3 - Email%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Subject%</div><div wdid=\"5\" class=\"wdform_row\">%5 - Message%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","1","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}\r\n// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","6","1","2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#2_elementform_id_temp#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","testmode","","","0","2*:*id*:*type_text*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*3*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_text*:*type*:*Subject*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*5*:*id*:*type_textarea*:*type*:*Message*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","3916","1","Contact Us","You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.","","none","0","0"),
("2","Client List Form","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - First Name%</div><div wdid=\"3\" class=\"wdform_row\">%3 - Last Name%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Email%</div><div wdid=\"5\" class=\"wdform_row\">%5 - Phone%</div><div wdid=\"6\" class=\"wdform_row\">%6 - Website%</div><div wdid=\"7\" class=\"wdform_row\">%7 - Address%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","1","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","13","1","2#**id**#First Name#**label**#type_text#****#3#**id**#Last Name#**label**#type_text#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#Phone#**label**#type_text#****#6#**id**#Website#**label**#type_text#****#7#**id**#Street Address#**label**#type_address#****#8#**id**#Street Address Line 2#**label**#type_address#****#9#**id**#City#**label**#type_address#****#10#**id**#State / Province / Region#**label**#type_address#****#11#**id**#Postal / Zip Code#**label**#type_address#****#12#**id**#Country#**label**#type_address#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#7_street1form_id_temp#**id**#type_submit_reset_1#**label**#type_submit_reset#****#7_street2form_id_temp#**id**##**label**##****#7_cityform_id_temp#**id**#undefined#**label**#undefined#****#7_stateform_id_temp#**id**#undefined#**label**#undefined#****#7_postalform_id_temp#**id**#undefined#**label**#undefined#****#7_countryform_id_temp#**id**#undefined#**label**#undefined#****#","2#**id**#First Name#**label**#type_text#****#3#**id**#Last Name#**label**#type_text#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#Phone#**label**#type_text#****#6#**id**#Website#**label**#type_text#****#7#**id**#Street Address#**label**#type_address#****#8#**id**#Street Address Line 2#**label**#type_address#****#9#**id**#City#**label**#type_address#****#10#**id**#State / Province / Region#**label**#type_address#****#11#**id**#Postal / Zip Code#**label**#type_address#****#12#**id**#Country#**label**#type_address#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","testmode","","","0","2*:*id*:*type_text*:*type*:*First Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*3*:*id*:*type_text*:*type*:*Last Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Phone*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Website*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:*http://example.com*:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*7*:*id*:*type_address*:*type*:*Address*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","0","1","","","","none","0","0"),
("3","Feedback Form","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - Name%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Email%</div><div wdid=\"5\" class=\"wdform_row\" style=\"position: relative; left: 0px; top: 0px;\">%5 - CMS%</div><div wdid=\"6\" class=\"wdform_row\">%6 - Extension%</div><div wdid=\"7\" class=\"wdform_row\">%7 - Plugin%</div><div wdid=\"2\" class=\"wdform_row\" style=\"position: relative; left: 0px; top: 0px;\">%2 - Subject%</div><div wdid=\"8\" class=\"wdform_row\">%8 - Message%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","3","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","9","1","3#**id**#Name#**label**#type_name#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#CMS#**label**#type_radio#****#6#**id**#Extension#**label**#type_own_select#****#7#**id**#Plugin#**label**#type_own_select#****#2#**id**#Subject#**label**#type_text#****#8#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#2_elementform_id_temp#**id**#Text#**label**#type_text#****#","3#**id**#Name#**label**#type_name#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#CMS#**label**#type_radio#****#6#**id**#Extension#**label**#type_own_select#****#7#**id**#Plugin#**label**#type_own_select#****#2#**id**#Subject#**label**#type_text#****#8#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","0","","USD","0","3*:*id*:*type_name*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:***********:*w_first_val*:*First***Last*******:*w_title*:*Title*********Middle*:*w_mini_labels*:**:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no***no*:*w_name_fields*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*5*:*id*:*type_radio*:*type*:*CMS*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*hor*:*w_flow*:*Joomla!***Wordpress*:*w_choices*:*false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Joomla!***Wordpress*:*w_choices_value*:*****:*w_choices_params*:**:*w_class*:**:*new_field*:*6*:*id*:*type_own_select*:*type*:*Extension*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select extension***Form Maker***Gallery WD***Spider Calendar*:*w_choices*:*true***false***false***false*:*w_choices_checked*:*true***false***false***false*:*w_choices_disabled*:*yes*:*w_required*:*no*:*w_value_disabled*:****Form Maker***Gallery WD***Spider Calendar*:*w_choices_value*:***********:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*7*:*id*:*type_own_select*:*type*:*Plugin*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select plugin***Form Maker***Photo Gallery***Ecommerce WD*:*w_choices*:*true***false***false***false*:*w_choices_checked*:*true***false***false***false*:*w_choices_disabled*:*yes*:*w_required*:*no*:*w_value_disabled*:****Form Maker***Photo Gallery***Ecommerce WD*:*w_choices_value*:***********:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Subject*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*8*:*id*:*type_textarea*:*type*:*Message*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","1*:*show_hide*:*6*:*field_label*:*and*:*all_any*:*5***==***Joomla!*:*next_condition*:**:*new_condition*:*1*:*show_hide*:*7*:*field_label*:*and*:*all_any*:*5***==***Wordpress*:*next_condition*:**:*new_condition*:*","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","110","1","Feedback Form","You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.","https://www.aneccullera.org/wp-content/plugins/form-maker/images/demo/2.png","flash","0","0"),
("4","Business Demographic Survey","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - What is your employment status?%</div><div wdid=\"3\" class=\"wdform_row\">%3 - What is your level of education?%</div><div wdid=\"4\" class=\"wdform_row\">%4 - In which industry do you work?%</div><div wdid=\"6\" class=\"wdform_row\">%6 - What is the annual revenue of your company?%</div><div wdid=\"5\" class=\"wdform_row\">%5 - Enter characters for verification.%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","4","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","7","1","2#**id**#What is your employment status?#**label**#type_radio#****#3#**id**#What is your level of education?#**label**#type_radio#****#4#**id**#In which industry do you work?#**label**#type_own_select#****#6#**id**#What is the annual revenue of your company?#**label**#type_radio#****#5#**id**#Enter characters for verification.#**label**#type_captcha#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#6_elementform_id_temp0#**id**#What is your employment status?#**label**#type_radio#****#6_elementform_id_temp1#**id**#What is your level of education?#**label**#type_radio#****#6_elementform_id_temp2#**id**#In which industry do you work?#**label**#type_own_select#****#6_elementform_id_temp3#**id**#Enter characters for verification.#**label**#type_captcha#****#6_elementform_id_temp4#**id**#type_submit_reset_1#**label**#type_submit_reset#****#6_elementform_id_temp5#**id**#type_submit_reset_1#**label**#type_submit_reset#****#6_elementform_id_temp6#**id**##**label**##****#6_elementform_id_temp7#**id**#undefined#**label**#undefined#****#6_elementform_id_temp8#**id**#undefined#**label**#undefined#****#6_elementform_id_temp9#**id**#undefined#**label**#undefined#****#6_elementform_id_temp10#**id**#undefined#**label**#undefined#****#6_elementform_id_temp11#**id**#undefined#**label**#undefined#****#6_elementform_id_temp12#**id**#undefined#**label**#undefined#****#6_elementform_id_temp13#**id**#undefined#**label**#undefined#****#6_elementform_id_temp14#**id**#undefined#**label**#undefined#****#6_elementform_id_temp15#**id**#undefined#**label**#undefined#****#6_elementform_id_temp16#**id**#undefined#**label**#undefined#****#6_elementform_id_temp17#**id**#undefined#**label**#undefined#****#6_elementform_id_temp18#**id**#undefined#**label**#undefined#****#6_elementform_id_temp19#**id**#undefined#**label**#undefined#****#6_elementform_id_temp20#**id**#undefined#**label**#undefined#****#6_elementform_id_temp21#**id**#undefined#**label**#undefined#****#6_elementform_id_temp22#**id**#undefined#**label**#undefined#****#6_elementform_id_temp23#**id**#undefined#**label**#undefined#****#6_elementform_id_temp24#**id**#undefined#**label**#undefined#****#6_elementform_id_temp25#**id**#undefined#**label**#undefined#****#6_elementform_id_temp26#**id**#undefined#**label**#undefined#****#6_elementform_id_temp27#**id**#undefined#**label**#undefined#****#6_elementform_id_temp28#**id**#undefined#**label**#undefined#****#6_elementform_id_temp29#**id**#undefined#**label**#undefined#****#6_elementform_id_temp30#**id**#undefined#**label**#undefined#****#6_elementform_id_temp31#**id**#undefined#**label**#undefined#****#6_elementform_id_temp32#**id**#undefined#**label**#undefined#****#6_elementform_id_temp33#**id**#undefined#**label**#undefined#****#6_elementform_id_temp34#**id**#undefined#**label**#undefined#****#6_elementform_id_temp35#**id**#undefined#**label**#undefined#****#6_elementform_id_temp36#**id**#undefined#**label**#undefined#****#6_elementform_id_temp37#**id**#undefined#**label**#undefined#****#6_elementform_id_temp38#**id**#undefined#**label**#undefined#****#6_elementform_id_temp39#**id**#undefined#**label**#undefined#****#6_elementform_id_temp40#**id**#undefined#**label**#undefined#****#6_elementform_id_temp41#**id**#undefined#**label**#undefined#****#6_elementform_id_temp42#**id**#undefined#**label**#undefined#****#6_elementform_id_temp43#**id**#undefined#**label**#undefined#****#6_elementform_id_temp44#**id**#undefined#**label**#undefined#****#6_elementform_id_temp45#**id**#undefined#**label**#undefined#****#6_elementform_id_temp46#**id**#undefined#**label**#undefined#****#6_elementform_id_temp47#**id**#undefined#**label**#undefined#****#6_elementform_id_temp48#**id**#undefined#**label**#undefined#****#6_elementform_id_temp49#**id**#undefined#**label**#undefined#****#","2#**id**#What is your employment status?#**label**#type_radio#****#3#**id**#What is your level of education?#**label**#type_radio#****#4#**id**#In which industry do you work?#**label**#type_own_select#****#6#**id**#What is the annual revenue of your company?#**label**#type_radio#****#5#**id**#Enter characters for verification.#**label**#type_captcha#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","testmode","","","0","2*:*id*:*type_radio*:*type*:*What is your employment status?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Employed full time***Trade or Vocational degree***Not employed, but looking for work***Not employed and not looking for work***Retired***Student***Homemaker***Prefer not to answer*:*w_choices*:*false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Employed full time***Trade or Vocational degree***Not employed, but looking for work***Not employed and not looking for work***Retired***Student***Homemaker***Prefer not to answer*:*w_choices_value*:***********************:*w_choices_params*:**:*w_class*:**:*new_field*:*3*:*id*:*type_radio*:*type*:*What is your level of education?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Some high school***High school graduate or equivalent***Trade or Vocational Degree***Some college***Associate degree***Bachelor\'s degree***Graduate or Professional degree***Prefer not to answer*:*w_choices*:*false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Some high school***High school graduate or equivalent***Trade or Vocational Degree***Some college***Associate degree***Bachelor\'s degree***Graduate or Professional degree***Prefer not to answer*:*w_choices_value*:***********************:*w_choices_params*:**:*w_class*:**:*new_field*:*4*:*id*:*type_own_select*:*type*:*In which industry do you work?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select industry***Agriculture***Engineering***Information Technologies***Media***Local Business*:*w_choices*:*true***false***false***false***false***false*:*w_choices_checked*:*true***false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*no*:*w_value_disabled*:****Agriculture***Engineering***Information Technologies***Media***Local Business*:*w_choices_value*:*****************:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*6*:*id*:*type_radio*:*type*:*What is the annual revenue of your company?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Under $10,000***$10,001 to $50,000***$50,001 to $100,000***$100,001 to $500,000***$500,001 to $1 Million***$1 Million to $10 Million***$10 Million to $50 Million***$50 Million to $100 Million***Over $100 Million*:*w_choices*:*false***false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Under $10,000***$10,001 to $50,000***$50,001 to $100,000***$100,001 to $500,000***$500,001 to $1 Million***$1 Million to $10 Million***$10 Million to $50 Million***$50 Million to $100 Million***Over $100 Million*:*w_choices_value*:**************************:*w_choices_params*:**:*w_class*:**:*new_field*:*5*:*id*:*type_captcha*:*type*:*Enter characters for verification.*:*w_field_label*:**:*w_field_label_size*:*left*:*w_field_label_pos*:*yes*:*w_hide_label*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","0","1","Business Demographic Survey","Thank you for joining our business demographic survey. Please give us your feedback by filling in the information bellow.","","none","1","0"),
("5","Cupcake Order Form","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - Name%</div><div wdid=\"3\" class=\"wdform_row\">%3 - Email%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Date%</div><div wdid=\"5\" class=\"wdform_row\">%5 - Cupcakes Flavors (1 doz. minimum)%</div><div wdid=\"6\" class=\"wdform_row\">%6 - Quantity%</div><div wdid=\"7\" class=\"wdform_row\">%7 - Details (if any)%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","6","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","8","1","2#**id**#Name#**label**#type_name#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Date#**label**#type_date_new#****#5#**id**#Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#6#**id**#Quantity#**label**#type_spinner#****#7#**id**#Details (if any)#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp0#**id**#Name#**label**#type_name#****#5_elementform_id_temp1#**id**#Email#**label**#type_submitter_mail#****#5_elementform_id_temp2#**id**#Date#**label**#type_date_new#****#5_elementform_id_temp3#**id**#Name:*   Email:* Date* Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#5_elementform_id_temp4#**id**#Quantity#**label**#type_spinner#****#5_elementform_id_temp5#**id**#Details (if any)#**label**#type_textarea#****#5_elementform_id_temp6#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp7#**id**#Name#**label**#type_name#****#5_elementform_id_temp8#**id**#Email#**label**#type_submitter_mail#****#5_elementform_id_temp9#**id**#Date#**label**#type_date_new#****#5_elementform_id_temp10#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp11#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp12#**id**#undefined#**label**#undefined#****#5_elementform_id_temp13#**id**#undefined#**label**#undefined#****#5_elementform_id_temp14#**id**#undefined#**label**#undefined#****#5_elementform_id_temp15#**id**#undefined#**label**#undefined#****#5_elementform_id_temp16#**id**#undefined#**label**#undefined#****#5_elementform_id_temp17#**id**#undefined#**label**#undefined#****#5_elementform_id_temp18#**id**#undefined#**label**#undefined#****#5_elementform_id_temp19#**id**#undefined#**label**#undefined#****#5_elementform_id_temp20#**id**#undefined#**label**#undefined#****#5_elementform_id_temp21#**id**#undefined#**label**#undefined#****#5_elementform_id_temp22#**id**#undefined#**label**#undefined#****#5_elementform_id_temp23#**id**#undefined#**label**#undefined#****#5_elementform_id_temp24#**id**#undefined#**label**#undefined#****#5_elementform_id_temp25#**id**#undefined#**label**#undefined#****#5_elementform_id_temp26#**id**#undefined#**label**#undefined#****#5_elementform_id_temp27#**id**#undefined#**label**#undefined#****#5_elementform_id_temp28#**id**#undefined#**label**#undefined#****#5_elementform_id_temp29#**id**#undefined#**label**#undefined#****#5_elementform_id_temp30#**id**#undefined#**label**#undefined#****#5_elementform_id_temp31#**id**#undefined#**label**#undefined#****#5_elementform_id_temp32#**id**#undefined#**label**#undefined#****#5_elementform_id_temp33#**id**#undefined#**label**#undefined#****#5_elementform_id_temp34#**id**#undefined#**label**#undefined#****#5_elementform_id_temp35#**id**#undefined#**label**#undefined#****#5_elementform_id_temp36#**id**#undefined#**label**#undefined#****#5_elementform_id_temp37#**id**#undefined#**label**#undefined#****#5_elementform_id_temp38#**id**#undefined#**label**#undefined#****#5_elementform_id_temp39#**id**#undefined#**label**#undefined#****#5_elementform_id_temp40#**id**#undefined#**label**#undefined#****#5_elementform_id_temp41#**id**#undefined#**label**#undefined#****#5_elementform_id_temp42#**id**#undefined#**label**#undefined#****#5_elementform_id_temp43#**id**#undefined#**label**#undefined#****#5_elementform_id_temp44#**id**#undefined#**label**#undefined#****#5_elementform_id_temp45#**id**#undefined#**label**#undefined#****#5_elementform_id_temp46#**id**#undefined#**label**#undefined#****#5_elementform_id_temp47#**id**#undefined#**label**#undefined#****#5_elementform_id_temp48#**id**#undefined#**label**#undefined#****#5_elementform_id_temp49#**id**#undefined#**label**#undefined#****#","2#**id**#Name#**label**#type_name#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Date#**label**#type_date_new#****#5#**id**#Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#6#**id**#Quantity#**label**#type_spinner#****#7#**id**#Details (if any)#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","testmode","","","0","2*:*id*:*type_name*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:***********:*w_first_val*:***********:*w_title*:*Title*********Middle*:*w_mini_labels*:**:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no***no*:*w_name_fields*:*no*:*w_autofill*:**:*new_field*:*3*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_date_new*:*type*:*Date*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_date*:*yes*:*w_required*:*yes*:*w_show_image*:**:*w_class*:*mm/dd/yy*:*w_format*:*0*:*w_start_day*:**:*w_default_date*:**:*w_min_date*:**:*w_max_date*:**:*w_invalid_dates*:*yes***yes***yes***yes***yes***yes***yes*:*w_show_days*:*yes*:*w_hide_time*:*...*:*w_but_val*:*no*:*w_disable_past_days*:**:*new_field*:*5*:*id*:*type_radio*:*type*:*Cupcakes Flavors (1 doz. minimum)*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Red Velvet***Vanilla***Chocolate***Guinness***Coconut***Lemon***Chocolate Mint*:*w_choices*:*false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Red Velvet***Vanilla***Chocolate***Guinness***Coconut***Lemon***Chocolate Mint*:*w_choices_value*:********************:*w_choices_params*:**:*w_class*:**:*new_field*:*6*:*id*:*type_spinner*:*type*:*Quantity*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:*60*:*w_field_width*:**:*w_field_min_value*:**:*w_field_max_value*:*1*:*w_field_step*:*null*:*w_field_value*:*no*:*w_required*:**:*w_class*:**:*new_field*:*7*:*id*:*type_textarea*:*type*:*Details (if any)*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","0","1","Cupcake Order Form","","","none","1","0");

INSERT IGNORE INTO `ac_formmaker_backup` VALUES 
("1","1","1","Contact Us","embedded","{adminemail}","<div class=\"wdform-page-and-images\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - Name%</div><div wdid=\"3\" class=\"wdform_row\">%3 - Email%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Subject%</div><div wdid=\"5\" class=\"wdform_row\">%5 - Message%</div><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>","1","// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}\r\n// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}","","","1","{all}","{all}","6","1","2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#2_elementform_id_temp#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#","0","none","","1","","","","0","testmode","","","0","2*:*id*:*type_text*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*3*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_text*:*type*:*Subject*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*new_field*:*5*:*id*:*type_textarea*:*type*:*Message*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*","1","1","*","","","","","1","","","","","","","","","","","","1","1","1","1","administrator,","1","","","0","0","0","3916","1","Contact Us","You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.","","none","0");

INSERT IGNORE INTO `ac_formmaker_themes` VALUES 
("1","Default Theme","{\"AGPWidth\":\"70\",\"AGPSPWidth\":\"30\",\"HPAlign\":\"top\",\"HTPWidth\":\"40\",\"HPTextAlign\":\"center\",\"HTPFontSize\":\"24\",\"HDPFontSize\":\"15\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"SPAlign\":\"left\",\"PSAPAlign\":\"right\",\"PPAPWidth\":\"100%\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"PSAPBGColor\":\"#7f7f7f\",\"PSAPPadding\":\"8px\",\"PSDPBGColor\":\"#999999\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 10px 0\",\"FPMargin\":\"15px 0 0 0\",\"IPHeight\":\"40\",\"IPFontSize\":\"16\",\"IPPadding\":\"6px 10px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"2\",\"GPMLFontSize\":\"12\",\"GPMLFontWeight\":\"normal\",\"OPRColor\":\"#FF0000\"}","1","2"),
("2","Theme 1","{\"GPFontFamily\":\"tahoma\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"30\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#96afab\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px 0\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"24\",\"HTPWeight\":\"normal\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"15\",\"HDPColor\":\"#607370\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"\",\"GPFontSize\":\"16\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#607370\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#868686\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"15px 20px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"40\",\"IPFontSize\":\"14\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#868686\",\"IPPadding\":\"6px 10px\",\"IPMargin\":\"0\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#868686\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#868686\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#868686\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#e74c3c\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"16\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"5px 8px\",\"SPMargin\":\"0 15px 0 0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#e74c3c\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#701e16\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#701e16\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#96afab\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"16\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"5px 8px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#8a8a8a\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#5a7784\",\"BHPColor\":\"#ffffff\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#5a7784\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#e74c3c\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"6px\",\"PSAPMargin\":\"0 1px 0 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#e74c3c\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"0\",\"PSDPBGColor\":\"#ededed\",\"PSDPFontSize\":\"14\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#737373\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"3px 5px\",\"PSDPMargin\":\"0 1px 0 0 \",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#ededed\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"0\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#607370\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#96afab\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#607370\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#96afab\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"20\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#777777\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#e74c3c\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#96afab\",\"MBPFontSize\":\"17\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#96afab\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#96afab\",\"MBHPColor\":\"#607370\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#96afab\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("3","Theme 2","{\"GPFontFamily\":\"Roboto Condensed\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"30\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#16afbf\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px 10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"25\",\"HTPWeight\":\"\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"16\",\"HDPColor\":\"#387185\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#ededed\",\"GPFontSize\":\"16\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#387185\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#777777\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#ededed\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"40\",\"IPFontSize\":\"16\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#777777\",\"IPPadding\":\"5px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#777777\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#777777\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#777777\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#a3aa44\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"16\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"8px 8px\",\"SPMargin\":\"0 5px 0 0 \",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#a3aa44\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"1px 1px 2px #ccc\",\"SHPBGColor\":\"#c2d852\",\"SHPColor\":\"#445d71\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#c2d852\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#16afbf\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"16\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"8px 8px\",\"BPMargin\":\"0 15px 0 0 \",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#16afbf\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"1px 1px 2px #ccc\",\"BHPBGColor\":\"#435c71\",\"BHPColor\":\"#ffffff\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#435c71\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#a3aa44\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#a3aa44\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#16afbf\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#16afbf\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#16afbf\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#387185\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#9c9c9c\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#2d4d5f\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"22\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#387185\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#a3aa44\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#16afbf\",\"MBPFontSize\":\"17\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#387185\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#16afbf\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#387185\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("4","Theme 3","{\"GPFontFamily\":\"Droid Sans\",\"AGPWidth\":\"80\",\"AGPSPWidth\":\"30\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#b7b7b7\",\"HPWidth\":\"100\",\"HTPWidth\":\"35\",\"HPPadding\":\"10px 13px 25px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"25\",\"HTPWeight\":\"\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"16\",\"HDPColor\":\"#354f5d\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#ededed\",\"GPFontSize\":\"16\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"65\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#627781\",\"GPPadding\":\"10px\",\"GPMargin\":\"-25px 0 0 \",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#627781\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#f3f3f3\",\"SEPPadding\":\"10px 15px\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"40\",\"IPFontSize\":\"16\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#627781\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#627781\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#777777\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#627781\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#676767\",\"SPWidth\":\"\",\"SPHeight\":\"40\",\"SPFontSize\":\"16\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"5px 8px\",\"SPMargin\":\"0px\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#676767\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"1px 1px 2px #ccc\",\"SHPBGColor\":\"#ededed\",\"SHPColor\":\"#676767\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#676767\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#f3f3f3\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"14\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#777777\",\"BPPadding\":\"5px 8px\",\"BPMargin\":\"0px\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#ededed\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"1px 1px 2px #ccc\",\"BHPBGColor\":\"#ededed\",\"BHPColor\":\"#777777\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#ededed\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#354f5d\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#354f5d\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#b7b7b7\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#b7b7b7\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#838383\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#387185\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#9c9c9c\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#2d4d5f\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"18\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#838383\",\"CBPPadding\":\"3px 5px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"30\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#ffffff\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#f3f3f3\",\"MBPFontSize\":\"17\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#354f5d\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#354f5d\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#b7b7b7\",\"MBHPColor\":\"#354f5d\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#354f5d\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("5","Theme 4","{\"GPFontFamily\":\"Patrick Hand\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"30\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderTop\":\"top\",\"AGPBorderRight\":\"right\",\"AGPBorderBottom\":\"bottom\",\"AGPBorderLeft\":\"left\",\"AGPBorderColor\":\"#606060\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#ffffff\",\"HPWidth\":\"100\",\"HTPWidth\":\"30\",\"HPPadding\":\"10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"26\",\"HTPWeight\":\"\",\"HTPColor\":\"#930912\",\"HDPFontSize\":\"17\",\"HDPColor\":\"#666666\",\"HIPAlign\":\"left\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#d8d8d8\",\"GPFontSize\":\"16\",\"GPFontWeight\":\"bold\",\"GPWidth\":\"100\",\"GTPWidth\":\"70\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#2d4d5f\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#2d4d5f\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#d8d8d8\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"30\",\"IPFontSize\":\"14\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#9c9c9c\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#777777\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#777777\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#777777\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#930912\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"16\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#e8e8e8\",\"SPPadding\":\"5px 8px\",\"SPMargin\":\"0 15px 0 0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#930912\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"1px 1px 2px #ccc\",\"SHPBGColor\":\"#51030b\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#51030b\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#666666\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"16\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"5px 8px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#666666\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"1px 1px 2px #ccc\",\"BHPBGColor\":\"#2d4d5f\",\"BHPColor\":\"#ffffff\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#2d4d5f\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#930912\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#930912\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#2d4d5f\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#2d4d5f\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#666666\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#930912\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#666666\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#930912\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"-10px\",\"CBPRight\":\"5px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"#ffffff\",\"CBPFontSize\":\"12\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#930912\",\"CBPPadding\":\"5px 7px\",\"CBPMargin\":\"0px\",\"CBPBorderTop\":\"top\",\"CBPBorderRight\":\"right\",\"CBPBorderBottom\":\"bottom\",\"CBPBorderLeft\":\"left\",\"CBPBorderColor\":\"#606060\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"15\",\"CBHPBGColor\":\"#ffffff\",\"CBHPColor\":\"#2d4d5f\",\"CBHPBorderTop\":\"top\",\"CBHPBorderRight\":\"right\",\"CBHPBorderBottom\":\"bottom\",\"CBHPBorderLeft\":\"left\",\"CBHPBorderColor\":\"#606060\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#ffffff\",\"MBPFontSize\":\"17\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#930912\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#606060\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#666666\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#930912\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("6","Theme 5","{\"GPFontFamily\":\"cursive\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"40\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#aee2de\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"19\",\"HTPWeight\":\"normal\",\"HTPColor\":\"#042325\",\"HDPFontSize\":\"13\",\"HDPColor\":\"#518a88\",\"HIPAlign\":\"left\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#214555\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#d4d4d4\",\"GPPadding\":\"10px 20px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#d4d4d4\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#214555\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"40\",\"IPFontSize\":\"16\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#518a88\",\"IPPadding\":\"5px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#dfdfdf\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#518a88\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#518a88\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#518a88\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#f46322\",\"SPWidth\":\"130\",\"SPHeight\":\"40\",\"SPFontSize\":\"14\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"0px 5px\",\"SPMargin\":\"0 15px 0 0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#f46322\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#f46322\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#f46322\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#bababa\",\"BPWidth\":\"\",\"BPHeight\":\"40\",\"BPFontSize\":\"14\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#454545\",\"BPPadding\":\"0px 5px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#bababa\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#bababa\",\"BHPColor\":\"#454545\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#bababa\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#f46322\",\"PSAPFontSize\":\"14\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0\",\"PSAPBorderColor\":\"\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#bababa\",\"PSDPFontSize\":\"13\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#518a88\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderColor\":\"#a3a3a3\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"left\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#f46322\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#d4d4d4\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#d4d4d4\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#f46322\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"6px\",\"CBPRight\":\"6px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"18\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#f46322\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#214555\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#aee2de\",\"MBPFontSize\":\"15\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#000000\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#518a88\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#518a88\",\"MBHPColor\":\"#ffffff\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#518a88\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("7","Theme 6","{\"GPFontFamily\":\"PT Sans\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"35\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#ffffff\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"27\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#1d6d69\",\"HDPFontSize\":\"15\",\"HDPColor\":\"#808080\",\"HIPAlign\":\"left\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#3a9391\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#ffffff\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#ffffff\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#3a9391\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"80\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"26\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#a0a0a0\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#d6d6d6\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#ffffff\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#ffffff\",\"SCCPWidth\":\"8\",\"SCCPHeight\":\"8\",\"SCCPMargin\":\"3\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"\",\"MCPWidth\":\"14\",\"MCPHeight\":\"14\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#ffffff\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"#ffffff\",\"MCCPBackground\":\"\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"10\",\"MCCPHeight\":\"10\",\"MCCPMargin\":\"2\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#ffb33a\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"15\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"6px 10px\",\"SPMargin\":\"0 15px 0 0\",\"SPBorderColor\":\"#1d6d69\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"2px 2px 2px #1d6d69\",\"SHPBGColor\":\"#f60c5b\",\"SHPColor\":\"#ffffff\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#1d6d69\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"6px 10px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderColor\":\"#357773\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"2px 2px 2px #1d6d69\",\"BHPBGColor\":\"#35a098\",\"BHPColor\":\"#ffffff\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#ffb33a\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#ffb33a\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#1d6d69\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#1d6d69\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#ffffff\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#018c8b\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#ffffff\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#d82534\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"16\",\"CBPFontWeight\":\"lighter\",\"CBPColor\":\"#ffb33a\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#f60c5b\",\"CBHPBorderColor\":\"#ffffff\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#1d6d69\",\"MBPFontSize\":\"16\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#1d6d69\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#1d6d69\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#1d6d69\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ffffff\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("8","Theme 7","{\"GPFontFamily\":\"PT Sans\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"35\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#ffffff\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px 0\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"27\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#3596d4\",\"HDPFontSize\":\"15\",\"HDPColor\":\"#808080\",\"HIPAlign\":\"left\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#2d4d5f\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#ffffff\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#ffffff\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#2d4d5f\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"80\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"26\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#a0a0a0\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#d6d6d6\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#ffffff\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#ffffff\",\"SCCPWidth\":\"8\",\"SCCPHeight\":\"8\",\"SCCPMargin\":\"3\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"\",\"MCPWidth\":\"14\",\"MCPHeight\":\"14\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#ffffff\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"#ffffff\",\"MCCPBackground\":\"\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"10\",\"MCCPHeight\":\"10\",\"MCCPMargin\":\"2\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#ffb33a\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"15\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"6px 10px\",\"SPMargin\":\"0 15px 0 0 \",\"SPBorderColor\":\"#ffffff\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"2px 2px 2px #1f3c4c\",\"SHPBGColor\":\"#ba9911\",\"SHPColor\":\"#ffffff\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#44acf0\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"6px 10px\",\"BPMargin\":\"0 15px 0 0 \",\"BPBorderColor\":\"#ffffff\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"2px 2px 2px #1f3c4c\",\"BHPBGColor\":\"#44acf0\",\"BHPColor\":\"#ffffff\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#44acf0\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0\",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#44acf0\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#ffffff\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#808080\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#808080\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"1\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#ffffff\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#ba9911\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#ffffff\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#ba9911\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"16\",\"CBPFontWeight\":\"lighter\",\"CBPColor\":\"#808080\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#ffb33a\",\"CBHPBorderColor\":\"#ffffff\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#ffffff\",\"MBPFontSize\":\"16\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#3596d4\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#2d4d5f\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#3596d4\",\"MBHPColor\":\"#ffffff\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#2d4d5f\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ffb33a\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("9","Theme 8","{\"GPFontFamily\":\"PT Sans\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"35\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#435c71\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"20px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"30\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#e6c41b\",\"HDPFontSize\":\"15\",\"HDPColor\":\"#ffffff\",\"HIPAlign\":\"right\",\"HIPWidth\":\"40\",\"HIPHeight\":\"26\",\"GPBGColor\":\"#f8f8f8\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"bold\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#3b3b3b\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"11\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#3b3b3b\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#f8f8f8\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"80\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"40\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#6e6e6e\",\"IPPadding\":\"6px 10px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#989898\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/3.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#989898\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#989898\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"4\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"\",\"MCPWidth\":\"14\",\"MCPHeight\":\"14\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#989898\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/3.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0 0 2px 0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#f05e22\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"15\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"6px 10px\",\"SPMargin\":\"0 15px 0 0 \",\"SPBorderColor\":\"#9eaab1\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"2px 2px 2px #9eaab1\",\"SHPBGColor\":\"#d82534\",\"SHPColor\":\"#ffffff\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#f1cb15\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#424242\",\"BPPadding\":\"6px 10px\",\"BPMargin\":\"0 15px 0 0 \",\"BPBorderColor\":\"#ffffff\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"2px 2px 2px #9eaab1\",\"BHPBGColor\":\"#435c71\",\"BHPColor\":\"#e6c41b\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#f05e22\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0\",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#f05e22\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#ffffff\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"bold\",\"PSDPColor\":\"#435c71\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#435c71\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"1\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#3b3b3b\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#d82534\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#3b3b3b\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#d82534\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"16\",\"CBPFontWeight\":\"lighter\",\"CBPColor\":\"#e6c41b\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#d82534\",\"CBHPBorderColor\":\"#ffffff\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#435c71\",\"MBPFontSize\":\"16\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#e6c41b\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#435c71\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#e6c41b\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#435c71\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#f05e22\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("10","Theme 9","{\"GPFontFamily\":\"Open Sans Condensed\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"35\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"left\",\"HPBGColor\":\"#4d4d4d\",\"HPWidth\":\"50\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"26\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"14\",\"HDPColor\":\"#b95d3c\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#f8f8f8\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"bold\",\"GPWidth\":\"50\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#3b3b3b\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#3b3b3b\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#f8f8f8\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"80\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"26\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#6e6e6e\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#989898\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/3.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#989898\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#989898\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"4\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"\",\"MCPWidth\":\"14\",\"MCPHeight\":\"14\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#989898\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/3.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0 0 2px 0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#f05e22\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"15\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"6px 10px\",\"SPMargin\":\"\",\"SPBorderColor\":\"#9eaab1\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"2px 2px 2px #9eaab1\",\"SHPBGColor\":\"#d82534\",\"SHPColor\":\"#ffffff\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#f1cb15\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#424242\",\"BPPadding\":\"6px 10px\",\"BPMargin\":\"0 15px 0 0 \",\"BPBorderColor\":\"#ffffff\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"2px 2px 2px #9eaab1\",\"BHPBGColor\":\"#435c71\",\"BHPColor\":\"#e6c41b\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#f05e22\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0\",\"PSAPBorderColor\":\"\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#ffffff\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"bold\",\"PSDPColor\":\"#435c71\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#435c71\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"1\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#3b3b3b\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#d82534\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#3b3b3b\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#d82534\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"16\",\"CBPFontWeight\":\"lighter\",\"CBPColor\":\"#e6c41b\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#d82534\",\"CBHPBorderColor\":\"#ffffff\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#4d4d4d\",\"MBPFontSize\":\"16\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#4d4d4d\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#f05e22\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#f05e22\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#f05e22\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("11","Theme 10","{\"GPFontFamily\":\"arial\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"35\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderTop\":\"top\",\"AGPBorderRight\":\"right\",\"AGPBorderBottom\":\"bottom\",\"AGPBorderLeft\":\"left\",\"AGPBorderColor\":\"#00bff3\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#00bff3\",\"HPWidth\":\"100\",\"HTPWidth\":\"30\",\"HPPadding\":\"10px\",\"HPMargin\":\"\",\"HPTextAlign\":\"left\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"25\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"14\",\"HDPColor\":\"#ffffff\",\"HIPAlign\":\"left\",\"HIPWidth\":\"41\",\"HIPHeight\":\"31\",\"GPBGColor\":\"#ffffff\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"100\",\"GPAlign\":\"left\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#494949\",\"GPPadding\":\"15px 15px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#494949\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#ffffff\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px 20px 10px 10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"80\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"30\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#6e6e6e\",\"IPPadding\":\"6px 6px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#00bff3\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/3.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#00bff3\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#989898\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"4\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"\",\"MCPWidth\":\"14\",\"MCPHeight\":\"14\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#00bff3\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/3.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0 0 2px 0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#000000\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"15\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"5px 10px\",\"SPMargin\":\"\",\"SPBorderColor\":\"#b0b5b8\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"6\",\"SPBoxShadow\":\"2px 2px 2px #b0b5b8\",\"SHPBGColor\":\"#000000\",\"SHPColor\":\"#ffffff\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#dfc97a\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#272727\",\"BPPadding\":\"15px 20px\",\"BPMargin\":\"0 15px 0 0 \",\"BPBorderColor\":\"#ffffff\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"2px 2px 2px #b0b5b8\",\"BHPBGColor\":\"#2d4d5f\",\"BHPColor\":\"#ffffff\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#139e92\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0\",\"PSAPBorderColor\":\"\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#f8f8f8\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#272727\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#dfc97a\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"1\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#3b3b3b\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#137065\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#3b3b3b\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#137065\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"16\",\"CBPFontWeight\":\"lighter\",\"CBPColor\":\"#757575\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#139e92\",\"CBHPBorderColor\":\"#ffffff\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#139e92\",\"MBPFontSize\":\"16\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#139e92\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#137065\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#137065\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#f82c2c\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"div[type=\\\"type_section_break\\\"] {\\r\\n  display: none !important;\\r\\n}\\r\\ndiv[wdid=\\\"12\\\"] {\\r\\n    border: 1px solid #00bff3;\\r\\n    padding: 10px 30px 0px;\\r\\n}\\r\\ninput.time_box {\\r\\n  width: 40px;\\r\\n}\"}","0","2"),
("12","Theme 11","{\"GPFontFamily\":\"Roboto\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"40\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#f2ecde\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px 15px\",\"HPMargin\":\"\",\"HPTextAlign\":\"left\",\"HPBorderTop\":\"top\",\"HPBorderColor\":\"#7a134b\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"4\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"19\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#042325\",\"HDPFontSize\":\"14\",\"HDPColor\":\"#8a877f\",\"HIPAlign\":\"right\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#d8d5c6\",\"GPFontSize\":\"14\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#37352f\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#37352f\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#d8d5c6\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"28\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#b7b3a7\",\"IPColor\":\"#ffffff\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#b7b3a7\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#7a134b\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#7a134b\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"4\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"12\",\"MCPHeight\":\"12\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#7a134b\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"#7a134b\",\"MCCPBackground\":\"\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"8\",\"MCCPHeight\":\"8\",\"MCCPMargin\":\"2\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#7a134b\",\"SPWidth\":\"130\",\"SPHeight\":\"28\",\"SPFontSize\":\"14\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"0px 5px\",\"SPMargin\":\"0 10px 0 0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#7a134b\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#630538\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#630538\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#f2ecde\",\"BPWidth\":\"60\",\"BPHeight\":\"28\",\"BPFontSize\":\"14\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#37352f\",\"BPPadding\":\"0px 5px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#f2ecde\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#f2ecde\",\"BHPColor\":\"#37352f\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#f2ecde\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#7a134b\",\"PSAPFontSize\":\"14\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 -2px  0\",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#7a134b\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"3\",\"PSAPBorderRadius\":\"0\",\"PSDPBGColor\":\"#f2ecde\",\"PSDPFontSize\":\"14\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#000000\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"8px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderColor\":\"#a3a3a3\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"\",\"PSAPAlign\":\"left\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#7a134b\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#630538\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#7a134b\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#630538\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"6px\",\"CBPRight\":\"6px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"18\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#7a134b\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#630538\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#f2ecde\",\"MBPFontSize\":\"15\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#000000\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderColor\":\"#7a134b\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#f2ecde\",\"MBHPColor\":\"#7a134b\",\"MBHPBorderTop\":\"top\",\"MBHPBorderColor\":\"#7a134b\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#ffffff\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("13","Theme 12","{\"GPFontFamily\":\"trebuchet ms\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"40\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#5d98b1\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"10px 15px\",\"HPMargin\":\"\",\"HPTextAlign\":\"left\",\"HPBorderTop\":\"top\",\"HPBorderColor\":\"#ffffff\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"5\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"22\",\"HTPWeight\":\"bold\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"14\",\"HDPColor\":\"#ffffff\",\"HIPAlign\":\"left\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#36748e\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#ffffff\",\"GPPadding\":\"10px\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#ffffff\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#36748e\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"10px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"28\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#204a5c\",\"IPColor\":\"#ffffff\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#204a5c\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#204a5c\",\"SCPWidth\":\"14\",\"SCPHeight\":\"14\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#204a5c\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#ffffff\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"4\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#204a5c\",\"MCPWidth\":\"12\",\"MCPHeight\":\"12\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#204a5c\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"#ffffff\",\"MCCPBackground\":\"\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"8\",\"MCCPHeight\":\"8\",\"MCCPMargin\":\"2\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#1e6466\",\"SPWidth\":\"130\",\"SPHeight\":\"28\",\"SPFontSize\":\"14\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"0px 5px\",\"SPMargin\":\"0 10px 0 0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#1e6466\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#268285\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#268285\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#d4d4d4\",\"BPWidth\":\"60\",\"BPHeight\":\"28\",\"BPFontSize\":\"15\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#11393a\",\"BPPadding\":\"0px 5px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#d4d4d4\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#f2ecde\",\"BHPColor\":\"#37352f\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#f2ecde\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#268285\",\"PSAPFontSize\":\"14\",\"PSAPFontWeight\":\"bold\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"10px\",\"PSAPMargin\":\"0\",\"PSAPBorderColor\":\"\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"4\",\"PSAPBorderRadius\":\"0\",\"PSDPBGColor\":\"#d4d4d4\",\"PSDPFontSize\":\"14\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#100e0e\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"8px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderColor\":\"#a3a3a3\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"\",\"PSAPAlign\":\"center\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#132d39\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#132d39\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#132d39\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#132d39\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"6px\",\"CBPRight\":\"6px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"18\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#1e6466\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#204a5c\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#204a5c\",\"MBPFontSize\":\"15\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#204a5c\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#5d98b1\",\"MBHPColor\":\"#ffffff\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#5d98b1\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#ffffff\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#ff1313\",\"OPDPIcon\":\"images/themes/date-pickers/5.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2"),
("14","Theme 13","{\"GPFontFamily\":\"tahoma\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"20\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#43aeab\",\"HPWidth\":\"100\",\"HTPWidth\":\"40\",\"HPPadding\":\"20px 0\",\"HPMargin\":\"0\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"20\",\"HTPWeight\":\"normal\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"13\",\"HDPColor\":\"#ffffff\",\"HIPAlign\":\"top\",\"HIPWidth\":\"80\",\"HIPHeight\":\"\",\"GPBGColor\":\"#ffffff\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"60\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#676767\",\"GPPadding\":\"10px 0\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#9c9c9c\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#ffffff\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"15px 20px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"28\",\"IPFontSize\":\"14\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#e4e4e4\",\"IPColor\":\"#9a9a9a\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#e4e4e4\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#868686\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#868686\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#868686\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"left\",\"SPBGColor\":\"#f38989\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"16\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"5px 8px\",\"SPMargin\":\"0\",\"SPBorderTop\":\"top\",\"SPBorderRight\":\"right\",\"SPBorderBottom\":\"bottom\",\"SPBorderLeft\":\"left\",\"SPBorderColor\":\"#f38989\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"1\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#c17777\",\"SHPColor\":\"#ffffff\",\"SHPBorderTop\":\"top\",\"SHPBorderRight\":\"right\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderLeft\":\"left\",\"SHPBorderColor\":\"#c17777\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"1\",\"BPBGColor\":\"#ffffff\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"16\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#8c8c8c\",\"BPPadding\":\"5px 8px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderTop\":\"top\",\"BPBorderRight\":\"right\",\"BPBorderBottom\":\"bottom\",\"BPBorderLeft\":\"left\",\"BPBorderColor\":\"#43aeab\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"1\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#43aeab\",\"BHPColor\":\"#ffffff\",\"BHPBorderTop\":\"top\",\"BHPBorderRight\":\"right\",\"BHPBorderBottom\":\"bottom\",\"BHPBorderLeft\":\"left\",\"BHPBorderColor\":\"#787878\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#f38989\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"6px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#f38989\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"0\",\"PSDPBGColor\":\"#a5a5a5\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"2px 4px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#a3a3a3\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"0\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#43aeab\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#777777\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#43aeab\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#777777\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"10px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"18\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#ffffff\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#ffffff\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#f38989\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#b7b7b7\",\"MBPFontSize\":\"17\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#8f8f8f\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#ffffff\",\"MBHPColor\":\"#8f8f8f\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#8f8f8f\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#aeaeae\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#cf1515\",\"OPDPIcon\":\"images/themes/date-pickers/5.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\".mwd-header-text { padding: 15px 15px 0; }\"}","0","2"),
("15","Theme 14","{\"GPFontFamily\":\"tahoma\",\"AGPWidth\":\"100\",\"AGPSPWidth\":\"40\",\"AGPPadding\":\"\",\"AGPMargin\":\"10px auto\",\"AGPBorderColor\":\"#ffffff\",\"AGPBorderType\":\"solid\",\"AGPBorderWidth\":\"1\",\"AGPBorderRadius\":\"0\",\"AGPBoxShadow\":\"\",\"HPAlign\":\"top\",\"HPBGColor\":\"#386f74\",\"HPWidth\":\"100\",\"HTPWidth\":\"26\",\"HPPadding\":\"0 20px\",\"HPMargin\":\"\",\"HPTextAlign\":\"center\",\"HPBorderColor\":\"#b7b7b7\",\"HPBorderType\":\"solid\",\"HPBorderWidth\":\"1\",\"HPBorderRadius\":\"0\",\"HTPFontSize\":\"19\",\"HTPWeight\":\"normal\",\"HTPColor\":\"#ffffff\",\"HDPFontSize\":\"13\",\"HDPColor\":\"#ffffff\",\"HIPAlign\":\"left\",\"HIPWidth\":\"40\",\"HIPHeight\":\"\",\"GPBGColor\":\"#5dbac2\",\"GPFontSize\":\"15\",\"GPFontWeight\":\"normal\",\"GPWidth\":\"100\",\"GTPWidth\":\"74\",\"GPAlign\":\"center\",\"GPBackground\":\"\",\"GPBackgroundRepeat\":\"no-repeat\",\"GPBGPosition1\":\"\",\"GPBGPosition2\":\"\",\"GPBGSize1\":\"\",\"GPBGSize2\":\"\",\"GPColor\":\"#ffffff\",\"GPPadding\":\"0\",\"GPMargin\":\"\",\"GPBorderColor\":\"#ffffff\",\"GPBorderType\":\"solid\",\"GPBorderWidth\":\"1\",\"GPBorderRadius\":\"0\",\"GPMLFontSize\":\"14\",\"GPMLFontWeight\":\"normal\",\"GPMLColor\":\"#ffffff\",\"GPMLPadding\":\"0px 5px 0px 0px\",\"GPMLMargin\":\"0px\",\"SEPBGColor\":\"#5dbac2\",\"SEPPadding\":\"\",\"SEPMargin\":\"\",\"COPPadding\":\"15px 20px\",\"COPMargin\":\"0px\",\"FPWidth\":\"70\",\"FPPadding\":\"15px 0 0 0\",\"FPMargin\":\"0 auto\",\"IPHeight\":\"28\",\"IPFontSize\":\"13\",\"IPFontWeight\":\"normal\",\"IPBGColor\":\"#ffffff\",\"IPColor\":\"#868686\",\"IPPadding\":\"0px 5px\",\"IPMargin\":\"0px\",\"IPBorderTop\":\"top\",\"IPBorderRight\":\"right\",\"IPBorderBottom\":\"bottom\",\"IPBorderLeft\":\"left\",\"IPBorderColor\":\"#ffffff\",\"IPBorderType\":\"solid\",\"IPBorderWidth\":\"1\",\"IPBorderRadius\":\"0\",\"IPBoxShadow\":\"\",\"SBPAppearance\":\"none\",\"SBPBackground\":\"images/themes/drop-downs/2.png\",\"SBPBGRepeat\":\"no-repeat\",\"SBPBGPos1\":\"95%\",\"SBPBGPos2\":\"50%\",\"SBPBGSize1\":\"8%\",\"SBPBGSize2\":\"32%\",\"SCPBGColor\":\"#ffffff\",\"SCPWidth\":\"16\",\"SCPHeight\":\"16\",\"SCPBorderTop\":\"top\",\"SCPBorderRight\":\"right\",\"SCPBorderBottom\":\"bottom\",\"SCPBorderLeft\":\"left\",\"SCPBorderColor\":\"#868686\",\"SCPBorderType\":\"solid\",\"SCPBorderWidth\":\"1\",\"SCPMargin\":\"0px 3px\",\"SCPBorderRadius\":\"15\",\"SCPBoxShadow\":\"\",\"SCCPBGColor\":\"#868686\",\"SCCPWidth\":\"6\",\"SCCPHeight\":\"6\",\"SCCPMargin\":\"5\",\"SCCPBorderRadius\":\"10\",\"MCPBGColor\":\"#ffffff\",\"MCPWidth\":\"16\",\"MCPHeight\":\"16\",\"MCPBorderTop\":\"top\",\"MCPBorderRight\":\"right\",\"MCPBorderBottom\":\"bottom\",\"MCPBorderLeft\":\"left\",\"MCPBorderColor\":\"#868686\",\"MCPBorderType\":\"solid\",\"MCPBorderWidth\":\"1\",\"MCPMargin\":\"0px 3px\",\"MCPBorderRadius\":\"0\",\"MCPBoxShadow\":\"\",\"MCCPBGColor\":\"\",\"MCCPBackground\":\"images/themes/checkboxes/1.png\",\"MCCPBGRepeat\":\"no-repeat\",\"MCCPBGPos1\":\"\",\"MCCPBGPos2\":\"\",\"MCCPWidth\":\"16\",\"MCCPHeight\":\"16\",\"MCCPMargin\":\"0\",\"MCCPBorderRadius\":\"0\",\"SPAlign\":\"right\",\"SPBGColor\":\"#f6c37a\",\"SPWidth\":\"\",\"SPHeight\":\"\",\"SPFontSize\":\"14\",\"SPFontWeight\":\"normal\",\"SPColor\":\"#ffffff\",\"SPPadding\":\"5px 15px\",\"SPMargin\":\"0 15px 0 0\",\"SPBorderBottom\":\"bottom\",\"SPBorderColor\":\"#ffffff\",\"SPBorderType\":\"solid\",\"SPBorderWidth\":\"3\",\"SPBorderRadius\":\"0\",\"SPBoxShadow\":\"\",\"SHPBGColor\":\"#f4b459\",\"SHPColor\":\"#ffffff\",\"SHPBorderBottom\":\"bottom\",\"SHPBorderColor\":\"#ffffff\",\"SHPBorderType\":\"solid\",\"SHPBorderWidth\":\"3\",\"BPBGColor\":\"#5dbac2\",\"BPWidth\":\"\",\"BPHeight\":\"\",\"BPFontSize\":\"14\",\"BPFontWeight\":\"normal\",\"BPColor\":\"#ffffff\",\"BPPadding\":\"5px 8px\",\"BPMargin\":\"0 15px 0 0\",\"BPBorderColor\":\"#ffffff\",\"BPBorderType\":\"solid\",\"BPBorderWidth\":\"3\",\"BPBorderRadius\":\"0\",\"BPBoxShadow\":\"\",\"BHPBGColor\":\"#5dbac2\",\"BHPColor\":\"#ffffff\",\"BHPBorderColor\":\"#ffffff\",\"BHPBorderType\":\"solid\",\"BHPBorderWidth\":\"1\",\"PSAPBGColor\":\"#e74c3c\",\"PSAPFontSize\":\"16\",\"PSAPFontWeight\":\"normal\",\"PSAPColor\":\"#ffffff\",\"PSAPHeight\":\"\",\"PSAPLineHeight\":\"\",\"PSAPPadding\":\"8px\",\"PSAPMargin\":\"0 0 4px 0 \",\"PSAPBorderTop\":\"top\",\"PSAPBorderRight\":\"right\",\"PSAPBorderBottom\":\"bottom\",\"PSAPBorderLeft\":\"left\",\"PSAPBorderColor\":\"#e74c3c\",\"PSAPBorderType\":\"solid\",\"PSAPBorderWidth\":\"2\",\"PSAPBorderRadius\":\"3\",\"PSDPBGColor\":\"#a5a5a5\",\"PSDPFontSize\":\"16\",\"PSDPFontWeight\":\"normal\",\"PSDPColor\":\"#ffffff\",\"PSDPHeight\":\"\",\"PSDPLineHeight\":\"\",\"PSDPPadding\":\"4px 6px\",\"PSDPMargin\":\"0 0 0 -3px\",\"PSDPBorderTop\":\"top\",\"PSDPBorderRight\":\"right\",\"PSDPBorderBottom\":\"bottom\",\"PSDPBorderLeft\":\"left\",\"PSDPBorderColor\":\"#a3a3a3\",\"PSDPBorderType\":\"solid\",\"PSDPBorderWidth\":\"2\",\"PSDPBorderRadius\":\"3\",\"PSAPAlign\":\"right\",\"PSAPWidth\":\"\",\"PPAPWidth\":\"100%\",\"NBPBGColor\":\"\",\"NBPWidth\":\"\",\"NBPHeight\":\"\",\"NBPLineHeight\":\"\",\"NBPColor\":\"#e74c3c\",\"NBPPadding\":\"4px 10px\",\"NBPMargin\":\"0px\",\"NBPBorderColor\":\"#777777\",\"NBPBorderType\":\"solid\",\"NBPBorderWidth\":\"1\",\"NBPBorderRadius\":\"0\",\"NBPBoxShadow\":\"\",\"NBHPBGColor\":\"\",\"NBHPColor\":\"#2d4d5f\",\"NBHPBorderColor\":\"#787878\",\"NBHPBorderType\":\"solid\",\"NBHPBorderWidth\":\"1\",\"PBPBGColor\":\"\",\"PBPWidth\":\"100\",\"PBPHeight\":\"\",\"PBPLineHeight\":\"\",\"PBPColor\":\"#9c9c9c\",\"PBPPadding\":\"\",\"PBPMargin\":\"0px\",\"PBPBorderColor\":\"#777777\",\"PBPBorderType\":\"solid\",\"PBPBorderWidth\":\"1\",\"PBPBorderRadius\":\"0\",\"PBPBoxShadow\":\"\",\"PBHPBGColor\":\"\",\"PBHPColor\":\"#2d4d5f\",\"PBHPBorderColor\":\"#787878\",\"PBHPBorderType\":\"solid\",\"PBHPBorderWidth\":\"1\",\"CBPPosition\":\"absolute\",\"CBPTop\":\"22px\",\"CBPRight\":\"10px\",\"CBPBottom\":\"\",\"CBPLeft\":\"\",\"CBPBGColor\":\"\",\"CBPFontSize\":\"20\",\"CBPFontWeight\":\"normal\",\"CBPColor\":\"#ffffff\",\"CBPPadding\":\"0px\",\"CBPMargin\":\"0px\",\"CBPBorderColor\":\"#f6c37a\",\"CBPBorderType\":\"solid\",\"CBPBorderWidth\":\"1\",\"CBPBorderRadius\":\"0\",\"CBHPBGColor\":\"\",\"CBHPColor\":\"#f6c37a\",\"CBHPBorderColor\":\"#737373\",\"CBHPBorderType\":\"solid\",\"CBHPBorderWidth\":\"1\",\"MBPBGColor\":\"#386f74\",\"MBPFontSize\":\"15\",\"MBPFontWeight\":\"normal\",\"MBPColor\":\"#ffffff\",\"MBPTextAlign\":\"center\",\"MBPPadding\":\"10px\",\"MBPMargin\":\"\",\"MBPBorderTop\":\"top\",\"MBPBorderRight\":\"right\",\"MBPBorderBottom\":\"bottom\",\"MBPBorderLeft\":\"left\",\"MBPBorderColor\":\"#386f74\",\"MBPBorderType\":\"solid\",\"MBPBorderWidth\":\"2\",\"MBPBorderRadius\":\"0\",\"MBHPBGColor\":\"#5dbac2\",\"MBHPColor\":\"#ffffff\",\"MBHPBorderTop\":\"top\",\"MBHPBorderRight\":\"right\",\"MBHPBorderBottom\":\"bottom\",\"MBHPBorderLeft\":\"left\",\"MBHPBorderColor\":\"#5dbac2\",\"MBHPBorderType\":\"solid\",\"MBHPBorderWidth\":\"2\",\"OPDeInputColor\":\"#afafaf\",\"OPFontStyle\":\"normal\",\"OPRColor\":\"#386f74\",\"OPDPIcon\":\"images/themes/date-pickers/2.png\",\"OPDPRepeat\":\"no-repeat\",\"OPDPPos1\":\"0%\",\"OPDPPos2\":\"10%\",\"OPDPMargin\":\"3px 0 0 -23px\",\"OPFBgUrl\":\"images/themes/file-uploads/2.png\",\"OPFBGRepeat\":\"no-repeat\",\"OPFPos1\":\"0%\",\"OPFPos2\":\"10%\",\"OPGWidth\":\"100\",\"CUPCSS\":\"\"}","0","2");

INSERT IGNORE INTO `ac_layerslider` VALUES 
("1","1","home","","{\"properties\":{\"title\":\"home\",\"slug\":\"\",\"sliderVersion\":\"6.7.1\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":1920,\"height\":670,\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v5\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"hoverprevnext\":true,\"hoverbottomnav\":true,\"bartimer\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"disabled\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"navbuttons\":false,\"autoplayvideos\":false,\"post_type\":[\"wpcf7_contact_form\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"responsive\":true,\"sublayercontainer\":\"0\",\"animatefirstlayer\":true,\"imgpreload\":true,\"lazyload\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"undefined\":true,\"slidebartimer\":false,\"pauseLayers\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":4235,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/1.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3800\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/1.jpg\",\"post_content\":false,\"customProperties\":[]},\"sublayers\":[],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":39},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"Sun\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Gives us clean energy\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1500\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"36\",\"color\":\"#ffffff\",\"top\":\"407px\",\"left\":\"382px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"9e56cb5d-4b74-4508-9ea9-e5c3b69112ce\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"100% Free\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ESPECIALS DE CULLERA\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"p\"},\"redo\":{\"type\":\"h1\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"h1\"},\"redo\":{\"type\":\"p\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"p\"},\"redo\":{\"type\":\"h2\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"h2\"},\"redo\":{\"type\":\"p\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"240\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"100\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"372.9999889026989px\",\"top\":\"125px\"},\"redo\":{\"left\":\"349px\",\"top\":\"86px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-size\":\"36\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"381.0000332919034px\",\"top\":\"455.99994081439394px\"},\"redo\":{\"left\":\"349px\",\"top\":\"244px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"348.99999445134944px\",\"top\":\"243.9999667080966px\"},\"redo\":{\"left\":\"329px\",\"top\":\"238px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-size\":\"36\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"379.99998150449807px\",\"top\":\"508.0000443892045px\"},\"redo\":{\"left\":\"329px\",\"top\":\"388px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"348.99999445134944px\",\"top\":\"86.00001479640152px\"},\"redo\":{\"left\":\"329px\",\"top\":\"102px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"790.9999963008996px\",\"top\":\"153.0000166459517px\"},\"redo\":{\"left\":\"955px\",\"top\":\"142px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"329px\",\"top\":\"388px\"},\"redo\":{\"left\":\"329px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"329px\",\"top\":\"238px\"},\"redo\":{\"left\":\"329px\",\"top\":\"225px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"329px\",\"top\":\"225px\"},\"redo\":{\"left\":\"326px\",\"top\":\"225px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"329px\",\"top\":\"102px\"},\"redo\":{\"left\":\"333px\",\"top\":\"102px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"329px\",\"top\":\"356px\"},\"redo\":{\"left\":\"326px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"326px\",\"top\":\"356px\"},\"redo\":{\"left\":\"325px\",\"top\":\"356px\"}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-3.jpg\",\"backgroundId\":3160,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-3-300x105.jpg\"},\"redo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/1.jpg\",\"backgroundId\":4235,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/1.jpg\"}}},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ASSOCIACI\\u00d3\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"800\",\"delayin\":\"400\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"100\",\"color\":\"#ffffff\",\"top\":\"102px\",\"left\":\"333px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"6ba6c3e6-c776-4a46-850a-13f294dea6b0\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"0.9999969859182098px\",\"top\":\"0px\"},\"redo\":{\"left\":\"196px\",\"top\":\"-37px\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"data\":{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3158,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-3.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"800\",\"delayin\":\"200\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"1000\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"1\",\"parallax\":true},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"top\":\"-37px\",\"left\":\"196px\"},\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-3-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"d01d3ec2-b806-4f81-ab4a-a378cad96767\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"DE NECESSITATS\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1500\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"100\",\"color\":\"#ffffff\",\"top\":\"225px\",\"left\":\"326px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"3e8f85e7-0d23-4992-806f-19471376d3a1\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3164,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/plan.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"-160\",\"offsetyin\":\"250\",\"durationin\":\"1500\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"60\",\"rotatexin\":\"60\",\"rotateyin\":\"60\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"160\",\"offsetyout\":\"-250\",\"durationout\":\"600\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"44\",\"color\":\"#ffffff\",\"top\":\"142px\",\"left\":\"955px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/plan.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"6f23a44d-e613-4a91-8c16-f68174a20277\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ESPECIALS DE CULLERA\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1500\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"100\",\"color\":\"#ffffff\",\"top\":\"356px\",\"left\":\"325px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"2b462f5d-40fd-4ee3-8e4a-563ddce2c978\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":4237,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/3.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/3.jpg\",\"post_content\":false,\"customProperties\":[]},\"sublayers\":[],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":50},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Are spilled in the ocean waters annually\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"838.0000159114053px\",\"top\":\"398.0000159114053px\"},\"redo\":{\"left\":\"684px\",\"top\":\"444px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"711.0000318228106px\",\"top\":\"526.0000318228106px\"},\"redo\":{\"left\":\"714px\",\"top\":\"526px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"510px\",\"top\":\"195px\"},\"redo\":{\"left\":\"369px\",\"top\":\"199px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"descarrega de fitxers\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Are spilled in the ocean waters annually\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"713.9999681771894px\",\"top\":\"526.0000318228106px\"},\"redo\":{\"left\":\"641px\",\"top\":\"546px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"641.0000318228106px\",\"top\":\"546.0000318228106px\"},\"redo\":{\"left\":\"714px\",\"top\":\"444px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"683.9999681771894px\",\"top\":\"443.9999681771894px\"},\"redo\":{\"left\":\"719px\",\"top\":\"500px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"713.9999681771894px\",\"top\":\"443.9999681771894px\"},\"redo\":{\"left\":\"681px\",\"top\":\"462px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"text\"},\"redo\":{\"media\":\"img\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"img\"},\"redo\":{\"media\":\"icon\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"descarregar .pdf\"},\"redo\":{\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"718.9999681771894px\",\"top\":\"500px\"},\"redo\":{\"left\":\"1244px\",\"top\":\"462px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"681.0000318228106px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"551px\",\"top\":\"488px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"550.9999920442973px\",\"top\":\"488.0000159114053px\"},\"redo\":{\"left\":\"568px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"28\"},\"redo\":{\"font-size\":\"35\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"568.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"473px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1243.9999681771894px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"1217px\",\"top\":\"465px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"473.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"483px\",\"top\":\"483px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1216.9999840885946px\",\"top\":\"465px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"458px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"483.0000159114053px\",\"top\":\"483.0000159114053px\"},\"redo\":{\"left\":\"510px\",\"top\":\"478px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"933.9999681771894px\",\"top\":\"160.99999204429736px\"},\"redo\":{\"left\":\"924px\",\"top\":\"62px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"369.00000795570264px\",\"top\":\"199.00000795570264px\"},\"redo\":{\"left\":\"368px\",\"top\":\"104px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"510px\",\"top\":\"478.0000159114053px\"},\"redo\":{\"left\":\"505px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251.0000318228106px\",\"top\":\"458.0000159114053px\"},\"redo\":{\"left\":\"1239px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"505px\",\"top\":\"378px\"},\"redo\":{\"left\":\"485px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1239px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"485px\",\"top\":\"378px\"},\"redo\":{\"left\":\"511px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1267px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Transpar\\u00e8ncia\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"400\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"180\",\"color\":\"#ffffff\",\"top\":\"104px\",\"left\":\"368px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0a82688d-1056-4638-8cf9-beab3ddc5e41\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2.jpg\",\"backgroundId\":3159,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2-300x105.jpg\"},\"redo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/3.jpg\",\"backgroundId\":4237,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/3.jpg\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"0px\",\"top\":\"0px\"},\"redo\":{\"left\":\"137px\",\"top\":\"-20px\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"data\":{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3157,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"800\",\"delayin\":\"200\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"1000\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"1\",\"parallax\":true},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"top\":\"-20px\",\"left\":\"137px\"},\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0151d387-b8df-454f-b4b3-ea63aee54229\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Descarregat els documents de transpariencia\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"35\",\"color\":\"#ffffff\",\"top\":\"378px\",\"left\":\"511px\"},\"style\":\"font-weight:500\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"e6dc01e4-ee1f-41bf-b0ce-fb2e1d68db0d\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3165,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"2000\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"180\",\"rotateyin\":\"180\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"40\",\"color\":\"#ffffff\",\"top\":\"62px\",\"left\":\"924px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"4df75fcc-fe85-4379-882d-0da16f5f754b\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"icon\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"600\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"60\",\"color\":\"#ffffff\",\"top\":\"364px\",\"left\":\"1267px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0012d4aa-4dab-484c-8cdb-f14151fcc83a\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":4236,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/2.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/2.jpg\",\"post_content\":false,\"customProperties\":[],\"uuid\":\"4c6fe089-cf10-4800-9ccc-04785f66503f\",\"title\":\"Slide #3\",\"skip\":false},\"sublayers\":[{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3165,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"924px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"4df75fcc-fe85-4379-882d-0da16f5f754b\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"skip\":false}],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":50},\"history\":[{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"550.9999920442973px\",\"top\":\"488.0000159114053px\"},\"redo\":{\"left\":\"568px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"28\"},\"redo\":{\"font-size\":\"35\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"568.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"473px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1243.9999681771894px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"1217px\",\"top\":\"465px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"473.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"483px\",\"top\":\"483px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1216.9999840885946px\",\"top\":\"465px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"458px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"483.0000159114053px\",\"top\":\"483.0000159114053px\"},\"redo\":{\"left\":\"510px\",\"top\":\"478px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"933.9999681771894px\",\"top\":\"160.99999204429736px\"},\"redo\":{\"left\":\"924px\",\"top\":\"62px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"369.00000795570264px\",\"top\":\"199.00000795570264px\"},\"redo\":{\"left\":\"368px\",\"top\":\"104px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"510px\",\"top\":\"478.0000159114053px\"},\"redo\":{\"left\":\"505px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251.0000318228106px\",\"top\":\"458.0000159114053px\"},\"redo\":{\"left\":\"1239px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"505px\",\"top\":\"378px\"},\"redo\":{\"left\":\"485px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1239px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"485px\",\"top\":\"378px\"},\"redo\":{\"left\":\"511px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1267px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer image\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2.jpg\",\"imageId\":3157,\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2-300x105.jpg\"},\"redo\":{\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"imageId\":3999,\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2.jpg\",\"backgroundId\":3159,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2-300x105.jpg\"},\"redo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"backgroundId\":3999,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\"}}},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Descarregat els documents de transpariencia\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"35\",\"color\":\"#ffffff\",\"top\":\"378px\",\"left\":\"511px\"},\"style\":\"font-weight:500\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"e6dc01e4-ee1f-41bf-b0ce-fb2e1d68db0d\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"icon\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"600\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"60\",\"color\":\"#ffffff\",\"top\":\"364px\",\"left\":\"1267px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0012d4aa-4dab-484c-8cdb-f14151fcc83a\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Transpar\\u00e8ncia\"},\"redo\":{\"html\":\"Colaborem amb l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"color\":\"#ffffff\"},\"redo\":{\"color\":\"#000000\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Colaborem amb l\'IVANN\"},\"redo\":{\"html\":\"Colaborem amb<br> l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"background\":\"\"},\"redo\":{\"background\":\"#5de5a7\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"color\":\"#000000\"},\"redo\":{\"color\":\"#ffffff\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"\"},\"redo\":{\"opacity\":\"50\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"border-radius\":\"\"},\"redo\":{\"border-radius\":\"50\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"50\"},\"redo\":{\"opacity\":\"0.5\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"border-radius\":\"50\"},\"redo\":{\"border-radius\":\"4\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"0.5\"},\"redo\":{\"opacity\":\"0.8\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Colaborem amb<br> l\'IVANN\"},\"redo\":{\"html\":\"Colaborem<br>amb l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"367.9999912855549px\",\"top\":\"104.00001742889013px\"},\"redo\":{\"left\":\"413px\",\"top\":\"121px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"923.9999738566648px\",\"top\":\"61.99999782138873px\"},\"redo\":{\"left\":\"924px\",\"top\":\"25px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"412.9999912855549px\",\"top\":\"120.99998257110987px\"},\"redo\":{\"left\":\"429px\",\"top\":\"87px\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Colaborem<br>amb l\'IVANN\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"400\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"180\",\"color\":\"#ffffff\",\"top\":\"87px\",\"left\":\"429px\",\"background\":\"#5de5a7\",\"opacity\":\"0.8\",\"border-radius\":\"4\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0a82688d-1056-4638-8cf9-beab3ddc5e41\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"hide_on_phone\":false,\"hide_on_desktop\":false}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"backgroundId\":3999,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann-300x105.jpg\"},\"redo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/2.jpg\",\"backgroundId\":4236,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2025\\/02\\/2.jpg\"}}},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"0px\",\"top\":\"0px\"},\"redo\":{\"left\":\"332px\",\"top\":\"25px\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"data\":{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3999,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"800\",\"delayin\":\"200\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"1000\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"1\",\"parallax\":true},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"top\":\"25px\",\"left\":\"332px\"},\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0151d387-b8df-454f-b4b3-ea63aee54229\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.general\",\"name\":\"Hide layer\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"skip\":false},\"redo\":{\"skip\":true}}]},{\"cmd\":\"layer.general\",\"name\":\"Hide layer\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"skip\":true},\"redo\":{\"skip\":false}}]}]}]}","1525779563","1739440790","0","0","0","0","0"),
("2","1","home copy","","{\"properties\":{\"title\":\"home copy\",\"slug\":\"\",\"sliderVersion\":\"6.7.1\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"width\":1920,\"height\":670,\"maxwidth\":\"\",\"responsiveunder\":\"0\",\"fullSizeMode\":\"normal\",\"fitScreenWidth\":true,\"allowFullscreen\":true,\"maxRatio\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"playByScrollSpeed\":\"1\",\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v5\",\"sliderfadeinduration\":\"350\",\"sliderclass\":\"\",\"sliderstyle\":\"margin-bottom: 0px;\",\"backgroundcolor\":\"\",\"backgroundimageId\":\"\",\"backgroundimage\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"hoverprevnext\":true,\"hoverbottomnav\":true,\"bartimer\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autopauseslideshow\":\"disabled\",\"youtubepreview\":\"maxresdefault.jpg\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceLeft\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceTop\":\"10\",\"popupDistanceBottom\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"yourlogoId\":\"\",\"yourlogo\":\"\",\"yourlogostyle\":\"left: -10px; top: -10px;\",\"yourlogolink\":\"\",\"yourlogotarget\":\"_self\",\"slideBGSize\":\"auto\",\"slideBGPosition\":\"50% 50%\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":true,\"preferBlendMode\":\"disabled\",\"previewId\":\"\",\"preview\":\"\",\"navbuttons\":false,\"autoplayvideos\":false,\"post_type\":[\"wpcf7_contact_form\"],\"post_taxonomy\":\"0\",\"post_orderby\":\"date\",\"post_order\":\"DESC\",\"post_offset\":\"-1\",\"responsive\":true,\"sublayercontainer\":\"0\",\"animatefirstlayer\":true,\"imgpreload\":true,\"lazyload\":true,\"cbinit\":\"function(element) {\\r\\n\\r\\n}\",\"cbstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbpause\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstart\":\"function(data) {\\r\\n\\r\\n}\",\"cbanimstop\":\"function(data) {\\r\\n\\r\\n}\",\"cbprev\":\"function(data) {\\r\\n\\r\\n}\",\"cbnext\":\"function(data) {\\r\\n\\r\\n}\",\"undefined\":true,\"slidebartimer\":false,\"pauseLayers\":false},\"layers\":[{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":3160,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-3.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3800\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-3-300x105.jpg\",\"post_content\":false,\"customProperties\":[]},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3158,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-3.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-3-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"d01d3ec2-b806-4f81-ab4a-a378cad96767\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ASSOCIACI\\u00d3\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"102px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"333px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"6ba6c3e6-c776-4a46-850a-13f294dea6b0\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3164,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/plan.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"-160\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"250\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"160\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"-250\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"600\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"44\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"142px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"955px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/plan.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"6f23a44d-e613-4a91-8c16-f68174a20277\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"DE NECESSITATS\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"225px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"326px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"3e8f85e7-0d23-4992-806f-19471376d3a1\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"ESPECIALS DE CULLERA\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1500\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"100\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"356px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"325px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"2b462f5d-40fd-4ee3-8e4a-563ddce2c978\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}],\"meta\":{\"activeLayers\":[0],\"undoStackIndex\":32},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"Sun\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ASSOCIACI\\u00d3\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Gives us clean energy\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1500\",\"delayin\":\"800\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"36\",\"color\":\"#ffffff\",\"top\":\"407px\",\"left\":\"382px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"9e56cb5d-4b74-4508-9ea9-e5c3b69112ce\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"100% Free\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"DE NECESSITATS ESPECIALS\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"ESPECIALS DE CULLERA\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"p\"},\"redo\":{\"type\":\"h1\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"h1\"},\"redo\":{\"type\":\"p\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"p\"},\"redo\":{\"type\":\"h2\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer type\",\"updateInfo\":{\"itemIndex\":3,\"undo\":{\"type\":\"h2\"},\"redo\":{\"type\":\"p\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"240\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"100\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"372.9999889026989px\",\"top\":\"125px\"},\"redo\":{\"left\":\"349px\",\"top\":\"86px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-size\":\"36\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"381.0000332919034px\",\"top\":\"455.99994081439394px\"},\"redo\":{\"left\":\"349px\",\"top\":\"244px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"348.99999445134944px\",\"top\":\"243.9999667080966px\"},\"redo\":{\"left\":\"329px\",\"top\":\"238px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-size\":\"36\"},\"redo\":{\"font-size\":\"150\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"379.99998150449807px\",\"top\":\"508.0000443892045px\"},\"redo\":{\"left\":\"329px\",\"top\":\"388px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"font-size\":\"150\"},\"redo\":{\"font-size\":\"100\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"348.99999445134944px\",\"top\":\"86.00001479640152px\"},\"redo\":{\"left\":\"329px\",\"top\":\"102px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"790.9999963008996px\",\"top\":\"153.0000166459517px\"},\"redo\":{\"left\":\"955px\",\"top\":\"142px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"329px\",\"top\":\"388px\"},\"redo\":{\"left\":\"329px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"329px\",\"top\":\"238px\"},\"redo\":{\"left\":\"329px\",\"top\":\"225px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"329px\",\"top\":\"225px\"},\"redo\":{\"left\":\"326px\",\"top\":\"225px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"329px\",\"top\":\"102px\"},\"redo\":{\"left\":\"333px\",\"top\":\"102px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"329px\",\"top\":\"356px\"},\"redo\":{\"left\":\"326px\",\"top\":\"356px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"326px\",\"top\":\"356px\"},\"redo\":{\"left\":\"325px\",\"top\":\"356px\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":3159,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2-300x105.jpg\",\"post_content\":false,\"customProperties\":[]},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3157,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"0px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0151d387-b8df-454f-b4b3-ea63aee54229\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Transpar\\u00e8ncia\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"104px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"368px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0a82688d-1056-4638-8cf9-beab3ddc5e41\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Descarregat els documents de transpariencia\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"35\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"378px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"511px\\\\\\\"}\",\"style\":\"font-weight:500\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"e6dc01e4-ee1f-41bf-b0ce-fb2e1d68db0d\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3165,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"62px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"924px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"4df75fcc-fe85-4379-882d-0da16f5f754b\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"icon\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"600\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"60\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"364px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"1267px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0012d4aa-4dab-484c-8cdb-f14151fcc83a\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}],\"meta\":{\"activeLayers\":[3],\"undoStackIndex\":45},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"tons of oil\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"tons of oil\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Are spilled in the ocean waters annually\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"838.0000159114053px\",\"top\":\"398.0000159114053px\"},\"redo\":{\"left\":\"684px\",\"top\":\"444px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"711.0000318228106px\",\"top\":\"526.0000318228106px\"},\"redo\":{\"left\":\"714px\",\"top\":\"526px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"510px\",\"top\":\"195px\"},\"redo\":{\"left\":\"369px\",\"top\":\"199px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"descarrega de fitxers\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Are spilled in the ocean waters annually\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"713.9999681771894px\",\"top\":\"526.0000318228106px\"},\"redo\":{\"left\":\"641px\",\"top\":\"546px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"641.0000318228106px\",\"top\":\"546.0000318228106px\"},\"redo\":{\"left\":\"714px\",\"top\":\"444px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"683.9999681771894px\",\"top\":\"443.9999681771894px\"},\"redo\":{\"left\":\"719px\",\"top\":\"500px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"713.9999681771894px\",\"top\":\"443.9999681771894px\"},\"redo\":{\"left\":\"681px\",\"top\":\"462px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"text\"},\"redo\":{\"media\":\"img\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"img\"},\"redo\":{\"media\":\"icon\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"descarregar .pdf\"},\"redo\":{\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"718.9999681771894px\",\"top\":\"500px\"},\"redo\":{\"left\":\"1244px\",\"top\":\"462px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"681.0000318228106px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"551px\",\"top\":\"488px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"550.9999920442973px\",\"top\":\"488.0000159114053px\"},\"redo\":{\"left\":\"568px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"28\"},\"redo\":{\"font-size\":\"35\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"568.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"473px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1243.9999681771894px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"1217px\",\"top\":\"465px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"473.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"483px\",\"top\":\"483px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1216.9999840885946px\",\"top\":\"465px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"458px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"483.0000159114053px\",\"top\":\"483.0000159114053px\"},\"redo\":{\"left\":\"510px\",\"top\":\"478px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"933.9999681771894px\",\"top\":\"160.99999204429736px\"},\"redo\":{\"left\":\"924px\",\"top\":\"62px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"369.00000795570264px\",\"top\":\"199.00000795570264px\"},\"redo\":{\"left\":\"368px\",\"top\":\"104px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"510px\",\"top\":\"478.0000159114053px\"},\"redo\":{\"left\":\"505px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251.0000318228106px\",\"top\":\"458.0000159114053px\"},\"redo\":{\"left\":\"1239px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"505px\",\"top\":\"378px\"},\"redo\":{\"left\":\"485px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1239px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"485px\",\"top\":\"378px\"},\"redo\":{\"left\":\"511px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1267px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]}]},{\"properties\":{\"post_offset\":\"-1\",\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"backgroundId\":3999,\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"bgsize\":\"inherit\",\"bgposition\":\"inherit\",\"bgcolor\":\"\",\"thumbnailId\":\"\",\"thumbnail\":\"\",\"slidedelay\":\"3500\",\"timeshift\":\"0\",\"transitionduration\":\"\",\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"globalhover\":false,\"overflow\":false,\"kenburnszoom\":\"disabled\",\"kenburnsscale\":\"1.2\",\"kenburnsrotate\":\"\",\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxtransformorigin\":\"50% 50% 0\",\"parallaxdurationmove\":\"1500\",\"parallaxdurationleave\":\"1200\",\"parallaxdistance\":\"10\",\"parallaxrotate\":\"10\",\"parallaxtransformperspective\":\"500\",\"id\":\"\",\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann-300x105.jpg\",\"post_content\":false,\"customProperties\":[],\"uuid\":\"4c6fe089-cf10-4800-9ccc-04785f66503f\",\"title\":\"Slide #3\",\"skip\":true},\"sublayers\":[{\"subtitle\":\"Layer #1\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3999,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"200\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallax\\\\\\\":true}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"top\\\\\\\":\\\\\\\"0px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"0px\\\\\\\"}\",\"style\":\"\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann-300x105.jpg\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0151d387-b8df-454f-b4b3-ea63aee54229\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"},{\"subtitle\":\"Layer #2 copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Colaborem<br>amb l\'IVANN\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"1000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"87px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"429px\\\\\\\",\\\\\\\"background\\\\\\\":\\\\\\\"#5de5a7\\\\\\\",\\\\\\\"opacity\\\\\\\":\\\\\\\"0.8\\\\\\\",\\\\\\\"border-radius\\\\\\\":\\\\\\\"4\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0a82688d-1056-4638-8cf9-beab3ddc5e41\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"hide_on_phone\":false,\"hide_on_desktop\":false},{\"subtitle\":\"Layer #2 copy copy copy\",\"media\":\"img\",\"type\":\"p\",\"imageId\":3165,\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"html\":\"\",\"post_text_length\":\"\",\"transition\":\"{\\\\\\\"offsetxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationin\\\\\\\":\\\\\\\"2000\\\\\\\",\\\\\\\"delayin\\\\\\\":\\\\\\\"800\\\\\\\",\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"rotatein\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"rotateyin\\\\\\\":\\\\\\\"180\\\\\\\",\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyin\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyin\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"offsetxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"offsetyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"durationout\\\\\\\":\\\\\\\"400\\\\\\\",\\\\\\\"showuntil\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"rotateout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotatexout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"rotateyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"skewxout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"skewyout\\\\\\\":\\\\\\\"0\\\\\\\",\\\\\\\"scalexout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"scaleyout\\\\\\\":\\\\\\\"1\\\\\\\",\\\\\\\"parallaxlevel\\\\\\\":\\\\\\\"0\\\\\\\"}\",\"url\":\"\",\"target\":\"_self\",\"styles\":\"{\\\\\\\"font-family\\\\\\\":\\\\\\\"open sans\\\\\\\",\\\\\\\"font-size\\\\\\\":\\\\\\\"40\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"25px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"924px\\\\\\\"}\",\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/wave.png\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"4df75fcc-fe85-4379-882d-0da16f5f754b\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}],\"meta\":{\"activeLayers\":[1],\"undoStackIndex\":50},\"history\":[{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[]},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"text\"},\"redo\":{\"media\":\"img\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer media\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"media\":\"img\"},\"redo\":{\"media\":\"icon\"}}},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"descarregar .pdf\"},\"redo\":{\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"718.9999681771894px\",\"top\":\"500px\"},\"redo\":{\"left\":\"1244px\",\"top\":\"462px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"681.0000318228106px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"551px\",\"top\":\"488px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"550.9999920442973px\",\"top\":\"488.0000159114053px\"},\"redo\":{\"left\":\"568px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"font-size\":\"28\"},\"redo\":{\"font-size\":\"35\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"568.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"473px\",\"top\":\"484px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1243.9999681771894px\",\"top\":\"461.9999840885947px\"},\"redo\":{\"left\":\"1217px\",\"top\":\"465px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"473.0000159114053px\",\"top\":\"483.9999681771894px\"},\"redo\":{\"left\":\"483px\",\"top\":\"483px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1216.9999840885946px\",\"top\":\"465px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"458px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"483.0000159114053px\",\"top\":\"483.0000159114053px\"},\"redo\":{\"left\":\"510px\",\"top\":\"478px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"933.9999681771894px\",\"top\":\"160.99999204429736px\"},\"redo\":{\"left\":\"924px\",\"top\":\"62px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"left\":\"369.00000795570264px\",\"top\":\"199.00000795570264px\"},\"redo\":{\"left\":\"368px\",\"top\":\"104px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"510px\",\"top\":\"478.0000159114053px\"},\"redo\":{\"left\":\"505px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251.0000318228106px\",\"top\":\"458.0000159114053px\"},\"redo\":{\"left\":\"1239px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"Descarregat el document de transpariencia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":4,\"undo\":{\"html\":\"\"},\"redo\":{\"html\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"505px\",\"top\":\"378px\"},\"redo\":{\"left\":\"485px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"url\":\"\"},\"redo\":{\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1239px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1251px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"left\":\"485px\",\"top\":\"378px\"},\"redo\":{\"left\":\"511px\",\"top\":\"378px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"1251px\",\"top\":\"364px\"},\"redo\":{\"left\":\"1267px\",\"top\":\"364px\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":3,\"undo\":{\"html\":\"Transpariencia\"},\"redo\":{\"html\":\"Transpar\\u00e8ncia\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer image\",\"updateInfo\":{\"itemIndex\":4,\"undo\":{\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2.jpg\",\"imageId\":3157,\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-2-300x105.jpg\"},\"redo\":{\"image\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"imageId\":3999,\"imageThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"Slide image\",\"updateInfo\":{\"itemIndex\":1,\"undo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2.jpg\",\"backgroundId\":3159,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/layerslider\\/home\\/bg-blur-2-300x105.jpg\"},\"redo\":{\"background\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\",\"backgroundId\":3999,\"backgroundThumb\":\"https:\\/\\/www.aneccullera.org\\/wp-content\\/uploads\\/2018\\/10\\/ivann.jpg\"}}},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"text\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\"Descarregat els documents de transpariencia\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"1000\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"400\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"35\",\"color\":\"#ffffff\",\"top\":\"378px\",\"left\":\"511px\"},\"style\":\"font-weight:500\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"e6dc01e4-ee1f-41bf-b0ce-fb2e1d68db0d\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"slide.layers\",\"name\":\"Remove layer(s)\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"data\":{\"subtitle\":\"Layer #2 copy copy\",\"media\":\"icon\",\"type\":\"p\",\"imageId\":\"\",\"image\":\"\",\"html\":\" <i class=\\\"fa fa-file-pdf-o\\\"><\\/i>\",\"post_text_length\":\"\",\"transition\":{\"offsetxin\":\"0\",\"offsetyin\":\"0\",\"durationin\":\"1000\",\"delayin\":\"600\",\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"rotatein\":\"0\",\"rotatexin\":\"0\",\"rotateyin\":\"0\",\"transformoriginin\":\"50% 50% 0\",\"skewxin\":\"0\",\"skewyin\":\"0\",\"scalexin\":\"1\",\"scaleyin\":\"1\",\"offsetxout\":\"0\",\"offsetyout\":\"0\",\"durationout\":\"0\",\"showuntil\":\"0\",\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"rotateout\":\"0\",\"rotatexout\":\"0\",\"rotateyout\":\"0\",\"transformoriginout\":\"50% 50% 0\",\"skewxout\":\"0\",\"skewyout\":\"0\",\"scalexout\":\"1\",\"scaleyout\":\"1\",\"parallaxlevel\":\"0\"},\"url\":\"https:\\/\\/www.aneccullera.org\\/transpariencia\\/\",\"target\":\"_self\",\"styles\":{\"font-family\":\"open sans\",\"font-size\":\"60\",\"color\":\"#ffffff\",\"top\":\"364px\",\"left\":\"1267px\"},\"style\":\"font-weight:300\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"innerAttributes\":[],\"outerAttributes\":[],\"uuid\":\"0012d4aa-4dab-484c-8cdb-f14151fcc83a\",\"hasTransforms\":false,\"meta\":[],\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\"}},\"redo\":{\"data\":[]}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Transpar\\u00e8ncia\"},\"redo\":{\"html\":\"Colaborem amb l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"color\":\"#ffffff\"},\"redo\":{\"color\":\"#000000\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Colaborem amb l\'IVANN\"},\"redo\":{\"html\":\"Colaborem amb<br> l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"background\":\"\"},\"redo\":{\"background\":\"#5de5a7\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"color\":\"#000000\"},\"redo\":{\"color\":\"#ffffff\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"\"},\"redo\":{\"opacity\":\"50\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"border-radius\":\"\"},\"redo\":{\"border-radius\":\"50\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"50\"},\"redo\":{\"opacity\":\"0.5\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"border-radius\":\"50\"},\"redo\":{\"border-radius\":\"4\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"opacity\":\"0.5\"},\"redo\":{\"opacity\":\"0.8\"}}]},{\"cmd\":\"layer.general\",\"name\":\"Layer settings\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"html\":\"Colaborem amb<br> l\'IVANN\"},\"redo\":{\"html\":\"Colaborem<br>amb l\'IVANN\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"367.9999912855549px\",\"top\":\"104.00001742889013px\"},\"redo\":{\"left\":\"413px\",\"top\":\"121px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"923.9999738566648px\",\"top\":\"61.99999782138873px\"},\"redo\":{\"left\":\"924px\",\"top\":\"25px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"Layer position\",\"updateInfo\":[{\"itemIndex\":1,\"undo\":{\"left\":\"412.9999912855549px\",\"top\":\"120.99998257110987px\"},\"redo\":{\"left\":\"429px\",\"top\":\"87px\"}}]}]}]}","1739440259","1739440259","0","0","0","0","0");

INSERT IGNORE INTO `ac_options` VALUES 
("1","siteurl","https://www.aneccullera.org","yes"),
("2","home","https://www.aneccullera.org","yes"),
("3","blogname","Associació de necessitats especials de Cullera","yes"),
("4","blogdescription","ANEC","yes"),
("5","users_can_register","0","yes"),
("6","admin_email","davidrgb@hotmail.com","yes"),
("7","start_of_week","1","yes"),
("8","use_balanceTags","0","yes"),
("9","use_smilies","1","yes"),
("10","require_name_email","1","yes"),
("11","comments_notify","1","yes"),
("12","posts_per_rss","10","yes"),
("13","rss_use_excerpt","0","yes"),
("14","mailserver_url","mail.example.com","yes"),
("15","mailserver_login","login@example.com","yes"),
("16","mailserver_pass","password","yes"),
("17","mailserver_port","110","yes"),
("18","default_category","1","yes"),
("19","default_comment_status","open","yes"),
("20","default_ping_status","open","yes"),
("21","default_pingback_flag","1","yes"),
("22","posts_per_page","10","yes"),
("23","date_format","j F, Y","yes"),
("24","time_format","g:i a","yes"),
("25","links_updated_date_format","j F, Y g:i a","yes"),
("26","comment_moderation","0","yes"),
("27","moderation_notify","1","yes"),
("28","permalink_structure","/%postname%/","yes"),
("30","hack_file","0","yes"),
("31","blog_charset","UTF-8","yes"),
("32","moderation_keys","","no"),
("33","active_plugins","a:18:{i:0;s:27:\"LayerSlider/layerslider.php\";i:1;s:57:\"cmsms-contact-form-builder/cmsms-contact-form-builder.php\";i:2;s:49:\"cmsms-content-composer/cmsms-content-composer.php\";i:3;s:35:\"cmsms-mega-menu/cmsms-mega-menu.php\";i:4;s:35:\"cookie-law-info/cookie-law-info.php\";i:5;s:32:\"duplicate-page/duplicatepage.php\";i:6;s:33:\"duplicator-pro/duplicator-pro.php\";i:7;s:25:\"facebook-stream/index.php\";i:8;s:55:\"final-tiles-grid-gallery-lite/FinalTilesGalleryLite.php\";i:9;s:16:\"gotmls/index.php\";i:10;s:23:\"loco-translate/loco.php\";i:11;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:12;s:23:\"revslider/revslider.php\";i:13;s:43:\"the-events-calendar/the-events-calendar.php\";i:14;s:43:\"the-events-calendar/the-events-calendar.php\";i:15;s:37:\"tinymce-advanced/tinymce-advanced.php\";i:16;s:41:\"wordpress-importer/wordpress-importer.php\";i:17;s:41:\"wp-gdpr-compliance/wp-gdpr-compliance.php\";}","yes"),
("34","category_base","","yes"),
("35","ping_sites","https://rpc.pingomatic.com/","yes"),
("36","comment_max_links","2","yes"),
("37","gmt_offset","0","yes"),
("38","default_email_category","1","yes"),
("39","recently_edited","","no"),
("40","template","econature","yes"),
("41","stylesheet","econature","yes"),
("44","comment_registration","0","yes"),
("45","html_type","text/html","yes"),
("46","use_trackback","0","yes"),
("47","default_role","subscriber","yes"),
("48","db_version","60421","yes"),
("49","uploads_use_yearmonth_folders","1","yes"),
("50","upload_path","","yes"),
("51","blog_public","1","yes"),
("52","default_link_category","2","yes"),
("53","show_on_front","page","yes"),
("54","tag_base","","yes"),
("55","show_avatars","1","yes"),
("56","avatar_rating","G","yes"),
("57","upload_url_path","","yes"),
("58","thumbnail_size_w","150","yes"),
("59","thumbnail_size_h","150","yes"),
("60","thumbnail_crop","1","yes"),
("61","medium_size_w","300","yes"),
("62","medium_size_h","300","yes"),
("63","avatar_default","mystery","yes"),
("64","large_size_w","1024","yes"),
("65","large_size_h","1024","yes"),
("66","image_default_link_type","none","yes"),
("67","image_default_size","","yes"),
("68","image_default_align","","yes"),
("69","close_comments_for_old_posts","0","yes"),
("70","close_comments_days_old","14","yes"),
("71","thread_comments","1","yes"),
("72","thread_comments_depth","5","yes"),
("73","page_comments","0","yes"),
("74","comments_per_page","50","yes"),
("75","default_comments_page","newest","yes"),
("76","comment_order","asc","yes"),
("77","sticky_posts","a:0:{}","yes"),
("78","widget_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("79","widget_text","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("80","widget_rss","a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}","yes"),
("81","uninstall_plugins","a:5:{s:27:\"LayerSlider/layerslider.php\";s:29:\"layerslider_uninstall_scripts\";s:35:\"cookie-law-info/cookie-law-info.php\";s:30:\"cookielawinfo_uninstall_plugin\";s:48:\"wp-survey-and-poll/wordpress-survey-and-poll.php\";a:2:{i:0;s:6:\"wp_sap\";i:1;s:9:\"uninstall\";}s:29:\"modal_survey/modal_survey.php\";a:2:{i:0;s:12:\"modal_survey\";i:1;s:9:\"uninstall\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:56:\"ReallySimplePlugins\\RSS\\Core\\Bootstrap\\Plugin::uninstall\";}","no"),
("82","timezone_string","","yes"),
("83","page_for_posts","0","yes"),
("84","page_on_front","3081","yes"),
("85","default_post_format","0","yes"),
("86","link_manager_enabled","0","yes"),
("87","finished_splitting_shared_terms","1","yes"),
("88","site_icon","0","yes"),
("89","medium_large_size_w","768","yes"),
("90","medium_large_size_h","0","yes"),
("91","initial_db_version","38590","yes"),
("92","ac_user_roles","a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:168:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:10:\"loco_admin\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:20:\"duplicator_pro_basic\";b:1;s:21:\"duplicator_pro_create\";b:1;s:23:\"duplicator_pro_schedule\";b:1;s:22:\"duplicator_pro_storage\";b:1;s:29:\"duplicator_pro_backup_restore\";b:1;s:21:\"duplicator_pro_import\";b:1;s:21:\"duplicator_pro_export\";b:1;s:23:\"duplicator_pro_settings\";b:1;s:22:\"duplicator_pro_license\";b:1;s:15:\"manage_security\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:30:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:7:\"Cliente\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:19:\"Gestor de la tienda\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}","yes"),
("93","fresh_site","0","off"),
("94","WPLANG","ca","yes"),
("95","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("96","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("97","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("98","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("99","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("100","sidebars_widgets","a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:15:\"sidebar_default\";a:0:{}s:14:\"sidebar_bottom\";a:1:{i:0;s:11:\"ff_widget-2\";}s:13:\"array_version\";i:3;}","yes"),
("101","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("102","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("103","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("104","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("105","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("106","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("107","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("108","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("109","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("110","cron","a:27:{i:1542381721;a:1:{s:39:\"woocommerce_plugin_background_installer\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:2:{i:0;s:12:\"2mb-autocode\";i:1;a:1:{s:9:\"repo-slug\";s:12:\"2mb-autocode\";}}s:8:\"interval\";i:3600;}}}i:1765539099;a:1:{s:29:\"rsssl_every_five_minutes_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:18:\"rsssl_five_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:300;}}}i:1765539118;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1765539832;a:1:{s:32:\"duplicator_backup_storages_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:41:\"duplicator_backup_storages_check_interval\";s:4:\"args\";a:0:{}s:8:\"interval\";i:900;}}}i:1765542113;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765542120;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1765542121;a:1:{s:39:\"woocommerce_plugin_background_installer\";a:1:{s:32:\"11c9a6df7317ef4ddb00956890c65c1b\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:2:{i:0;s:12:\"2mb-autocode\";i:1;a:1:{s:9:\"repo-slug\";s:12:\"2mb-autocode\";}}s:8:\"interval\";i:3600;}}}i:1765542561;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765542898;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765545698;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765545713;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765549599;a:1:{s:28:\"rsssl_every_three_hours_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:23:\"rsssl_every_three_hours\";s:4:\"args\";a:0:{}s:8:\"interval\";i:10800;}}}i:1765550359;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765552920;a:1:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765554982;a:1:{s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765554984;a:1:{s:30:\"tribe_schedule_transient_purge\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765555037;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765617637;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765625199;a:1:{s:20:\"rsssl_every_day_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"rsssl_daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765625332;a:1:{s:31:\"duplicator_activity_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:21:\"duplicator_daily_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765807200;a:1:{s:33:\"duplicator_pro_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765827745;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766074731;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766105972;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1766143599;a:1:{s:21:\"rsssl_every_week_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:12:\"rsssl_weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1768130799;a:1:{s:22:\"rsssl_every_month_hook\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:13:\"rsssl_monthly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on"),
("111","theme_mods_twentyseventeen","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1525515428;s:4:\"data\";a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:9:\"sidebar-2\";a:0:{}s:9:\"sidebar-3\";a:0:{}}}}","off"),
("142","new_admin_email","davidrgb@hotmail.com","yes"),
("147","current_theme","EcoNature | Shared By Themes24x7.com","yes"),
("148","theme_mods_econature","a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:29;s:6:\"footer\";i:0;s:8:\"top_line\";i:0;}s:18:\"custom_css_post_id\";i:-1;}","yes"),
("149","theme_switched","","yes"),
("150","widget_custom-advertisement","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("151","widget_custom-contact-info","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("152","widget_custom-divider","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("153","widget_custom-video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("154","widget_custom-facebook","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("155","widget_custom-flickr","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("156","widget_custom-html5-audio","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("157","widget_custom-html5-video","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("158","widget_custom-posts-tabs","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("159","widget_custom-twitter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("160","cmsms_active_theme","econature","yes"),
("161","cmsms_options_econature_general","a:8:{s:22:\"econature_theme_layout\";s:6:\"liquid\";s:20:\"econature_responsive\";i:1;s:16:\"econature_retina\";i:1;s:17:\"econature_preload\";i:1;s:20:\"econature_preload_bg\";s:7:\"#ffffff\";s:23:\"econature_preload_color\";s:7:\"#dadada\";s:24:\"econature_preload_effect\";s:4:\"grow\";s:28:\"econature_preload_percentage\";i:0;}","yes"),
("162","cmsms_options_econature_sidebar","","yes"),
("163","cmsms_options_econature_sitemap","a:6:{s:21:\"econature_sitemap_nav\";i:1;s:24:\"econature_sitemap_categs\";i:1;s:22:\"econature_sitemap_tags\";i:1;s:23:\"econature_sitemap_month\";i:1;s:27:\"econature_sitemap_pj_categs\";i:1;s:25:\"econature_sitemap_pj_tags\";i:1;}","yes"),
("164","cmsms_options_econature_error","a:5:{s:24:\"econature_error_bg_color\";s:11:\"#3d3d3d|100\";s:24:\"econature_error_bg_image\";s:0:\"\";s:22:\"econature_error_search\";i:1;s:30:\"econature_error_sitemap_button\";i:1;s:28:\"econature_error_sitemap_link\";s:0:\"\";}","yes"),
("165","cmsms_options_econature_lightbox","a:19:{s:24:\"econature_ilightbox_skin\";s:4:\"dark\";s:24:\"econature_ilightbox_path\";s:8:\"vertical\";s:28:\"econature_ilightbox_infinite\";i:0;s:32:\"econature_ilightbox_aspect_ratio\";i:1;s:36:\"econature_ilightbox_mobile_optimizer\";i:1;s:29:\"econature_ilightbox_max_scale\";i:1;s:29:\"econature_ilightbox_min_scale\";d:0.20000000000000001;s:33:\"econature_ilightbox_inner_toolbar\";i:0;s:37:\"econature_ilightbox_smart_recognition\";i:0;s:40:\"econature_ilightbox_fullscreen_one_slide\";i:0;s:39:\"econature_ilightbox_fullscreen_viewport\";s:6:\"center\";s:36:\"econature_ilightbox_controls_toolbar\";i:1;s:35:\"econature_ilightbox_controls_arrows\";i:0;s:39:\"econature_ilightbox_controls_fullscreen\";i:1;s:38:\"econature_ilightbox_controls_thumbnail\";i:1;s:37:\"econature_ilightbox_controls_keyboard\";i:1;s:39:\"econature_ilightbox_controls_mousewheel\";i:1;s:34:\"econature_ilightbox_controls_swipe\";i:1;s:38:\"econature_ilightbox_controls_slideshow\";i:0;}","yes"),
("166","cmsms_options_econature_code","a:8:{s:26:\"econature_google_analytics\";s:0:\"\";s:20:\"econature_custom_css\";s:584:\".header_mid_inner #navigation > li > a > span {\r\n    padding: 0 10px;\r\n    position: relative;\r\n    z-index: 205;\r\n}\r\n.headline_outer .headline_inner .headline_text h1 {\r\n    margin: 0;\r\n    color: white;\r\n}\r\n.post-password-form, .header_top_inner, .header_mid_inner, .header_bot_inner, .content_wrap, .headline_inner, .cmsms_breadcrumbs_inner, .bottom_outer, .footer_inner, .cmsms_row_inner {\r\n    position: relative;\r\n    width: 1200px;\r\n    padding: 0 20px;\r\n    margin: 0 auto;\r\n    -webkit-box-sizing: border-box;\r\n    -moz-box-sizing: border-box;\r\n    box-sizing: border-box;\r\n}\";s:19:\"econature_custom_js\";s:0:\"\";s:22:\"econature_gmap_api_key\";s:0:\"\";s:17:\"econature_api_key\";s:0:\"\";s:20:\"econature_api_secret\";s:0:\"\";s:22:\"econature_access_token\";s:0:\"\";s:29:\"econature_access_token_secret\";s:0:\"\";}","yes"),
("167","cmsms_options_econature_recaptcha","","yes"),
("168","cmsms_options_econature_style_logo","a:10:{s:19:\"econature_logo_type\";s:5:\"image\";s:18:\"econature_logo_url\";s:67:\"3166|http://www.aneccullera.org/wp-content/uploads/2018/05/logo.jpg\";s:25:\"econature_logo_url_retina\";s:67:\"3166|http://www.aneccullera.org/wp-content/uploads/2018/05/logo.jpg\";s:20:\"econature_logo_title\";s:47:\"Associació de necessitats especials de Cullera\";s:23:\"econature_logo_subtitle\";s:0:\"\";s:27:\"econature_logo_custom_color\";i:0;s:26:\"econature_logo_title_color\";s:11:\"#3d3d3d|100\";s:29:\"econature_logo_subtitle_color\";s:11:\"#3d3d3d|100\";s:17:\"econature_favicon\";i:1;s:21:\"econature_favicon_url\";s:70:\"3168|http://www.aneccullera.org/wp-content/uploads/2018/05/favicon.png\";}","yes"),
("169","cmsms_options_econature_style_bg","a:7:{s:16:\"econature_bg_col\";s:7:\"#ffffff\";s:23:\"econature_bg_img_enable\";i:0;s:16:\"econature_bg_img\";s:0:\"\";s:16:\"econature_bg_rep\";s:9:\"no-repeat\";s:16:\"econature_bg_pos\";s:10:\"top center\";s:16:\"econature_bg_att\";s:6:\"scroll\";s:17:\"econature_bg_size\";s:5:\"cover\";}","yes"),
("170","cmsms_options_econature_style_header","a:11:{s:22:\"econature_fixed_header\";i:1;s:25:\"econature_header_top_line\";i:1;s:27:\"econature_header_top_height\";s:2:\"40\";s:36:\"econature_header_top_line_short_info\";s:888:\"<span style=\\\"font-size: 13px\\\"><img src=\\\"https://www.aneccullera.org/img/ubicacion.png\\\" />  C/ Madrid, 4. Cullera (Valencia). 46400<img src=\\\"https://www.aneccullera.org/img/blanco.png\\\" /><img src=\\\"https://www.aneccullera.org/img/telefono.png\\\" />  606318062<img src=\\\"https://www.aneccullera.org/img/blanco.png\\\" /><img src=\\\"https://www.aneccullera.org/img/blanco.png\\\" /></span><a href=\\\"https://www.aneccullera.org/transpariencia\\\"> <img src=\\\"https://www.aneccullera.org/img/transpariencia.jpg\\\" /></a><a href=\\\"https://www.aneccullera.org/galeria-d-imatges\\\"> <img src=\\\"https://www.aneccullera.org/img/galeria.jpg\\\" /></a><a href=\\\"https://www.aneccullera.org/escola-de-pares/\\\"> <img src=\\\"https://www.aneccullera.org/img/escoladepares.jpg\\\" /></a><a href=\\\"https://www.aneccullera.org/sugerencies-contacte/\\\"> <img src=\\\"https://www.aneccullera.org/img/contacte.jpg\\\" /></a>\";s:34:\"econature_header_top_line_add_cont\";s:6:\"social\";s:23:\"econature_header_styles\";s:7:\"default\";s:27:\"econature_header_mid_height\";s:3:\"120\";s:27:\"econature_header_bot_height\";s:2:\"45\";s:23:\"econature_header_search\";i:0;s:25:\"econature_header_add_cont\";s:9:\"cust_html\";s:35:\"econature_header_add_cont_cust_html\";s:0:\"\";}","yes"),
("171","cmsms_options_econature_style_content","a:16:{s:16:\"econature_layout\";s:9:\"fullwidth\";s:27:\"econature_heading_alignment\";s:4:\"left\";s:24:\"econature_heading_scheme\";s:7:\"default\";s:33:\"econature_heading_bg_image_enable\";i:0;s:26:\"econature_heading_bg_image\";s:0:\"\";s:27:\"econature_heading_bg_repeat\";s:9:\"no-repeat\";s:31:\"econature_heading_bg_attachment\";s:6:\"scroll\";s:25:\"econature_heading_bg_size\";s:5:\"cover\";s:26:\"econature_heading_bg_color\";s:7:\"#000000\";s:34:\"econature_heading_bg_color_opacity\";s:1:\"0\";s:24:\"econature_heading_height\";s:2:\"70\";s:21:\"econature_breadcrumbs\";i:1;s:31:\"econature_breadcrumbs_alignment\";s:5:\"right\";s:23:\"econature_bottom_scheme\";s:7:\"default\";s:24:\"econature_bottom_sidebar\";i:0;s:31:\"econature_bottom_sidebar_layout\";s:6:\"131313\";}","yes"),
("172","cmsms_options_econature_style_footer","a:12:{s:23:\"econature_footer_scheme\";s:6:\"footer\";s:21:\"econature_footer_type\";s:7:\"default\";s:35:\"econature_footer_additional_content\";s:6:\"social\";s:22:\"econature_fixed_footer\";i:0;s:23:\"econature_footer_height\";s:3:\"300\";s:21:\"econature_footer_logo\";i:0;s:25:\"econature_footer_logo_url\";s:67:\"3166|http://www.aneccullera.org/wp-content/uploads/2018/05/logo.jpg\";s:32:\"econature_footer_logo_url_retina\";s:67:\"3166|http://www.aneccullera.org/wp-content/uploads/2018/05/logo.jpg\";s:20:\"econature_footer_nav\";i:1;s:23:\"econature_footer_social\";i:1;s:21:\"econature_footer_html\";s:245:\"<a href=\\\"https://www.aneccullera.org/politica-de-privacidad\\\">Política de privacidad</a> | <a href=\\\"https://www.aneccullera.org/avis-legal\\\">Aviso legal</a> |<a href=\\\"https://www.aneccullera.org/politica-de-cookies\\\">Política de cookies</a>\";s:26:\"econature_footer_copyright\";s:42:\"Anec Cullera © | Tots els drets reservats\";}","yes"),
("173","cmsms_options_econature_style_icon","a:1:{s:22:\"econature_social_icons\";a:1:{i:0;s:43:\"cmsms-icon-facebook-circled|#|Facebook|true\";}}","yes"),
("174","cmsms_options_econature_font_content","a:6:{s:34:\"econature_content_font_system_font\";s:58:\"\'Lucida Sans Unicode\', \'Lucida Grande\', Garuda, sans-serif\";s:34:\"econature_content_font_google_font\";s:51:\"Open+Sans:300,300italic,400,400italic,700,700italic\";s:32:\"econature_content_font_font_size\";s:2:\"14\";s:34:\"econature_content_font_line_height\";s:2:\"20\";s:34:\"econature_content_font_font_weight\";s:6:\"normal\";s:33:\"econature_content_font_font_style\";s:6:\"normal\";}","yes"),
("175","cmsms_options_econature_font_link","a:9:{s:31:\"econature_link_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:31:\"econature_link_font_google_font\";s:18:\"Oxygen:300,400,700\";s:29:\"econature_link_font_font_size\";s:2:\"14\";s:31:\"econature_link_font_line_height\";s:2:\"20\";s:31:\"econature_link_font_font_weight\";s:3:\"500\";s:30:\"econature_link_font_font_style\";s:6:\"normal\";s:34:\"econature_link_font_text_transform\";s:4:\"none\";s:35:\"econature_link_font_text_decoration\";s:4:\"none\";s:31:\"econature_link_hover_decoration\";s:4:\"none\";}","yes"),
("176","cmsms_options_econature_font_nav","a:14:{s:36:\"econature_nav_title_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:36:\"econature_nav_title_font_google_font\";s:18:\"Oxygen:300,400,700\";s:34:\"econature_nav_title_font_font_size\";s:2:\"16\";s:36:\"econature_nav_title_font_line_height\";s:2:\"20\";s:36:\"econature_nav_title_font_font_weight\";s:3:\"300\";s:35:\"econature_nav_title_font_font_style\";s:6:\"normal\";s:39:\"econature_nav_title_font_text_transform\";s:4:\"none\";s:39:\"econature_nav_dropdown_font_system_font\";s:42:\"Verdana, Geneva, \'DejaVu Sans\', sans-serif\";s:39:\"econature_nav_dropdown_font_google_font\";s:0:\"\";s:37:\"econature_nav_dropdown_font_font_size\";s:2:\"15\";s:39:\"econature_nav_dropdown_font_line_height\";s:2:\"20\";s:39:\"econature_nav_dropdown_font_font_weight\";s:6:\"normal\";s:38:\"econature_nav_dropdown_font_font_style\";s:6:\"normal\";s:42:\"econature_nav_dropdown_font_text_transform\";s:4:\"none\";}","yes"),
("177","cmsms_options_econature_font_heading","a:48:{s:29:\"econature_h1_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h1_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h1_font_font_size\";s:2:\"32\";s:29:\"econature_h1_font_line_height\";s:2:\"40\";s:29:\"econature_h1_font_font_weight\";s:3:\"300\";s:28:\"econature_h1_font_font_style\";s:6:\"normal\";s:32:\"econature_h1_font_text_transform\";s:4:\"none\";s:33:\"econature_h1_font_text_decoration\";s:4:\"none\";s:29:\"econature_h2_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h2_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h2_font_font_size\";s:2:\"22\";s:29:\"econature_h2_font_line_height\";s:2:\"34\";s:29:\"econature_h2_font_font_weight\";s:3:\"300\";s:28:\"econature_h2_font_font_style\";s:6:\"normal\";s:32:\"econature_h2_font_text_transform\";s:4:\"none\";s:33:\"econature_h2_font_text_decoration\";s:4:\"none\";s:29:\"econature_h3_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h3_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h3_font_font_size\";s:2:\"18\";s:29:\"econature_h3_font_line_height\";s:2:\"28\";s:29:\"econature_h3_font_font_weight\";s:3:\"300\";s:28:\"econature_h3_font_font_style\";s:6:\"normal\";s:32:\"econature_h3_font_text_transform\";s:4:\"none\";s:33:\"econature_h3_font_text_decoration\";s:4:\"none\";s:29:\"econature_h4_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h4_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h4_font_font_size\";s:2:\"16\";s:29:\"econature_h4_font_line_height\";s:2:\"26\";s:29:\"econature_h4_font_font_weight\";s:3:\"300\";s:28:\"econature_h4_font_font_style\";s:6:\"italic\";s:32:\"econature_h4_font_text_transform\";s:4:\"none\";s:33:\"econature_h4_font_text_decoration\";s:4:\"none\";s:29:\"econature_h5_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h5_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h5_font_font_size\";s:2:\"15\";s:29:\"econature_h5_font_line_height\";s:2:\"24\";s:29:\"econature_h5_font_font_weight\";s:3:\"300\";s:28:\"econature_h5_font_font_style\";s:6:\"normal\";s:32:\"econature_h5_font_text_transform\";s:4:\"none\";s:33:\"econature_h5_font_text_decoration\";s:4:\"none\";s:29:\"econature_h6_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:29:\"econature_h6_font_google_font\";s:18:\"Oxygen:300,400,700\";s:27:\"econature_h6_font_font_size\";s:2:\"14\";s:29:\"econature_h6_font_line_height\";s:2:\"20\";s:29:\"econature_h6_font_font_weight\";s:3:\"300\";s:28:\"econature_h6_font_font_style\";s:6:\"normal\";s:32:\"econature_h6_font_text_transform\";s:4:\"none\";s:33:\"econature_h6_font_text_decoration\";s:4:\"none\";}","yes"),
("178","cmsms_options_econature_font_other","a:26:{s:33:\"econature_button_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:33:\"econature_button_font_google_font\";s:18:\"Oxygen:300,400,700\";s:31:\"econature_button_font_font_size\";s:2:\"15\";s:33:\"econature_button_font_line_height\";s:2:\"44\";s:33:\"econature_button_font_font_weight\";s:6:\"normal\";s:32:\"econature_button_font_font_style\";s:6:\"normal\";s:36:\"econature_button_font_text_transform\";s:9:\"uppercase\";s:32:\"econature_small_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:32:\"econature_small_font_google_font\";s:18:\"Oxygen:300,400,700\";s:30:\"econature_small_font_font_size\";s:2:\"11\";s:32:\"econature_small_font_line_height\";s:2:\"18\";s:32:\"econature_small_font_font_weight\";s:6:\"normal\";s:31:\"econature_small_font_font_style\";s:6:\"normal\";s:35:\"econature_small_font_text_transform\";s:4:\"none\";s:32:\"econature_input_font_system_font\";s:42:\"Verdana, Geneva, \'DejaVu Sans\', sans-serif\";s:32:\"econature_input_font_google_font\";s:0:\"\";s:30:\"econature_input_font_font_size\";s:2:\"13\";s:32:\"econature_input_font_line_height\";s:2:\"20\";s:32:\"econature_input_font_font_weight\";s:6:\"normal\";s:31:\"econature_input_font_font_style\";s:6:\"normal\";s:32:\"econature_quote_font_system_font\";s:45:\"Arial, Helvetica, \'Nimbus Sans L\', sans-serif\";s:32:\"econature_quote_font_google_font\";s:18:\"Oxygen:300,400,700\";s:30:\"econature_quote_font_font_size\";s:2:\"16\";s:32:\"econature_quote_font_line_height\";s:2:\"26\";s:32:\"econature_quote_font_font_weight\";s:3:\"400\";s:31:\"econature_quote_font_font_style\";s:6:\"italic\";}","yes"),
("179","cmsms_options_econature_single_post","a:15:{s:26:\"econature_blog_post_layout\";s:9:\"r_sidebar\";s:25:\"econature_blog_post_title\";i:1;s:24:\"econature_blog_post_date\";i:1;s:23:\"econature_blog_post_cat\";i:1;s:26:\"econature_blog_post_author\";i:1;s:27:\"econature_blog_post_comment\";i:1;s:23:\"econature_blog_post_tag\";i:1;s:24:\"econature_blog_post_like\";i:1;s:27:\"econature_blog_post_nav_box\";i:1;s:29:\"econature_blog_post_share_box\";i:1;s:30:\"econature_blog_post_author_box\";i:1;s:37:\"econature_blog_more_posts_box_related\";s:4:\"true\";s:37:\"econature_blog_more_posts_box_popular\";s:4:\"true\";s:36:\"econature_blog_more_posts_box_recent\";s:4:\"true\";s:32:\"econature_blog_post_r_p_l_number\";s:1:\"4\";}","yes"),
("180","cmsms_options_econature_single_project","a:17:{s:33:\"econature_portfolio_project_title\";i:1;s:41:\"econature_portfolio_project_details_title\";s:15:\"Project details\";s:32:\"econature_portfolio_project_date\";i:1;s:31:\"econature_portfolio_project_cat\";i:1;s:34:\"econature_portfolio_project_author\";i:1;s:35:\"econature_portfolio_project_comment\";i:0;s:31:\"econature_portfolio_project_tag\";i:0;s:32:\"econature_portfolio_project_like\";i:1;s:32:\"econature_portfolio_project_link\";i:0;s:37:\"econature_portfolio_project_share_box\";i:1;s:35:\"econature_portfolio_project_nav_box\";i:1;s:38:\"econature_portfolio_project_author_box\";i:1;s:45:\"econature_portfolio_more_projects_box_related\";s:4:\"true\";s:45:\"econature_portfolio_more_projects_box_popular\";s:4:\"true\";s:44:\"econature_portfolio_more_projects_box_recent\";s:4:\"true\";s:40:\"econature_portfolio_project_r_p_l_number\";s:1:\"4\";s:32:\"econature_portfolio_project_slug\";s:7:\"project\";}","yes"),
("181","cmsms_options_econature_single_profile","a:7:{s:28:\"econature_profile_post_title\";i:1;s:36:\"econature_profile_post_details_title\";s:15:\"Profile details\";s:26:\"econature_profile_post_cat\";i:1;s:30:\"econature_profile_post_comment\";i:1;s:30:\"econature_profile_post_nav_box\";i:1;s:32:\"econature_profile_post_share_box\";i:1;s:27:\"econature_profile_post_slug\";s:7:\"profile\";}","yes"),
("182","cmsms_options_econature_color_default","a:7:{s:23:\"econature_default_color\";s:11:\"#556270|100\";s:22:\"econature_default_link\";s:11:\"#58cf90|100\";s:23:\"econature_default_hover\";s:11:\"#c8ccce|100\";s:25:\"econature_default_heading\";s:11:\"#4c5562|100\";s:20:\"econature_default_bg\";s:11:\"#ffffff|100\";s:27:\"econature_default_alternate\";s:11:\"#ffffff|100\";s:24:\"econature_default_border\";s:11:\"#e5e8ec|100\";}","yes"),
("183","cmsms_options_econature_color_header","a:13:{s:22:\"econature_header_color\";s:11:\"#58cf90|100\";s:21:\"econature_header_link\";s:11:\"#707070|100\";s:22:\"econature_header_hover\";s:11:\"#58cf90|100\";s:19:\"econature_header_bg\";s:10:\"#ffffff|95\";s:25:\"econature_header_hover_bg\";s:9:\"#3d3d3d|0\";s:23:\"econature_header_border\";s:11:\"#ebebeb|100\";s:30:\"econature_header_dropdown_link\";s:11:\"#9e9e9e|100\";s:31:\"econature_header_dropdown_hover\";s:11:\"#3d3d3d|100\";s:28:\"econature_header_dropdown_bg\";s:11:\"#ffffff|100\";s:34:\"econature_header_dropdown_hover_bg\";s:11:\"#fbfbfb|100\";s:32:\"econature_header_dropdown_border\";s:11:\"#ebebeb|100\";s:32:\"econature_header_dropdown_shadow\";i:1;s:40:\"econature_header_dropdown_shadow_opacity\";s:1:\"2\";}","yes"),
("184","cmsms_options_econature_color_header_top","a:11:{s:26:\"econature_header_top_color\";s:11:\"#979ca4|100\";s:25:\"econature_header_top_link\";s:11:\"#979ca4|100\";s:26:\"econature_header_top_hover\";s:11:\"#c8ccce|100\";s:23:\"econature_header_top_bg\";s:11:\"#ffffff|100\";s:27:\"econature_header_top_border\";s:11:\"#eaedf0|100\";s:34:\"econature_header_top_dropdown_link\";s:11:\"#979ca4|100\";s:35:\"econature_header_top_dropdown_hover\";s:11:\"#58cf90|100\";s:32:\"econature_header_top_dropdown_bg\";s:11:\"#ffffff|100\";s:36:\"econature_header_top_dropdown_border\";s:11:\"#e5e8ec|100\";s:36:\"econature_header_top_dropdown_shadow\";i:1;s:44:\"econature_header_top_dropdown_shadow_opacity\";s:2:\"80\";}","yes"),
("185","cmsms_options_econature_color_footer","a:7:{s:22:\"econature_footer_color\";s:11:\"#979ca4|100\";s:21:\"econature_footer_link\";s:11:\"#c8ccce|100\";s:22:\"econature_footer_hover\";s:11:\"#58cf90|100\";s:24:\"econature_footer_heading\";s:11:\"#4c5562|100\";s:19:\"econature_footer_bg\";s:11:\"#ffffff|100\";s:26:\"econature_footer_alternate\";s:11:\"#f2f2f2|100\";s:23:\"econature_footer_border\";s:11:\"#e5e8ec|100\";}","yes"),
("186","cmsms_options_econature_color_first","a:7:{s:21:\"econature_first_color\";s:11:\"#ffffff|100\";s:20:\"econature_first_link\";s:11:\"#ffffff|100\";s:21:\"econature_first_hover\";s:11:\"#ffffff|100\";s:23:\"econature_first_heading\";s:11:\"#ffffff|100\";s:18:\"econature_first_bg\";s:11:\"#3d3d3d|100\";s:25:\"econature_first_alternate\";s:11:\"#414141|100\";s:22:\"econature_first_border\";s:11:\"#5a5a5a|100\";}","yes"),
("187","cmsms_options_econature_color_second","a:7:{s:22:\"econature_second_color\";s:11:\"#3d3d3d|100\";s:21:\"econature_second_link\";s:11:\"#9e9e9e|100\";s:22:\"econature_second_hover\";s:11:\"#3d3d3d|100\";s:24:\"econature_second_heading\";s:11:\"#3d3d3d|100\";s:19:\"econature_second_bg\";s:11:\"#ffffff|100\";s:26:\"econature_second_alternate\";s:11:\"#fbfbfb|100\";s:23:\"econature_second_border\";s:11:\"#ebebeb|100\";}","yes"),
("188","cmsms_options_econature_color_third","a:7:{s:21:\"econature_third_color\";s:11:\"#9c9c9c|100\";s:20:\"econature_third_link\";s:11:\"#838383|100\";s:21:\"econature_third_hover\";s:11:\"#ffffff|100\";s:23:\"econature_third_heading\";s:11:\"#838383|100\";s:18:\"econature_third_bg\";s:11:\"#ffffff|100\";s:25:\"econature_third_alternate\";s:11:\"#ffffff|100\";s:22:\"econature_third_border\";s:11:\"#eaedf0|100\";}","yes"),
("189","cmsms_options_econature_color_fourth","a:7:{s:22:\"econature_fourth_color\";s:11:\"#707070|100\";s:21:\"econature_fourth_link\";s:11:\"#94e95d|100\";s:22:\"econature_fourth_hover\";s:11:\"#3d3d3d|100\";s:24:\"econature_fourth_heading\";s:11:\"#979ca4|100\";s:19:\"econature_fourth_bg\";s:11:\"#ffffff|100\";s:26:\"econature_fourth_alternate\";s:11:\"#fdfdfd|100\";s:23:\"econature_fourth_border\";s:11:\"#c8ccce|100\";}","yes"),
("190","cmsms_options_econature_color_fifth","a:7:{s:21:\"econature_fifth_color\";s:11:\"#ffffff|100\";s:20:\"econature_fifth_link\";s:11:\"#58cf90|100\";s:21:\"econature_fifth_hover\";s:11:\"#d0f275|100\";s:23:\"econature_fifth_heading\";s:11:\"#fcfcfc|100\";s:18:\"econature_fifth_bg\";s:11:\"#5b5b5b|100\";s:25:\"econature_fifth_alternate\";s:11:\"#fdfdfd|100\";s:22:\"econature_fifth_border\";s:11:\"#b5b5b5|100\";}","yes"),
("191","cmsms_econature_icons","s:233000:\"a:7:{s:4:\"name\";s:0:\"\";s:15:\"css_prefix_text\";s:11:\"cmsms-icon-\";s:14:\"css_use_suffix\";b:0;s:7:\"hinting\";b:1;s:12:\"units_per_em\";i:1000;s:6:\"ascent\";i:850;s:6:\"glyphs\";a:1750:{i:0;a:4:{s:3:\"uid\";s:32:\"572c9ded6a688698dc275b30ff30fefa\";s:3:\"css\";s:7:\"music-4\";s:4:\"code\";i:60527;s:3:\"src\";s:8:\"linecons\";}i:1;a:4:{s:3:\"uid\";s:32:\"9725db89b610135dc76cd8a21afffa83\";s:3:\"css\";s:8:\"search-7\";s:4:\"code\";i:60528;s:3:\"src\";s:8:\"linecons\";}i:2;a:4:{s:3:\"uid\";s:32:\"91bac16b22827347e9ee20477f0b44d2\";s:3:\"css\";s:6:\"mail-7\";s:4:\"code\";i:60529;s:3:\"src\";s:8:\"linecons\";}i:3;a:4:{s:3:\"uid\";s:32:\"b19ac67070bc44e310990016288e449c\";s:3:\"css\";s:7:\"heart-7\";s:4:\"code\";i:60530;s:3:\"src\";s:8:\"linecons\";}i:4;a:4:{s:3:\"uid\";s:32:\"0817b47d6e5f1d85f2428640a021f0c4\";s:3:\"css\";s:6:\"star-7\";s:4:\"code\";i:60531;s:3:\"src\";s:8:\"linecons\";}i:5;a:4:{s:3:\"uid\";s:32:\"56a0672588820ab1a16363e5d07dd22e\";s:3:\"css\";s:6:\"user-7\";s:4:\"code\";i:60532;s:3:\"src\";s:8:\"linecons\";}i:6;a:4:{s:3:\"uid\";s:32:\"f2a37db235ca1951d60d7ebc9733eb54\";s:3:\"css\";s:10:\"videocam-5\";s:4:\"code\";i:60533;s:3:\"src\";s:8:\"linecons\";}i:7;a:4:{s:3:\"uid\";s:32:\"b59cc4d390a6df564a055f43c03a6af5\";s:3:\"css\";s:8:\"camera-7\";s:4:\"code\";i:60534;s:3:\"src\";s:8:\"linecons\";}i:8;a:4:{s:3:\"uid\";s:32:\"8573943a49ed6dd8f7819070445baa46\";s:3:\"css\";s:5:\"photo\";s:4:\"code\";i:60535;s:3:\"src\";s:8:\"linecons\";}i:9;a:4:{s:3:\"uid\";s:32:\"359f380b2113cb40259269aed843e33d\";s:3:\"css\";s:8:\"attach-6\";s:4:\"code\";i:60536;s:3:\"src\";s:8:\"linecons\";}i:10;a:4:{s:3:\"uid\";s:32:\"47e9e56d2b5abe839bcf1e014d643dea\";s:3:\"css\";s:6:\"lock-7\";s:4:\"code\";i:60537;s:3:\"src\";s:8:\"linecons\";}i:11;a:4:{s:3:\"uid\";s:32:\"a58c05a8a3ba59ababd4860a30892560\";s:3:\"css\";s:5:\"eye-7\";s:4:\"code\";i:60538;s:3:\"src\";s:8:\"linecons\";}i:12;a:4:{s:3:\"uid\";s:32:\"930c31d4c72bd792b5dceb6de607c3e0\";s:3:\"css\";s:5:\"tag-6\";s:4:\"code\";i:60539;s:3:\"src\";s:8:\"linecons\";}i:13;a:4:{s:3:\"uid\";s:32:\"06a2fbb04dffecdb444936073cae9123\";s:3:\"css\";s:11:\"thumbs-up-5\";s:4:\"code\";i:60540;s:3:\"src\";s:8:\"linecons\";}i:14;a:4:{s:3:\"uid\";s:32:\"2aeb4987b469d22fcb8b471b6d2cdfff\";s:3:\"css\";s:8:\"pencil-7\";s:4:\"code\";i:60541;s:3:\"src\";s:8:\"linecons\";}i:15;a:4:{s:3:\"uid\";s:32:\"5b1a68729f60f8be3769238379d1b8e9\";s:3:\"css\";s:9:\"comment-6\";s:4:\"code\";i:60542;s:3:\"src\";s:8:\"linecons\";}i:16;a:4:{s:3:\"uid\";s:32:\"1ea8ad6dbe1ae9a73565ad16cf88de19\";s:3:\"css\";s:10:\"location-7\";s:4:\"code\";i:60543;s:3:\"src\";s:8:\"linecons\";}i:17;a:4:{s:3:\"uid\";s:32:\"c2958cfd1eed4434ab6e4bd6ab337af9\";s:3:\"css\";s:5:\"cup-1\";s:4:\"code\";i:60544;s:3:\"src\";s:8:\"linecons\";}i:18;a:4:{s:3:\"uid\";s:32:\"2cc73cc335f054682c04fe63439c4dcb\";s:3:\"css\";s:7:\"trash-8\";s:4:\"code\";i:60545;s:3:\"src\";s:8:\"linecons\";}i:19;a:4:{s:3:\"uid\";s:32:\"f978da58836f23373882916f05fb70b4\";s:3:\"css\";s:5:\"doc-7\";s:4:\"code\";i:60546;s:3:\"src\";s:8:\"linecons\";}i:20;a:4:{s:3:\"uid\";s:32:\"29f4bce4a60650057c5248e30baa15a6\";s:3:\"css\";s:6:\"note-1\";s:4:\"code\";i:60547;s:3:\"src\";s:8:\"linecons\";}i:21;a:4:{s:3:\"uid\";s:32:\"484b4ad2058d17849f205c4054b6f315\";s:3:\"css\";s:5:\"cog-6\";s:4:\"code\";i:60548;s:3:\"src\";s:8:\"linecons\";}i:22;a:4:{s:3:\"uid\";s:32:\"3e2bd88137dd7ceec98b4bfd8640e5ec\";s:3:\"css\";s:6:\"params\";s:4:\"code\";i:60549;s:3:\"src\";s:8:\"linecons\";}i:23;a:4:{s:3:\"uid\";s:32:\"43e4647c57186b5e06874621b5e665be\";s:3:\"css\";s:10:\"calendar-8\";s:4:\"code\";i:60550;s:3:\"src\";s:8:\"linecons\";}i:24;a:4:{s:3:\"uid\";s:32:\"143d93c9abdee0f4a7a2a810acc62b91\";s:3:\"css\";s:7:\"sound-1\";s:4:\"code\";i:60551;s:3:\"src\";s:8:\"linecons\";}i:25;a:4:{s:3:\"uid\";s:32:\"ee22dc89481ea63f27654f59dcace804\";s:3:\"css\";s:7:\"clock-7\";s:4:\"code\";i:60552;s:3:\"src\";s:8:\"linecons\";}i:26;a:4:{s:3:\"uid\";s:32:\"fb3ee9c192c946342e0cdd12f06d7774\";s:3:\"css\";s:11:\"lightbulb-3\";s:4:\"code\";i:60553;s:3:\"src\";s:8:\"linecons\";}i:27;a:4:{s:3:\"uid\";s:32:\"cc5e3696cf6c3ad8c32daaea05355a99\";s:3:\"css\";s:2:\"tv\";s:4:\"code\";i:60554;s:3:\"src\";s:8:\"linecons\";}i:28;a:4:{s:3:\"uid\";s:32:\"7697f1734d53461137f05faab3f79cf0\";s:3:\"css\";s:9:\"desktop-3\";s:4:\"code\";i:60555;s:3:\"src\";s:8:\"linecons\";}i:29;a:4:{s:3:\"uid\";s:32:\"6a9f3405aba67bcaee81e7ea38946b27\";s:3:\"css\";s:8:\"mobile-6\";s:4:\"code\";i:60556;s:3:\"src\";s:8:\"linecons\";}i:30;a:4:{s:3:\"uid\";s:32:\"52cde78d270e411ccf22c9ec02910d69\";s:3:\"css\";s:4:\"cd-3\";s:4:\"code\";i:60557;s:3:\"src\";s:8:\"linecons\";}i:31;a:4:{s:3:\"uid\";s:32:\"efaf7e97e8b1aa7c2b52cc29432c96ca\";s:3:\"css\";s:7:\"inbox-4\";s:4:\"code\";i:60558;s:3:\"src\";s:8:\"linecons\";}i:32;a:4:{s:3:\"uid\";s:32:\"1e89103762be72b0720eda0468e62b90\";s:3:\"css\";s:7:\"globe-6\";s:4:\"code\";i:60559;s:3:\"src\";s:8:\"linecons\";}i:33;a:4:{s:3:\"uid\";s:32:\"f6eb7f8aed5dc03a323d5ef2895ae50b\";s:3:\"css\";s:7:\"cloud-7\";s:4:\"code\";i:60560;s:3:\"src\";s:8:\"linecons\";}i:34;a:4:{s:3:\"uid\";s:32:\"6fbd93c0d220507921015a15575009e5\";s:3:\"css\";s:13:\"paper-plane-2\";s:4:\"code\";i:60561;s:3:\"src\";s:8:\"linecons\";}i:35;a:4:{s:3:\"uid\";s:32:\"04309fefab5210bf502d278d65d134cf\";s:3:\"css\";s:6:\"fire-3\";s:4:\"code\";i:60562;s:3:\"src\";s:8:\"linecons\";}i:36;a:4:{s:3:\"uid\";s:32:\"4b7f817f780705a5d267ad59e855da91\";s:3:\"css\";s:16:\"graduation-cap-1\";s:4:\"code\";i:60563;s:3:\"src\";s:8:\"linecons\";}i:37;a:4:{s:3:\"uid\";s:32:\"cdcc1a6693235d1205370c1f47d5e7ad\";s:3:\"css\";s:11:\"megaphone-3\";s:4:\"code\";i:60564;s:3:\"src\";s:8:\"linecons\";}i:38;a:4:{s:3:\"uid\";s:32:\"02ad0683eaa9826f396fa7ccf1f1fb25\";s:3:\"css\";s:10:\"database-2\";s:4:\"code\";i:60565;s:3:\"src\";s:8:\"linecons\";}i:39;a:4:{s:3:\"uid\";s:32:\"75347b319511175da51af3955919dbac\";s:3:\"css\";s:5:\"key-5\";s:4:\"code\";i:60566;s:3:\"src\";s:8:\"linecons\";}i:40;a:4:{s:3:\"uid\";s:32:\"6cc796276697d8a75ae21bb2df4badc9\";s:3:\"css\";s:8:\"beaker-1\";s:4:\"code\";i:60567;s:3:\"src\";s:8:\"linecons\";}i:41;a:4:{s:3:\"uid\";s:32:\"f5053e43ef8be31afb905801449ae26d\";s:3:\"css\";s:7:\"truck-1\";s:4:\"code\";i:60568;s:3:\"src\";s:8:\"linecons\";}i:42;a:4:{s:3:\"uid\";s:32:\"b8e88705f42bd79580be828233c65da0\";s:3:\"css\";s:7:\"money-2\";s:4:\"code\";i:60569;s:3:\"src\";s:8:\"linecons\";}i:43;a:4:{s:3:\"uid\";s:32:\"b08f8c33777cd6b512d9576fc6e7f405\";s:3:\"css\";s:6:\"food-1\";s:4:\"code\";i:60570;s:3:\"src\";s:8:\"linecons\";}i:44;a:4:{s:3:\"uid\";s:32:\"5d27926667773d186de09fda4312af27\";s:3:\"css\";s:6:\"shop-1\";s:4:\"code\";i:60571;s:3:\"src\";s:8:\"linecons\";}i:45;a:4:{s:3:\"uid\";s:32:\"f8e8b267a9b949804f0c9dd7fed8e477\";s:3:\"css\";s:7:\"diamond\";s:4:\"code\";i:60572;s:3:\"src\";s:8:\"linecons\";}i:46;a:4:{s:3:\"uid\";s:32:\"862d4faacb164c0412cb3249d43d5d39\";s:3:\"css\";s:7:\"t-shirt\";s:4:\"code\";i:60573;s:3:\"src\";s:8:\"linecons\";}i:47;a:4:{s:3:\"uid\";s:32:\"d58dc0a0927a7dea2992f615f2fbf400\";s:3:\"css\";s:6:\"wallet\";s:4:\"code\";i:60574;s:3:\"src\";s:8:\"linecons\";}i:48;a:4:{s:3:\"uid\";s:32:\"cfaa8fbbdcc7bb8d636cb974aad1f9b9\";s:3:\"css\";s:5:\"glass\";s:4:\"code\";i:59426;s:3:\"src\";s:11:\"fontawesome\";}i:49;a:4:{s:3:\"uid\";s:32:\"9ea0a737ccc45d6c510dcbae56058849\";s:3:\"css\";s:5:\"music\";s:4:\"code\";i:59427;s:3:\"src\";s:11:\"fontawesome\";}i:50;a:4:{s:3:\"uid\";s:32:\"9dd9e835aebe1060ba7190ad2b2ed951\";s:3:\"css\";s:8:\"search-1\";s:4:\"code\";i:59428;s:3:\"src\";s:11:\"fontawesome\";}i:51;a:4:{s:3:\"uid\";s:32:\"bf882b30900da12fca090d9796bc3030\";s:3:\"css\";s:6:\"mail-1\";s:4:\"code\";i:59429;s:3:\"src\";s:11:\"fontawesome\";}i:52;a:4:{s:3:\"uid\";s:32:\"ccc2329632396dc096bb638d4b46fb98\";s:3:\"css\";s:8:\"mail-alt\";s:4:\"code\";i:59430;s:3:\"src\";s:11:\"fontawesome\";}i:53;a:4:{s:3:\"uid\";s:32:\"d73eceadda1f594cec0536087539afbf\";s:3:\"css\";s:7:\"heart-1\";s:4:\"code\";i:59431;s:3:\"src\";s:11:\"fontawesome\";}i:54;a:4:{s:3:\"uid\";s:32:\"f3dc2d6d8fe9cf9ebff84dc260888cdf\";s:3:\"css\";s:11:\"heart-empty\";s:4:\"code\";i:59432;s:3:\"src\";s:11:\"fontawesome\";}i:55;a:4:{s:3:\"uid\";s:32:\"474656633f79ea2f1dad59ff63f6bf07\";s:3:\"css\";s:6:\"star-1\";s:4:\"code\";i:59433;s:3:\"src\";s:11:\"fontawesome\";}i:56;a:4:{s:3:\"uid\";s:32:\"d17030afaecc1e1c22349b99f3c4992a\";s:3:\"css\";s:10:\"star-empty\";s:4:\"code\";i:59434;s:3:\"src\";s:11:\"fontawesome\";}i:57;a:4:{s:3:\"uid\";s:32:\"8f8278fbe5a2a0ea836be3c408b005d2\";s:3:\"css\";s:9:\"star-half\";s:4:\"code\";i:59435;s:3:\"src\";s:11:\"fontawesome\";}i:58;a:4:{s:3:\"uid\";s:32:\"84cf1fcc3fec556e7eaeb19679ca2dc9\";s:3:\"css\";s:13:\"star-half-alt\";s:4:\"code\";i:59436;s:3:\"src\";s:11:\"fontawesome\";}i:59;a:4:{s:3:\"uid\";s:32:\"8b80d36d4ef43889db10bc1f0dc9a862\";s:3:\"css\";s:6:\"user-1\";s:4:\"code\";i:59437;s:3:\"src\";s:11:\"fontawesome\";}i:60;a:4:{s:3:\"uid\";s:32:\"31972e4e9d080eaa796290349ae6c1fd\";s:3:\"css\";s:5:\"users\";s:4:\"code\";i:59438;s:3:\"src\";s:11:\"fontawesome\";}i:61;a:4:{s:3:\"uid\";s:32:\"ca2d64f8a3ea7cbf6af45898b2dcf35e\";s:3:\"css\";s:4:\"male\";s:4:\"code\";i:59439;s:3:\"src\";s:11:\"fontawesome\";}i:62;a:4:{s:3:\"uid\";s:32:\"9bf7e14698cccdca37a6f1a02cf7d79e\";s:3:\"css\";s:6:\"female\";s:4:\"code\";i:59440;s:3:\"src\";s:11:\"fontawesome\";}i:63;a:4:{s:3:\"uid\";s:32:\"872d9516df93eb6b776cc4d94bd97dac\";s:3:\"css\";s:7:\"video-1\";s:4:\"code\";i:59441;s:3:\"src\";s:11:\"fontawesome\";}i:64;a:4:{s:3:\"uid\";s:32:\"0f99ab40ab0b4d64a74f2d0deeb03e42\";s:3:\"css\";s:10:\"videocam-1\";s:4:\"code\";i:59442;s:3:\"src\";s:11:\"fontawesome\";}i:65;a:4:{s:3:\"uid\";s:32:\"381da2c2f7fd51f8de877c044d7f439d\";s:3:\"css\";s:7:\"picture\";s:4:\"code\";i:59443;s:3:\"src\";s:11:\"fontawesome\";}i:66;a:4:{s:3:\"uid\";s:32:\"dc3f1d5b1d006f7f7b3b6295eccab9da\";s:3:\"css\";s:6:\"camera\";s:4:\"code\";i:59444;s:3:\"src\";s:11:\"fontawesome\";}i:67;a:4:{s:3:\"uid\";s:32:\"9d3d9d6ce1ec63eaa26281e6162853c9\";s:3:\"css\";s:10:\"camera-alt\";s:4:\"code\";i:59445;s:3:\"src\";s:11:\"fontawesome\";}i:68;a:4:{s:3:\"uid\";s:32:\"dd492243d64e21dfe16a92452f7861cb\";s:3:\"css\";s:8:\"th-large\";s:4:\"code\";i:59446;s:3:\"src\";s:11:\"fontawesome\";}i:69;a:4:{s:3:\"uid\";s:32:\"b1887b423d2fd15c345e090320c91ca0\";s:3:\"css\";s:2:\"th\";s:4:\"code\";i:59447;s:3:\"src\";s:11:\"fontawesome\";}i:70;a:4:{s:3:\"uid\";s:32:\"f805bb95d40c7ef2bc51b3d50d4f2e5c\";s:3:\"css\";s:7:\"th-list\";s:4:\"code\";i:59448;s:3:\"src\";s:11:\"fontawesome\";}i:71;a:4:{s:3:\"uid\";s:32:\"12f4ece88e46abd864e40b35e05b11cd\";s:3:\"css\";s:4:\"ok-2\";s:4:\"code\";i:59449;s:3:\"src\";s:11:\"fontawesome\";}i:72;a:4:{s:3:\"uid\";s:32:\"43ab845088317bd348dee1d975700c48\";s:3:\"css\";s:10:\"ok-circled\";s:4:\"code\";i:59450;s:3:\"src\";s:11:\"fontawesome\";}i:73;a:4:{s:3:\"uid\";s:32:\"ad33e708f4d2e25c5056c931da1528d6\";s:3:\"css\";s:11:\"ok-circled2\";s:4:\"code\";i:59451;s:3:\"src\";s:11:\"fontawesome\";}i:74;a:4:{s:3:\"uid\";s:32:\"1400d5103edd2fa6d2d61688fee79a5a\";s:3:\"css\";s:10:\"ok-squared\";s:4:\"code\";i:59452;s:3:\"src\";s:11:\"fontawesome\";}i:75;a:4:{s:3:\"uid\";s:32:\"5211af474d3a9848f67f945e2ccaf143\";s:3:\"css\";s:8:\"cancel-3\";s:4:\"code\";i:59453;s:3:\"src\";s:11:\"fontawesome\";}i:76;a:4:{s:3:\"uid\";s:32:\"0f4cae16f34ae243a6144c18a003f2d8\";s:3:\"css\";s:14:\"cancel-circled\";s:4:\"code\";i:59454;s:3:\"src\";s:11:\"fontawesome\";}i:77;a:4:{s:3:\"uid\";s:32:\"2e2dba0307a502a8507c1729084c7ab5\";s:3:\"css\";s:15:\"cancel-circled2\";s:4:\"code\";i:59455;s:3:\"src\";s:11:\"fontawesome\";}i:78;a:4:{s:3:\"uid\";s:32:\"44e04715aecbca7f266a17d5a7863c68\";s:3:\"css\";s:6:\"plus-1\";s:4:\"code\";i:59456;s:3:\"src\";s:11:\"fontawesome\";}i:79;a:4:{s:3:\"uid\";s:32:\"4ba33d2607902cf690dd45df09774cb0\";s:3:\"css\";s:12:\"plus-circled\";s:4:\"code\";i:59457;s:3:\"src\";s:11:\"fontawesome\";}i:80;a:4:{s:3:\"uid\";s:32:\"1a5cfa186647e8c929c2b17b9fc4dac1\";s:3:\"css\";s:12:\"plus-squared\";s:4:\"code\";i:59458;s:3:\"src\";s:11:\"fontawesome\";}i:81;a:4:{s:3:\"uid\";s:32:\"bec22f5ef2f066ae057a0246fc6a36dd\";s:3:\"css\";s:18:\"plus-squared-small\";s:4:\"code\";i:59459;s:3:\"src\";s:11:\"fontawesome\";}i:82;a:4:{s:3:\"uid\";s:32:\"861ab06e455e2de3232ebef67d60d708\";s:3:\"css\";s:5:\"minus\";s:4:\"code\";i:59460;s:3:\"src\";s:11:\"fontawesome\";}i:83;a:4:{s:3:\"uid\";s:32:\"eeadb020bb75d089b25d8424aabe19e0\";s:3:\"css\";s:13:\"minus-circled\";s:4:\"code\";i:59461;s:3:\"src\";s:11:\"fontawesome\";}i:84;a:4:{s:3:\"uid\";s:32:\"f755a58fb985eeb70bd47d9b31892a34\";s:3:\"css\";s:13:\"minus-squared\";s:4:\"code\";i:59462;s:3:\"src\";s:11:\"fontawesome\";}i:85;a:4:{s:3:\"uid\";s:32:\"18ef25350258541e8e54148ed79845c0\";s:3:\"css\";s:17:\"minus-squared-alt\";s:4:\"code\";i:59463;s:3:\"src\";s:11:\"fontawesome\";}i:86;a:4:{s:3:\"uid\";s:32:\"21e8b8217ed9d1a164fd02eff39c5388\";s:3:\"css\";s:19:\"minus-squared-small\";s:4:\"code\";i:59464;s:3:\"src\";s:11:\"fontawesome\";}i:87;a:4:{s:3:\"uid\";s:32:\"ce3cf091d6ebd004dd0b52d24074e6e3\";s:3:\"css\";s:4:\"help\";s:4:\"code\";i:59465;s:3:\"src\";s:11:\"fontawesome\";}i:88;a:4:{s:3:\"uid\";s:32:\"17ebadd1e3f274ff0205601eef7b9cc4\";s:3:\"css\";s:12:\"help-circled\";s:4:\"code\";i:59466;s:3:\"src\";s:11:\"fontawesome\";}i:89;a:4:{s:3:\"uid\";s:32:\"e82cedfa1d5f15b00c5a81c9bd731ea2\";s:3:\"css\";s:12:\"info-circled\";s:4:\"code\";i:59467;s:3:\"src\";s:11:\"fontawesome\";}i:90;a:4:{s:3:\"uid\";s:32:\"3d4ea8a78dc34efe891f3a0f3d961274\";s:3:\"css\";s:4:\"info\";s:4:\"code\";i:59468;s:3:\"src\";s:11:\"fontawesome\";}i:91;a:4:{s:3:\"uid\";s:32:\"d7271d490b71df4311e32cdacae8b331\";s:3:\"css\";s:4:\"home\";s:4:\"code\";i:59469;s:3:\"src\";s:11:\"fontawesome\";}i:92;a:4:{s:3:\"uid\";s:32:\"0ddd3e8201ccc7d41f7b7c9d27eca6c1\";s:3:\"css\";s:4:\"link\";s:4:\"code\";i:59470;s:3:\"src\";s:11:\"fontawesome\";}i:93;a:4:{s:3:\"uid\";s:32:\"1dcd2b2148b7f086a4eb47f6a746bdee\";s:3:\"css\";s:6:\"unlink\";s:4:\"code\";i:59471;s:3:\"src\";s:11:\"fontawesome\";}i:94;a:4:{s:3:\"uid\";s:32:\"e15f0d620a7897e2035c18c80142f6d9\";s:3:\"css\";s:8:\"link-ext\";s:4:\"code\";i:59472;s:3:\"src\";s:11:\"fontawesome\";}i:95;a:4:{s:3:\"uid\";s:32:\"e35de5ea31cd56970498e33efbcb8e36\";s:3:\"css\";s:12:\"link-ext-alt\";s:4:\"code\";i:59473;s:3:\"src\";s:11:\"fontawesome\";}i:96;a:4:{s:3:\"uid\";s:32:\"0d6ab6194c0eddda2b8c9cedf2ab248e\";s:3:\"css\";s:6:\"attach\";s:4:\"code\";i:59474;s:3:\"src\";s:11:\"fontawesome\";}i:97;a:4:{s:3:\"uid\";s:32:\"c1f1975c885aa9f3dad7810c53b82074\";s:3:\"css\";s:4:\"lock\";s:4:\"code\";i:59475;s:3:\"src\";s:11:\"fontawesome\";}i:98;a:4:{s:3:\"uid\";s:32:\"657ab647f6248a6b57a5b893beaf35a9\";s:3:\"css\";s:9:\"lock-open\";s:4:\"code\";i:59476;s:3:\"src\";s:11:\"fontawesome\";}i:99;a:4:{s:3:\"uid\";s:32:\"05376be04a27d5a46e855a233d6e8508\";s:3:\"css\";s:13:\"lock-open-alt\";s:4:\"code\";i:59477;s:3:\"src\";s:11:\"fontawesome\";}i:100;a:4:{s:3:\"uid\";s:32:\"5b0772e9484a1a11646793a82edd622a\";s:3:\"css\";s:3:\"pin\";s:4:\"code\";i:59478;s:3:\"src\";s:11:\"fontawesome\";}i:101;a:4:{s:3:\"uid\";s:32:\"c5fd349cbd3d23e4ade333789c29c729\";s:3:\"css\";s:3:\"eye\";s:4:\"code\";i:59479;s:3:\"src\";s:11:\"fontawesome\";}i:102;a:4:{s:3:\"uid\";s:32:\"7fd683b2c518ceb9e5fa6757f2276faa\";s:3:\"css\";s:7:\"eye-off\";s:4:\"code\";i:59480;s:3:\"src\";s:11:\"fontawesome\";}i:103;a:4:{s:3:\"uid\";s:32:\"3db5347bd219f3bce6025780f5d9ef45\";s:3:\"css\";s:3:\"tag\";s:4:\"code\";i:59481;s:3:\"src\";s:11:\"fontawesome\";}i:104;a:4:{s:3:\"uid\";s:32:\"a3f89e106175a5c5c4e9738870b12e55\";s:3:\"css\";s:4:\"tags\";s:4:\"code\";i:59482;s:3:\"src\";s:11:\"fontawesome\";}i:105;a:4:{s:3:\"uid\";s:32:\"f04a5d24e9e659145b966739c4fde82a\";s:3:\"css\";s:8:\"bookmark\";s:4:\"code\";i:59483;s:3:\"src\";s:11:\"fontawesome\";}i:106;a:4:{s:3:\"uid\";s:32:\"2f5ef6f6b7aaebc56458ab4e865beff5\";s:3:\"css\";s:14:\"bookmark-empty\";s:4:\"code\";i:59484;s:3:\"src\";s:11:\"fontawesome\";}i:107;a:4:{s:3:\"uid\";s:32:\"57a0ac800df728aad61a7cf9e12f5fef\";s:3:\"css\";s:4:\"flag\";s:4:\"code\";i:59485;s:3:\"src\";s:11:\"fontawesome\";}i:108;a:4:{s:3:\"uid\";s:32:\"6c83092421441296f5c4e8074b0cf32c\";s:3:\"css\";s:10:\"flag-empty\";s:4:\"code\";i:59486;s:3:\"src\";s:11:\"fontawesome\";}i:109;a:4:{s:3:\"uid\";s:32:\"d7a614bd701f6712e8e3b2be124899e1\";s:3:\"css\";s:14:\"flag-checkered\";s:4:\"code\";i:59487;s:3:\"src\";s:11:\"fontawesome\";}i:110;a:4:{s:3:\"uid\";s:32:\"acf41aa4018e58d49525665469e35665\";s:3:\"css\";s:9:\"thumbs-up\";s:4:\"code\";i:59488;s:3:\"src\";s:11:\"fontawesome\";}i:111;a:4:{s:3:\"uid\";s:32:\"7533e68038fc6d520ede7a7ffa0a2f64\";s:3:\"css\";s:11:\"thumbs-down\";s:4:\"code\";i:59489;s:3:\"src\";s:11:\"fontawesome\";}i:112;a:4:{s:3:\"uid\";s:32:\"5e2ab018e3044337bcef5f7e94098ea1\";s:3:\"css\";s:13:\"thumbs-up-alt\";s:4:\"code\";i:59490;s:3:\"src\";s:11:\"fontawesome\";}i:113;a:4:{s:3:\"uid\";s:32:\"ddcd918b502642705838815d40aea9e3\";s:3:\"css\";s:15:\"thumbs-down-alt\";s:4:\"code\";i:59491;s:3:\"src\";s:11:\"fontawesome\";}i:114;a:4:{s:3:\"uid\";s:32:\"9a76bc135eac17d2c8b8ad4a5774fc87\";s:3:\"css\";s:8:\"download\";s:4:\"code\";i:59492;s:3:\"src\";s:11:\"fontawesome\";}i:115;a:4:{s:3:\"uid\";s:32:\"eeec3208c90b7b48e804919d0d2d4a41\";s:3:\"css\";s:6:\"upload\";s:4:\"code\";i:59493;s:3:\"src\";s:11:\"fontawesome\";}i:116;a:4:{s:3:\"uid\";s:32:\"f5999a012fc3752386635ec02a858447\";s:3:\"css\";s:14:\"download-cloud\";s:4:\"code\";i:59494;s:3:\"src\";s:11:\"fontawesome\";}i:117;a:4:{s:3:\"uid\";s:32:\"de2fc7a5c986ab8c622f63455d7cf814\";s:3:\"css\";s:12:\"upload-cloud\";s:4:\"code\";i:59495;s:3:\"src\";s:11:\"fontawesome\";}i:118;a:4:{s:3:\"uid\";s:32:\"c6be5a58ee4e63a5ec399c2b0d15cf2c\";s:3:\"css\";s:5:\"reply\";s:4:\"code\";i:59496;s:3:\"src\";s:11:\"fontawesome\";}i:119;a:4:{s:3:\"uid\";s:32:\"1b5597a3bacaeca6600e88ae36d02e0a\";s:3:\"css\";s:9:\"reply-all\";s:4:\"code\";i:59497;s:3:\"src\";s:11:\"fontawesome\";}i:120;a:4:{s:3:\"uid\";s:32:\"3d39c828009c04ddb6764c0b04cd2439\";s:3:\"css\";s:7:\"forward\";s:4:\"code\";i:59498;s:3:\"src\";s:11:\"fontawesome\";}i:121;a:4:{s:3:\"uid\";s:32:\"ab95e1351ebaec5850101097cbf7097f\";s:3:\"css\";s:10:\"quote-left\";s:4:\"code\";i:59499;s:3:\"src\";s:11:\"fontawesome\";}i:122;a:4:{s:3:\"uid\";s:32:\"d745d7c05b94e609decabade2cae12cb\";s:3:\"css\";s:11:\"quote-right\";s:4:\"code\";i:59500;s:3:\"src\";s:11:\"fontawesome\";}i:123;a:4:{s:3:\"uid\";s:32:\"7034e4d22866af82bef811f52fb1ba46\";s:3:\"css\";s:4:\"code\";s:4:\"code\";i:59501;s:3:\"src\";s:11:\"fontawesome\";}i:124;a:4:{s:3:\"uid\";s:32:\"895405dfac8a3b7b2f23b183c6608ee6\";s:3:\"css\";s:6:\"export\";s:4:\"code\";i:59502;s:3:\"src\";s:11:\"fontawesome\";}i:125;a:4:{s:3:\"uid\";s:32:\"13b9eebfea581ad8e756ee7a18a7cba8\";s:3:\"css\";s:10:\"export-alt\";s:4:\"code\";i:59503;s:3:\"src\";s:11:\"fontawesome\";}i:126;a:4:{s:3:\"uid\";s:32:\"d35a1d35efeb784d1dc9ac18b9b6c2b6\";s:3:\"css\";s:6:\"pencil\";s:4:\"code\";i:59504;s:3:\"src\";s:11:\"fontawesome\";}i:127;a:4:{s:3:\"uid\";s:32:\"44fae3bfdd54754dc68ec50d37efea37\";s:3:\"css\";s:14:\"pencil-squared\";s:4:\"code\";i:59505;s:3:\"src\";s:11:\"fontawesome\";}i:128;a:4:{s:3:\"uid\";s:32:\"41087bc74d4b20b55059c60a33bf4008\";s:3:\"css\";s:4:\"edit\";s:4:\"code\";i:59506;s:3:\"src\";s:11:\"fontawesome\";}i:129;a:4:{s:3:\"uid\";s:32:\"7277ded7695b2a307a5f9d50097bb64c\";s:3:\"css\";s:5:\"print\";s:4:\"code\";i:59507;s:3:\"src\";s:11:\"fontawesome\";}i:130;a:4:{s:3:\"uid\";s:32:\"09feb4465d9bd1364f4e301c9ddbaa92\";s:3:\"css\";s:7:\"retweet\";s:4:\"code\";i:59508;s:3:\"src\";s:11:\"fontawesome\";}i:131;a:4:{s:3:\"uid\";s:32:\"ecb97add13804c190456025e43ec003b\";s:3:\"css\";s:8:\"keyboard\";s:4:\"code\";i:59509;s:3:\"src\";s:11:\"fontawesome\";}i:132;a:4:{s:3:\"uid\";s:32:\"0133387f2069a1b3168942b84d81dd3a\";s:3:\"css\";s:7:\"gamepad\";s:4:\"code\";i:59510;s:3:\"src\";s:11:\"fontawesome\";}i:133;a:4:{s:3:\"uid\";s:32:\"85528017f1e6053b2253785c31047f44\";s:3:\"css\";s:7:\"comment\";s:4:\"code\";i:59511;s:3:\"src\";s:11:\"fontawesome\";}i:134;a:4:{s:3:\"uid\";s:32:\"dcedf50ab1ede3283d7a6c70e2fe32f3\";s:3:\"css\";s:4:\"chat\";s:4:\"code\";i:59512;s:3:\"src\";s:11:\"fontawesome\";}i:135;a:4:{s:3:\"uid\";s:32:\"9c1376672bb4f1ed616fdd78a23667e9\";s:3:\"css\";s:13:\"comment-empty\";s:4:\"code\";i:59513;s:3:\"src\";s:11:\"fontawesome\";}i:136;a:4:{s:3:\"uid\";s:32:\"31951fbb9820ed0690f675b3d495c8da\";s:3:\"css\";s:10:\"chat-empty\";s:4:\"code\";i:59514;s:3:\"src\";s:11:\"fontawesome\";}i:137;a:4:{s:3:\"uid\";s:32:\"cd21cbfb28ad4d903cede582157f65dc\";s:3:\"css\";s:4:\"bell\";s:4:\"code\";i:59515;s:3:\"src\";s:11:\"fontawesome\";}i:138;a:4:{s:3:\"uid\";s:32:\"671f29fa10dda08074a4c6a341bb4f39\";s:3:\"css\";s:8:\"bell-alt\";s:4:\"code\";i:59516;s:3:\"src\";s:11:\"fontawesome\";}i:139;a:4:{s:3:\"uid\";s:32:\"00391fac5d419345ffcccd95b6f76263\";s:3:\"css\";s:13:\"attention-alt\";s:4:\"code\";i:59517;s:3:\"src\";s:11:\"fontawesome\";}i:140;a:4:{s:3:\"uid\";s:32:\"c76b7947c957c9b78b11741173c8349b\";s:3:\"css\";s:9:\"attention\";s:4:\"code\";i:59518;s:3:\"src\";s:11:\"fontawesome\";}i:141;a:4:{s:3:\"uid\";s:32:\"b035c28eba2b35c6ffe92aee8b0df507\";s:3:\"css\";s:17:\"attention-circled\";s:4:\"code\";i:59519;s:3:\"src\";s:11:\"fontawesome\";}i:142;a:4:{s:3:\"uid\";s:32:\"0d08dbb1dd648a43bdea81b7e6c9e036\";s:3:\"css\";s:8:\"location\";s:4:\"code\";i:59520;s:3:\"src\";s:11:\"fontawesome\";}i:143;a:4:{s:3:\"uid\";s:32:\"921e3974e54ff9e8b7cd906a3dc74636\";s:3:\"css\";s:9:\"direction\";s:4:\"code\";i:59521;s:3:\"src\";s:11:\"fontawesome\";}i:144;a:4:{s:3:\"uid\";s:32:\"e5d624264734620fa9f98d59e6dc941f\";s:3:\"css\";s:7:\"compass\";s:4:\"code\";i:59522;s:3:\"src\";s:11:\"fontawesome\";}i:145;a:4:{s:3:\"uid\";s:32:\"f48ae54adfb27d8ada53d0fd9e34ee10\";s:3:\"css\";s:5:\"trash\";s:4:\"code\";i:59523;s:3:\"src\";s:11:\"fontawesome\";}i:146;a:4:{s:3:\"uid\";s:32:\"1b5a5d7b7e3c71437f5a26befdd045ed\";s:3:\"css\";s:3:\"doc\";s:4:\"code\";i:59524;s:3:\"src\";s:11:\"fontawesome\";}i:147;a:4:{s:3:\"uid\";s:32:\"c8585e1e5b0467f28b70bce765d5840c\";s:3:\"css\";s:4:\"docs\";s:4:\"code\";i:59525;s:3:\"src\";s:11:\"fontawesome\";}i:148;a:4:{s:3:\"uid\";s:32:\"5408be43f7c42bccee419c6be53fdef5\";s:3:\"css\";s:8:\"doc-text\";s:4:\"code\";i:59526;s:3:\"src\";s:11:\"fontawesome\";}i:149;a:4:{s:3:\"uid\";s:32:\"178053298e3e5b03551d754d4b9acd8b\";s:3:\"css\";s:7:\"doc-inv\";s:4:\"code\";i:59527;s:3:\"src\";s:11:\"fontawesome\";}i:150;a:4:{s:3:\"uid\";s:32:\"c08a1cde48d96cba21d8c05fa7d7feb1\";s:3:\"css\";s:12:\"doc-text-inv\";s:4:\"code\";i:59528;s:3:\"src\";s:11:\"fontawesome\";}i:151;a:4:{s:3:\"uid\";s:32:\"f8aa663c489bcbd6e68ec8147dca841e\";s:3:\"css\";s:6:\"folder\";s:4:\"code\";i:59529;s:3:\"src\";s:11:\"fontawesome\";}i:152;a:4:{s:3:\"uid\";s:32:\"c95735c17a10af81448c7fed98a04546\";s:3:\"css\";s:11:\"folder-open\";s:4:\"code\";i:59530;s:3:\"src\";s:11:\"fontawesome\";}i:153;a:4:{s:3:\"uid\";s:32:\"b091a8bd0fdade174951f17d936f51e4\";s:3:\"css\";s:12:\"folder-empty\";s:4:\"code\";i:59531;s:3:\"src\";s:11:\"fontawesome\";}i:154;a:4:{s:3:\"uid\";s:32:\"6533bdc16ab201eb3f3b27ce989cab33\";s:3:\"css\";s:17:\"folder-open-empty\";s:4:\"code\";i:59532;s:3:\"src\";s:11:\"fontawesome\";}i:155;a:4:{s:3:\"uid\";s:32:\"04ff8d6592fe548b332b27ed87ce397a\";s:3:\"css\";s:3:\"box\";s:4:\"code\";i:59533;s:3:\"src\";s:11:\"fontawesome\";}i:156;a:4:{s:3:\"uid\";s:32:\"72b1277834cba5b7944b0a6cac7ddb0d\";s:3:\"css\";s:3:\"rss\";s:4:\"code\";i:59534;s:3:\"src\";s:11:\"fontawesome\";}i:157;a:4:{s:3:\"uid\";s:32:\"de5f0a564ccf8816325330e292e11533\";s:3:\"css\";s:11:\"rss-squared\";s:4:\"code\";i:59535;s:3:\"src\";s:11:\"fontawesome\";}i:158;a:4:{s:3:\"uid\";s:32:\"9f7e588c66cfd6891f6f507cf6f6596b\";s:3:\"css\";s:5:\"phone\";s:4:\"code\";i:59536;s:3:\"src\";s:11:\"fontawesome\";}i:159;a:4:{s:3:\"uid\";s:32:\"ec488dfd1f548948c09671ca5a60ec92\";s:3:\"css\";s:13:\"phone-squared\";s:4:\"code\";i:59537;s:3:\"src\";s:11:\"fontawesome\";}i:160;a:4:{s:3:\"uid\";s:32:\"559647a6f430b3aeadbecd67194451dd\";s:3:\"css\";s:4:\"menu\";s:4:\"code\";i:59538;s:3:\"src\";s:11:\"fontawesome\";}i:161;a:4:{s:3:\"uid\";s:32:\"e99461abfef3923546da8d745372c995\";s:3:\"css\";s:3:\"cog\";s:4:\"code\";i:59539;s:3:\"src\";s:11:\"fontawesome\";}i:162;a:4:{s:3:\"uid\";s:32:\"98687378abd1faf8f6af97c254eb6cd6\";s:3:\"css\";s:7:\"cog-alt\";s:4:\"code\";i:59540;s:3:\"src\";s:11:\"fontawesome\";}i:163;a:4:{s:3:\"uid\";s:32:\"5bb103cd29de77e0e06a52638527b575\";s:3:\"css\";s:6:\"wrench\";s:4:\"code\";i:59541;s:3:\"src\";s:11:\"fontawesome\";}i:164;a:4:{s:3:\"uid\";s:32:\"9affc98d652b86628d650ee58dbf0357\";s:3:\"css\";s:6:\"basket\";s:4:\"code\";i:59542;s:3:\"src\";s:11:\"fontawesome\";}i:165;a:4:{s:3:\"uid\";s:32:\"531bc468eecbb8867d822f1c11f1e039\";s:3:\"css\";s:8:\"calendar\";s:4:\"code\";i:59543;s:3:\"src\";s:11:\"fontawesome\";}i:166;a:4:{s:3:\"uid\";s:32:\"ead4c82d04d7758db0f076584893a8c1\";s:3:\"css\";s:14:\"calendar-empty\";s:4:\"code\";i:59544;s:3:\"src\";s:11:\"fontawesome\";}i:167;a:4:{s:3:\"uid\";s:32:\"3a00327e61b997b58518bd43ed83c3df\";s:3:\"css\";s:5:\"login\";s:4:\"code\";i:59545;s:3:\"src\";s:11:\"fontawesome\";}i:168;a:4:{s:3:\"uid\";s:32:\"0d20938846444af8deb1920dc85a29fb\";s:3:\"css\";s:6:\"logout\";s:4:\"code\";i:59546;s:3:\"src\";s:11:\"fontawesome\";}i:169;a:4:{s:3:\"uid\";s:32:\"19c50c52858a81de58f9db488aba77bc\";s:3:\"css\";s:3:\"mic\";s:4:\"code\";i:59547;s:3:\"src\";s:11:\"fontawesome\";}i:170;a:4:{s:3:\"uid\";s:32:\"43c629249e2cca7e73cd4ef410c9551f\";s:3:\"css\";s:4:\"mute\";s:4:\"code\";i:59548;s:3:\"src\";s:11:\"fontawesome\";}i:171;a:4:{s:3:\"uid\";s:32:\"e44601720c64e6bb6a2d5cba6b0c588c\";s:3:\"css\";s:10:\"volume-off\";s:4:\"code\";i:59549;s:3:\"src\";s:11:\"fontawesome\";}i:172;a:4:{s:3:\"uid\";s:32:\"fee6e00f36e8ca8ef3e4a62caa213bf6\";s:3:\"css\";s:11:\"volume-down\";s:4:\"code\";i:59550;s:3:\"src\";s:11:\"fontawesome\";}i:173;a:4:{s:3:\"uid\";s:32:\"76857a03fbaa6857fe063b6c25aa98ed\";s:3:\"css\";s:9:\"volume-up\";s:4:\"code\";i:59551;s:3:\"src\";s:11:\"fontawesome\";}i:174;a:4:{s:3:\"uid\";s:32:\"f27bba41a700af51a4dd23cf4edea61d\";s:3:\"css\";s:10:\"headphones\";s:4:\"code\";i:59552;s:3:\"src\";s:11:\"fontawesome\";}i:175;a:4:{s:3:\"uid\";s:32:\"598a5f2bcf3521d1615de8e1881ccd17\";s:3:\"css\";s:5:\"clock\";s:4:\"code\";i:59553;s:3:\"src\";s:11:\"fontawesome\";}i:176;a:4:{s:3:\"uid\";s:32:\"5278ef7773e948d56c4d442c8c8c98cf\";s:3:\"css\";s:9:\"lightbulb\";s:4:\"code\";i:59554;s:3:\"src\";s:11:\"fontawesome\";}i:177;a:4:{s:3:\"uid\";s:32:\"98d9c83c1ee7c2c25af784b518c522c5\";s:3:\"css\";s:5:\"block\";s:4:\"code\";i:59555;s:3:\"src\";s:11:\"fontawesome\";}i:178;a:4:{s:3:\"uid\";s:32:\"e594fc6e5870b4ab7e49f52571d52577\";s:3:\"css\";s:11:\"resize-full\";s:4:\"code\";i:59556;s:3:\"src\";s:11:\"fontawesome\";}i:179;a:4:{s:3:\"uid\";s:32:\"b013f6403e5ab0326614e68d1850fd6b\";s:3:\"css\";s:15:\"resize-full-alt\";s:4:\"code\";i:59557;s:3:\"src\";s:11:\"fontawesome\";}i:180;a:4:{s:3:\"uid\";s:32:\"3c24ee33c9487bbf18796ca6dffa1905\";s:3:\"css\";s:12:\"resize-small\";s:4:\"code\";i:59558;s:3:\"src\";s:11:\"fontawesome\";}i:181;a:4:{s:3:\"uid\";s:32:\"d3b3f17bc3eb7cd809a07bbd4d178bee\";s:3:\"css\";s:15:\"resize-vertical\";s:4:\"code\";i:59559;s:3:\"src\";s:11:\"fontawesome\";}i:182;a:4:{s:3:\"uid\";s:32:\"3c73d058e4589b65a8d959c0fc8f153d\";s:3:\"css\";s:17:\"resize-horizontal\";s:4:\"code\";i:59560;s:3:\"src\";s:11:\"fontawesome\";}i:183;a:4:{s:3:\"uid\";s:32:\"6605ee6441bf499ffa3c63d3c7409471\";s:3:\"css\";s:6:\"move-1\";s:4:\"code\";i:59561;s:3:\"src\";s:11:\"fontawesome\";}i:184;a:4:{s:3:\"uid\";s:32:\"0b2b66e526028a6972d51a6f10281b4b\";s:3:\"css\";s:7:\"zoom-in\";s:4:\"code\";i:59562;s:3:\"src\";s:11:\"fontawesome\";}i:185;a:4:{s:3:\"uid\";s:32:\"d25d10efa900f529ad1d275657cfd30e\";s:3:\"css\";s:8:\"zoom-out\";s:4:\"code\";i:59563;s:3:\"src\";s:11:\"fontawesome\";}i:186;a:4:{s:3:\"uid\";s:32:\"c53068fe21c8410b0a098b4c52c3d37e\";s:3:\"css\";s:13:\"down-circled2\";s:4:\"code\";i:59564;s:3:\"src\";s:11:\"fontawesome\";}i:187;a:4:{s:3:\"uid\";s:32:\"128d63150a41800e0beff55235269542\";s:3:\"css\";s:11:\"up-circled2\";s:4:\"code\";i:59565;s:3:\"src\";s:11:\"fontawesome\";}i:188;a:4:{s:3:\"uid\";s:32:\"a65ca48f3fe7d6e5c60edbd943f4fdb6\";s:3:\"css\";s:13:\"left-circled2\";s:4:\"code\";i:59566;s:3:\"src\";s:11:\"fontawesome\";}i:189;a:4:{s:3:\"uid\";s:32:\"d0673ef38e1c458a6de52aad2a2f800d\";s:3:\"css\";s:14:\"right-circled2\";s:4:\"code\";i:59567;s:3:\"src\";s:11:\"fontawesome\";}i:190;a:4:{s:3:\"uid\";s:32:\"2d6150442079cbda7df64522dc24f482\";s:3:\"css\";s:8:\"down-dir\";s:4:\"code\";i:59568;s:3:\"src\";s:11:\"fontawesome\";}i:191;a:4:{s:3:\"uid\";s:32:\"80cd1022bd9ea151d554bec1fa05f2de\";s:3:\"css\";s:6:\"up-dir\";s:4:\"code\";i:59569;s:3:\"src\";s:11:\"fontawesome\";}i:192;a:4:{s:3:\"uid\";s:32:\"9dc654095085167524602c9acc0c5570\";s:3:\"css\";s:8:\"left-dir\";s:4:\"code\";i:59570;s:3:\"src\";s:11:\"fontawesome\";}i:193;a:4:{s:3:\"uid\";s:32:\"fb1c799ffe5bf8fb7f8bcb647c8fe9e6\";s:3:\"css\";s:9:\"right-dir\";s:4:\"code\";i:59571;s:3:\"src\";s:11:\"fontawesome\";}i:194;a:4:{s:3:\"uid\";s:32:\"ccddff8e8670dcd130e3cb55fdfc2fd0\";s:3:\"css\";s:9:\"down-open\";s:4:\"code\";i:59572;s:3:\"src\";s:11:\"fontawesome\";}i:195;a:4:{s:3:\"uid\";s:32:\"d870630ff8f81e6de3958ecaeac532f2\";s:3:\"css\";s:9:\"left-open\";s:4:\"code\";i:59573;s:3:\"src\";s:11:\"fontawesome\";}i:196;a:4:{s:3:\"uid\";s:32:\"399ef63b1e23ab1b761dfbb5591fa4da\";s:3:\"css\";s:10:\"right-open\";s:4:\"code\";i:59574;s:3:\"src\";s:11:\"fontawesome\";}i:197;a:4:{s:3:\"uid\";s:32:\"fe6697b391355dec12f3d86d6d490397\";s:3:\"css\";s:7:\"up-open\";s:4:\"code\";i:59575;s:3:\"src\";s:11:\"fontawesome\";}i:198;a:4:{s:3:\"uid\";s:32:\"f3f90c8c89795da30f7444634476ea4f\";s:3:\"css\";s:10:\"angle-left\";s:4:\"code\";i:59576;s:3:\"src\";s:11:\"fontawesome\";}i:199;a:4:{s:3:\"uid\";s:32:\"7bf14281af5633a597f85b061ef1cfb9\";s:3:\"css\";s:11:\"angle-right\";s:4:\"code\";i:59577;s:3:\"src\";s:11:\"fontawesome\";}i:200;a:4:{s:3:\"uid\";s:32:\"5de9370846a26947e03f63142a3f1c07\";s:3:\"css\";s:8:\"angle-up\";s:4:\"code\";i:59578;s:3:\"src\";s:11:\"fontawesome\";}i:201;a:4:{s:3:\"uid\";s:32:\"e4dde1992f787163e2e2b534b8c8067d\";s:3:\"css\";s:10:\"angle-down\";s:4:\"code\";i:59579;s:3:\"src\";s:11:\"fontawesome\";}i:202;a:4:{s:3:\"uid\";s:32:\"8933c2579166c2ee56ae40dc6a0b4dc6\";s:3:\"css\";s:18:\"angle-circled-left\";s:4:\"code\";i:59580;s:3:\"src\";s:11:\"fontawesome\";}i:203;a:4:{s:3:\"uid\";s:32:\"94089b37297572e936b0943bcfa041d3\";s:3:\"css\";s:19:\"angle-circled-right\";s:4:\"code\";i:59581;s:3:\"src\";s:11:\"fontawesome\";}i:204;a:4:{s:3:\"uid\";s:32:\"8cbd5bcfb00043b8094fd7ac21ae5e06\";s:3:\"css\";s:16:\"angle-circled-up\";s:4:\"code\";i:59582;s:3:\"src\";s:11:\"fontawesome\";}i:205;a:4:{s:3:\"uid\";s:32:\"c35e0796f6f806945a44b1655ce7bbe7\";s:3:\"css\";s:18:\"angle-circled-down\";s:4:\"code\";i:59583;s:3:\"src\";s:11:\"fontawesome\";}i:206;a:4:{s:3:\"uid\";s:32:\"745f12abe1472d14f8f658de7e5aba66\";s:3:\"css\";s:17:\"angle-double-left\";s:4:\"code\";i:59584;s:3:\"src\";s:11:\"fontawesome\";}i:207;a:4:{s:3:\"uid\";s:32:\"fdfbd1fcbd4cb229716a810801a5f207\";s:3:\"css\";s:18:\"angle-double-right\";s:4:\"code\";i:59585;s:3:\"src\";s:11:\"fontawesome\";}i:208;a:4:{s:3:\"uid\";s:32:\"63b3012c8cbe3654ba5bea598235aa3a\";s:3:\"css\";s:15:\"angle-double-up\";s:4:\"code\";i:59586;s:3:\"src\";s:11:\"fontawesome\";}i:209;a:4:{s:3:\"uid\";s:32:\"dfec4ffa849d8594c2e4b86f6320b8a6\";s:3:\"css\";s:17:\"angle-double-down\";s:4:\"code\";i:59587;s:3:\"src\";s:11:\"fontawesome\";}i:210;a:4:{s:3:\"uid\";s:32:\"f06941dfcb90dc24b987d810898c4310\";s:3:\"css\";s:4:\"down\";s:4:\"code\";i:59588;s:3:\"src\";s:11:\"fontawesome\";}i:211;a:4:{s:3:\"uid\";s:32:\"fb94e23ae1e7660aa63cc5f351ec7560\";s:3:\"css\";s:4:\"left\";s:4:\"code\";i:59589;s:3:\"src\";s:11:\"fontawesome\";}i:212;a:4:{s:3:\"uid\";s:32:\"f6d72aa5ef8e8f0e553012af9a29a87e\";s:3:\"css\";s:5:\"right\";s:4:\"code\";i:59590;s:3:\"src\";s:11:\"fontawesome\";}i:213;a:4:{s:3:\"uid\";s:32:\"720f98e7580b7987c8dc542513d1d440\";s:3:\"css\";s:2:\"up\";s:4:\"code\";i:59591;s:3:\"src\";s:11:\"fontawesome\";}i:214;a:4:{s:3:\"uid\";s:32:\"1c4068ed75209e21af36017df8871802\";s:3:\"css\";s:8:\"down-big\";s:4:\"code\";i:59592;s:3:\"src\";s:11:\"fontawesome\";}i:215;a:4:{s:3:\"uid\";s:32:\"555ef8c86832e686fef85f7af2eb7cde\";s:3:\"css\";s:8:\"left-big\";s:4:\"code\";i:59593;s:3:\"src\";s:11:\"fontawesome\";}i:216;a:4:{s:3:\"uid\";s:32:\"ad6b3fbb5324abe71a9c0b6609cbb9f1\";s:3:\"css\";s:9:\"right-big\";s:4:\"code\";i:59594;s:3:\"src\";s:11:\"fontawesome\";}i:217;a:4:{s:3:\"uid\";s:32:\"95376bf082bfec6ce06ea1cda7bd7ead\";s:3:\"css\";s:6:\"up-big\";s:4:\"code\";i:59595;s:3:\"src\";s:11:\"fontawesome\";}i:218;a:4:{s:3:\"uid\";s:32:\"aa0d9175a3919a260a4012d560e9f01e\";s:3:\"css\";s:10:\"right-hand\";s:4:\"code\";i:59596;s:3:\"src\";s:11:\"fontawesome\";}i:219;a:4:{s:3:\"uid\";s:32:\"3d99d345645f43e31e9e0fd48be37e9c\";s:3:\"css\";s:9:\"left-hand\";s:4:\"code\";i:59597;s:3:\"src\";s:11:\"fontawesome\";}i:220;a:4:{s:3:\"uid\";s:32:\"034e645aa3bad56ce68389a816547c87\";s:3:\"css\";s:7:\"up-hand\";s:4:\"code\";i:59598;s:3:\"src\";s:11:\"fontawesome\";}i:221;a:4:{s:3:\"uid\";s:32:\"beb43b8df442eac4b8d35f528d5ed5af\";s:3:\"css\";s:9:\"down-hand\";s:4:\"code\";i:59599;s:3:\"src\";s:11:\"fontawesome\";}i:222;a:4:{s:3:\"uid\";s:32:\"6855131631509e8795730ce062045ea1\";s:3:\"css\";s:12:\"left-circled\";s:4:\"code\";i:59600;s:3:\"src\";s:11:\"fontawesome\";}i:223;a:4:{s:3:\"uid\";s:32:\"19b04848ae7332d2c0ea2a9e19064037\";s:3:\"css\";s:13:\"right-circled\";s:4:\"code\";i:59601;s:3:\"src\";s:11:\"fontawesome\";}i:224;a:4:{s:3:\"uid\";s:32:\"2b8e9b027181aafd210bf29c5486d4a0\";s:3:\"css\";s:10:\"up-circled\";s:4:\"code\";i:59602;s:3:\"src\";s:11:\"fontawesome\";}i:225;a:4:{s:3:\"uid\";s:32:\"55ae6ea25cd707fe34af5b52b2001cdc\";s:3:\"css\";s:12:\"down-circled\";s:4:\"code\";i:59603;s:3:\"src\";s:11:\"fontawesome\";}i:226;a:4:{s:3:\"uid\";s:32:\"bc71f4c6e53394d5ba46b063040014f1\";s:3:\"css\";s:2:\"cw\";s:4:\"code\";i:59604;s:3:\"src\";s:11:\"fontawesome\";}i:227;a:4:{s:3:\"uid\";s:32:\"f9c3205df26e7778abac86183aefdc99\";s:3:\"css\";s:3:\"ccw\";s:4:\"code\";i:59605;s:3:\"src\";s:11:\"fontawesome\";}i:228;a:4:{s:3:\"uid\";s:32:\"a73c5deb486c8d66249811642e5d719a\";s:3:\"css\";s:9:\"arrows-cw\";s:4:\"code\";i:59606;s:3:\"src\";s:11:\"fontawesome\";}i:229;a:4:{s:3:\"uid\";s:32:\"dea706a9bd3144316ce37406ec10f469\";s:3:\"css\";s:8:\"level-up\";s:4:\"code\";i:59607;s:3:\"src\";s:11:\"fontawesome\";}i:230;a:4:{s:3:\"uid\";s:32:\"4684e690bad65fb618329dfe52017475\";s:3:\"css\";s:10:\"level-down\";s:4:\"code\";i:59608;s:3:\"src\";s:11:\"fontawesome\";}i:231;a:4:{s:3:\"uid\";s:32:\"37c5ab63f10d7ad0b84d0978dcd0c7a8\";s:3:\"css\";s:7:\"shuffle\";s:4:\"code\";i:59609;s:3:\"src\";s:11:\"fontawesome\";}i:232;a:4:{s:3:\"uid\";s:32:\"6020aff067fc3c119cdd75daa5249220\";s:3:\"css\";s:8:\"exchange\";s:4:\"code\";i:59610;s:3:\"src\";s:11:\"fontawesome\";}i:233;a:4:{s:3:\"uid\";s:32:\"84bb9695b8662fa4783242f84c9e4682\";s:3:\"css\";s:8:\"collapse\";s:4:\"code\";i:59611;s:3:\"src\";s:11:\"fontawesome\";}i:234;a:4:{s:3:\"uid\";s:32:\"7960517a504e42aea0641f15bc55fbed\";s:3:\"css\";s:12:\"collapse-top\";s:4:\"code\";i:59612;s:3:\"src\";s:11:\"fontawesome\";}i:235;a:4:{s:3:\"uid\";s:32:\"ed5a38704f0329e610ee1c92bec3ad3d\";s:3:\"css\";s:6:\"expand\";s:4:\"code\";i:59613;s:3:\"src\";s:11:\"fontawesome\";}i:236;a:4:{s:3:\"uid\";s:32:\"ea2ec99fbce03864e593bbf4f302a79d\";s:3:\"css\";s:13:\"collapse-left\";s:4:\"code\";i:59614;s:3:\"src\";s:11:\"fontawesome\";}i:237;a:4:{s:3:\"uid\";s:32:\"ce06b5805120d0c2f8d60cd3f1a4fdb5\";s:3:\"css\";s:4:\"play\";s:4:\"code\";i:59615;s:3:\"src\";s:11:\"fontawesome\";}i:238;a:4:{s:3:\"uid\";s:32:\"5717236f6134afe2d2a278a5c9b3927a\";s:3:\"css\";s:12:\"play-circled\";s:4:\"code\";i:59616;s:3:\"src\";s:11:\"fontawesome\";}i:239;a:4:{s:3:\"uid\";s:32:\"e835d9d0f2ee39ae01b01cc6a6fa24ab\";s:3:\"css\";s:13:\"play-circled2\";s:4:\"code\";i:59617;s:3:\"src\";s:11:\"fontawesome\";}i:240;a:4:{s:3:\"uid\";s:32:\"b624a1e512819d410ddbee84e6918b9d\";s:3:\"css\";s:4:\"stop\";s:4:\"code\";i:59618;s:3:\"src\";s:11:\"fontawesome\";}i:241;a:4:{s:3:\"uid\";s:32:\"0b28050bac9d3facf2f0226db643ece0\";s:3:\"css\";s:5:\"pause\";s:4:\"code\";i:59619;s:3:\"src\";s:11:\"fontawesome\";}i:242;a:4:{s:3:\"uid\";s:32:\"c47efa0e3e74f6ba4c2562c1258fff1f\";s:3:\"css\";s:6:\"to-end\";s:4:\"code\";i:59620;s:3:\"src\";s:11:\"fontawesome\";}i:243;a:4:{s:3:\"uid\";s:32:\"7ea35a8fc7e676c78e99cab2d4bc8653\";s:3:\"css\";s:10:\"to-end-alt\";s:4:\"code\";i:59621;s:3:\"src\";s:11:\"fontawesome\";}i:244;a:4:{s:3:\"uid\";s:32:\"12052b30d23a1a70d6b32962d5464cae\";s:3:\"css\";s:8:\"to-start\";s:4:\"code\";i:59622;s:3:\"src\";s:11:\"fontawesome\";}i:245;a:4:{s:3:\"uid\";s:32:\"6b5450145d620234f07ffcbfbb671074\";s:3:\"css\";s:12:\"to-start-alt\";s:4:\"code\";i:59623;s:3:\"src\";s:11:\"fontawesome\";}i:246;a:4:{s:3:\"uid\";s:32:\"4e511190b60f329d08301eb6869c5130\";s:3:\"css\";s:7:\"fast-fw\";s:4:\"code\";i:59624;s:3:\"src\";s:11:\"fontawesome\";}i:247;a:4:{s:3:\"uid\";s:32:\"b3d902fcead809e3a64c7ddcda497a6c\";s:3:\"css\";s:7:\"fast-bw\";s:4:\"code\";i:59625;s:3:\"src\";s:11:\"fontawesome\";}i:248;a:4:{s:3:\"uid\";s:32:\"91b141af48402743aa3503d0a7007132\";s:3:\"css\";s:5:\"eject\";s:4:\"code\";i:59626;s:3:\"src\";s:11:\"fontawesome\";}i:249;a:4:{s:3:\"uid\";s:32:\"e75c54c282c0bf22186c5c7ec4b03eac\";s:3:\"css\";s:6:\"target\";s:4:\"code\";i:59627;s:3:\"src\";s:11:\"fontawesome\";}i:250;a:4:{s:3:\"uid\";s:32:\"d407a4707f719b042ed2ad28d2619d7e\";s:3:\"css\";s:6:\"signal\";s:4:\"code\";i:59628;s:3:\"src\";s:11:\"fontawesome\";}i:251;a:4:{s:3:\"uid\";s:32:\"ab656e280958018a7859eba9a1eabbc7\";s:3:\"css\";s:5:\"award\";s:4:\"code\";i:59629;s:3:\"src\";s:11:\"fontawesome\";}i:252;a:4:{s:3:\"uid\";s:32:\"757afacc32d82967975cbb3b45cfb41b\";s:3:\"css\";s:7:\"desktop\";s:4:\"code\";i:59630;s:3:\"src\";s:11:\"fontawesome\";}i:253;a:4:{s:3:\"uid\";s:32:\"500fc1f109021e4b1de4deda2f7ed399\";s:3:\"css\";s:6:\"laptop\";s:4:\"code\";i:59631;s:3:\"src\";s:11:\"fontawesome\";}i:254;a:4:{s:3:\"uid\";s:32:\"f001fc3d4daa7da078e8c971e4f36977\";s:3:\"css\";s:6:\"tablet\";s:4:\"code\";i:59632;s:3:\"src\";s:11:\"fontawesome\";}i:255;a:4:{s:3:\"uid\";s:32:\"0357f7abbc0babf43509669f332e41e6\";s:3:\"css\";s:6:\"mobile\";s:4:\"code\";i:59633;s:3:\"src\";s:11:\"fontawesome\";}i:256;a:4:{s:3:\"uid\";s:32:\"c7a75a25880928fe76981a53eca4f926\";s:3:\"css\";s:5:\"inbox\";s:4:\"code\";i:59634;s:3:\"src\";s:11:\"fontawesome\";}i:257;a:4:{s:3:\"uid\";s:32:\"197375a3cea8cb90b02d06e4ddf1433d\";s:3:\"css\";s:5:\"globe\";s:4:\"code\";i:59635;s:3:\"src\";s:11:\"fontawesome\";}i:258;a:4:{s:3:\"uid\";s:32:\"aa035df0908c4665c269b7b09a5596f3\";s:3:\"css\";s:3:\"sun\";s:4:\"code\";i:59636;s:3:\"src\";s:11:\"fontawesome\";}i:259;a:4:{s:3:\"uid\";s:32:\"2c413e78faf1d6631fd7b094d14c2253\";s:3:\"css\";s:5:\"cloud\";s:4:\"code\";i:59637;s:3:\"src\";s:11:\"fontawesome\";}i:260;a:4:{s:3:\"uid\";s:32:\"3212f42c65d41ed91cb435d0490e29ed\";s:3:\"css\";s:5:\"flash\";s:4:\"code\";i:59638;s:3:\"src\";s:11:\"fontawesome\";}i:261;a:4:{s:3:\"uid\";s:32:\"567e3e257f2cc8fba2c12bf691c9f2d8\";s:3:\"css\";s:4:\"moon\";s:4:\"code\";i:59639;s:3:\"src\";s:11:\"fontawesome\";}i:262;a:4:{s:3:\"uid\";s:32:\"24ca41ab002c09de6e89b28f9d599508\";s:3:\"css\";s:8:\"umbrella\";s:4:\"code\";i:59640;s:3:\"src\";s:11:\"fontawesome\";}i:263;a:4:{s:3:\"uid\";s:32:\"297fe6c2ef08198b03d706ba52f51b7f\";s:3:\"css\";s:6:\"flight\";s:4:\"code\";i:59641;s:3:\"src\";s:11:\"fontawesome\";}i:264;a:4:{s:3:\"uid\";s:32:\"cb36cbe4e2dac9545e32c3d80a7c6e03\";s:3:\"css\";s:11:\"fighter-jet\";s:4:\"code\";i:59642;s:3:\"src\";s:11:\"fontawesome\";}i:265;a:4:{s:3:\"uid\";s:32:\"19e7b342a5e6bd0cd86de6d6208486a4\";s:3:\"css\";s:4:\"leaf\";s:4:\"code\";i:59643;s:3:\"src\";s:11:\"fontawesome\";}i:266;a:4:{s:3:\"uid\";s:32:\"f9cbf7508cd04145ade2800169959eef\";s:3:\"css\";s:4:\"font\";s:4:\"code\";i:59644;s:3:\"src\";s:11:\"fontawesome\";}i:267;a:4:{s:3:\"uid\";s:32:\"02cca871bb69da75e8ee286b7055832c\";s:3:\"css\";s:4:\"bold\";s:4:\"code\";i:59645;s:3:\"src\";s:11:\"fontawesome\";}i:268;a:4:{s:3:\"uid\";s:32:\"a8cb1c217f02b073db3670c061cc54d2\";s:3:\"css\";s:6:\"italic\";s:4:\"code\";i:59646;s:3:\"src\";s:11:\"fontawesome\";}i:269;a:4:{s:3:\"uid\";s:32:\"c009d417f87d6a27bb5a1cefd30b6cbd\";s:3:\"css\";s:11:\"text-height\";s:4:\"code\";i:59647;s:3:\"src\";s:11:\"fontawesome\";}i:270;a:4:{s:3:\"uid\";s:32:\"13a971bcccd2dda26d4d4eccd8593f8a\";s:3:\"css\";s:10:\"text-width\";s:4:\"code\";i:59648;s:3:\"src\";s:11:\"fontawesome\";}i:271;a:4:{s:3:\"uid\";s:32:\"f4f0e849b805be1f6d76b65581cb3b8b\";s:3:\"css\";s:10:\"align-left\";s:4:\"code\";i:59649;s:3:\"src\";s:11:\"fontawesome\";}i:272;a:4:{s:3:\"uid\";s:32:\"ae6336c46d73af999fe7460c089abb4d\";s:3:\"css\";s:12:\"align-center\";s:4:\"code\";i:59650;s:3:\"src\";s:11:\"fontawesome\";}i:273;a:4:{s:3:\"uid\";s:32:\"e1e7306b47c3c5e6faecce9d32571381\";s:3:\"css\";s:11:\"align-right\";s:4:\"code\";i:59651;s:3:\"src\";s:11:\"fontawesome\";}i:274;a:4:{s:3:\"uid\";s:32:\"25a81737628d1e654a30ad412d7d6dd7\";s:3:\"css\";s:13:\"align-justify\";s:4:\"code\";i:59652;s:3:\"src\";s:11:\"fontawesome\";}i:275;a:4:{s:3:\"uid\";s:32:\"48b87105bd38c20315f1b705b8c7b38c\";s:3:\"css\";s:4:\"list\";s:4:\"code\";i:59653;s:3:\"src\";s:11:\"fontawesome\";}i:276;a:4:{s:3:\"uid\";s:32:\"594e9271c08ff732c04b3bf3117b9040\";s:3:\"css\";s:11:\"indent-left\";s:4:\"code\";i:59654;s:3:\"src\";s:11:\"fontawesome\";}i:277;a:4:{s:3:\"uid\";s:32:\"4d2dfc45d8176b1f26aed973fa84a91e\";s:3:\"css\";s:12:\"indent-right\";s:4:\"code\";i:59655;s:3:\"src\";s:11:\"fontawesome\";}i:278;a:4:{s:3:\"uid\";s:32:\"a2a74f5e7b7d9ba054897d8c795a326a\";s:3:\"css\";s:11:\"list-bullet\";s:4:\"code\";i:59656;s:3:\"src\";s:11:\"fontawesome\";}i:279;a:4:{s:3:\"uid\";s:32:\"f6766a8b042c2453a4e153af03294383\";s:3:\"css\";s:13:\"list-numbered\";s:4:\"code\";i:59657;s:3:\"src\";s:11:\"fontawesome\";}i:280;a:4:{s:3:\"uid\";s:32:\"61c242c9e2134d5864d7fdd57b3c9289\";s:3:\"css\";s:6:\"strike\";s:4:\"code\";i:59658;s:3:\"src\";s:11:\"fontawesome\";}i:281;a:4:{s:3:\"uid\";s:32:\"d4a4a38a40b728f46dad1de4ac950231\";s:3:\"css\";s:9:\"underline\";s:4:\"code\";i:59659;s:3:\"src\";s:11:\"fontawesome\";}i:282;a:4:{s:3:\"uid\";s:32:\"4e88371fb8857dacc1f66afe6314e426\";s:3:\"css\";s:11:\"superscript\";s:4:\"code\";i:59660;s:3:\"src\";s:11:\"fontawesome\";}i:283;a:4:{s:3:\"uid\";s:32:\"3d1c929dbc966992185ce749548c1b2c\";s:3:\"css\";s:9:\"subscript\";s:4:\"code\";i:59661;s:3:\"src\";s:11:\"fontawesome\";}i:284;a:4:{s:3:\"uid\";s:32:\"8fb55fd696d9a0f58f3b27c1d8633750\";s:3:\"css\";s:5:\"table\";s:4:\"code\";i:59662;s:3:\"src\";s:11:\"fontawesome\";}i:285;a:4:{s:3:\"uid\";s:32:\"53dd31a6cc6438192b2d7b09b1c1dd45\";s:3:\"css\";s:7:\"columns\";s:4:\"code\";i:59663;s:3:\"src\";s:11:\"fontawesome\";}i:286;a:4:{s:3:\"uid\";s:32:\"09bdae120f85e79f2db16145a9e1f6d8\";s:3:\"css\";s:4:\"crop\";s:4:\"code\";i:59664;s:3:\"src\";s:11:\"fontawesome\";}i:287;a:4:{s:3:\"uid\";s:32:\"8772331a9fec983cdb5d72902a6f9e0e\";s:3:\"css\";s:8:\"scissors\";s:4:\"code\";i:59665;s:3:\"src\";s:11:\"fontawesome\";}i:288;a:4:{s:3:\"uid\";s:32:\"b429436ec5a518c78479d44ef18dbd60\";s:3:\"css\";s:5:\"paste\";s:4:\"code\";i:59666;s:3:\"src\";s:11:\"fontawesome\";}i:289;a:4:{s:3:\"uid\";s:32:\"053b757d97042e1c94276200c7b64b91\";s:3:\"css\";s:9:\"briefcase\";s:4:\"code\";i:59667;s:3:\"src\";s:11:\"fontawesome\";}i:290;a:4:{s:3:\"uid\";s:32:\"5ccf1ed249fd9d723ec1ce8629a9f507\";s:3:\"css\";s:8:\"suitcase\";s:4:\"code\";i:59668;s:3:\"src\";s:11:\"fontawesome\";}i:291;a:4:{s:3:\"uid\";s:32:\"107ce08c7231097c7447d8f4d059b55f\";s:3:\"css\";s:8:\"ellipsis\";s:4:\"code\";i:59669;s:3:\"src\";s:11:\"fontawesome\";}i:292;a:4:{s:3:\"uid\";s:32:\"750058837a91edae64b03d60fc7e81a7\";s:3:\"css\";s:13:\"ellipsis-vert\";s:4:\"code\";i:59670;s:3:\"src\";s:11:\"fontawesome\";}i:293;a:4:{s:3:\"uid\";s:32:\"8b9e6a8dd8f67f7c003ed8e7e5ee0857\";s:3:\"css\";s:3:\"off\";s:4:\"code\";i:59671;s:3:\"src\";s:11:\"fontawesome\";}i:294;a:4:{s:3:\"uid\";s:32:\"ecede48deb16179e5ef9a3f8ffae62f4\";s:3:\"css\";s:4:\"road\";s:4:\"code\";i:59672;s:3:\"src\";s:11:\"fontawesome\";}i:295;a:4:{s:3:\"uid\";s:32:\"c819c6225685bae2eed1b8da13e629fa\";s:3:\"css\";s:8:\"list-alt\";s:4:\"code\";i:59673;s:3:\"src\";s:11:\"fontawesome\";}i:296;a:4:{s:3:\"uid\";s:32:\"fd45bb961d08f9f2092f0df3fba29fe9\";s:3:\"css\";s:6:\"qrcode\";s:4:\"code\";i:59674;s:3:\"src\";s:11:\"fontawesome\";}i:297;a:4:{s:3:\"uid\";s:32:\"aa991e8e66ac54b33f0a4b0555597b08\";s:3:\"css\";s:7:\"barcode\";s:4:\"code\";i:59675;s:3:\"src\";s:11:\"fontawesome\";}i:298;a:4:{s:3:\"uid\";s:32:\"9755f76110ae4d12ac5f9466c9152031\";s:3:\"css\";s:4:\"book\";s:4:\"code\";i:59676;s:3:\"src\";s:11:\"fontawesome\";}i:299;a:4:{s:3:\"uid\";s:32:\"ca90da02d2c6a3183f2458e4dc416285\";s:3:\"css\";s:5:\"ajust\";s:4:\"code\";i:59677;s:3:\"src\";s:11:\"fontawesome\";}i:300;a:4:{s:3:\"uid\";s:32:\"83458acd9f38d03ec0226ce82a83c0f4\";s:3:\"css\";s:4:\"tint\";s:4:\"code\";i:59678;s:3:\"src\";s:11:\"fontawesome\";}i:301;a:4:{s:3:\"uid\";s:32:\"dd6c6b221a1088ff8a9b9cd32d0b3dd5\";s:3:\"css\";s:5:\"check\";s:4:\"code\";i:59679;s:3:\"src\";s:11:\"fontawesome\";}i:302;a:4:{s:3:\"uid\";s:32:\"4b900d04e8ab8c82f080c1cfbac5772c\";s:3:\"css\";s:11:\"check-empty\";s:4:\"code\";i:59680;s:3:\"src\";s:11:\"fontawesome\";}i:303;a:4:{s:3:\"uid\";s:32:\"130380e481a7defc690dfb24123a1f0c\";s:3:\"css\";s:6:\"circle\";s:4:\"code\";i:59681;s:3:\"src\";s:11:\"fontawesome\";}i:304;a:4:{s:3:\"uid\";s:32:\"422e07e5afb80258a9c4ed1706498f8a\";s:3:\"css\";s:12:\"circle-empty\";s:4:\"code\";i:59682;s:3:\"src\";s:11:\"fontawesome\";}i:305;a:4:{s:3:\"uid\";s:32:\"81bb68665e8e595505272a746db07c7a\";s:3:\"css\";s:11:\"dot-circled\";s:4:\"code\";i:59683;s:3:\"src\";s:11:\"fontawesome\";}i:306;a:4:{s:3:\"uid\";s:32:\"823a9e02e643318116fea40a00190e4e\";s:3:\"css\";s:8:\"asterisk\";s:4:\"code\";i:59684;s:3:\"src\";s:11:\"fontawesome\";}i:307;a:4:{s:3:\"uid\";s:32:\"28f308aa0a07a67433f54c089c400d82\";s:3:\"css\";s:4:\"gift\";s:4:\"code\";i:59685;s:3:\"src\";s:11:\"fontawesome\";}i:308;a:4:{s:3:\"uid\";s:32:\"254077e7c0a9e6d303b32f9c35b96a40\";s:3:\"css\";s:4:\"fire\";s:4:\"code\";i:59686;s:3:\"src\";s:11:\"fontawesome\";}i:309;a:4:{s:3:\"uid\";s:32:\"d20912c814d0ff9a7fd27ed1f54813cc\";s:3:\"css\";s:6:\"magnet\";s:4:\"code\";i:59687;s:3:\"src\";s:11:\"fontawesome\";}i:310;a:4:{s:3:\"uid\";s:32:\"266d5d9adf15a61800477a5acf9a4462\";s:3:\"css\";s:9:\"chart-bar\";s:4:\"code\";i:59688;s:3:\"src\";s:11:\"fontawesome\";}i:311;a:4:{s:3:\"uid\";s:32:\"d6fcb9886485b0bdb41b94521e7a3311\";s:3:\"css\";s:6:\"ticket\";s:4:\"code\";i:59689;s:3:\"src\";s:11:\"fontawesome\";}i:312;a:4:{s:3:\"uid\";s:32:\"3d8cc269fdad8a4cda55a20542a84e5c\";s:3:\"css\";s:11:\"credit-card\";s:4:\"code\";i:59690;s:3:\"src\";s:11:\"fontawesome\";}i:313;a:4:{s:3:\"uid\";s:32:\"f4445feb55521283572ee88bc304f928\";s:3:\"css\";s:8:\"floppy-1\";s:4:\"code\";i:59691;s:3:\"src\";s:11:\"fontawesome\";}i:314;a:4:{s:3:\"uid\";s:32:\"3e674995cacc2b09692c096ea7eb6165\";s:3:\"css\";s:9:\"megaphone\";s:4:\"code\";i:59692;s:3:\"src\";s:11:\"fontawesome\";}i:315;a:4:{s:3:\"uid\";s:32:\"795efd07cd5205b589c883916a76cff0\";s:3:\"css\";s:3:\"hdd\";s:4:\"code\";i:59693;s:3:\"src\";s:11:\"fontawesome\";}i:316;a:4:{s:3:\"uid\";s:32:\"f2aa28a2548ed3d2be718d087b65ee21\";s:3:\"css\";s:3:\"key\";s:4:\"code\";i:59694;s:3:\"src\";s:11:\"fontawesome\";}i:317;a:4:{s:3:\"uid\";s:32:\"bc4b94dd7a9a1dd2e02f9e4648062596\";s:3:\"css\";s:4:\"fork\";s:4:\"code\";i:59695;s:3:\"src\";s:11:\"fontawesome\";}i:318;a:4:{s:3:\"uid\";s:32:\"8aa99bc60f3553bb3e31b73dd6e744c8\";s:3:\"css\";s:6:\"rocket\";s:4:\"code\";i:59696;s:3:\"src\";s:11:\"fontawesome\";}i:319;a:4:{s:3:\"uid\";s:32:\"7432077e6a2d6aa19984ca821bb6bbda\";s:3:\"css\";s:3:\"bug\";s:4:\"code\";i:59697;s:3:\"src\";s:11:\"fontawesome\";}i:320;a:4:{s:3:\"uid\";s:32:\"d61be837c725a299b432dcbee2ecdae6\";s:3:\"css\";s:11:\"certificate\";s:4:\"code\";i:59698;s:3:\"src\";s:11:\"fontawesome\";}i:321;a:4:{s:3:\"uid\";s:32:\"9396b2d8849e0213a0f11c5fd7fcc522\";s:3:\"css\";s:5:\"tasks\";s:4:\"code\";i:59699;s:3:\"src\";s:11:\"fontawesome\";}i:322;a:4:{s:3:\"uid\";s:32:\"4109c474ff99cad28fd5a2c38af2ec6f\";s:3:\"css\";s:6:\"filter\";s:4:\"code\";i:59700;s:3:\"src\";s:11:\"fontawesome\";}i:323;a:4:{s:3:\"uid\";s:32:\"0f444c61b0d2c9966016d7ddb12f5837\";s:3:\"css\";s:6:\"beaker\";s:4:\"code\";i:59701;s:3:\"src\";s:11:\"fontawesome\";}i:324;a:4:{s:3:\"uid\";s:32:\"ff70f7b3228702e0d590e60ed3b90bea\";s:3:\"css\";s:5:\"magic\";s:4:\"code\";i:59702;s:3:\"src\";s:11:\"fontawesome\";}i:325;a:4:{s:3:\"uid\";s:32:\"7f3d8ff1d5f6ee019f0c00ed7a86caec\";s:3:\"css\";s:5:\"truck\";s:4:\"code\";i:59703;s:3:\"src\";s:11:\"fontawesome\";}i:326;a:4:{s:3:\"uid\";s:32:\"f279f25007794fa6837ff78fe94b216e\";s:3:\"css\";s:5:\"money\";s:4:\"code\";i:59704;s:3:\"src\";s:11:\"fontawesome\";}i:327;a:4:{s:3:\"uid\";s:32:\"486b835e9eebf54eee78ed12b4291b86\";s:3:\"css\";s:4:\"euro\";s:4:\"code\";i:59705;s:3:\"src\";s:11:\"fontawesome\";}i:328;a:4:{s:3:\"uid\";s:32:\"9854f7f091bd4fdf9b8735ed66667b9d\";s:3:\"css\";s:5:\"pound\";s:4:\"code\";i:59706;s:3:\"src\";s:11:\"fontawesome\";}i:329;a:4:{s:3:\"uid\";s:32:\"026007bd17bfc67f3fe013199676f620\";s:3:\"css\";s:6:\"dollar\";s:4:\"code\";i:59707;s:3:\"src\";s:11:\"fontawesome\";}i:330;a:4:{s:3:\"uid\";s:32:\"62e4fa2c664818d20ce4740cadbf9aeb\";s:3:\"css\";s:5:\"rupee\";s:4:\"code\";i:59708;s:3:\"src\";s:11:\"fontawesome\";}i:331;a:4:{s:3:\"uid\";s:32:\"5f61f8a682b77d2529296a8061bf9597\";s:3:\"css\";s:3:\"yen\";s:4:\"code\";i:59709;s:3:\"src\";s:11:\"fontawesome\";}i:332;a:4:{s:3:\"uid\";s:32:\"243424d56528e83e4fe9ef6e6347a2ef\";s:3:\"css\";s:8:\"renminbi\";s:4:\"code\";i:59710;s:3:\"src\";s:11:\"fontawesome\";}i:333;a:4:{s:3:\"uid\";s:32:\"7f5801d1e299b445ad0090b0a9e94bcb\";s:3:\"css\";s:3:\"try\";s:4:\"code\";i:59711;s:3:\"src\";s:11:\"fontawesome\";}i:334;a:4:{s:3:\"uid\";s:32:\"82f0dc5149d842219e45000bebd683fb\";s:3:\"css\";s:3:\"won\";s:4:\"code\";i:59712;s:3:\"src\";s:11:\"fontawesome\";}i:335;a:4:{s:3:\"uid\";s:32:\"2cb15eb2b295ee3c33fab1530e18a924\";s:3:\"css\";s:7:\"bitcoin\";s:4:\"code\";i:59713;s:3:\"src\";s:11:\"fontawesome\";}i:336;a:4:{s:3:\"uid\";s:32:\"56a21935a5d4d79b2e91ec00f760b369\";s:3:\"css\";s:4:\"sort\";s:4:\"code\";i:59714;s:3:\"src\";s:11:\"fontawesome\";}i:337;a:4:{s:3:\"uid\";s:32:\"94103e1b3f1e8cf514178ec5912b4469\";s:3:\"css\";s:9:\"sort-down\";s:4:\"code\";i:59715;s:3:\"src\";s:11:\"fontawesome\";}i:338;a:4:{s:3:\"uid\";s:32:\"65b3ce930627cabfb6ac81ac60ec5ae4\";s:3:\"css\";s:7:\"sort-up\";s:4:\"code\";i:59716;s:3:\"src\";s:11:\"fontawesome\";}i:339;a:4:{s:3:\"uid\";s:32:\"0cd2582b8c93719d066ee0affd02ac78\";s:3:\"css\";s:11:\"sort-alt-up\";s:4:\"code\";i:59717;s:3:\"src\";s:11:\"fontawesome\";}i:340;a:4:{s:3:\"uid\";s:32:\"27b13eff5eb0ca15e01a6e65ffe6eeec\";s:3:\"css\";s:13:\"sort-alt-down\";s:4:\"code\";i:59718;s:3:\"src\";s:11:\"fontawesome\";}i:341;a:4:{s:3:\"uid\";s:32:\"3ed68ae14e9cde775121954242a412b2\";s:3:\"css\";s:12:\"sort-name-up\";s:4:\"code\";i:59719;s:3:\"src\";s:11:\"fontawesome\";}i:342;a:4:{s:3:\"uid\";s:32:\"6586267200a42008a9fc0a1bf7ac06c7\";s:3:\"css\";s:14:\"sort-name-down\";s:4:\"code\";i:59720;s:3:\"src\";s:11:\"fontawesome\";}i:343;a:4:{s:3:\"uid\";s:32:\"3a7b6876c1817ce3b801b86c04a9d0af\";s:3:\"css\";s:14:\"sort-number-up\";s:4:\"code\";i:59721;s:3:\"src\";s:11:\"fontawesome\";}i:344;a:4:{s:3:\"uid\";s:32:\"b04fc30546f597a7e0a14715e6fc81ff\";s:3:\"css\";s:16:\"sort-number-down\";s:4:\"code\";i:59722;s:3:\"src\";s:11:\"fontawesome\";}i:345;a:4:{s:3:\"uid\";s:32:\"dec0ce0476433f7e49e096526cf89465\";s:3:\"css\";s:6:\"hammer\";s:4:\"code\";i:59723;s:3:\"src\";s:11:\"fontawesome\";}i:346;a:4:{s:3:\"uid\";s:32:\"0bda4bc779d4c32623dec2e43bd67ee8\";s:3:\"css\";s:5:\"gauge\";s:4:\"code\";i:59724;s:3:\"src\";s:11:\"fontawesome\";}i:347;a:4:{s:3:\"uid\";s:32:\"6fe95ffc3c807e62647d4f814a96e0d7\";s:3:\"css\";s:7:\"sitemap\";s:4:\"code\";i:59725;s:3:\"src\";s:11:\"fontawesome\";}i:348;a:4:{s:3:\"uid\";s:32:\"cda0cdcfd38f5f1d9255e722dad42012\";s:3:\"css\";s:20:\"spinner animate-spin\";s:4:\"code\";i:59726;s:3:\"src\";s:11:\"fontawesome\";}i:349;a:4:{s:3:\"uid\";s:32:\"3a26448b711645ba1abfc86c1a6e2f30\";s:3:\"css\";s:6:\"coffee\";s:4:\"code\";i:59727;s:3:\"src\";s:11:\"fontawesome\";}i:350;a:4:{s:3:\"uid\";s:32:\"30b79160618d99ce798e4bd11cafe3fe\";s:3:\"css\";s:4:\"food\";s:4:\"code\";i:59728;s:3:\"src\";s:11:\"fontawesome\";}i:351;a:4:{s:3:\"uid\";s:32:\"890bcc8897cce868f6ee65cadadde036\";s:3:\"css\";s:4:\"beer\";s:4:\"code\";i:59729;s:3:\"src\";s:11:\"fontawesome\";}i:352;a:4:{s:3:\"uid\";s:32:\"9e8430ce95f56720ae8e7afba291df88\";s:3:\"css\";s:7:\"user-md\";s:4:\"code\";i:59730;s:3:\"src\";s:11:\"fontawesome\";}i:353;a:4:{s:3:\"uid\";s:32:\"5590d2f643b64d2d0757ae660f9c24cb\";s:3:\"css\";s:11:\"stethoscope\";s:4:\"code\";i:59731;s:3:\"src\";s:11:\"fontawesome\";}i:354;a:4:{s:3:\"uid\";s:32:\"6dbf07228006788a96eb6244b3591970\";s:3:\"css\";s:9:\"ambulance\";s:4:\"code\";i:59732;s:3:\"src\";s:11:\"fontawesome\";}i:355;a:4:{s:3:\"uid\";s:32:\"46120eb259799eab0dac0691137e5706\";s:3:\"css\";s:6:\"medkit\";s:4:\"code\";i:59733;s:3:\"src\";s:11:\"fontawesome\";}i:356;a:4:{s:3:\"uid\";s:32:\"6f41d9b99564a01f1fde503b7f03bf1a\";s:3:\"css\";s:6:\"h-sigh\";s:4:\"code\";i:59734;s:3:\"src\";s:11:\"fontawesome\";}i:357;a:4:{s:3:\"uid\";s:32:\"c4adaacece4c6341a9ae1816f5ea500c\";s:3:\"css\";s:8:\"hospital\";s:4:\"code\";i:59735;s:3:\"src\";s:11:\"fontawesome\";}i:358;a:4:{s:3:\"uid\";s:32:\"3d1e04316a48ace4e2b81be58343a41c\";s:3:\"css\";s:8:\"building\";s:4:\"code\";i:59736;s:3:\"src\";s:11:\"fontawesome\";}i:359;a:4:{s:3:\"uid\";s:32:\"d862a10e1448589215be19702f98f2c1\";s:3:\"css\";s:5:\"smile\";s:4:\"code\";i:59737;s:3:\"src\";s:11:\"fontawesome\";}i:360;a:4:{s:3:\"uid\";s:32:\"06ddc67d609c477cd5524a7238d7850d\";s:3:\"css\";s:5:\"frown\";s:4:\"code\";i:59738;s:3:\"src\";s:11:\"fontawesome\";}i:361;a:4:{s:3:\"uid\";s:32:\"2c5055a9c9723725f49f0593a08535af\";s:3:\"css\";s:3:\"meh\";s:4:\"code\";i:59739;s:3:\"src\";s:11:\"fontawesome\";}i:362;a:4:{s:3:\"uid\";s:32:\"7a9d73c640892d4b917c706ad95d6fec\";s:3:\"css\";s:6:\"anchor\";s:4:\"code\";i:59740;s:3:\"src\";s:11:\"fontawesome\";}i:363;a:4:{s:3:\"uid\";s:32:\"fa10777b2d88cc64cd6e4f26ef0e5264\";s:3:\"css\";s:8:\"terminal\";s:4:\"code\";i:59741;s:3:\"src\";s:11:\"fontawesome\";}i:364;a:4:{s:3:\"uid\";s:32:\"ebc57fa8400e4ede049ac5dc665210e1\";s:3:\"css\";s:6:\"eraser\";s:4:\"code\";i:59742;s:3:\"src\";s:11:\"fontawesome\";}i:365;a:4:{s:3:\"uid\";s:32:\"5f0f183e241d15cbe486bff88b188dff\";s:3:\"css\";s:6:\"puzzle\";s:4:\"code\";i:59743;s:3:\"src\";s:11:\"fontawesome\";}i:366;a:4:{s:3:\"uid\";s:32:\"44a0e2660ac966cdfaa04deb6aac51df\";s:3:\"css\";s:6:\"shield\";s:4:\"code\";i:59744;s:3:\"src\";s:11:\"fontawesome\";}i:367;a:4:{s:3:\"uid\";s:32:\"1e7648f03fbdc28114a00b33b059b499\";s:3:\"css\";s:12:\"extinguisher\";s:4:\"code\";i:59745;s:3:\"src\";s:11:\"fontawesome\";}i:368;a:4:{s:3:\"uid\";s:32:\"c92ad3028acce9d51bae0ac82f5de8a2\";s:3:\"css\";s:8:\"bullseye\";s:4:\"code\";i:59746;s:3:\"src\";s:11:\"fontawesome\";}i:369;a:4:{s:3:\"uid\";s:32:\"8a67014b864fb93503348593979ddce3\";s:3:\"css\";s:10:\"wheelchair\";s:4:\"code\";i:59747;s:3:\"src\";s:11:\"fontawesome\";}i:370;a:4:{s:3:\"uid\";s:32:\"ef98b489bfb943225e6761cfa9999e9b\";s:3:\"css\";s:3:\"adn\";s:4:\"code\";i:59748;s:3:\"src\";s:11:\"fontawesome\";}i:371;a:4:{s:3:\"uid\";s:32:\"809f2374b759f5b9278ac6307e690ba4\";s:3:\"css\";s:7:\"android\";s:4:\"code\";i:59749;s:3:\"src\";s:11:\"fontawesome\";}i:372;a:4:{s:3:\"uid\";s:32:\"e9fa538fd5913046497ac148e27cd8ea\";s:3:\"css\";s:5:\"apple\";s:4:\"code\";i:59750;s:3:\"src\";s:11:\"fontawesome\";}i:373;a:4:{s:3:\"uid\";s:32:\"169f51b7e405de8c03cf85a6e8c740ab\";s:3:\"css\";s:9:\"bitbucket\";s:4:\"code\";i:59751;s:3:\"src\";s:11:\"fontawesome\";}i:374;a:4:{s:3:\"uid\";s:32:\"4ae56c66a1f93e28b8d4f866db2b018a\";s:3:\"css\";s:17:\"bitbucket-squared\";s:4:\"code\";i:59752;s:3:\"src\";s:11:\"fontawesome\";}i:375;a:4:{s:3:\"uid\";s:32:\"01c946ce2ed5500e0a918f2b3a7d1923\";s:3:\"css\";s:4:\"css3\";s:4:\"code\";i:59753;s:3:\"src\";s:11:\"fontawesome\";}i:376;a:4:{s:3:\"uid\";s:32:\"199c44bca402ec5a6351f75ba5228375\";s:3:\"css\";s:8:\"dribbble\";s:4:\"code\";i:59754;s:3:\"src\";s:11:\"fontawesome\";}i:377;a:4:{s:3:\"uid\";s:32:\"9e34a047fee949eae9b6e613d790d6cf\";s:3:\"css\";s:7:\"dropbox\";s:4:\"code\";i:59755;s:3:\"src\";s:11:\"fontawesome\";}i:378;a:4:{s:3:\"uid\";s:32:\"8e04c98c8f5ca0a035776e3001ad2638\";s:3:\"css\";s:8:\"facebook\";s:4:\"code\";i:59756;s:3:\"src\";s:11:\"fontawesome\";}i:379;a:4:{s:3:\"uid\";s:32:\"4743b088aa95d6f3b6b990e770d3b647\";s:3:\"css\";s:16:\"facebook-squared\";s:4:\"code\";i:59757;s:3:\"src\";s:11:\"fontawesome\";}i:380;a:4:{s:3:\"uid\";s:32:\"649004fb1ed50395a33c3780236ba8aa\";s:3:\"css\";s:6:\"flickr\";s:4:\"code\";i:59758;s:3:\"src\";s:11:\"fontawesome\";}i:381;a:4:{s:3:\"uid\";s:32:\"a32d12927584e3c8a3dff23eb816d360\";s:3:\"css\";s:10:\"foursquare\";s:4:\"code\";i:59759;s:3:\"src\";s:11:\"fontawesome\";}i:382;a:4:{s:3:\"uid\";s:32:\"5e0a374728ffa8d0ae1f331a8f648231\";s:3:\"css\";s:6:\"github\";s:4:\"code\";i:59760;s:3:\"src\";s:11:\"fontawesome\";}i:383;a:4:{s:3:\"uid\";s:32:\"0ece9a12de796b8411f868d582bee678\";s:3:\"css\";s:14:\"github-squared\";s:4:\"code\";i:59761;s:3:\"src\";s:11:\"fontawesome\";}i:384;a:4:{s:3:\"uid\";s:32:\"0f6a2573a7b6df911ed199bb63717e27\";s:3:\"css\";s:14:\"github-circled\";s:4:\"code\";i:59762;s:3:\"src\";s:11:\"fontawesome\";}i:385;a:4:{s:3:\"uid\";s:32:\"5b4b48418155c35459f12171f97c82ff\";s:3:\"css\";s:6:\"gittip\";s:4:\"code\";i:59763;s:3:\"src\";s:11:\"fontawesome\";}i:386;a:4:{s:3:\"uid\";s:32:\"f0cf7db1b03cb65adc450aa3bdaf8c4d\";s:3:\"css\";s:13:\"gplus-squared\";s:4:\"code\";i:59764;s:3:\"src\";s:11:\"fontawesome\";}i:387;a:4:{s:3:\"uid\";s:32:\"b8d0c7d76e87b94882329a88e8e43d3d\";s:3:\"css\";s:5:\"gplus\";s:4:\"code\";i:59765;s:3:\"src\";s:11:\"fontawesome\";}i:388;a:4:{s:3:\"uid\";s:32:\"ff44f01f60948555026580eedf1e39bb\";s:3:\"css\";s:5:\"html5\";s:4:\"code\";i:59766;s:3:\"src\";s:11:\"fontawesome\";}i:389;a:4:{s:3:\"uid\";s:32:\"4c1ef492f1d2c39a2250ae457cee2a6e\";s:3:\"css\";s:10:\"instagramm\";s:4:\"code\";i:59767;s:3:\"src\";s:11:\"fontawesome\";}i:390;a:4:{s:3:\"uid\";s:32:\"1145676a91138011729fa2909997af66\";s:3:\"css\";s:16:\"linkedin-squared\";s:4:\"code\";i:59768;s:3:\"src\";s:11:\"fontawesome\";}i:391;a:4:{s:3:\"uid\";s:32:\"47a35af762c8e06f3d152750134c8750\";s:3:\"css\";s:5:\"linux\";s:4:\"code\";i:59769;s:3:\"src\";s:11:\"fontawesome\";}i:392;a:4:{s:3:\"uid\";s:32:\"e9107949dd6c9e8ab2b29ae07156e38c\";s:3:\"css\";s:8:\"linkedin\";s:4:\"code\";i:59770;s:3:\"src\";s:11:\"fontawesome\";}i:393;a:4:{s:3:\"uid\";s:32:\"fcdc6d7a89771d2dbd38eb719aafb2ff\";s:3:\"css\";s:6:\"maxcdn\";s:4:\"code\";i:59771;s:3:\"src\";s:11:\"fontawesome\";}i:394;a:4:{s:3:\"uid\";s:32:\"bbf50a560f95a4cce5209d47e71cbc30\";s:3:\"css\";s:9:\"pagelines\";s:4:\"code\";i:59772;s:3:\"src\";s:11:\"fontawesome\";}i:395;a:4:{s:3:\"uid\";s:32:\"da851b7c1f84ee83f93b29ae613558dc\";s:3:\"css\";s:17:\"pinterest-circled\";s:4:\"code\";i:59773;s:3:\"src\";s:11:\"fontawesome\";}i:396;a:4:{s:3:\"uid\";s:32:\"79689c4c425b7cdaa2746f510e81e27a\";s:3:\"css\";s:17:\"pinterest-squared\";s:4:\"code\";i:59774;s:3:\"src\";s:11:\"fontawesome\";}i:397;a:4:{s:3:\"uid\";s:32:\"cfa8a2588cab42a6ff7ba81eb4fec21b\";s:3:\"css\";s:6:\"renren\";s:4:\"code\";i:59775;s:3:\"src\";s:11:\"fontawesome\";}i:398;a:4:{s:3:\"uid\";s:32:\"58a16628dcbd6456c61218f3d27591be\";s:3:\"css\";s:5:\"skype\";s:4:\"code\";i:59776;s:3:\"src\";s:11:\"fontawesome\";}i:399;a:4:{s:3:\"uid\";s:32:\"b6d6b3561d705330c7ad2155e8ee94ba\";s:3:\"css\";s:13:\"stackexchange\";s:4:\"code\";i:59777;s:3:\"src\";s:11:\"fontawesome\";}i:400;a:4:{s:3:\"uid\";s:32:\"e1597911f34fea0a188ae51fe4a2d9a9\";s:3:\"css\";s:13:\"stackoverflow\";s:4:\"code\";i:59778;s:3:\"src\";s:11:\"fontawesome\";}i:401;a:4:{s:3:\"uid\";s:32:\"b846892636bd74112998bb159bdddf27\";s:3:\"css\";s:6:\"trello\";s:4:\"code\";i:59779;s:3:\"src\";s:11:\"fontawesome\";}i:402;a:4:{s:3:\"uid\";s:32:\"43fcf807461234935e65261328e1dff6\";s:3:\"css\";s:6:\"tumblr\";s:4:\"code\";i:59780;s:3:\"src\";s:11:\"fontawesome\";}i:403;a:4:{s:3:\"uid\";s:32:\"5b79895d979c408282b4e92fa7db8e82\";s:3:\"css\";s:14:\"tumblr-squared\";s:4:\"code\";i:59781;s:3:\"src\";s:11:\"fontawesome\";}i:404;a:4:{s:3:\"uid\";s:32:\"906348dc798a0d42715cc97c875e3ac6\";s:3:\"css\";s:15:\"twitter-squared\";s:4:\"code\";i:59782;s:3:\"src\";s:11:\"fontawesome\";}i:405;a:4:{s:3:\"uid\";s:32:\"627abcdb627cb1789e009c08e2678ef9\";s:3:\"css\";s:7:\"twitter\";s:4:\"code\";i:59783;s:3:\"src\";s:11:\"fontawesome\";}i:406;a:4:{s:3:\"uid\";s:32:\"1f66490bf24c99e2c56b866d8fbd0372\";s:3:\"css\";s:13:\"vimeo-squared\";s:4:\"code\";i:59784;s:3:\"src\";s:11:\"fontawesome\";}i:407;a:4:{s:3:\"uid\";s:32:\"f3d95e13eb43f3f6b8efe1eb424a1e3b\";s:3:\"css\";s:9:\"vkontakte\";s:4:\"code\";i:59785;s:3:\"src\";s:11:\"fontawesome\";}i:408;a:4:{s:3:\"uid\";s:32:\"9854b94688e31450fc76aae4c2a45dff\";s:3:\"css\";s:5:\"weibo\";s:4:\"code\";i:59786;s:3:\"src\";s:11:\"fontawesome\";}i:409;a:4:{s:3:\"uid\";s:32:\"8aff323697468c4a63993cde00386ec6\";s:3:\"css\";s:7:\"windows\";s:4:\"code\";i:59787;s:3:\"src\";s:11:\"fontawesome\";}i:410;a:4:{s:3:\"uid\";s:32:\"11ebb30e17efcd988a228ade5d3e8c74\";s:3:\"css\";s:4:\"xing\";s:4:\"code\";i:59788;s:3:\"src\";s:11:\"fontawesome\";}i:411;a:4:{s:3:\"uid\";s:32:\"f7dff44258aa565cbe35565be350b58d\";s:3:\"css\";s:12:\"xing-squared\";s:4:\"code\";i:59789;s:3:\"src\";s:11:\"fontawesome\";}i:412;a:4:{s:3:\"uid\";s:32:\"a9862b9d5197886c1ad693ecd7120b31\";s:3:\"css\";s:7:\"youtube\";s:4:\"code\";i:59790;s:3:\"src\";s:11:\"fontawesome\";}i:413;a:4:{s:3:\"uid\";s:32:\"e331ff486a299c6bdf0056426c8fac53\";s:3:\"css\";s:15:\"youtube-squared\";s:4:\"code\";i:59791;s:3:\"src\";s:11:\"fontawesome\";}i:414;a:4:{s:3:\"uid\";s:32:\"47a1f80457068fbeab69fdb83d7d0817\";s:3:\"css\";s:12:\"youtube-play\";s:4:\"code\";i:59792;s:3:\"src\";s:11:\"fontawesome\";}i:415;a:4:{s:3:\"uid\";s:32:\"2c2ca8a96b31781c9c8056d05c0a8980\";s:3:\"css\";s:5:\"blank\";s:4:\"code\";i:59793;s:3:\"src\";s:11:\"fontawesome\";}i:416;a:4:{s:3:\"uid\";s:32:\"5e0191587645a9f5d514ed4b0a0e008a\";s:3:\"css\";s:5:\"lemon\";s:4:\"code\";i:59794;s:3:\"src\";s:11:\"fontawesome\";}i:417;a:4:{s:3:\"uid\";s:32:\"39e2e6682c28e1e3b5f49825a19717c4\";s:3:\"css\";s:4:\"note\";s:4:\"code\";i:60019;s:3:\"src\";s:6:\"entypo\";}i:418;a:4:{s:3:\"uid\";s:32:\"fda731b5a4026685e1a9c7e64228e2b2\";s:3:\"css\";s:11:\"note-beamed\";s:4:\"code\";i:60020;s:3:\"src\";s:6:\"entypo\";}i:419;a:4:{s:3:\"uid\";s:32:\"f2a036a85c0a6a46b0c9709a70e1bb70\";s:3:\"css\";s:7:\"music-1\";s:4:\"code\";i:60021;s:3:\"src\";s:6:\"entypo\";}i:420;a:4:{s:3:\"uid\";s:32:\"7222571caa5c15f83dcfd447c58d68d9\";s:3:\"css\";s:8:\"search-2\";s:4:\"code\";i:60022;s:3:\"src\";s:6:\"entypo\";}i:421;a:4:{s:3:\"uid\";s:32:\"c9b928dc82d7d77033644fcf59dca3b3\";s:3:\"css\";s:10:\"flashlight\";s:4:\"code\";i:60023;s:3:\"src\";s:6:\"entypo\";}i:422;a:4:{s:3:\"uid\";s:32:\"e335adbc2d898c7d85d40c507796e7b4\";s:3:\"css\";s:6:\"mail-2\";s:4:\"code\";i:60024;s:3:\"src\";s:6:\"entypo\";}i:423;a:4:{s:3:\"uid\";s:32:\"0eabe5f8d71cc838484ff39436426d2d\";s:3:\"css\";s:7:\"heart-2\";s:4:\"code\";i:60025;s:3:\"src\";s:6:\"entypo\";}i:424;a:4:{s:3:\"uid\";s:32:\"d18071bbf8f0a8cec8d1f556c91c6af0\";s:3:\"css\";s:13:\"heart-empty-1\";s:4:\"code\";i:60026;s:3:\"src\";s:6:\"entypo\";}i:425;a:4:{s:3:\"uid\";s:32:\"25b34dea4784f72c710454f32ff8fa2b\";s:3:\"css\";s:6:\"star-2\";s:4:\"code\";i:60027;s:3:\"src\";s:6:\"entypo\";}i:426;a:4:{s:3:\"uid\";s:32:\"0e3f1335f83cca67329b2c4bcb3aaec5\";s:3:\"css\";s:12:\"star-empty-1\";s:4:\"code\";i:60028;s:3:\"src\";s:6:\"entypo\";}i:427;a:4:{s:3:\"uid\";s:32:\"bbd66ef66bb8fa9edde54d9a90b89150\";s:3:\"css\";s:6:\"user-2\";s:4:\"code\";i:60029;s:3:\"src\";s:6:\"entypo\";}i:428;a:4:{s:3:\"uid\";s:32:\"ecf8edb95c3f45eb433b4cce7ba9f740\";s:3:\"css\";s:7:\"users-2\";s:4:\"code\";i:60030;s:3:\"src\";s:6:\"entypo\";}i:429;a:4:{s:3:\"uid\";s:32:\"6274e0601f2feef7eced89146e708de0\";s:3:\"css\";s:10:\"user-add-1\";s:4:\"code\";i:60031;s:3:\"src\";s:6:\"entypo\";}i:430;a:4:{s:3:\"uid\";s:32:\"6341ebcbe1ed1f6777c1b9527ead368e\";s:3:\"css\";s:7:\"video-2\";s:4:\"code\";i:60032;s:3:\"src\";s:6:\"entypo\";}i:431;a:4:{s:3:\"uid\";s:32:\"3def559c3c39b8500882e02892b7daa8\";s:3:\"css\";s:9:\"picture-2\";s:4:\"code\";i:60033;s:3:\"src\";s:6:\"entypo\";}i:432;a:4:{s:3:\"uid\";s:32:\"85017ab6ca074831a8de771b40e9640c\";s:3:\"css\";s:8:\"camera-2\";s:4:\"code\";i:60034;s:3:\"src\";s:6:\"entypo\";}i:433;a:4:{s:3:\"uid\";s:32:\"5e9f01871d44e56b45ecbfd00f4dbc3a\";s:3:\"css\";s:6:\"layout\";s:4:\"code\";i:60035;s:3:\"src\";s:6:\"entypo\";}i:434;a:4:{s:3:\"uid\";s:32:\"2cfb3f2b46b34a1790aec0aa846297b6\";s:3:\"css\";s:6:\"menu-2\";s:4:\"code\";i:60036;s:3:\"src\";s:6:\"entypo\";}i:435;a:4:{s:3:\"uid\";s:32:\"14017aae737730faeda4a6fd8fb3a5f0\";s:3:\"css\";s:7:\"check-2\";s:4:\"code\";i:60037;s:3:\"src\";s:6:\"entypo\";}i:436;a:4:{s:3:\"uid\";s:32:\"c709da589c923ba3c2ad48d9fc563e93\";s:3:\"css\";s:8:\"cancel-2\";s:4:\"code\";i:60038;s:3:\"src\";s:6:\"entypo\";}i:437;a:4:{s:3:\"uid\";s:32:\"c759418c008e9562944080fee617fc76\";s:3:\"css\";s:16:\"cancel-circled-1\";s:4:\"code\";i:60039;s:3:\"src\";s:6:\"entypo\";}i:438;a:4:{s:3:\"uid\";s:32:\"bf45c39702763f1803b550c36a0ceb12\";s:3:\"css\";s:14:\"cancel-squared\";s:4:\"code\";i:60040;s:3:\"src\";s:6:\"entypo\";}i:439;a:4:{s:3:\"uid\";s:32:\"70370693ada58ef0a60fa0984fe8d52a\";s:3:\"css\";s:6:\"plus-2\";s:4:\"code\";i:60041;s:3:\"src\";s:6:\"entypo\";}i:440;a:4:{s:3:\"uid\";s:32:\"a66cdc7278e6b33b8bd44a141f5e1a8d\";s:3:\"css\";s:14:\"plus-circled-1\";s:4:\"code\";i:60042;s:3:\"src\";s:6:\"entypo\";}i:441;a:4:{s:3:\"uid\";s:32:\"9e1c33b6849ceb08db8acfaf02188b7d\";s:3:\"css\";s:14:\"plus-squared-1\";s:4:\"code\";i:60043;s:3:\"src\";s:6:\"entypo\";}i:442;a:4:{s:3:\"uid\";s:32:\"1256e3054823e304d7e452a589cf8bb8\";s:3:\"css\";s:7:\"minus-2\";s:4:\"code\";i:60044;s:3:\"src\";s:6:\"entypo\";}i:443;a:4:{s:3:\"uid\";s:32:\"3eb93689881ad0804f87052a53edc2b6\";s:3:\"css\";s:15:\"minus-circled-1\";s:4:\"code\";i:60045;s:3:\"src\";s:6:\"entypo\";}i:444;a:4:{s:3:\"uid\";s:32:\"4ffa544c1a81c905f0a8a5745d8b9faa\";s:3:\"css\";s:15:\"minus-squared-1\";s:4:\"code\";i:60046;s:3:\"src\";s:6:\"entypo\";}i:445;a:4:{s:3:\"uid\";s:32:\"3a230e539a4f3b904debd04c6c155034\";s:3:\"css\";s:6:\"help-1\";s:4:\"code\";i:60047;s:3:\"src\";s:6:\"entypo\";}i:446;a:4:{s:3:\"uid\";s:32:\"de9a631a7d18106aea1c89ba51b1990a\";s:3:\"css\";s:14:\"help-circled-1\";s:4:\"code\";i:60048;s:3:\"src\";s:6:\"entypo\";}i:447;a:4:{s:3:\"uid\";s:32:\"63b86fedd4ee9ad2105f54f4888e7088\";s:3:\"css\";s:6:\"info-2\";s:4:\"code\";i:60049;s:3:\"src\";s:6:\"entypo\";}i:448;a:4:{s:3:\"uid\";s:32:\"7e4164950ffa4990961958b2d6318658\";s:3:\"css\";s:14:\"info-circled-1\";s:4:\"code\";i:60050;s:3:\"src\";s:6:\"entypo\";}i:449;a:4:{s:3:\"uid\";s:32:\"3ba4275937db277075fc47d6b5a69a2e\";s:3:\"css\";s:4:\"back\";s:4:\"code\";i:60051;s:3:\"src\";s:6:\"entypo\";}i:450;a:4:{s:3:\"uid\";s:32:\"513ac180ff85bd275f2b736720cbbf5e\";s:3:\"css\";s:6:\"home-2\";s:4:\"code\";i:60052;s:3:\"src\";s:6:\"entypo\";}i:451;a:4:{s:3:\"uid\";s:32:\"815503841e980c848f55e0271deacead\";s:3:\"css\";s:6:\"link-2\";s:4:\"code\";i:60053;s:3:\"src\";s:6:\"entypo\";}i:452;a:4:{s:3:\"uid\";s:32:\"44b9e75612c5fad5505edd70d071651f\";s:3:\"css\";s:8:\"attach-2\";s:4:\"code\";i:60054;s:3:\"src\";s:6:\"entypo\";}i:453;a:4:{s:3:\"uid\";s:32:\"1a7104205ea96e6f40ac716d0ca72f21\";s:3:\"css\";s:6:\"lock-2\";s:4:\"code\";i:60055;s:3:\"src\";s:6:\"entypo\";}i:454;a:4:{s:3:\"uid\";s:32:\"e81fc3a0d39ace6ee735d7b24eedd56d\";s:3:\"css\";s:11:\"lock-open-2\";s:4:\"code\";i:60056;s:3:\"src\";s:6:\"entypo\";}i:455;a:4:{s:3:\"uid\";s:32:\"25fc99a30fecc4021fdcae5fff5ba9ac\";s:3:\"css\";s:5:\"eye-2\";s:4:\"code\";i:60057;s:3:\"src\";s:6:\"entypo\";}i:456;a:4:{s:3:\"uid\";s:32:\"875ab0f6d417223f6ec76ff7f0a4baed\";s:3:\"css\";s:5:\"tag-1\";s:4:\"code\";i:60058;s:3:\"src\";s:6:\"entypo\";}i:457;a:4:{s:3:\"uid\";s:32:\"23912d5623126e14b7b137c3ba557168\";s:3:\"css\";s:10:\"bookmark-1\";s:4:\"code\";i:60059;s:3:\"src\";s:6:\"entypo\";}i:458;a:4:{s:3:\"uid\";s:32:\"8538a2249db7f07ae75411886732fb87\";s:3:\"css\";s:9:\"bookmarks\";s:4:\"code\";i:60060;s:3:\"src\";s:6:\"entypo\";}i:459;a:4:{s:3:\"uid\";s:32:\"1d2a6c3d9236b88b0f185c7c4530fa52\";s:3:\"css\";s:6:\"flag-1\";s:4:\"code\";i:60061;s:3:\"src\";s:6:\"entypo\";}i:460;a:4:{s:3:\"uid\";s:32:\"7ad4d2306ebda8452e5e3eff3cd8241c\";s:3:\"css\";s:11:\"thumbs-up-2\";s:4:\"code\";i:60062;s:3:\"src\";s:6:\"entypo\";}i:461;a:4:{s:3:\"uid\";s:32:\"429fba993b729174468a9493613ad1ba\";s:3:\"css\";s:13:\"thumbs-down-2\";s:4:\"code\";i:60063;s:3:\"src\";s:6:\"entypo\";}i:462;a:4:{s:3:\"uid\";s:32:\"b08cfe8039de2ce815686aced2caef06\";s:3:\"css\";s:10:\"download-1\";s:4:\"code\";i:60064;s:3:\"src\";s:6:\"entypo\";}i:463;a:4:{s:3:\"uid\";s:32:\"44199a54057e6e264fde61a49b034171\";s:3:\"css\";s:8:\"upload-1\";s:4:\"code\";i:60065;s:3:\"src\";s:6:\"entypo\";}i:464;a:4:{s:3:\"uid\";s:32:\"5d595124cecf472869d1cdc020da0ccc\";s:3:\"css\";s:14:\"upload-cloud-1\";s:4:\"code\";i:60066;s:3:\"src\";s:6:\"entypo\";}i:465;a:4:{s:3:\"uid\";s:32:\"b6fc2f656ef87275889422e19550680a\";s:3:\"css\";s:7:\"reply-1\";s:4:\"code\";i:60067;s:3:\"src\";s:6:\"entypo\";}i:466;a:4:{s:3:\"uid\";s:32:\"1a4b54ba5618e5364fc47a3d26c1cf59\";s:3:\"css\";s:11:\"reply-all-1\";s:4:\"code\";i:60068;s:3:\"src\";s:6:\"entypo\";}i:467;a:4:{s:3:\"uid\";s:32:\"ec347024a3640deebeeab53fd0d5ad03\";s:3:\"css\";s:9:\"forward-1\";s:4:\"code\";i:60069;s:3:\"src\";s:6:\"entypo\";}i:468;a:4:{s:3:\"uid\";s:32:\"c3e5dafba1739ef33cc574c7484febf7\";s:3:\"css\";s:5:\"quote\";s:4:\"code\";i:60070;s:3:\"src\";s:6:\"entypo\";}i:469;a:4:{s:3:\"uid\";s:32:\"b6f32db98a3de777f5ae3005191b1831\";s:3:\"css\";s:6:\"code-2\";s:4:\"code\";i:60071;s:3:\"src\";s:6:\"entypo\";}i:470;a:4:{s:3:\"uid\";s:32:\"390d6d13398cbf8c8c3c5493f7d34088\";s:3:\"css\";s:8:\"export-1\";s:4:\"code\";i:60072;s:3:\"src\";s:6:\"entypo\";}i:471;a:4:{s:3:\"uid\";s:32:\"c77fd2fd065b5fe16d6f2b41e190b266\";s:3:\"css\";s:8:\"pencil-2\";s:4:\"code\";i:60073;s:3:\"src\";s:6:\"entypo\";}i:472;a:4:{s:3:\"uid\";s:32:\"bcb868184ff9c35f8aef564f50c0d649\";s:3:\"css\";s:7:\"feather\";s:4:\"code\";i:60074;s:3:\"src\";s:6:\"entypo\";}i:473;a:4:{s:3:\"uid\";s:32:\"28f124a10127a47b9d9472699193d75a\";s:3:\"css\";s:7:\"print-1\";s:4:\"code\";i:60075;s:3:\"src\";s:6:\"entypo\";}i:474;a:4:{s:3:\"uid\";s:32:\"216891b0093d4dbef19877d5b00d1b16\";s:3:\"css\";s:9:\"retweet-1\";s:4:\"code\";i:60076;s:3:\"src\";s:6:\"entypo\";}i:475;a:4:{s:3:\"uid\";s:32:\"005a38f6af74b31aeb817fedb09d2175\";s:3:\"css\";s:10:\"keyboard-1\";s:4:\"code\";i:60077;s:3:\"src\";s:6:\"entypo\";}i:476;a:4:{s:3:\"uid\";s:32:\"16890362e811b4cb8de36282b071fe30\";s:3:\"css\";s:9:\"comment-1\";s:4:\"code\";i:60078;s:3:\"src\";s:6:\"entypo\";}i:477;a:4:{s:3:\"uid\";s:32:\"2c0b53280f82068f6bab4e2200025d9f\";s:3:\"css\";s:6:\"chat-1\";s:4:\"code\";i:59795;s:3:\"src\";s:6:\"entypo\";}i:478;a:4:{s:3:\"uid\";s:32:\"2c5335c6e56b876139d7a58ab2f4b2fe\";s:3:\"css\";s:6:\"bell-1\";s:4:\"code\";i:59796;s:3:\"src\";s:6:\"entypo\";}i:479;a:4:{s:3:\"uid\";s:32:\"97902f87200ce74d181044df02a0458d\";s:3:\"css\";s:11:\"attention-2\";s:4:\"code\";i:59797;s:3:\"src\";s:6:\"entypo\";}i:480;a:4:{s:3:\"uid\";s:32:\"39a5a0d7ce8342d149373b2ce219503a\";s:3:\"css\";s:5:\"alert\";s:4:\"code\";i:59798;s:3:\"src\";s:6:\"entypo\";}i:481;a:4:{s:3:\"uid\";s:32:\"457c8e2b305e7af74c1be4f07a01ca92\";s:3:\"css\";s:7:\"vcard-1\";s:4:\"code\";i:59799;s:3:\"src\";s:6:\"entypo\";}i:482;a:4:{s:3:\"uid\";s:32:\"540b6a4262be769515c79700618b4aea\";s:3:\"css\";s:7:\"address\";s:4:\"code\";i:59800;s:3:\"src\";s:6:\"entypo\";}i:483;a:4:{s:3:\"uid\";s:32:\"a42b598e4298f3319b25a2702a02e7ff\";s:3:\"css\";s:10:\"location-2\";s:4:\"code\";i:59801;s:3:\"src\";s:6:\"entypo\";}i:484;a:4:{s:3:\"uid\";s:32:\"64f5a50cf7ac972a56a9a511acb5d28e\";s:3:\"css\";s:5:\"map-1\";s:4:\"code\";i:59802;s:3:\"src\";s:6:\"entypo\";}i:485;a:4:{s:3:\"uid\";s:32:\"f8513213799b244e66b2836aeee88531\";s:3:\"css\";s:11:\"direction-1\";s:4:\"code\";i:59803;s:3:\"src\";s:6:\"entypo\";}i:486;a:4:{s:3:\"uid\";s:32:\"c117f17c0316ef71fb2a658c4c273002\";s:3:\"css\";s:9:\"compass-1\";s:4:\"code\";i:59804;s:3:\"src\";s:6:\"entypo\";}i:487;a:4:{s:3:\"uid\";s:32:\"9bdc80f58999873c5a8079ad2d7f4143\";s:3:\"css\";s:3:\"cup\";s:4:\"code\";i:59805;s:3:\"src\";s:6:\"entypo\";}i:488;a:4:{s:3:\"uid\";s:32:\"2626e3a1bbcd90e45849af3b58a1d594\";s:3:\"css\";s:7:\"trash-2\";s:4:\"code\";i:59806;s:3:\"src\";s:6:\"entypo\";}i:489;a:4:{s:3:\"uid\";s:32:\"49bd3e825b8267f976f6d1ad391e2f4d\";s:3:\"css\";s:5:\"doc-1\";s:4:\"code\";i:59807;s:3:\"src\";s:6:\"entypo\";}i:490;a:4:{s:3:\"uid\";s:32:\"922ab2cb66943a83de969990289ef1dc\";s:3:\"css\";s:6:\"docs-1\";s:4:\"code\";i:59808;s:3:\"src\";s:6:\"entypo\";}i:491;a:4:{s:3:\"uid\";s:32:\"8782cc70184b33096ae927590d1fadc4\";s:3:\"css\";s:13:\"doc-landscape\";s:4:\"code\";i:59809;s:3:\"src\";s:6:\"entypo\";}i:492;a:4:{s:3:\"uid\";s:32:\"1189604bf305b6b03a74685ce60e6632\";s:3:\"css\";s:10:\"doc-text-1\";s:4:\"code\";i:59810;s:3:\"src\";s:6:\"entypo\";}i:493;a:4:{s:3:\"uid\";s:32:\"1d7c1d30ad49a988556273a238097c2a\";s:3:\"css\";s:14:\"doc-text-inv-1\";s:4:\"code\";i:59811;s:3:\"src\";s:6:\"entypo\";}i:494;a:4:{s:3:\"uid\";s:32:\"da0fd38d651815e3a12f6c030ff1fe5b\";s:3:\"css\";s:9:\"newspaper\";s:4:\"code\";i:59812;s:3:\"src\";s:6:\"entypo\";}i:495;a:4:{s:3:\"uid\";s:32:\"51727ca007aa35ceabcaffc28934faee\";s:3:\"css\";s:9:\"book-open\";s:4:\"code\";i:59813;s:3:\"src\";s:6:\"entypo\";}i:496;a:4:{s:3:\"uid\";s:32:\"48b79f27e4798f23bafa07b55dbe5b73\";s:3:\"css\";s:6:\"book-1\";s:4:\"code\";i:59814;s:3:\"src\";s:6:\"entypo\";}i:497;a:4:{s:3:\"uid\";s:32:\"0ccb084ddeeae372673793ed0b45bb4a\";s:3:\"css\";s:8:\"folder-2\";s:4:\"code\";i:59815;s:3:\"src\";s:6:\"entypo\";}i:498;a:4:{s:3:\"uid\";s:32:\"96ea1be71f597a5bdfc8f791ada4f651\";s:3:\"css\";s:9:\"archive-1\";s:4:\"code\";i:59816;s:3:\"src\";s:6:\"entypo\";}i:499;a:4:{s:3:\"uid\";s:32:\"cc05df515bebe11df3ada0a5910a8f6d\";s:3:\"css\";s:5:\"box-2\";s:4:\"code\";i:59817;s:3:\"src\";s:6:\"entypo\";}i:500;a:4:{s:3:\"uid\";s:32:\"3e617d8049807e128c80d0344ba09e37\";s:3:\"css\";s:5:\"rss-1\";s:4:\"code\";i:59818;s:3:\"src\";s:6:\"entypo\";}i:501;a:4:{s:3:\"uid\";s:32:\"5854855e963044f93b15738a5bb27a29\";s:3:\"css\";s:7:\"phone-1\";s:4:\"code\";i:59819;s:3:\"src\";s:6:\"entypo\";}i:502;a:4:{s:3:\"uid\";s:32:\"bc64550dd022ce21604f97309b346cea\";s:3:\"css\";s:5:\"cog-1\";s:4:\"code\";i:59820;s:3:\"src\";s:6:\"entypo\";}i:503;a:4:{s:3:\"uid\";s:32:\"6a7b9d4863bb7e6c79e9457a72d689b6\";s:3:\"css\";s:5:\"tools\";s:4:\"code\";i:59821;s:3:\"src\";s:6:\"entypo\";}i:504;a:4:{s:3:\"uid\";s:32:\"91426c82d94428a33353e495418435e3\";s:3:\"css\";s:5:\"share\";s:4:\"code\";i:59822;s:3:\"src\";s:6:\"entypo\";}i:505;a:4:{s:3:\"uid\";s:32:\"e4536ab890a215f2fe8952de5c2fe354\";s:3:\"css\";s:9:\"shareable\";s:4:\"code\";i:59823;s:3:\"src\";s:6:\"entypo\";}i:506;a:4:{s:3:\"uid\";s:32:\"e126987944593dfee041f8e2a68145db\";s:3:\"css\";s:8:\"basket-1\";s:4:\"code\";i:59824;s:3:\"src\";s:6:\"entypo\";}i:507;a:4:{s:3:\"uid\";s:32:\"2c71ee1c65e1992ba32d5ffc5ee7f337\";s:3:\"css\";s:3:\"bag\";s:4:\"code\";i:59825;s:3:\"src\";s:6:\"entypo\";}i:508;a:4:{s:3:\"uid\";s:32:\"413717f5ea649e8d8b93938be277264a\";s:3:\"css\";s:10:\"calendar-2\";s:4:\"code\";i:59826;s:3:\"src\";s:6:\"entypo\";}i:509;a:4:{s:3:\"uid\";s:32:\"a204f0fa972408eaae5a363c444991b2\";s:3:\"css\";s:7:\"login-1\";s:4:\"code\";i:59827;s:3:\"src\";s:6:\"entypo\";}i:510;a:4:{s:3:\"uid\";s:32:\"2d76f2c8d13be40694ecadfea7fb83c3\";s:3:\"css\";s:8:\"logout-1\";s:4:\"code\";i:59828;s:3:\"src\";s:6:\"entypo\";}i:511;a:4:{s:3:\"uid\";s:32:\"1e099a876c8a6a83f10c9bafa9886614\";s:3:\"css\";s:5:\"mic-1\";s:4:\"code\";i:59829;s:3:\"src\";s:6:\"entypo\";}i:512;a:4:{s:3:\"uid\";s:32:\"2f750a9be253e8e451209574336e7020\";s:3:\"css\";s:6:\"mute-1\";s:4:\"code\";i:59830;s:3:\"src\";s:6:\"entypo\";}i:513;a:4:{s:3:\"uid\";s:32:\"ef51920c7a9bed4d87f53709db115e34\";s:3:\"css\";s:5:\"sound\";s:4:\"code\";i:59831;s:3:\"src\";s:6:\"entypo\";}i:514;a:4:{s:3:\"uid\";s:32:\"edd88296295d95d6510e66d9a6bbd6c3\";s:3:\"css\";s:6:\"volume\";s:4:\"code\";i:59832;s:3:\"src\";s:6:\"entypo\";}i:515;a:4:{s:3:\"uid\";s:32:\"8663320a860b00f26e94d3d15c9ba99a\";s:3:\"css\";s:7:\"clock-2\";s:4:\"code\";i:59833;s:3:\"src\";s:6:\"entypo\";}i:516;a:4:{s:3:\"uid\";s:32:\"7f6916533c0842b6cec699fd773693d3\";s:3:\"css\";s:9:\"hourglass\";s:4:\"code\";i:59834;s:3:\"src\";s:6:\"entypo\";}i:517;a:4:{s:3:\"uid\";s:32:\"4b20e1deee87faf4c3fab735fbd4bc1a\";s:3:\"css\";s:4:\"lamp\";s:4:\"code\";i:59835;s:3:\"src\";s:6:\"entypo\";}i:518;a:4:{s:3:\"uid\";s:32:\"2d14369ed7f129e779eaa30195368218\";s:3:\"css\";s:10:\"light-down\";s:4:\"code\";i:59836;s:3:\"src\";s:6:\"entypo\";}i:519;a:4:{s:3:\"uid\";s:32:\"f8e120c48c070f8afd2d072651b4fb9f\";s:3:\"css\";s:8:\"light-up\";s:4:\"code\";i:59837;s:3:\"src\";s:6:\"entypo\";}i:520;a:4:{s:3:\"uid\";s:32:\"f6fa10cb3ffec7becb60834f50bb0182\";s:3:\"css\";s:6:\"adjust\";s:4:\"code\";i:59838;s:3:\"src\";s:6:\"entypo\";}i:521;a:4:{s:3:\"uid\";s:32:\"29e7f6072d5935d7818204d9b088508b\";s:3:\"css\";s:7:\"block-2\";s:4:\"code\";i:59839;s:3:\"src\";s:6:\"entypo\";}i:522;a:4:{s:3:\"uid\";s:32:\"3a3f65b92c9b2fcbb3a8dcd0d42ee806\";s:3:\"css\";s:13:\"resize-full-2\";s:4:\"code\";i:59840;s:3:\"src\";s:6:\"entypo\";}i:523;a:4:{s:3:\"uid\";s:32:\"108c8ac13badc00ce66da014436e6eb1\";s:3:\"css\";s:14:\"resize-small-1\";s:4:\"code\";i:59841;s:3:\"src\";s:6:\"entypo\";}i:524;a:4:{s:3:\"uid\";s:32:\"9248ce8062fb4707a6919bfe9ac1af8e\";s:3:\"css\";s:7:\"popup-2\";s:4:\"code\";i:59842;s:3:\"src\";s:6:\"entypo\";}i:525;a:4:{s:3:\"uid\";s:32:\"77bcf90f0c68635bab5abfb4ed736696\";s:3:\"css\";s:7:\"publish\";s:4:\"code\";i:59843;s:3:\"src\";s:6:\"entypo\";}i:526;a:4:{s:3:\"uid\";s:32:\"744a71fe4b5ab7c4f4b7cd598e9bf75a\";s:3:\"css\";s:6:\"window\";s:4:\"code\";i:59844;s:3:\"src\";s:6:\"entypo\";}i:527;a:4:{s:3:\"uid\";s:32:\"0a3192de65a73ca1501b073ad601f87d\";s:3:\"css\";s:11:\"arrow-combo\";s:4:\"code\";i:59845;s:3:\"src\";s:6:\"entypo\";}i:528;a:4:{s:3:\"uid\";s:32:\"40ef3542646bed70cb63f1290c9d98c9\";s:3:\"css\";s:14:\"down-circled-1\";s:4:\"code\";i:59846;s:3:\"src\";s:6:\"entypo\";}i:529;a:4:{s:3:\"uid\";s:32:\"0db0310883e0bdacfd1bb2d394238e8a\";s:3:\"css\";s:14:\"left-circled-1\";s:4:\"code\";i:59847;s:3:\"src\";s:6:\"entypo\";}i:530;a:4:{s:3:\"uid\";s:32:\"52725ff4d4042964bd3a60609bf3695b\";s:3:\"css\";s:15:\"right-circled-1\";s:4:\"code\";i:59848;s:3:\"src\";s:6:\"entypo\";}i:531;a:4:{s:3:\"uid\";s:32:\"64691230b90991883f94c6dfb2afc90a\";s:3:\"css\";s:12:\"up-circled-1\";s:4:\"code\";i:59849;s:3:\"src\";s:6:\"entypo\";}i:532;a:4:{s:3:\"uid\";s:32:\"8704cd847a47b64265b8bb110c8b4d62\";s:3:\"css\";s:11:\"down-open-1\";s:4:\"code\";i:59850;s:3:\"src\";s:6:\"entypo\";}i:533;a:4:{s:3:\"uid\";s:32:\"c311c48d79488965b0fab7f9cd12b6b5\";s:3:\"css\";s:11:\"left-open-2\";s:4:\"code\";i:59851;s:3:\"src\";s:6:\"entypo\";}i:534;a:4:{s:3:\"uid\";s:32:\"749e7d90a9182938180f1d2d8c33584e\";s:3:\"css\";s:12:\"right-open-2\";s:4:\"code\";i:59852;s:3:\"src\";s:6:\"entypo\";}i:535;a:4:{s:3:\"uid\";s:32:\"9c7ff134960bb5a82404e4aeaab366d9\";s:3:\"css\";s:9:\"up-open-1\";s:4:\"code\";i:59853;s:3:\"src\";s:6:\"entypo\";}i:536;a:4:{s:3:\"uid\";s:32:\"f11c9e95ae5eaa84d193e8fa1d38c6f9\";s:3:\"css\";s:14:\"down-open-mini\";s:4:\"code\";i:59854;s:3:\"src\";s:6:\"entypo\";}i:537;a:4:{s:3:\"uid\";s:32:\"592717bd601645d61517d2a584d04127\";s:3:\"css\";s:14:\"left-open-mini\";s:4:\"code\";i:59855;s:3:\"src\";s:6:\"entypo\";}i:538;a:4:{s:3:\"uid\";s:32:\"37f6cfbb4062ed0d01b351ec35c334ff\";s:3:\"css\";s:15:\"right-open-mini\";s:4:\"code\";i:59856;s:3:\"src\";s:6:\"entypo\";}i:539;a:4:{s:3:\"uid\";s:32:\"9e251fb8e9e1c71ab09683468e0479a3\";s:3:\"css\";s:12:\"up-open-mini\";s:4:\"code\";i:59857;s:3:\"src\";s:6:\"entypo\";}i:540;a:4:{s:3:\"uid\";s:32:\"289b5f92f23acf1059c93fbf401c1ad5\";s:3:\"css\";s:13:\"down-open-big\";s:4:\"code\";i:59858;s:3:\"src\";s:6:\"entypo\";}i:541;a:4:{s:3:\"uid\";s:32:\"884cfc3e6e2d456dd2a2ca0dbb9e6337\";s:3:\"css\";s:13:\"left-open-big\";s:4:\"code\";i:59859;s:3:\"src\";s:6:\"entypo\";}i:542;a:4:{s:3:\"uid\";s:32:\"004882ab2d5c418c5b2060e80596279b\";s:3:\"css\";s:14:\"right-open-big\";s:4:\"code\";i:59860;s:3:\"src\";s:6:\"entypo\";}i:543;a:4:{s:3:\"uid\";s:32:\"0805cca616b3c12714f35af4d0912c10\";s:3:\"css\";s:11:\"up-open-big\";s:4:\"code\";i:59861;s:3:\"src\";s:6:\"entypo\";}i:544;a:4:{s:3:\"uid\";s:32:\"d5098cb09be5827a2911dbab5af49ad2\";s:3:\"css\";s:6:\"down-1\";s:4:\"code\";i:59862;s:3:\"src\";s:6:\"entypo\";}i:545;a:4:{s:3:\"uid\";s:32:\"6acd5cf005d48f96787350e72bd45688\";s:3:\"css\";s:6:\"left-1\";s:4:\"code\";i:59863;s:3:\"src\";s:6:\"entypo\";}i:546;a:4:{s:3:\"uid\";s:32:\"9e67bfab0143d9511f8eef6897caeb88\";s:3:\"css\";s:7:\"right-1\";s:4:\"code\";i:59864;s:3:\"src\";s:6:\"entypo\";}i:547;a:4:{s:3:\"uid\";s:32:\"43c4064ec1260d0e55c37e0467c75cbb\";s:3:\"css\";s:4:\"up-1\";s:4:\"code\";i:59865;s:3:\"src\";s:6:\"entypo\";}i:548;a:4:{s:3:\"uid\";s:32:\"7e89c12b577c31bc91bfb61bb597f01f\";s:3:\"css\";s:10:\"down-dir-1\";s:4:\"code\";i:59866;s:3:\"src\";s:6:\"entypo\";}i:549;a:4:{s:3:\"uid\";s:32:\"9aeaf29161eb005a308bbd624d6e066a\";s:3:\"css\";s:10:\"left-dir-1\";s:4:\"code\";i:59867;s:3:\"src\";s:6:\"entypo\";}i:550;a:4:{s:3:\"uid\";s:32:\"ff9a85aa20950dcc0615a2707a2b3f8e\";s:3:\"css\";s:11:\"right-dir-1\";s:4:\"code\";i:59868;s:3:\"src\";s:6:\"entypo\";}i:551;a:4:{s:3:\"uid\";s:32:\"401b644723fb2f20b0df30cce7745c18\";s:3:\"css\";s:8:\"up-dir-1\";s:4:\"code\";i:59869;s:3:\"src\";s:6:\"entypo\";}i:552;a:4:{s:3:\"uid\";s:32:\"78944e4652d6f9b8b506eaef331308cd\";s:3:\"css\";s:9:\"down-bold\";s:4:\"code\";i:59870;s:3:\"src\";s:6:\"entypo\";}i:553;a:4:{s:3:\"uid\";s:32:\"0222089fb4194cc714dcc1ffd2525c11\";s:3:\"css\";s:9:\"left-bold\";s:4:\"code\";i:59871;s:3:\"src\";s:6:\"entypo\";}i:554;a:4:{s:3:\"uid\";s:32:\"1a90b06af8614b12d8c8a5b90cc19ab3\";s:3:\"css\";s:10:\"right-bold\";s:4:\"code\";i:59872;s:3:\"src\";s:6:\"entypo\";}i:555;a:4:{s:3:\"uid\";s:32:\"8c8f768607b8fc4c92c0f85b488e87e8\";s:3:\"css\";s:7:\"up-bold\";s:4:\"code\";i:59873;s:3:\"src\";s:6:\"entypo\";}i:556;a:4:{s:3:\"uid\";s:32:\"a30a32d49f80bb534c062ae1743ef433\";s:3:\"css\";s:9:\"down-thin\";s:4:\"code\";i:59874;s:3:\"src\";s:6:\"entypo\";}i:557;a:4:{s:3:\"uid\";s:32:\"8d8f4722d16e95290858eaf294d9d830\";s:3:\"css\";s:9:\"left-thin\";s:4:\"code\";i:59875;s:3:\"src\";s:6:\"entypo\";}i:558;a:4:{s:3:\"uid\";s:32:\"ef3eda51383ce050517892df3fc05ffc\";s:3:\"css\";s:10:\"right-thin\";s:4:\"code\";i:59876;s:3:\"src\";s:6:\"entypo\";}i:559;a:4:{s:3:\"uid\";s:32:\"dbc97808cba7d0c135c7054e7a85fb86\";s:3:\"css\";s:7:\"up-thin\";s:4:\"code\";i:59877;s:3:\"src\";s:6:\"entypo\";}i:560;a:4:{s:3:\"uid\";s:32:\"465bb89b6f204234e5787c326b4ae54c\";s:3:\"css\";s:5:\"ccw-1\";s:4:\"code\";i:59878;s:3:\"src\";s:6:\"entypo\";}i:561;a:4:{s:3:\"uid\";s:32:\"bb46b15cb78cc4cc05d3d715d522ac4d\";s:3:\"css\";s:4:\"cw-1\";s:4:\"code\";i:59879;s:3:\"src\";s:6:\"entypo\";}i:562;a:4:{s:3:\"uid\";s:32:\"3bd18d47a12b8709e9f4fe9ead4f7518\";s:3:\"css\";s:10:\"arrows-ccw\";s:4:\"code\";i:59880;s:3:\"src\";s:6:\"entypo\";}i:563;a:4:{s:3:\"uid\";s:32:\"fa0118a65fc8dee739469f6901bbd189\";s:3:\"css\";s:12:\"level-down-1\";s:4:\"code\";i:59881;s:3:\"src\";s:6:\"entypo\";}i:564;a:4:{s:3:\"uid\";s:32:\"5308d824454af8ec7835786e272361a9\";s:3:\"css\";s:10:\"level-up-1\";s:4:\"code\";i:59882;s:3:\"src\";s:6:\"entypo\";}i:565;a:4:{s:3:\"uid\";s:32:\"3d349daaea304032a7669b4f24931b6c\";s:3:\"css\";s:9:\"shuffle-1\";s:4:\"code\";i:59883;s:3:\"src\";s:6:\"entypo\";}i:566;a:4:{s:3:\"uid\";s:32:\"8e0220796066428d6ddea96a4f1b5131\";s:3:\"css\";s:4:\"loop\";s:4:\"code\";i:59884;s:3:\"src\";s:6:\"entypo\";}i:567;a:4:{s:3:\"uid\";s:32:\"f0eac0958921fe45b85d01b79d76e86b\";s:3:\"css\";s:6:\"switch\";s:4:\"code\";i:59885;s:3:\"src\";s:6:\"entypo\";}i:568;a:4:{s:3:\"uid\";s:32:\"cb13afd4722a849d48056540bb74c47e\";s:3:\"css\";s:6:\"play-2\";s:4:\"code\";i:59886;s:3:\"src\";s:6:\"entypo\";}i:569;a:4:{s:3:\"uid\";s:32:\"48f2e18872fe74d4579a4c8a1527fc1e\";s:3:\"css\";s:6:\"stop-2\";s:4:\"code\";i:59887;s:3:\"src\";s:6:\"entypo\";}i:570;a:4:{s:3:\"uid\";s:32:\"d8d378d0ce413f231dfa37592e39c227\";s:3:\"css\";s:7:\"pause-2\";s:4:\"code\";i:59888;s:3:\"src\";s:6:\"entypo\";}i:571;a:4:{s:3:\"uid\";s:32:\"e188c02f740feff7e2d2bce1950b75fa\";s:3:\"css\";s:8:\"record-1\";s:4:\"code\";i:59889;s:3:\"src\";s:6:\"entypo\";}i:572;a:4:{s:3:\"uid\";s:32:\"0afbb00323696f49e9c47f4d9fe6390b\";s:3:\"css\";s:8:\"to-end-1\";s:4:\"code\";i:59890;s:3:\"src\";s:6:\"entypo\";}i:573;a:4:{s:3:\"uid\";s:32:\"ceefe7653a4f6edaacce9e7f196cec5a\";s:3:\"css\";s:10:\"to-start-1\";s:4:\"code\";i:59891;s:3:\"src\";s:6:\"entypo\";}i:574;a:4:{s:3:\"uid\";s:32:\"18f7c393e3532e40edd45607c9d99988\";s:3:\"css\";s:12:\"fast-forward\";s:4:\"code\";i:59892;s:3:\"src\";s:6:\"entypo\";}i:575;a:4:{s:3:\"uid\";s:32:\"85806fd8ab907f45d34f976354a0df23\";s:3:\"css\";s:13:\"fast-backward\";s:4:\"code\";i:59893;s:3:\"src\";s:6:\"entypo\";}i:576;a:4:{s:3:\"uid\";s:32:\"be998d5ee625a58912ae630f34cc8419\";s:3:\"css\";s:10:\"progress-0\";s:4:\"code\";i:59894;s:3:\"src\";s:6:\"entypo\";}i:577;a:4:{s:3:\"uid\";s:32:\"054519608bca087aa306252471dda9c4\";s:3:\"css\";s:10:\"progress-1\";s:4:\"code\";i:59895;s:3:\"src\";s:6:\"entypo\";}i:578;a:4:{s:3:\"uid\";s:32:\"3e49435dd1950a0b7543e13256c89e52\";s:3:\"css\";s:10:\"progress-2\";s:4:\"code\";i:59896;s:3:\"src\";s:6:\"entypo\";}i:579;a:4:{s:3:\"uid\";s:32:\"d924bc68683f68ecf5e09e49731fd59a\";s:3:\"css\";s:10:\"progress-3\";s:4:\"code\";i:59897;s:3:\"src\";s:6:\"entypo\";}i:580;a:4:{s:3:\"uid\";s:32:\"3eadc3e443cf1c7e17f1b44d21254c00\";s:3:\"css\";s:8:\"target-1\";s:4:\"code\";i:59898;s:3:\"src\";s:6:\"entypo\";}i:581;a:4:{s:3:\"uid\";s:32:\"80451d627470ea7f977a263fdb771d7b\";s:3:\"css\";s:7:\"palette\";s:4:\"code\";i:59899;s:3:\"src\";s:6:\"entypo\";}i:582;a:4:{s:3:\"uid\";s:32:\"3626b3f3a0b284e7f4166b815719aece\";s:3:\"css\";s:6:\"list-1\";s:4:\"code\";i:59900;s:3:\"src\";s:6:\"entypo\";}i:583;a:4:{s:3:\"uid\";s:32:\"97bd5542ed3e143d2ee9b60e14487615\";s:3:\"css\";s:8:\"list-add\";s:4:\"code\";i:59901;s:3:\"src\";s:6:\"entypo\";}i:584;a:4:{s:3:\"uid\";s:32:\"84a7262985600b683bbab0da9298776d\";s:3:\"css\";s:8:\"signal-1\";s:4:\"code\";i:59902;s:3:\"src\";s:6:\"entypo\";}i:585;a:4:{s:3:\"uid\";s:32:\"978aa8facd816df874039e139cb0cdde\";s:3:\"css\";s:6:\"trophy\";s:4:\"code\";i:59903;s:3:\"src\";s:6:\"entypo\";}i:586;a:4:{s:3:\"uid\";s:32:\"a51290161c48d96d7f2e2151a4cbcde1\";s:3:\"css\";s:7:\"battery\";s:4:\"code\";i:59904;s:3:\"src\";s:6:\"entypo\";}i:587;a:4:{s:3:\"uid\";s:32:\"89eb512cb82a1c3fe83cb16134f9876c\";s:3:\"css\";s:12:\"back-in-time\";s:4:\"code\";i:59905;s:3:\"src\";s:6:\"entypo\";}i:588;a:4:{s:3:\"uid\";s:32:\"b7a336095aa4535c3689cb557edf23db\";s:3:\"css\";s:7:\"monitor\";s:4:\"code\";i:59906;s:3:\"src\";s:6:\"entypo\";}i:589;a:4:{s:3:\"uid\";s:32:\"767fede84586366cd7d6c835be745454\";s:3:\"css\";s:8:\"mobile-1\";s:4:\"code\";i:59907;s:3:\"src\";s:6:\"entypo\";}i:590;a:4:{s:3:\"uid\";s:32:\"414fe97e4af5215a06d29be0f2cecdf5\";s:3:\"css\";s:7:\"network\";s:4:\"code\";i:59908;s:3:\"src\";s:6:\"entypo\";}i:591;a:4:{s:3:\"uid\";s:32:\"16f88519423df34fc5c48be7ded81b8f\";s:3:\"css\";s:2:\"cd\";s:4:\"code\";i:59909;s:3:\"src\";s:6:\"entypo\";}i:592;a:4:{s:3:\"uid\";s:32:\"b32d88adf7cd6bfa8d0e177dfa642a4d\";s:3:\"css\";s:7:\"inbox-1\";s:4:\"code\";i:59910;s:3:\"src\";s:6:\"entypo\";}i:593;a:4:{s:3:\"uid\";s:32:\"d83b7429002f7b0b206c8d550034212b\";s:3:\"css\";s:7:\"install\";s:4:\"code\";i:59911;s:3:\"src\";s:6:\"entypo\";}i:594;a:4:{s:3:\"uid\";s:32:\"6a12c2b74456ea21cc984e11dec227a1\";s:3:\"css\";s:7:\"globe-1\";s:4:\"code\";i:59912;s:3:\"src\";s:6:\"entypo\";}i:595;a:4:{s:3:\"uid\";s:32:\"114fed43140e2b5ce42c48b95c19375b\";s:3:\"css\";s:7:\"cloud-1\";s:4:\"code\";i:59913;s:3:\"src\";s:6:\"entypo\";}i:596;a:4:{s:3:\"uid\";s:32:\"66a40c7c0ee5ea61f4b6aa0dd0f9ebb9\";s:3:\"css\";s:13:\"cloud-thunder\";s:4:\"code\";i:59914;s:3:\"src\";s:6:\"entypo\";}i:597;a:4:{s:3:\"uid\";s:32:\"98c63f6b98c543b52d4c43bcd486d28f\";s:3:\"css\";s:7:\"flash-1\";s:4:\"code\";i:59915;s:3:\"src\";s:6:\"entypo\";}i:598;a:4:{s:3:\"uid\";s:32:\"0d03db7afd4857accf1821efdc8ea72b\";s:3:\"css\";s:6:\"moon-1\";s:4:\"code\";i:59916;s:3:\"src\";s:6:\"entypo\";}i:599;a:4:{s:3:\"uid\";s:32:\"6e8aea8fff9525dfc5149f0c03669091\";s:3:\"css\";s:8:\"flight-1\";s:4:\"code\";i:59917;s:3:\"src\";s:6:\"entypo\";}i:600;a:4:{s:3:\"uid\";s:32:\"db112402805d9dadc01ce009fbfdb914\";s:3:\"css\";s:11:\"paper-plane\";s:4:\"code\";i:59918;s:3:\"src\";s:6:\"entypo\";}i:601;a:4:{s:3:\"uid\";s:32:\"41d534223ef447a01af3e2f629ec70eb\";s:3:\"css\";s:6:\"leaf-1\";s:4:\"code\";i:59919;s:3:\"src\";s:6:\"entypo\";}i:602;a:4:{s:3:\"uid\";s:32:\"2f9f67ee4354feef8c1f51e03bac6ef3\";s:3:\"css\";s:8:\"lifebuoy\";s:4:\"code\";i:59920;s:3:\"src\";s:6:\"entypo\";}i:603;a:4:{s:3:\"uid\";s:32:\"97c6901d8db077614e77b089d4eedac8\";s:3:\"css\";s:5:\"mouse\";s:4:\"code\";i:59921;s:3:\"src\";s:6:\"entypo\";}i:604;a:4:{s:3:\"uid\";s:32:\"9ea7cce5e08e5ac2c225fabf2e6dc353\";s:3:\"css\";s:11:\"briefcase-1\";s:4:\"code\";i:59922;s:3:\"src\";s:6:\"entypo\";}i:605;a:4:{s:3:\"uid\";s:32:\"11dd26ebf6934bf750a9156b353d7f2d\";s:3:\"css\";s:10:\"suitcase-1\";s:4:\"code\";i:59923;s:3:\"src\";s:6:\"entypo\";}i:606;a:4:{s:3:\"uid\";s:32:\"d2c6b59d9a239140cb76be0627480855\";s:3:\"css\";s:3:\"dot\";s:4:\"code\";i:59924;s:3:\"src\";s:6:\"entypo\";}i:607;a:4:{s:3:\"uid\";s:32:\"13b11ab72c6ae9c97ee12428e17f3a4e\";s:3:\"css\";s:5:\"dot-2\";s:4:\"code\";i:59925;s:3:\"src\";s:6:\"entypo\";}i:608;a:4:{s:3:\"uid\";s:32:\"d10920db2e79c997c5e783279291970c\";s:3:\"css\";s:5:\"dot-3\";s:4:\"code\";i:59926;s:3:\"src\";s:6:\"entypo\";}i:609;a:4:{s:3:\"uid\";s:32:\"39c4d0e225a1263a398a47523cb5b9bd\";s:3:\"css\";s:5:\"brush\";s:4:\"code\";i:59927;s:3:\"src\";s:6:\"entypo\";}i:610;a:4:{s:3:\"uid\";s:32:\"d55e21e6468c04c5ca38a6560b27d1aa\";s:3:\"css\";s:8:\"magnet-1\";s:4:\"code\";i:59928;s:3:\"src\";s:6:\"entypo\";}i:611;a:4:{s:3:\"uid\";s:32:\"34ba50fe8e4f95e7f3d76c6534814a70\";s:3:\"css\";s:8:\"infinity\";s:4:\"code\";i:59929;s:3:\"src\";s:6:\"entypo\";}i:612;a:4:{s:3:\"uid\";s:32:\"e8239f8188c76c925be4bd1bbcc013ac\";s:3:\"css\";s:5:\"erase\";s:4:\"code\";i:59930;s:3:\"src\";s:6:\"entypo\";}i:613;a:4:{s:3:\"uid\";s:32:\"fb5082fac1794b69a1381196219a836e\";s:3:\"css\";s:9:\"chart-pie\";s:4:\"code\";i:59931;s:3:\"src\";s:6:\"entypo\";}i:614;a:4:{s:3:\"uid\";s:32:\"7184d8171b6a9b18eabbace94cca21db\";s:3:\"css\";s:10:\"chart-line\";s:4:\"code\";i:59932;s:3:\"src\";s:6:\"entypo\";}i:615;a:4:{s:3:\"uid\";s:32:\"7d90b6cb3f3783170a96b09e5f0de6d5\";s:3:\"css\";s:11:\"chart-bar-2\";s:4:\"code\";i:59933;s:3:\"src\";s:6:\"entypo\";}i:616;a:4:{s:3:\"uid\";s:32:\"32b4054f35918992f723e39f4095f005\";s:3:\"css\";s:10:\"chart-area\";s:4:\"code\";i:59934;s:3:\"src\";s:6:\"entypo\";}i:617;a:4:{s:3:\"uid\";s:32:\"ed62f5f10b256b0a959e6c847ed8f4a6\";s:3:\"css\";s:4:\"tape\";s:4:\"code\";i:59935;s:3:\"src\";s:6:\"entypo\";}i:618;a:4:{s:3:\"uid\";s:32:\"ef74ff62feda486fd414410e782b598a\";s:3:\"css\";s:14:\"graduation-cap\";s:4:\"code\";i:59936;s:3:\"src\";s:6:\"entypo\";}i:619;a:4:{s:3:\"uid\";s:32:\"ddecf5ad7935e3fb1b70dac6ed00d06a\";s:3:\"css\";s:8:\"language\";s:4:\"code\";i:59937;s:3:\"src\";s:6:\"entypo\";}i:620;a:4:{s:3:\"uid\";s:32:\"333bae7aaf7395d1004875be5a075661\";s:3:\"css\";s:8:\"ticket-1\";s:4:\"code\";i:59938;s:3:\"src\";s:6:\"entypo\";}i:621;a:4:{s:3:\"uid\";s:32:\"36a1cee80657a9c66e8384dd57bed66c\";s:3:\"css\";s:5:\"water\";s:4:\"code\";i:59939;s:3:\"src\";s:6:\"entypo\";}i:622;a:4:{s:3:\"uid\";s:32:\"4efb719e797c54b3c58e5ae061d29d53\";s:3:\"css\";s:7:\"droplet\";s:4:\"code\";i:59940;s:3:\"src\";s:6:\"entypo\";}i:623;a:4:{s:3:\"uid\";s:32:\"5f3a0ebf2d13f60ec7ed76eb41ba9bb2\";s:3:\"css\";s:3:\"air\";s:4:\"code\";i:59941;s:3:\"src\";s:6:\"entypo\";}i:624;a:4:{s:3:\"uid\";s:32:\"c5cd6ea1981cecdd85c42d9d209bc3b8\";s:3:\"css\";s:13:\"credit-card-1\";s:4:\"code\";i:59942;s:3:\"src\";s:6:\"entypo\";}i:625;a:4:{s:3:\"uid\";s:32:\"191bcf63575a78def53c907c3d3bf7f0\";s:3:\"css\";s:6:\"floppy\";s:4:\"code\";i:59943;s:3:\"src\";s:6:\"entypo\";}i:626;a:4:{s:3:\"uid\";s:32:\"b95cfc96d48a72dd665e0ab109880b5e\";s:3:\"css\";s:9:\"clipboard\";s:4:\"code\";i:59944;s:3:\"src\";s:6:\"entypo\";}i:627;a:4:{s:3:\"uid\";s:32:\"489090690d8bd1745e365485946e20a8\";s:3:\"css\";s:11:\"megaphone-1\";s:4:\"code\";i:59945;s:3:\"src\";s:6:\"entypo\";}i:628;a:4:{s:3:\"uid\";s:32:\"248db7c0563d8cee80b7041f7736dcad\";s:3:\"css\";s:8:\"database\";s:4:\"code\";i:59946;s:3:\"src\";s:6:\"entypo\";}i:629;a:4:{s:3:\"uid\";s:32:\"603d5ccab42d916e79d7c0fcdb56a614\";s:3:\"css\";s:5:\"drive\";s:4:\"code\";i:59947;s:3:\"src\";s:6:\"entypo\";}i:630;a:4:{s:3:\"uid\";s:32:\"8ea66d97faf9816abd34f48f3f26d216\";s:3:\"css\";s:6:\"bucket\";s:4:\"code\";i:59948;s:3:\"src\";s:6:\"entypo\";}i:631;a:4:{s:3:\"uid\";s:32:\"d4939d1f4e5f03f6e58900b2ac8f1c6c\";s:3:\"css\";s:11:\"thermometer\";s:4:\"code\";i:59949;s:3:\"src\";s:6:\"entypo\";}i:632;a:4:{s:3:\"uid\";s:32:\"8beac4a5fd5bed9f82ca7a96cc8ba218\";s:3:\"css\";s:5:\"key-2\";s:4:\"code\";i:59950;s:3:\"src\";s:6:\"entypo\";}i:633;a:4:{s:3:\"uid\";s:32:\"898ddc67cb7d9ae53dbd4cce78043e9e\";s:3:\"css\";s:12:\"flow-cascade\";s:4:\"code\";i:59951;s:3:\"src\";s:6:\"entypo\";}i:634;a:4:{s:3:\"uid\";s:32:\"4bcb3aaa98736be3027bef7c76c55021\";s:3:\"css\";s:11:\"flow-branch\";s:4:\"code\";i:59952;s:3:\"src\";s:6:\"entypo\";}i:635;a:4:{s:3:\"uid\";s:32:\"8a1d446e5555e76f82ddb1c8b526f579\";s:3:\"css\";s:9:\"flow-tree\";s:4:\"code\";i:59953;s:3:\"src\";s:6:\"entypo\";}i:636;a:4:{s:3:\"uid\";s:32:\"6cea40aa6cc50057083e4f0a5b92410c\";s:3:\"css\";s:9:\"flow-line\";s:4:\"code\";i:59954;s:3:\"src\";s:6:\"entypo\";}i:637;a:4:{s:3:\"uid\";s:32:\"5f88095dc5e638863a0c733e99c32568\";s:3:\"css\";s:13:\"flow-parallel\";s:4:\"code\";i:59955;s:3:\"src\";s:6:\"entypo\";}i:638;a:4:{s:3:\"uid\";s:32:\"9c7fd7637a41b59a358cb70893f945a5\";s:3:\"css\";s:8:\"rocket-1\";s:4:\"code\";i:59956;s:3:\"src\";s:6:\"entypo\";}i:639;a:4:{s:3:\"uid\";s:32:\"3a6f0140c3a390bdb203f56d1bfdefcb\";s:3:\"css\";s:7:\"gauge-1\";s:4:\"code\";i:59957;s:3:\"src\";s:6:\"entypo\";}i:640;a:4:{s:3:\"uid\";s:32:\"2bbde1076919db3d1dcc7f6b43d19bd4\";s:3:\"css\";s:12:\"traffic-cone\";s:4:\"code\";i:59958;s:3:\"src\";s:6:\"entypo\";}i:641;a:4:{s:3:\"uid\";s:32:\"4a413ef43c364dafa42766e74c31bbca\";s:3:\"css\";s:2:\"cc\";s:4:\"code\";i:59959;s:3:\"src\";s:6:\"entypo\";}i:642;a:4:{s:3:\"uid\";s:32:\"72681d2825fef7fd83711278f845547b\";s:3:\"css\";s:5:\"cc-by\";s:4:\"code\";i:59960;s:3:\"src\";s:6:\"entypo\";}i:643;a:4:{s:3:\"uid\";s:32:\"7540520e12e941839cdb7d76b12e82a8\";s:3:\"css\";s:5:\"cc-nc\";s:4:\"code\";i:59961;s:3:\"src\";s:6:\"entypo\";}i:644;a:4:{s:3:\"uid\";s:32:\"2d741e29010c6afbfc3784251fbf4e8b\";s:3:\"css\";s:8:\"cc-nc-eu\";s:4:\"code\";i:59962;s:3:\"src\";s:6:\"entypo\";}i:645;a:4:{s:3:\"uid\";s:32:\"3138d5e10d50279c6d97ad1c99fdb584\";s:3:\"css\";s:8:\"cc-nc-jp\";s:4:\"code\";i:59963;s:3:\"src\";s:6:\"entypo\";}i:646;a:4:{s:3:\"uid\";s:32:\"900851106d63af1bc6076ae118dc543d\";s:3:\"css\";s:5:\"cc-sa\";s:4:\"code\";i:59964;s:3:\"src\";s:6:\"entypo\";}i:647;a:4:{s:3:\"uid\";s:32:\"b92e2a918daa2f9a042df1ce942b686f\";s:3:\"css\";s:5:\"cc-nd\";s:4:\"code\";i:59965;s:3:\"src\";s:6:\"entypo\";}i:648;a:4:{s:3:\"uid\";s:32:\"49679f26492c29c7bc277f1de9249229\";s:3:\"css\";s:5:\"cc-pd\";s:4:\"code\";i:59966;s:3:\"src\";s:6:\"entypo\";}i:649;a:4:{s:3:\"uid\";s:32:\"94914cbbfba692ebbc13c179d62355f7\";s:3:\"css\";s:7:\"cc-zero\";s:4:\"code\";i:59967;s:3:\"src\";s:6:\"entypo\";}i:650;a:4:{s:3:\"uid\";s:32:\"915c11e4e2e713cc7d65d32d66f004bf\";s:3:\"css\";s:8:\"cc-share\";s:4:\"code\";i:59968;s:3:\"src\";s:6:\"entypo\";}i:651;a:4:{s:3:\"uid\";s:32:\"0cd7be54280d9ffbe0f48342c011268e\";s:3:\"css\";s:8:\"cc-remix\";s:4:\"code\";i:59969;s:3:\"src\";s:6:\"entypo\";}i:652;a:4:{s:3:\"uid\";s:32:\"d94334f23acba022bfd68e49d76b31bb\";s:3:\"css\";s:8:\"github-1\";s:4:\"code\";i:59970;s:3:\"src\";s:6:\"entypo\";}i:653;a:4:{s:3:\"uid\";s:32:\"91daf8fde1042a363514ca7e42d89570\";s:3:\"css\";s:16:\"github-circled-1\";s:4:\"code\";i:59971;s:3:\"src\";s:6:\"entypo\";}i:654;a:4:{s:3:\"uid\";s:32:\"14cfd18cc1dd5fb99ba04311b888bc23\";s:3:\"css\";s:8:\"flickr-1\";s:4:\"code\";i:59972;s:3:\"src\";s:6:\"entypo\";}i:655;a:4:{s:3:\"uid\";s:32:\"5bbd46b2a0b972533f4d3ef243645e1d\";s:3:\"css\";s:14:\"flickr-circled\";s:4:\"code\";i:59973;s:3:\"src\";s:6:\"entypo\";}i:656;a:4:{s:3:\"uid\";s:32:\"538531af0e023b15882c505ee2297cbe\";s:3:\"css\";s:5:\"vimeo\";s:4:\"code\";i:59974;s:3:\"src\";s:6:\"entypo\";}i:657;a:4:{s:3:\"uid\";s:32:\"6569bd1801e232180221ba0f6a4b8b27\";s:3:\"css\";s:13:\"vimeo-circled\";s:4:\"code\";i:59975;s:3:\"src\";s:6:\"entypo\";}i:658;a:4:{s:3:\"uid\";s:32:\"d090355c31f497b61d676416c1fd39fb\";s:3:\"css\";s:9:\"twitter-1\";s:4:\"code\";i:59976;s:3:\"src\";s:6:\"entypo\";}i:659;a:4:{s:3:\"uid\";s:32:\"0419da6446cb4f31093e2022793571ca\";s:3:\"css\";s:15:\"twitter-circled\";s:4:\"code\";i:59977;s:3:\"src\";s:6:\"entypo\";}i:660;a:4:{s:3:\"uid\";s:32:\"bc50457410acf467b8b5721240768742\";s:3:\"css\";s:10:\"facebook-1\";s:4:\"code\";i:59978;s:3:\"src\";s:6:\"entypo\";}i:661;a:4:{s:3:\"uid\";s:32:\"ce1d525f3f31024c6a6b38f5e9a88953\";s:3:\"css\";s:16:\"facebook-circled\";s:4:\"code\";i:59979;s:3:\"src\";s:6:\"entypo\";}i:662;a:4:{s:3:\"uid\";s:32:\"47bd87a650e95b97f947d275ed968efe\";s:3:\"css\";s:18:\"facebook-squared-1\";s:4:\"code\";i:59980;s:3:\"src\";s:6:\"entypo\";}i:663;a:4:{s:3:\"uid\";s:32:\"b945f4ac2439565661e8e4878e35d379\";s:3:\"css\";s:7:\"gplus-1\";s:4:\"code\";i:59981;s:3:\"src\";s:6:\"entypo\";}i:664;a:4:{s:3:\"uid\";s:32:\"818a6c2a76c89800632c0335e9cdafee\";s:3:\"css\";s:13:\"gplus-circled\";s:4:\"code\";i:59982;s:3:\"src\";s:6:\"entypo\";}i:665;a:4:{s:3:\"uid\";s:32:\"689febe699d74bc8862965555503e445\";s:3:\"css\";s:9:\"pinterest\";s:4:\"code\";i:59983;s:3:\"src\";s:6:\"entypo\";}i:666;a:4:{s:3:\"uid\";s:32:\"2e9c0fdd4d59598cb122801ab80222e7\";s:3:\"css\";s:19:\"pinterest-circled-1\";s:4:\"code\";i:59984;s:3:\"src\";s:6:\"entypo\";}i:667;a:4:{s:3:\"uid\";s:32:\"d491462e64eb5b8c4f064108a2ff1780\";s:3:\"css\";s:8:\"tumblr-1\";s:4:\"code\";i:59985;s:3:\"src\";s:6:\"entypo\";}i:668;a:4:{s:3:\"uid\";s:32:\"72a6237752f5cd00a107d097adac9ce3\";s:3:\"css\";s:14:\"tumblr-circled\";s:4:\"code\";i:59986;s:3:\"src\";s:6:\"entypo\";}i:669;a:4:{s:3:\"uid\";s:32:\"7132e1233bc16cd1b6efe7e29d3613a5\";s:3:\"css\";s:10:\"linkedin-1\";s:4:\"code\";i:59987;s:3:\"src\";s:6:\"entypo\";}i:670;a:4:{s:3:\"uid\";s:32:\"21adad41ffebf469b2370d26bcb8a3c4\";s:3:\"css\";s:16:\"linkedin-circled\";s:4:\"code\";i:59988;s:3:\"src\";s:6:\"entypo\";}i:671;a:4:{s:3:\"uid\";s:32:\"e8d13cd05bd63219329b2b61835d776c\";s:3:\"css\";s:10:\"dribbble-1\";s:4:\"code\";i:59989;s:3:\"src\";s:6:\"entypo\";}i:672;a:4:{s:3:\"uid\";s:32:\"ec3e0b50a56867ac26a6de47953b9831\";s:3:\"css\";s:16:\"dribbble-circled\";s:4:\"code\";i:59990;s:3:\"src\";s:6:\"entypo\";}i:673;a:4:{s:3:\"uid\";s:32:\"ef5e2b339a93fff038cc6a28f8c91edd\";s:3:\"css\";s:11:\"stumbleupon\";s:4:\"code\";i:59991;s:3:\"src\";s:6:\"entypo\";}i:674;a:4:{s:3:\"uid\";s:32:\"e3606432570e59d4d852727bad063cd1\";s:3:\"css\";s:19:\"stumbleupon-circled\";s:4:\"code\";i:59992;s:3:\"src\";s:6:\"entypo\";}i:675;a:4:{s:3:\"uid\";s:32:\"ae49d5a5d0c2f7253f375bde5f0da2d2\";s:3:\"css\";s:6:\"lastfm\";s:4:\"code\";i:59993;s:3:\"src\";s:6:\"entypo\";}i:676;a:4:{s:3:\"uid\";s:32:\"9eedcbf6e07d6ba820e3e22f5ab6f734\";s:3:\"css\";s:14:\"lastfm-circled\";s:4:\"code\";i:59994;s:3:\"src\";s:6:\"entypo\";}i:677;a:4:{s:3:\"uid\";s:32:\"406d96226bd9d021b7d976efa1c4a061\";s:3:\"css\";s:4:\"rdio\";s:4:\"code\";i:59995;s:3:\"src\";s:6:\"entypo\";}i:678;a:4:{s:3:\"uid\";s:32:\"4d8e1f1173bab9aac8991e9eee2fa326\";s:3:\"css\";s:12:\"rdio-circled\";s:4:\"code\";i:59996;s:3:\"src\";s:6:\"entypo\";}i:679;a:4:{s:3:\"uid\";s:32:\"882d407598d4e60074f5c08b3372811e\";s:3:\"css\";s:7:\"spotify\";s:4:\"code\";i:59997;s:3:\"src\";s:6:\"entypo\";}i:680;a:4:{s:3:\"uid\";s:32:\"067edf3e1f6458e782d0254e63eb5eb6\";s:3:\"css\";s:15:\"spotify-circled\";s:4:\"code\";i:59998;s:3:\"src\";s:6:\"entypo\";}i:681;a:4:{s:3:\"uid\";s:32:\"935e2e437efbb3a69ed9a83e2d2f637e\";s:3:\"css\";s:2:\"qq\";s:4:\"code\";i:59999;s:3:\"src\";s:6:\"entypo\";}i:682;a:4:{s:3:\"uid\";s:32:\"0fbfb1cd7a847c88ea4c141d0e1bbdb5\";s:3:\"css\";s:9:\"instagram\";s:4:\"code\";i:60000;s:3:\"src\";s:6:\"entypo\";}i:683;a:4:{s:3:\"uid\";s:32:\"b22fdf6cbaa9c54fbb0bc9abb0ed4098\";s:3:\"css\";s:9:\"dropbox-1\";s:4:\"code\";i:60001;s:3:\"src\";s:6:\"entypo\";}i:684;a:4:{s:3:\"uid\";s:32:\"ce291d00162e998dbf5cb81bc5edff75\";s:3:\"css\";s:8:\"evernote\";s:4:\"code\";i:60002;s:3:\"src\";s:6:\"entypo\";}i:685;a:4:{s:3:\"uid\";s:32:\"4274fc9f6190d330fcdf61e7ad564370\";s:3:\"css\";s:6:\"flattr\";s:4:\"code\";i:60003;s:3:\"src\";s:6:\"entypo\";}i:686;a:4:{s:3:\"uid\";s:32:\"28ccaf022b8363aeaa5b86f66e1f5173\";s:3:\"css\";s:7:\"skype-1\";s:4:\"code\";i:60004;s:3:\"src\";s:6:\"entypo\";}i:687;a:4:{s:3:\"uid\";s:32:\"8354734770d837204e6a004885240d2e\";s:3:\"css\";s:13:\"skype-circled\";s:4:\"code\";i:60005;s:3:\"src\";s:6:\"entypo\";}i:688;a:4:{s:3:\"uid\";s:32:\"7fe35dea791456114c356934333b4171\";s:3:\"css\";s:8:\"renren-1\";s:4:\"code\";i:60006;s:3:\"src\";s:6:\"entypo\";}i:689;a:4:{s:3:\"uid\";s:32:\"d1945696d6bbbf84e388df9961f26a37\";s:3:\"css\";s:10:\"sina-weibo\";s:4:\"code\";i:60007;s:3:\"src\";s:6:\"entypo\";}i:690;a:4:{s:3:\"uid\";s:32:\"8d584f31a5d54de313f1f3da28708ec0\";s:3:\"css\";s:6:\"paypal\";s:4:\"code\";i:60008;s:3:\"src\";s:6:\"entypo\";}i:691;a:4:{s:3:\"uid\";s:32:\"07269ba9c8905d091e1a01beab1f0958\";s:3:\"css\";s:6:\"picasa\";s:4:\"code\";i:60009;s:3:\"src\";s:6:\"entypo\";}i:692;a:4:{s:3:\"uid\";s:32:\"b86600decaba538aca184421752cd640\";s:3:\"css\";s:10:\"soundcloud\";s:4:\"code\";i:60010;s:3:\"src\";s:6:\"entypo\";}i:693;a:4:{s:3:\"uid\";s:32:\"c510878e39f27f3fb4e6171148829962\";s:3:\"css\";s:4:\"mixi\";s:4:\"code\";i:60011;s:3:\"src\";s:6:\"entypo\";}i:694;a:4:{s:3:\"uid\";s:32:\"84f3880057574e968053d6d6c8a7b216\";s:3:\"css\";s:7:\"behance\";s:4:\"code\";i:60012;s:3:\"src\";s:6:\"entypo\";}i:695;a:4:{s:3:\"uid\";s:32:\"5a24a9d2bffe3b66cea31ed2f57fb65a\";s:3:\"css\";s:14:\"google-circles\";s:4:\"code\";i:60013;s:3:\"src\";s:6:\"entypo\";}i:696;a:4:{s:3:\"uid\";s:32:\"c9a7eca58474311926922ff8c2c1d256\";s:3:\"css\";s:11:\"vkontakte-1\";s:4:\"code\";i:60014;s:3:\"src\";s:6:\"entypo\";}i:697;a:4:{s:3:\"uid\";s:32:\"2e97984c1130787e123117d4cacc07fa\";s:3:\"css\";s:8:\"smashing\";s:4:\"code\";i:60015;s:3:\"src\";s:6:\"entypo\";}i:698;a:4:{s:3:\"uid\";s:32:\"c22c5fa36d200793ad39b984fb5c8610\";s:3:\"css\";s:6:\"sweden\";s:4:\"code\";i:60016;s:3:\"src\";s:6:\"entypo\";}i:699;a:4:{s:3:\"uid\";s:32:\"e9ede58f5f90bbc3e52bf4bf53da71c0\";s:3:\"css\";s:8:\"db-shape\";s:4:\"code\";i:60017;s:3:\"src\";s:6:\"entypo\";}i:700;a:4:{s:3:\"uid\";s:32:\"ea16996158db7b9fedf060a4f44b27ee\";s:3:\"css\";s:7:\"logo-db\";s:4:\"code\";i:60018;s:3:\"src\";s:6:\"entypo\";}i:701;a:4:{s:3:\"uid\";s:32:\"b1c81b3df9f4a9b8c393f405bb5293d8\";s:3:\"css\";s:13:\"music-outline\";s:4:\"code\";i:60994;s:3:\"src\";s:8:\"typicons\";}i:702;a:4:{s:3:\"uid\";s:32:\"5rarhtgcreeh8evuaqd8zoekgehkt3mm\";s:3:\"css\";s:7:\"music-2\";s:4:\"code\";i:60995;s:3:\"src\";s:8:\"typicons\";}i:703;a:4:{s:3:\"uid\";s:32:\"1be0ad37c941fcc88233d38c2e460cf5\";s:3:\"css\";s:14:\"search-outline\";s:4:\"code\";i:60996;s:3:\"src\";s:8:\"typicons\";}i:704;a:4:{s:3:\"uid\";s:32:\"t6cy82vd3t5piy0j3uknrlrzpg1ld8y3\";s:3:\"css\";s:6:\"search\";s:4:\"code\";i:60997;s:3:\"src\";s:8:\"typicons\";}i:705;a:4:{s:3:\"uid\";s:32:\"wg849ixsobykxshs6efpc6fk4m0fq8bh\";s:3:\"css\";s:4:\"mail\";s:4:\"code\";i:60998;s:3:\"src\";s:8:\"typicons\";}i:706;a:4:{s:3:\"uid\";s:32:\"3b00728aa97ad1a2581d414bd9d650bc\";s:3:\"css\";s:5:\"heart\";s:4:\"code\";i:60999;s:3:\"src\";s:8:\"typicons\";}i:707;a:4:{s:3:\"uid\";s:32:\"hi76m8qggwn5lbl286oeqp64q0n8kusy\";s:3:\"css\";s:12:\"heart-filled\";s:4:\"code\";i:61000;s:3:\"src\";s:8:\"typicons\";}i:708;a:4:{s:3:\"uid\";s:32:\"bcdc294bb787b15203b82f2be8096548\";s:3:\"css\";s:4:\"star\";s:4:\"code\";i:61001;s:3:\"src\";s:8:\"typicons\";}i:709;a:4:{s:3:\"uid\";s:32:\"vyuzsm6wijlfwtjo4ifkoblfmsepk6g8\";s:3:\"css\";s:11:\"star-filled\";s:4:\"code\";i:61002;s:3:\"src\";s:8:\"typicons\";}i:710;a:4:{s:3:\"uid\";s:32:\"8ed4884bf9b840729eef8f0bbd2b1dbb\";s:3:\"css\";s:12:\"user-outline\";s:4:\"code\";i:61003;s:3:\"src\";s:8:\"typicons\";}i:711;a:4:{s:3:\"uid\";s:32:\"bczb7qup4axmc490xmuuv8qdhcnbgeyf\";s:3:\"css\";s:4:\"user\";s:4:\"code\";i:61004;s:3:\"src\";s:8:\"typicons\";}i:712;a:4:{s:3:\"uid\";s:32:\"a1d4b614f12cfe2b5aa66313ad88c90c\";s:3:\"css\";s:13:\"users-outline\";s:4:\"code\";i:61005;s:3:\"src\";s:8:\"typicons\";}i:713;a:4:{s:3:\"uid\";s:32:\"x8m4z7b33cv1h2s784tjlam56uq40wtd\";s:3:\"css\";s:7:\"users-1\";s:4:\"code\";i:61006;s:3:\"src\";s:8:\"typicons\";}i:714;a:4:{s:3:\"uid\";s:32:\"b9cd6e266f74ac97272b2fabbfbd0b85\";s:3:\"css\";s:16:\"user-add-outline\";s:4:\"code\";i:61007;s:3:\"src\";s:8:\"typicons\";}i:715;a:4:{s:3:\"uid\";s:32:\"076f940ac56adee91dd43d6fd77dd0cf\";s:3:\"css\";s:8:\"user-add\";s:4:\"code\";i:61008;s:3:\"src\";s:8:\"typicons\";}i:716;a:4:{s:3:\"uid\";s:32:\"344c1c070cd0018ced51d3f051c6f4dd\";s:3:\"css\";s:19:\"user-delete-outline\";s:4:\"code\";i:61009;s:3:\"src\";s:8:\"typicons\";}i:717;a:4:{s:3:\"uid\";s:32:\"d139ce97a43aedd333fa40f776328c3c\";s:3:\"css\";s:11:\"user-delete\";s:4:\"code\";i:61010;s:3:\"src\";s:8:\"typicons\";}i:718;a:4:{s:3:\"uid\";s:32:\"342dd4f00ec75318e1484d360cc21871\";s:3:\"css\";s:5:\"video\";s:4:\"code\";i:61011;s:3:\"src\";s:8:\"typicons\";}i:719;a:4:{s:3:\"uid\";s:32:\"3d8b20949cd6f782067f9e652967f8a8\";s:3:\"css\";s:16:\"videocam-outline\";s:4:\"code\";i:61012;s:3:\"src\";s:8:\"typicons\";}i:720;a:4:{s:3:\"uid\";s:32:\"fa92c2529910e6958311b673ebf307e2\";s:3:\"css\";s:8:\"videocam\";s:4:\"code\";i:61013;s:3:\"src\";s:8:\"typicons\";}i:721;a:4:{s:3:\"uid\";s:32:\"96819a35f3d743b4df0ea2e92803eeb5\";s:3:\"css\";s:15:\"picture-outline\";s:4:\"code\";i:61014;s:3:\"src\";s:8:\"typicons\";}i:722;a:4:{s:3:\"uid\";s:32:\"6a7ed3214c9049148cbdb01825e5efc2\";s:3:\"css\";s:9:\"picture-1\";s:4:\"code\";i:61015;s:3:\"src\";s:8:\"typicons\";}i:723;a:4:{s:3:\"uid\";s:32:\"05de65980bb8a3711da037c2cc25f4f8\";s:3:\"css\";s:14:\"camera-outline\";s:4:\"code\";i:61016;s:3:\"src\";s:8:\"typicons\";}i:724;a:4:{s:3:\"uid\";s:32:\"aklhk54yg779pgovdsjr9r9w22hej00n\";s:3:\"css\";s:8:\"camera-1\";s:4:\"code\";i:61017;s:3:\"src\";s:8:\"typicons\";}i:725;a:4:{s:3:\"uid\";s:32:\"a0af0ba081a37bac0783788042ea1774\";s:3:\"css\";s:10:\"th-outline\";s:4:\"code\";i:61018;s:3:\"src\";s:8:\"typicons\";}i:726;a:4:{s:3:\"uid\";s:32:\"9x8p16w516pn1b19chr85japkedporm7\";s:3:\"css\";s:4:\"th-1\";s:4:\"code\";i:61019;s:3:\"src\";s:8:\"typicons\";}i:727;a:4:{s:3:\"uid\";s:32:\"08db5357646aae59e018ba87f2d466cd\";s:3:\"css\";s:16:\"th-large-outline\";s:4:\"code\";i:61020;s:3:\"src\";s:8:\"typicons\";}i:728;a:4:{s:3:\"uid\";s:32:\"e903698d494785d5e9328f0645da81bb\";s:3:\"css\";s:10:\"th-large-1\";s:4:\"code\";i:61021;s:3:\"src\";s:8:\"typicons\";}i:729;a:4:{s:3:\"uid\";s:32:\"43855c51ebf847e8d581b794e4126dfe\";s:3:\"css\";s:15:\"th-list-outline\";s:4:\"code\";i:61022;s:3:\"src\";s:8:\"typicons\";}i:730;a:4:{s:3:\"uid\";s:32:\"lu2wqmd7v9zp21knhy4eifo41wjp4cnx\";s:3:\"css\";s:9:\"th-list-1\";s:4:\"code\";i:61023;s:3:\"src\";s:8:\"typicons\";}i:731;a:4:{s:3:\"uid\";s:32:\"40c9502d45c736a0a6ec45e6fbc28656\";s:3:\"css\";s:10:\"ok-outline\";s:4:\"code\";i:61024;s:3:\"src\";s:8:\"typicons\";}i:732;a:4:{s:3:\"uid\";s:32:\"43fl9m553j1z5937vfjz0lgolrlspxwl\";s:3:\"css\";s:2:\"ok\";s:4:\"code\";i:61025;s:3:\"src\";s:8:\"typicons\";}i:733;a:4:{s:3:\"uid\";s:32:\"24aba8757d4a7b49568c98a577a85df3\";s:3:\"css\";s:14:\"cancel-outline\";s:4:\"code\";i:61026;s:3:\"src\";s:8:\"typicons\";}i:734;a:4:{s:3:\"uid\";s:32:\"1dq4tek4k8ea7zlj4kc3w83itnutaxg5\";s:3:\"css\";s:6:\"cancel\";s:4:\"code\";i:61027;s:3:\"src\";s:8:\"typicons\";}i:735;a:4:{s:3:\"uid\";s:32:\"3df1557e2d6e84ec32bd47aee5bfdf59\";s:3:\"css\";s:10:\"cancel-alt\";s:4:\"code\";i:61028;s:3:\"src\";s:8:\"typicons\";}i:736;a:4:{s:3:\"uid\";s:32:\"l11ixzfrief0chds7elurdm2ot98xp4l\";s:3:\"css\";s:17:\"cancel-alt-filled\";s:4:\"code\";i:61029;s:3:\"src\";s:8:\"typicons\";}i:737;a:4:{s:3:\"uid\";s:32:\"517522647a556192fbc78aa391b7b0c2\";s:3:\"css\";s:22:\"cancel-circled-outline\";s:4:\"code\";i:61030;s:3:\"src\";s:8:\"typicons\";}i:738;a:4:{s:3:\"uid\";s:32:\"3327862df439988139b61814143b7a42\";s:3:\"css\";s:16:\"cancel-circled-2\";s:4:\"code\";i:61031;s:3:\"src\";s:8:\"typicons\";}i:739;a:4:{s:3:\"uid\";s:32:\"0677f879e75956571d8cbbb478487c47\";s:3:\"css\";s:12:\"plus-outline\";s:4:\"code\";i:61032;s:3:\"src\";s:8:\"typicons\";}i:740;a:4:{s:3:\"uid\";s:32:\"1gf923f9wvaezxmfon515dglxa3drf0e\";s:3:\"css\";s:4:\"plus\";s:4:\"code\";i:61033;s:3:\"src\";s:8:\"typicons\";}i:741;a:4:{s:3:\"uid\";s:32:\"7b67ab93e2dd09f8884b574925ab9352\";s:3:\"css\";s:13:\"minus-outline\";s:4:\"code\";i:61034;s:3:\"src\";s:8:\"typicons\";}i:742;a:4:{s:3:\"uid\";s:32:\"qab5uvjyoc3uu4d2pvt8soshtgkuvpak\";s:3:\"css\";s:7:\"minus-1\";s:4:\"code\";i:61035;s:3:\"src\";s:8:\"typicons\";}i:743;a:4:{s:3:\"uid\";s:32:\"c7b7ea4719f6592a6b36f8d041226e37\";s:3:\"css\";s:14:\"divide-outline\";s:4:\"code\";i:61036;s:3:\"src\";s:8:\"typicons\";}i:744;a:4:{s:3:\"uid\";s:32:\"863fa3cea75a505bbc420a1db8b6b89b\";s:3:\"css\";s:6:\"divide\";s:4:\"code\";i:61037;s:3:\"src\";s:8:\"typicons\";}i:745;a:4:{s:3:\"uid\";s:32:\"f8d0a7a987fa0384bfd7e08000ec1476\";s:3:\"css\";s:10:\"eq-outline\";s:4:\"code\";i:61038;s:3:\"src\";s:8:\"typicons\";}i:746;a:4:{s:3:\"uid\";s:32:\"yb3vdwfxck5hmudxna4fq8fcwo9xari9\";s:3:\"css\";s:2:\"eq\";s:4:\"code\";i:61039;s:3:\"src\";s:8:\"typicons\";}i:747;a:4:{s:3:\"uid\";s:32:\"6364d85e960f23b9a843a506387e7970\";s:3:\"css\";s:12:\"info-outline\";s:4:\"code\";i:61040;s:3:\"src\";s:8:\"typicons\";}i:748;a:4:{s:3:\"uid\";s:32:\"85fda3129wk4amvn25wrq843sbj3yzl0\";s:3:\"css\";s:6:\"info-1\";s:4:\"code\";i:61041;s:3:\"src\";s:8:\"typicons\";}i:749;a:4:{s:3:\"uid\";s:32:\"a42f298da5c64e646a5d532724cd6e15\";s:3:\"css\";s:12:\"home-outline\";s:4:\"code\";i:61042;s:3:\"src\";s:8:\"typicons\";}i:750;a:4:{s:3:\"uid\";s:32:\"w3nzesrlbezu6f30q7ytyq919p6gdlb6\";s:3:\"css\";s:6:\"home-1\";s:4:\"code\";i:61043;s:3:\"src\";s:8:\"typicons\";}i:751;a:4:{s:3:\"uid\";s:32:\"3562ca2f2f16f6629b5ffabfe3cfa5a7\";s:3:\"css\";s:12:\"link-outline\";s:4:\"code\";i:61044;s:3:\"src\";s:8:\"typicons\";}i:752;a:4:{s:3:\"uid\";s:32:\"45g23adv6rwe7nokwek4d471h8y09ayz\";s:3:\"css\";s:6:\"link-1\";s:4:\"code\";i:61045;s:3:\"src\";s:8:\"typicons\";}i:753;a:4:{s:3:\"uid\";s:32:\"6310fc4804f3ffaebc4436ee30f3856e\";s:3:\"css\";s:14:\"attach-outline\";s:4:\"code\";i:61046;s:3:\"src\";s:8:\"typicons\";}i:754;a:4:{s:3:\"uid\";s:32:\"0f81c70dd389bf78f46387b794f2573f\";s:3:\"css\";s:8:\"attach-1\";s:4:\"code\";i:61047;s:3:\"src\";s:8:\"typicons\";}i:755;a:4:{s:3:\"uid\";s:32:\"3e1bb74572a30486bd647304d9fcaff6\";s:3:\"css\";s:6:\"lock-1\";s:4:\"code\";i:61048;s:3:\"src\";s:8:\"typicons\";}i:756;a:4:{s:3:\"uid\";s:32:\"4x5p6fnblkhqsj4ibuc724faotghuiaq\";s:3:\"css\";s:11:\"lock-filled\";s:4:\"code\";i:61049;s:3:\"src\";s:8:\"typicons\";}i:757;a:4:{s:3:\"uid\";s:32:\"75cff40f03567673e13b0e7d005b7741\";s:3:\"css\";s:11:\"lock-open-1\";s:4:\"code\";i:61050;s:3:\"src\";s:8:\"typicons\";}i:758;a:4:{s:3:\"uid\";s:32:\"a33vyvfsje6eklq8loqtzb1jcgo37onm\";s:3:\"css\";s:16:\"lock-open-filled\";s:4:\"code\";i:61051;s:3:\"src\";s:8:\"typicons\";}i:759;a:4:{s:3:\"uid\";s:32:\"6373242453e92e8ce419b8391463867a\";s:3:\"css\";s:11:\"pin-outline\";s:4:\"code\";i:61052;s:3:\"src\";s:8:\"typicons\";}i:760;a:4:{s:3:\"uid\";s:32:\"p57wgnf4glngbchbucdi029iptu8oxb8\";s:3:\"css\";s:5:\"pin-1\";s:4:\"code\";i:61053;s:3:\"src\";s:8:\"typicons\";}i:761;a:4:{s:3:\"uid\";s:32:\"366c3c56b79031deacc953d7f92085e5\";s:3:\"css\";s:11:\"eye-outline\";s:4:\"code\";i:61054;s:3:\"src\";s:8:\"typicons\";}i:762;a:4:{s:3:\"uid\";s:32:\"k7sao112253txym1egnte7822irbyphe\";s:3:\"css\";s:5:\"eye-1\";s:4:\"code\";i:61055;s:3:\"src\";s:8:\"typicons\";}i:763;a:4:{s:3:\"uid\";s:32:\"z2kx6nr3u9112p0e1pfhxdhva9v7kd4k\";s:3:\"css\";s:5:\"tag-2\";s:4:\"code\";i:61056;s:3:\"src\";s:8:\"typicons\";}i:764;a:4:{s:3:\"uid\";s:32:\"e417e4ca7774bb0f4aca5278ae3bfe49\";s:3:\"css\";s:6:\"tags-1\";s:4:\"code\";i:61057;s:3:\"src\";s:8:\"typicons\";}i:765;a:4:{s:3:\"uid\";s:32:\"gr2i0fsmy50yfjhz6defsqkexnmctv8z\";s:3:\"css\";s:10:\"bookmark-2\";s:4:\"code\";i:61058;s:3:\"src\";s:8:\"typicons\";}i:766;a:4:{s:3:\"uid\";s:32:\"d91495faa39f7bc987caa15275d96ae8\";s:3:\"css\";s:6:\"flag-2\";s:4:\"code\";i:61059;s:3:\"src\";s:8:\"typicons\";}i:767;a:4:{s:3:\"uid\";s:32:\"4i0s2bklai5fywieqm4dqqngfz9ptfab\";s:3:\"css\";s:11:\"flag-filled\";s:4:\"code\";i:61060;s:3:\"src\";s:8:\"typicons\";}i:768;a:4:{s:3:\"uid\";s:32:\"tau7t0t38662eqxrb80ozeiase5em2x9\";s:3:\"css\";s:11:\"thumbs-up-1\";s:4:\"code\";i:61061;s:3:\"src\";s:8:\"typicons\";}i:769;a:4:{s:3:\"uid\";s:32:\"ani12ucvy2plqmykysnk4zd9i24cmxqp\";s:3:\"css\";s:13:\"thumbs-down-1\";s:4:\"code\";i:61062;s:3:\"src\";s:8:\"typicons\";}i:770;a:4:{s:3:\"uid\";s:32:\"86157b2f942e37940f8702a4a3221a2b\";s:3:\"css\";s:16:\"download-outline\";s:4:\"code\";i:61063;s:3:\"src\";s:8:\"typicons\";}i:771;a:4:{s:3:\"uid\";s:32:\"7yekfd0qlkgp6emwfbo10sjdmf8pewli\";s:3:\"css\";s:10:\"download-2\";s:4:\"code\";i:61064;s:3:\"src\";s:8:\"typicons\";}i:772;a:4:{s:3:\"uid\";s:32:\"9367acef93427f6301ee8ab42d45def7\";s:3:\"css\";s:14:\"upload-outline\";s:4:\"code\";i:61065;s:3:\"src\";s:8:\"typicons\";}i:773;a:4:{s:3:\"uid\";s:32:\"f156d14a32cd7d5bc5a5f70382ab04ec\";s:3:\"css\";s:8:\"upload-2\";s:4:\"code\";i:61066;s:3:\"src\";s:8:\"typicons\";}i:774;a:4:{s:3:\"uid\";s:32:\"e9bce795d01ef5a058c63cab0a03dc66\";s:3:\"css\";s:20:\"upload-cloud-outline\";s:4:\"code\";i:61067;s:3:\"src\";s:8:\"typicons\";}i:775;a:4:{s:3:\"uid\";s:32:\"4e77fc7fc71e69ba520ffa3b4d898e55\";s:3:\"css\";s:14:\"upload-cloud-2\";s:4:\"code\";i:61068;s:3:\"src\";s:8:\"typicons\";}i:776;a:4:{s:3:\"uid\";s:32:\"c60f50a1729165e3752fa27a16325208\";s:3:\"css\";s:13:\"reply-outline\";s:4:\"code\";i:61069;s:3:\"src\";s:8:\"typicons\";}i:777;a:4:{s:3:\"uid\";s:32:\"28r0xthd180mg0wnfh8ek3mtn761hs11\";s:3:\"css\";s:7:\"reply-2\";s:4:\"code\";i:61070;s:3:\"src\";s:8:\"typicons\";}i:778;a:4:{s:3:\"uid\";s:32:\"ca92083691d138f832d6a9874d7636dc\";s:3:\"css\";s:15:\"forward-outline\";s:4:\"code\";i:61071;s:3:\"src\";s:8:\"typicons\";}i:779;a:4:{s:3:\"uid\";s:32:\"7p5gflyid3o4gtesy94a6erq94e4pz7u\";s:3:\"css\";s:9:\"forward-2\";s:4:\"code\";i:61072;s:3:\"src\";s:8:\"typicons\";}i:780;a:4:{s:3:\"uid\";s:32:\"9e02faeda1ede96a076b72260f44e4b5\";s:3:\"css\";s:12:\"code-outline\";s:4:\"code\";i:61073;s:3:\"src\";s:8:\"typicons\";}i:781;a:4:{s:3:\"uid\";s:32:\"8b202d3dd1fd0541ed0d47d1279ec8f3\";s:3:\"css\";s:6:\"code-1\";s:4:\"code\";i:61074;s:3:\"src\";s:8:\"typicons\";}i:782;a:4:{s:3:\"uid\";s:32:\"44a6b866f720a1d2b11bf05023a4e089\";s:3:\"css\";s:14:\"export-outline\";s:4:\"code\";i:61075;s:3:\"src\";s:8:\"typicons\";}i:783;a:4:{s:3:\"uid\";s:32:\"wh8nbtrxjl2f67dpybsww6mri0xcaklm\";s:3:\"css\";s:8:\"export-2\";s:4:\"code\";i:61076;s:3:\"src\";s:8:\"typicons\";}i:784;a:4:{s:3:\"uid\";s:32:\"1e77a2yvsq3owssduo2lcgsiven57iv5\";s:3:\"css\";s:8:\"pencil-1\";s:4:\"code\";i:61077;s:3:\"src\";s:8:\"typicons\";}i:785;a:4:{s:3:\"uid\";s:32:\"8e50efd23ddcb26f05878476c2c1ce8f\";s:3:\"css\";s:3:\"pen\";s:4:\"code\";i:61078;s:3:\"src\";s:8:\"typicons\";}i:786;a:4:{s:3:\"uid\";s:32:\"d78522fbabf6251440fe30463756192c\";s:3:\"css\";s:9:\"feather-1\";s:4:\"code\";i:61079;s:3:\"src\";s:8:\"typicons\";}i:787;a:4:{s:3:\"uid\";s:32:\"jqzwo6i8oicjbn049sh2856d8anrqoli\";s:3:\"css\";s:6:\"edit-1\";s:4:\"code\";i:61080;s:3:\"src\";s:8:\"typicons\";}i:788;a:4:{s:3:\"uid\";s:32:\"9d4f81f2d81e14141b68706668498441\";s:3:\"css\";s:7:\"print-2\";s:4:\"code\";i:61081;s:3:\"src\";s:8:\"typicons\";}i:789;a:4:{s:3:\"uid\";s:32:\"b90868gfogj970a1g0dnot6hm5r4uj55\";s:3:\"css\";s:9:\"comment-2\";s:4:\"code\";i:61082;s:3:\"src\";s:8:\"typicons\";}i:790;a:4:{s:3:\"uid\";s:32:\"2hqh2lidoqvaujgq29tdkrtiay5s6tyk\";s:3:\"css\";s:6:\"chat-2\";s:4:\"code\";i:61083;s:3:\"src\";s:8:\"typicons\";}i:791;a:4:{s:3:\"uid\";s:32:\"ccf71c505b173c61a2e4e8c8cb907dfa\";s:3:\"css\";s:8:\"chat-alt\";s:4:\"code\";i:61084;s:3:\"src\";s:8:\"typicons\";}i:792;a:4:{s:3:\"uid\";s:32:\"c155bb86da2f8da808394d58220b5146\";s:3:\"css\";s:6:\"bell-2\";s:4:\"code\";i:61085;s:3:\"src\";s:8:\"typicons\";}i:793;a:4:{s:3:\"uid\";s:32:\"2a58da2238c31ffa3ff4dac966c2dc99\";s:3:\"css\";s:11:\"attention-1\";s:4:\"code\";i:61086;s:3:\"src\";s:8:\"typicons\";}i:794;a:4:{s:3:\"uid\";s:32:\"rp4bhvranczqlvvwzerni2uuanp2gvqb\";s:3:\"css\";s:16:\"attention-filled\";s:4:\"code\";i:61087;s:3:\"src\";s:8:\"typicons\";}i:795;a:4:{s:3:\"uid\";s:32:\"8f28d948aa6379b1a69d2a090e7531d4\";s:3:\"css\";s:13:\"warning-empty\";s:4:\"code\";i:61088;s:3:\"src\";s:8:\"typicons\";}i:796;a:4:{s:3:\"uid\";s:32:\"dd4b00255957a608953c409346e7d7fb\";s:3:\"css\";s:7:\"warning\";s:4:\"code\";i:61089;s:3:\"src\";s:8:\"typicons\";}i:797;a:4:{s:3:\"uid\";s:32:\"ba9ae3250633c7b1fe249587358c8383\";s:3:\"css\";s:8:\"contacts\";s:4:\"code\";i:61090;s:3:\"src\";s:8:\"typicons\";}i:798;a:4:{s:3:\"uid\";s:32:\"933f454f9d3342a055217fd695475d44\";s:3:\"css\";s:5:\"vcard\";s:4:\"code\";i:61091;s:3:\"src\";s:8:\"typicons\";}i:799;a:4:{s:3:\"uid\";s:32:\"gruasbs60jlu9us53csv9q7nnwy4d990\";s:3:\"css\";s:9:\"address-1\";s:4:\"code\";i:61092;s:3:\"src\";s:8:\"typicons\";}i:800;a:4:{s:3:\"uid\";s:32:\"13289e807e02b1d46f2fe10d81d6fba6\";s:3:\"css\";s:16:\"location-outline\";s:4:\"code\";i:61093;s:3:\"src\";s:8:\"typicons\";}i:801;a:4:{s:3:\"uid\";s:32:\"gjt8ba5q0n3nn8ptw6324sflr8qoaeam\";s:3:\"css\";s:10:\"location-1\";s:4:\"code\";i:61094;s:3:\"src\";s:8:\"typicons\";}i:802;a:4:{s:3:\"uid\";s:32:\"87d337fee4866c2c28f6082994ce0f41\";s:3:\"css\";s:3:\"map\";s:4:\"code\";i:61095;s:3:\"src\";s:8:\"typicons\";}i:803;a:4:{s:3:\"uid\";s:32:\"0d5c609b66c40a8482943f18235da869\";s:3:\"css\";s:17:\"direction-outline\";s:4:\"code\";i:61096;s:3:\"src\";s:8:\"typicons\";}i:804;a:4:{s:3:\"uid\";s:32:\"cka09asalx8otiykquyp5d9tymlan1o3\";s:3:\"css\";s:11:\"direction-2\";s:4:\"code\";i:61097;s:3:\"src\";s:8:\"typicons\";}i:805;a:4:{s:3:\"uid\";s:32:\"547c96163e3724fa7384f6ddce0c10e7\";s:3:\"css\";s:9:\"compass-2\";s:4:\"code\";i:61098;s:3:\"src\";s:8:\"typicons\";}i:806;a:4:{s:3:\"uid\";s:32:\"csuoy0rqoun3unhsgjoy2uumpldzbfmt\";s:3:\"css\";s:7:\"trash-1\";s:4:\"code\";i:61099;s:3:\"src\";s:8:\"typicons\";}i:807;a:4:{s:3:\"uid\";s:32:\"85ef733b1e280809e8443f5f0167b5c2\";s:3:\"css\";s:5:\"doc-2\";s:4:\"code\";i:61100;s:3:\"src\";s:8:\"typicons\";}i:808;a:4:{s:3:\"uid\";s:32:\"6a06892e76b81e023da6ddfb38a26b37\";s:3:\"css\";s:10:\"doc-text-2\";s:4:\"code\";i:61101;s:3:\"src\";s:8:\"typicons\";}i:809;a:4:{s:3:\"uid\";s:32:\"bd517dbd6ccbc464f6d80efca97abb7d\";s:3:\"css\";s:7:\"doc-add\";s:4:\"code\";i:61102;s:3:\"src\";s:8:\"typicons\";}i:810;a:4:{s:3:\"uid\";s:32:\"72686f3e46dda4b891938886eca27c59\";s:3:\"css\";s:10:\"doc-remove\";s:4:\"code\";i:61103;s:3:\"src\";s:8:\"typicons\";}i:811;a:4:{s:3:\"uid\";s:32:\"56da5324fc5a04f131ab65668c36b931\";s:3:\"css\";s:4:\"news\";s:4:\"code\";i:61104;s:3:\"src\";s:8:\"typicons\";}i:812;a:4:{s:3:\"uid\";s:32:\"83e7b366e9b39bc4006b821f7c5efa4d\";s:3:\"css\";s:8:\"folder-1\";s:4:\"code\";i:61105;s:3:\"src\";s:8:\"typicons\";}i:813;a:4:{s:3:\"uid\";s:32:\"e536c80e011366046360f5ffe669dbfd\";s:3:\"css\";s:10:\"folder-add\";s:4:\"code\";i:61106;s:3:\"src\";s:8:\"typicons\";}i:814;a:4:{s:3:\"uid\";s:32:\"aa0d87f43ed577ed479df28dc3724c11\";s:3:\"css\";s:13:\"folder-delete\";s:4:\"code\";i:61107;s:3:\"src\";s:8:\"typicons\";}i:815;a:4:{s:3:\"uid\";s:32:\"f7f29824b6c2d0a9645adc48297f41f4\";s:3:\"css\";s:7:\"archive\";s:4:\"code\";i:61108;s:3:\"src\";s:8:\"typicons\";}i:816;a:4:{s:3:\"uid\";s:32:\"a3264f2df401aaeeee9d9eb800e455eb\";s:3:\"css\";s:5:\"box-1\";s:4:\"code\";i:61109;s:3:\"src\";s:8:\"typicons\";}i:817;a:4:{s:3:\"uid\";s:32:\"aa7d4f131e866180ed30e6fbb504328c\";s:3:\"css\";s:11:\"rss-outline\";s:4:\"code\";i:61110;s:3:\"src\";s:8:\"typicons\";}i:818;a:4:{s:3:\"uid\";s:32:\"3o0pu4qbmgvcv8zqb5o3qh8vttzvhpy7\";s:3:\"css\";s:5:\"rss-2\";s:4:\"code\";i:61111;s:3:\"src\";s:8:\"typicons\";}i:819;a:4:{s:3:\"uid\";s:32:\"eae068bed86aca956cdd10edcaaf24ee\";s:3:\"css\";s:13:\"phone-outline\";s:4:\"code\";i:61112;s:3:\"src\";s:8:\"typicons\";}i:820;a:4:{s:3:\"uid\";s:32:\"24eiet6l58t0myywueih34b0e5a30bw1\";s:3:\"css\";s:7:\"phone-2\";s:4:\"code\";i:61113;s:3:\"src\";s:8:\"typicons\";}i:821;a:4:{s:3:\"uid\";s:32:\"a151e07df1262b33b210de5d956e4cc8\";s:3:\"css\";s:12:\"menu-outline\";s:4:\"code\";i:61114;s:3:\"src\";s:8:\"typicons\";}i:822;a:4:{s:3:\"uid\";s:32:\"jh3jpcb1t1bcm80gidkadilh080aq79h\";s:3:\"css\";s:6:\"menu-1\";s:4:\"code\";i:61115;s:3:\"src\";s:8:\"typicons\";}i:823;a:4:{s:3:\"uid\";s:32:\"3a89ddb1c81111c15d6c4e26cc3c546a\";s:3:\"css\";s:11:\"cog-outline\";s:4:\"code\";i:61116;s:3:\"src\";s:8:\"typicons\";}i:824;a:4:{s:3:\"uid\";s:32:\"dpxunrtmigvk6jm0ieo7axfsgzx4awll\";s:3:\"css\";s:5:\"cog-2\";s:4:\"code\";i:61117;s:3:\"src\";s:8:\"typicons\";}i:825;a:4:{s:3:\"uid\";s:32:\"9e717a7080503cfe84c7c7bd336ffe5f\";s:3:\"css\";s:14:\"wrench-outline\";s:4:\"code\";i:61118;s:3:\"src\";s:8:\"typicons\";}i:826;a:4:{s:3:\"uid\";s:32:\"i7r8vgyqewsy2rlx0xhawybpw5uyss3z\";s:3:\"css\";s:8:\"wrench-1\";s:4:\"code\";i:61119;s:3:\"src\";s:8:\"typicons\";}i:827;a:4:{s:3:\"uid\";s:32:\"e0d15ef5945000f5f264acc35494002f\";s:3:\"css\";s:8:\"basket-2\";s:4:\"code\";i:61120;s:3:\"src\";s:8:\"typicons\";}i:828;a:4:{s:3:\"uid\";s:32:\"3d211fe82ca138fce185f8869d38df26\";s:3:\"css\";s:17:\"calendar-outlilne\";s:4:\"code\";i:61121;s:3:\"src\";s:8:\"typicons\";}i:829;a:4:{s:3:\"uid\";s:32:\"4c2a3128819fef9548d6f0d38a5e291a\";s:3:\"css\";s:10:\"calendar-1\";s:4:\"code\";i:61122;s:3:\"src\";s:8:\"typicons\";}i:830;a:4:{s:3:\"uid\";s:32:\"b7bd78e163801889af145e513d6c5383\";s:3:\"css\";s:11:\"mic-outline\";s:4:\"code\";i:61123;s:3:\"src\";s:8:\"typicons\";}i:831;a:4:{s:3:\"uid\";s:32:\"b1a40ej6b1xgsxjeh1b1urm8ptglt0hk\";s:3:\"css\";s:5:\"mic-2\";s:4:\"code\";i:61124;s:3:\"src\";s:8:\"typicons\";}i:832;a:4:{s:3:\"uid\";s:32:\"0a9d5a8bfa0ccfd44a38328b8ca276c2\";s:3:\"css\";s:12:\"volume-off-1\";s:4:\"code\";i:61125;s:3:\"src\";s:8:\"typicons\";}i:833;a:4:{s:3:\"uid\";s:32:\"43m0a70tvxqc6q7jxgzhz5lmlt3ce2iy\";s:3:\"css\";s:10:\"volume-low\";s:4:\"code\";i:61126;s:3:\"src\";s:8:\"typicons\";}i:834;a:4:{s:3:\"uid\";s:32:\"3bf8e868324f7efb93c7bde31be9cc5e\";s:3:\"css\";s:13:\"volume-middle\";s:4:\"code\";i:61127;s:3:\"src\";s:8:\"typicons\";}i:835;a:4:{s:3:\"uid\";s:32:\"okc52fdxu9uz2wnl0awdtv5373is429s\";s:3:\"css\";s:11:\"volume-high\";s:4:\"code\";i:61128;s:3:\"src\";s:8:\"typicons\";}i:836;a:4:{s:3:\"uid\";s:32:\"e5297b06d9300be7e7c347f78a9b8b61\";s:3:\"css\";s:12:\"headphones-1\";s:4:\"code\";i:61129;s:3:\"src\";s:8:\"typicons\";}i:837;a:4:{s:3:\"uid\";s:32:\"eh1m4shhgsndy7pmdzx3ynrakadhozgr\";s:3:\"css\";s:7:\"clock-1\";s:4:\"code\";i:61130;s:3:\"src\";s:8:\"typicons\";}i:838;a:4:{s:3:\"uid\";s:32:\"e5e2804a6d7681eb37e80a1fc380fe49\";s:3:\"css\";s:10:\"wristwatch\";s:4:\"code\";i:61131;s:3:\"src\";s:8:\"typicons\";}i:839;a:4:{s:3:\"uid\";s:32:\"cb8b402e2efdc57d6d37ad7d3da819fe\";s:3:\"css\";s:9:\"stopwatch\";s:4:\"code\";i:61132;s:3:\"src\";s:8:\"typicons\";}i:840;a:4:{s:3:\"uid\";s:32:\"12d16dda691bda304e3b57d7bc0de5a9\";s:3:\"css\";s:11:\"lightbulb-1\";s:4:\"code\";i:61133;s:3:\"src\";s:8:\"typicons\";}i:841;a:4:{s:3:\"uid\";s:32:\"d8e8d6ef89a7e3992ade2b9e01b6b780\";s:3:\"css\";s:13:\"block-outline\";s:4:\"code\";i:61134;s:3:\"src\";s:8:\"typicons\";}i:842;a:4:{s:3:\"uid\";s:32:\"j6xzwioffey3gxe90yx3ie56j5dlt902\";s:3:\"css\";s:7:\"block-1\";s:4:\"code\";i:61135;s:3:\"src\";s:8:\"typicons\";}i:843;a:4:{s:3:\"uid\";s:32:\"debaf3311987af708b9c1646fc192c15\";s:3:\"css\";s:19:\"resize-full-outline\";s:4:\"code\";i:61136;s:3:\"src\";s:8:\"typicons\";}i:844;a:4:{s:3:\"uid\";s:32:\"cdfalpadi7huwv9ah4fef2gpfpb4c6qm\";s:3:\"css\";s:13:\"resize-full-1\";s:4:\"code\";i:61137;s:3:\"src\";s:8:\"typicons\";}i:845;a:4:{s:3:\"uid\";s:32:\"1e4cf19f2a9f546c5f13f09af7c40ba9\";s:3:\"css\";s:21:\"resize-normal-outline\";s:4:\"code\";i:61138;s:3:\"src\";s:8:\"typicons\";}i:846;a:4:{s:3:\"uid\";s:32:\"8d2bc2d959a55e76466bbef6e84c8373\";s:3:\"css\";s:13:\"resize-normal\";s:4:\"code\";i:61139;s:3:\"src\";s:8:\"typicons\";}i:847;a:4:{s:3:\"uid\";s:32:\"2b9bcf0829f99d9bdaa653b0a8cf41f5\";s:3:\"css\";s:12:\"move-outline\";s:4:\"code\";i:61140;s:3:\"src\";s:8:\"typicons\";}i:848;a:4:{s:3:\"uid\";s:32:\"fhkechw94uv9ydw6tukba3ka2hhoif4n\";s:3:\"css\";s:4:\"move\";s:4:\"code\";i:61141;s:3:\"src\";s:8:\"typicons\";}i:849;a:4:{s:3:\"uid\";s:32:\"ca1c07c0df52dbf2af6813c9e36c2611\";s:3:\"css\";s:5:\"popup\";s:4:\"code\";i:61142;s:3:\"src\";s:8:\"typicons\";}i:850;a:4:{s:3:\"uid\";s:32:\"16bd6f8fd1c32a89b16d61e09a968c24\";s:3:\"css\";s:15:\"zoom-in-outline\";s:4:\"code\";i:61143;s:3:\"src\";s:8:\"typicons\";}i:851;a:4:{s:3:\"uid\";s:32:\"dfhp68fdlvh9dknvxk4tkf8yy0h7vw3r\";s:3:\"css\";s:9:\"zoom-in-1\";s:4:\"code\";i:61144;s:3:\"src\";s:8:\"typicons\";}i:852;a:4:{s:3:\"uid\";s:32:\"abbfffb71ee797c071d628c374714083\";s:3:\"css\";s:16:\"zoom-out-outline\";s:4:\"code\";i:61145;s:3:\"src\";s:8:\"typicons\";}i:853;a:4:{s:3:\"uid\";s:32:\"1nkxlfe3u6kwarxqy3g4z3c9lrsgdu5h\";s:3:\"css\";s:10:\"zoom-out-1\";s:4:\"code\";i:61146;s:3:\"src\";s:8:\"typicons\";}i:854;a:4:{s:3:\"uid\";s:32:\"493hui9b6xiqaf04slclmqnwpap3oxjj\";s:3:\"css\";s:7:\"popup-1\";s:4:\"code\";i:61147;s:3:\"src\";s:8:\"typicons\";}i:855;a:4:{s:3:\"uid\";s:32:\"d4ebe676479ff9cb41c7797f003aa54d\";s:3:\"css\";s:17:\"left-open-outline\";s:4:\"code\";i:61148;s:3:\"src\";s:8:\"typicons\";}i:856;a:4:{s:3:\"uid\";s:32:\"wlri7uftq4zbi82q2xuf08ayd8kpijlk\";s:3:\"css\";s:11:\"left-open-1\";s:4:\"code\";i:61149;s:3:\"src\";s:8:\"typicons\";}i:857;a:4:{s:3:\"uid\";s:32:\"813cb2527308990d4870591d9d76f8cd\";s:3:\"css\";s:18:\"right-open-outline\";s:4:\"code\";i:61150;s:3:\"src\";s:8:\"typicons\";}i:858;a:4:{s:3:\"uid\";s:32:\"6zhrgcf3co77hnljttd3b2mrc8z5fiq5\";s:3:\"css\";s:12:\"right-open-1\";s:4:\"code\";i:61151;s:3:\"src\";s:8:\"typicons\";}i:859;a:4:{s:3:\"uid\";s:32:\"xq9z5jujkqhrf97s70hjek6otohmhr1y\";s:3:\"css\";s:6:\"down-2\";s:4:\"code\";i:61152;s:3:\"src\";s:8:\"typicons\";}i:860;a:4:{s:3:\"uid\";s:32:\"qqsxko9kqxh5g53lz33yonkpc2rpkvkn\";s:3:\"css\";s:6:\"left-2\";s:4:\"code\";i:61153;s:3:\"src\";s:8:\"typicons\";}i:861;a:4:{s:3:\"uid\";s:32:\"4oaz56fmzfvx7vry2o540n9l4z79fz8t\";s:3:\"css\";s:7:\"right-2\";s:4:\"code\";i:60846;s:3:\"src\";s:8:\"typicons\";}i:862;a:4:{s:3:\"uid\";s:32:\"mj2pxhfj0eumtbzirpdokhtzk00480uo\";s:3:\"css\";s:4:\"up-2\";s:4:\"code\";i:60847;s:3:\"src\";s:8:\"typicons\";}i:863;a:4:{s:3:\"uid\";s:32:\"1d9b2bb0d0621cd616139c6a441ed442\";s:3:\"css\";s:12:\"down-outline\";s:4:\"code\";i:60848;s:3:\"src\";s:8:\"typicons\";}i:864;a:4:{s:3:\"uid\";s:32:\"ec3be32c1330a17ef251b378ebd7d3ac\";s:3:\"css\";s:12:\"left-outline\";s:4:\"code\";i:60849;s:3:\"src\";s:8:\"typicons\";}i:865;a:4:{s:3:\"uid\";s:32:\"86bc84e014767f8f1377723c47d1b153\";s:3:\"css\";s:13:\"right-outline\";s:4:\"code\";i:60850;s:3:\"src\";s:8:\"typicons\";}i:866;a:4:{s:3:\"uid\";s:32:\"abf264d54e3f10187167ebc0e833d12e\";s:3:\"css\";s:10:\"up-outline\";s:4:\"code\";i:60851;s:3:\"src\";s:8:\"typicons\";}i:867;a:4:{s:3:\"uid\";s:32:\"c16a63e911bc47b46dc2a7129d2f0c46\";s:3:\"css\";s:10:\"down-small\";s:4:\"code\";i:60852;s:3:\"src\";s:8:\"typicons\";}i:868;a:4:{s:3:\"uid\";s:32:\"58b78b6ca784d5c3db5beefcd9e18061\";s:3:\"css\";s:10:\"left-small\";s:4:\"code\";i:60853;s:3:\"src\";s:8:\"typicons\";}i:869;a:4:{s:3:\"uid\";s:32:\"877a233d7fdca8a1d82615b96ed0d7a2\";s:3:\"css\";s:11:\"right-small\";s:4:\"code\";i:60854;s:3:\"src\";s:8:\"typicons\";}i:870;a:4:{s:3:\"uid\";s:32:\"62bc6fe2a82e4864e2b94d4c0985ee0c\";s:3:\"css\";s:8:\"up-small\";s:4:\"code\";i:60855;s:3:\"src\";s:8:\"typicons\";}i:871;a:4:{s:3:\"uid\";s:32:\"1fb50a37bc38da3863187931ac44ae5e\";s:3:\"css\";s:10:\"cw-outline\";s:4:\"code\";i:60856;s:3:\"src\";s:8:\"typicons\";}i:872;a:4:{s:3:\"uid\";s:32:\"5qynhqqaenby227l5kogqj8sdk5s4e7h\";s:3:\"css\";s:4:\"cw-2\";s:4:\"code\";i:60857;s:3:\"src\";s:8:\"typicons\";}i:873;a:4:{s:3:\"uid\";s:32:\"d12574a0151c84ddf56f4fd7b4aff678\";s:3:\"css\";s:17:\"arrows-cw-outline\";s:4:\"code\";i:60858;s:3:\"src\";s:8:\"typicons\";}i:874;a:4:{s:3:\"uid\";s:32:\"mqlxga8x57rhlfv44zsvmz1reex8lbqg\";s:3:\"css\";s:11:\"arrows-cw-1\";s:4:\"code\";i:60859;s:3:\"src\";s:8:\"typicons\";}i:875;a:4:{s:3:\"uid\";s:32:\"6b69b1a2df6d099ba15f11476075438e\";s:3:\"css\";s:12:\"loop-outline\";s:4:\"code\";i:60860;s:3:\"src\";s:8:\"typicons\";}i:876;a:4:{s:3:\"uid\";s:32:\"em9mdmyhjwd003ndercv4r08h0ai31tl\";s:3:\"css\";s:6:\"loop-1\";s:4:\"code\";i:60861;s:3:\"src\";s:8:\"typicons\";}i:877;a:4:{s:3:\"uid\";s:32:\"7c0965b50bb5e83150abcbd752b7c29e\";s:3:\"css\";s:16:\"loop-alt-outline\";s:4:\"code\";i:60862;s:3:\"src\";s:8:\"typicons\";}i:878;a:4:{s:3:\"uid\";s:32:\"jskdfgyhjwd003ndercv4r08h0ai3dfg\";s:3:\"css\";s:8:\"loop-alt\";s:4:\"code\";i:60863;s:3:\"src\";s:8:\"typicons\";}i:879;a:4:{s:3:\"uid\";s:32:\"36m3wq83tio3uymjbu44su7ior03u9cc\";s:3:\"css\";s:9:\"shuffle-2\";s:4:\"code\";i:60864;s:3:\"src\";s:8:\"typicons\";}i:880;a:4:{s:3:\"uid\";s:32:\"8d2b91edcad12992a96fc5eac674700d\";s:3:\"css\";s:12:\"play-outline\";s:4:\"code\";i:60865;s:3:\"src\";s:8:\"typicons\";}i:881;a:4:{s:3:\"uid\";s:32:\"3e290a111c0f3ee3acbf7b5f17ccc04a\";s:3:\"css\";s:6:\"play-1\";s:4:\"code\";i:60866;s:3:\"src\";s:8:\"typicons\";}i:882;a:4:{s:3:\"uid\";s:32:\"4a770f766e0c1f06ce850db219684355\";s:3:\"css\";s:12:\"stop-outline\";s:4:\"code\";i:60867;s:3:\"src\";s:8:\"typicons\";}i:883;a:4:{s:3:\"uid\";s:32:\"0785c02e57804318c8fe070338f89cd9\";s:3:\"css\";s:6:\"stop-1\";s:4:\"code\";i:60868;s:3:\"src\";s:8:\"typicons\";}i:884;a:4:{s:3:\"uid\";s:32:\"633072ff889a2ac52b162880e104550e\";s:3:\"css\";s:13:\"pause-outline\";s:4:\"code\";i:60869;s:3:\"src\";s:8:\"typicons\";}i:885;a:4:{s:3:\"uid\";s:32:\"e44ef09cb81413287d702eefa65dd790\";s:3:\"css\";s:7:\"pause-1\";s:4:\"code\";i:60870;s:3:\"src\";s:8:\"typicons\";}i:886;a:4:{s:3:\"uid\";s:32:\"f7b9bc563b87218a2ed804cc71a6eb9c\";s:3:\"css\";s:15:\"fast-fw-outline\";s:4:\"code\";i:60871;s:3:\"src\";s:8:\"typicons\";}i:887;a:4:{s:3:\"uid\";s:32:\"94656a720f169a0fc78c5a942e0c7112\";s:3:\"css\";s:9:\"fast-fw-1\";s:4:\"code\";i:60872;s:3:\"src\";s:8:\"typicons\";}i:888;a:4:{s:3:\"uid\";s:32:\"f54874f26664ff241013d7b74b930b3f\";s:3:\"css\";s:14:\"rewind-outline\";s:4:\"code\";i:60873;s:3:\"src\";s:8:\"typicons\";}i:889;a:4:{s:3:\"uid\";s:32:\"c80828ee2c3fc55b3e58a2b5e6ebba91\";s:3:\"css\";s:6:\"rewind\";s:4:\"code\";i:60874;s:3:\"src\";s:8:\"typicons\";}i:890;a:4:{s:3:\"uid\";s:32:\"1e29f134dfa565422897dacc67dee3e8\";s:3:\"css\";s:14:\"record-outline\";s:4:\"code\";i:60875;s:3:\"src\";s:8:\"typicons\";}i:891;a:4:{s:3:\"uid\";s:32:\"6c985c88b4c460d6c5a3e34d53361286\";s:3:\"css\";s:6:\"record\";s:4:\"code\";i:60876;s:3:\"src\";s:8:\"typicons\";}i:892;a:4:{s:3:\"uid\";s:32:\"b345edfec8ce1b62e75f889fbd02bd0e\";s:3:\"css\";s:13:\"eject-outline\";s:4:\"code\";i:60877;s:3:\"src\";s:8:\"typicons\";}i:893;a:4:{s:3:\"uid\";s:32:\"ef7107c004ac05657c5f41177e0bf4f3\";s:3:\"css\";s:7:\"eject-1\";s:4:\"code\";i:60878;s:3:\"src\";s:8:\"typicons\";}i:894;a:4:{s:3:\"uid\";s:32:\"24f39880f1bd96bafcaf46db5881bc0e\";s:3:\"css\";s:17:\"eject-alt-outline\";s:4:\"code\";i:60879;s:3:\"src\";s:8:\"typicons\";}i:895;a:4:{s:3:\"uid\";s:32:\"ygvgohzaooew2l8favz2xu2xi59w1hoo\";s:3:\"css\";s:9:\"eject-alt\";s:4:\"code\";i:60880;s:3:\"src\";s:8:\"typicons\";}i:896;a:4:{s:3:\"uid\";s:32:\"f378encthmyxe8mfi1ute1knv09ggkar\";s:3:\"css\";s:4:\"bat1\";s:4:\"code\";i:60881;s:3:\"src\";s:8:\"typicons\";}i:897;a:4:{s:3:\"uid\";s:32:\"jslb32twsd38zgx4v3sm5upu0t6wirtm\";s:3:\"css\";s:4:\"bat2\";s:4:\"code\";i:60882;s:3:\"src\";s:8:\"typicons\";}i:898;a:4:{s:3:\"uid\";s:32:\"g43j86b0hso37oir42285zjo3nhd7m08\";s:3:\"css\";s:4:\"bat3\";s:4:\"code\";i:60883;s:3:\"src\";s:8:\"typicons\";}i:899;a:4:{s:3:\"uid\";s:32:\"7wc8mz5d93cbka5pscqjhsej173tqmbs\";s:3:\"css\";s:4:\"bat4\";s:4:\"code\";i:60884;s:3:\"src\";s:8:\"typicons\";}i:900;a:4:{s:3:\"uid\";s:32:\"bc1u8zgs4wteyj0u35n943k3jzx5olkm\";s:3:\"css\";s:10:\"bat-charge\";s:4:\"code\";i:60885;s:3:\"src\";s:8:\"typicons\";}i:901;a:4:{s:3:\"uid\";s:32:\"5c8a627c2e11bfc2854045872f6bd8f4\";s:3:\"css\";s:4:\"plug\";s:4:\"code\";i:60886;s:3:\"src\";s:8:\"typicons\";}i:902;a:4:{s:3:\"uid\";s:32:\"c3b851a7a3ee5407ff159e9c7f61945f\";s:3:\"css\";s:14:\"target-outline\";s:4:\"code\";i:60887;s:3:\"src\";s:8:\"typicons\";}i:903;a:4:{s:3:\"uid\";s:32:\"xzlln8s96kcutcubtwavdjt80tmhkbkq\";s:3:\"css\";s:8:\"target-2\";s:4:\"code\";i:60888;s:3:\"src\";s:8:\"typicons\";}i:904;a:4:{s:3:\"uid\";s:32:\"c72248ca6a6ca8ee4c267f343e464003\";s:3:\"css\";s:12:\"wifi-outline\";s:4:\"code\";i:60889;s:3:\"src\";s:8:\"typicons\";}i:905;a:4:{s:3:\"uid\";s:32:\"a19527dd18f0e45e597e8a2622604d14\";s:3:\"css\";s:4:\"wifi\";s:4:\"code\";i:60890;s:3:\"src\";s:8:\"typicons\";}i:906;a:4:{s:3:\"uid\";s:32:\"4d3a91e6b0db6e03acaa74a861e2ab95\";s:3:\"css\";s:9:\"desktop-1\";s:4:\"code\";i:60891;s:3:\"src\";s:8:\"typicons\";}i:907;a:4:{s:3:\"uid\";s:32:\"eea1af32a01c5e7a9ce5675bcff64a7b\";s:3:\"css\";s:8:\"laptop-1\";s:4:\"code\";i:60892;s:3:\"src\";s:8:\"typicons\";}i:908;a:4:{s:3:\"uid\";s:32:\"c710cda53f5e1f8705865d453b7f323f\";s:3:\"css\";s:8:\"tablet-1\";s:4:\"code\";i:60893;s:3:\"src\";s:8:\"typicons\";}i:909;a:4:{s:3:\"uid\";s:32:\"gz5flrq210wzbyafnerm4e0aublo7qwb\";s:3:\"css\";s:8:\"mobile-2\";s:4:\"code\";i:60894;s:3:\"src\";s:8:\"typicons\";}i:910;a:4:{s:3:\"uid\";s:32:\"3fzybskyukolbvmshoyord1b254366gh\";s:3:\"css\";s:8:\"contrast\";s:4:\"code\";i:60895;s:3:\"src\";s:8:\"typicons\";}i:911;a:4:{s:3:\"uid\";s:32:\"1e8ffb4f9e0d313a9f5ffa5788487712\";s:3:\"css\";s:13:\"globe-outline\";s:4:\"code\";i:60896;s:3:\"src\";s:8:\"typicons\";}i:912;a:4:{s:3:\"uid\";s:32:\"igynut9bozd2s1mxnmkeeut1qou984gc\";s:3:\"css\";s:7:\"globe-2\";s:4:\"code\";i:60897;s:3:\"src\";s:8:\"typicons\";}i:913;a:4:{s:3:\"uid\";s:32:\"63ec74ce71635a8fc128c2eef73b96ae\";s:3:\"css\";s:17:\"globe-alt-outline\";s:4:\"code\";i:60898;s:3:\"src\";s:8:\"typicons\";}i:914;a:4:{s:3:\"uid\";s:32:\"n1ld0w7zazkxq7bsqtksyez86sdufqgd\";s:3:\"css\";s:9:\"globe-alt\";s:4:\"code\";i:60899;s:3:\"src\";s:8:\"typicons\";}i:915;a:4:{s:3:\"uid\";s:32:\"ivmsk67zo1yb1tthd3ugi4xnb3get418\";s:3:\"css\";s:5:\"sun-1\";s:4:\"code\";i:60900;s:3:\"src\";s:8:\"typicons\";}i:916;a:4:{s:3:\"uid\";s:32:\"5840fe162df3bcc8e390c58ef4e2acf9\";s:3:\"css\";s:10:\"sun-filled\";s:4:\"code\";i:60901;s:3:\"src\";s:8:\"typicons\";}i:917;a:4:{s:3:\"uid\";s:32:\"f9efb0f1944c550cf8d38cdf4aba07c4\";s:3:\"css\";s:7:\"cloud-2\";s:4:\"code\";i:60902;s:3:\"src\";s:8:\"typicons\";}i:918;a:4:{s:3:\"uid\";s:32:\"971842913945f59c7f3cf11e75e1e4f1\";s:3:\"css\";s:13:\"flash-outline\";s:4:\"code\";i:60903;s:3:\"src\";s:8:\"typicons\";}i:919;a:4:{s:3:\"uid\";s:32:\"pgdm1vsngqxmheo5xkjpbm5o8k81pawd\";s:3:\"css\";s:7:\"flash-2\";s:4:\"code\";i:60904;s:3:\"src\";s:8:\"typicons\";}i:920;a:4:{s:3:\"uid\";s:32:\"7d6302991626c252d089d14dc760fc37\";s:3:\"css\";s:6:\"moon-2\";s:4:\"code\";i:60905;s:3:\"src\";s:8:\"typicons\";}i:921;a:4:{s:3:\"uid\";s:32:\"9bd0a2540c17de10023e5e8ca3e64da5\";s:3:\"css\";s:13:\"waves-outline\";s:4:\"code\";i:60906;s:3:\"src\";s:8:\"typicons\";}i:922;a:4:{s:3:\"uid\";s:32:\"fd8d9ae4422e55d3ca23f55d9cf4b20a\";s:3:\"css\";s:5:\"waves\";s:4:\"code\";i:60907;s:3:\"src\";s:8:\"typicons\";}i:923;a:4:{s:3:\"uid\";s:32:\"e7a4824e79002c2d8ce3047b2da8b5a2\";s:3:\"css\";s:4:\"rain\";s:4:\"code\";i:60908;s:3:\"src\";s:8:\"typicons\";}i:924;a:4:{s:3:\"uid\";s:32:\"ac10a3a3077eab1b9d66509eb25fb9b4\";s:3:\"css\";s:9:\"cloud-sun\";s:4:\"code\";i:60909;s:3:\"src\";s:8:\"typicons\";}i:925;a:4:{s:3:\"uid\";s:32:\"6f200a5a449259c51cd0ccf56b4c1e93\";s:3:\"css\";s:7:\"drizzle\";s:4:\"code\";i:60910;s:3:\"src\";s:8:\"typicons\";}i:926;a:4:{s:3:\"uid\";s:32:\"d26795657ef6fb008bee4d54c358f7c8\";s:3:\"css\";s:4:\"snow\";s:4:\"code\";i:60911;s:3:\"src\";s:8:\"typicons\";}i:927;a:4:{s:3:\"uid\";s:32:\"3cac7625657b10cf706e7f332749c912\";s:3:\"css\";s:11:\"cloud-flash\";s:4:\"code\";i:60912;s:3:\"src\";s:8:\"typicons\";}i:928;a:4:{s:3:\"uid\";s:32:\"364cc69fb3edb8fb21caa6a2c0489589\";s:3:\"css\";s:10:\"cloud-wind\";s:4:\"code\";i:60913;s:3:\"src\";s:8:\"typicons\";}i:929;a:4:{s:3:\"uid\";s:32:\"b356b6fbb59d7eca7c15fdb055f0401f\";s:3:\"css\";s:4:\"wind\";s:4:\"code\";i:60914;s:3:\"src\";s:8:\"typicons\";}i:930;a:4:{s:3:\"uid\";s:32:\"db7651b88bb33a590710f551bfbbd371\";s:3:\"css\";s:13:\"plane-outline\";s:4:\"code\";i:60915;s:3:\"src\";s:8:\"typicons\";}i:931;a:4:{s:3:\"uid\";s:32:\"3dae5d2af2b99240c3c118e872f762f2\";s:3:\"css\";s:5:\"plane\";s:4:\"code\";i:60916;s:3:\"src\";s:8:\"typicons\";}i:932;a:4:{s:3:\"uid\";s:32:\"4ecf5fd3870bb82ba003d7f34845448d\";s:3:\"css\";s:6:\"leaf-2\";s:4:\"code\";i:60917;s:3:\"src\";s:8:\"typicons\";}i:933;a:4:{s:3:\"uid\";s:32:\"a9359f32375e27bf884c4b3388885050\";s:3:\"css\";s:10:\"lifebuoy-1\";s:4:\"code\";i:60918;s:3:\"src\";s:8:\"typicons\";}i:934;a:4:{s:3:\"uid\";s:32:\"bb310a229d0d33a1cbe8aa151a7a8fcb\";s:3:\"css\";s:11:\"briefcase-2\";s:4:\"code\";i:60919;s:3:\"src\";s:8:\"typicons\";}i:935;a:4:{s:3:\"uid\";s:32:\"5381e124761bc5dbcf32ec5dd86f91d6\";s:3:\"css\";s:7:\"brush-1\";s:4:\"code\";i:60920;s:3:\"src\";s:8:\"typicons\";}i:936;a:4:{s:3:\"uid\";s:32:\"287ee2cac4ded1712253c7b03ff4a5db\";s:3:\"css\";s:7:\"pipette\";s:4:\"code\";i:60921;s:3:\"src\";s:8:\"typicons\";}i:937;a:4:{s:3:\"uid\";s:32:\"b7cf8dba5f349cb92b536d76db4a4178\";s:3:\"css\";s:13:\"power-outline\";s:4:\"code\";i:60922;s:3:\"src\";s:8:\"typicons\";}i:938;a:4:{s:3:\"uid\";s:32:\"b387bb08e237859ba573fb32e2117310\";s:3:\"css\";s:5:\"power\";s:4:\"code\";i:60923;s:3:\"src\";s:8:\"typicons\";}i:939;a:4:{s:3:\"uid\";s:32:\"0c71ab36fb4e0923e3cf8d6beabe1851\";s:3:\"css\";s:13:\"check-outline\";s:4:\"code\";i:60924;s:3:\"src\";s:8:\"typicons\";}i:940;a:4:{s:3:\"uid\";s:32:\"27531040afb54140f4d449321c9cec3a\";s:3:\"css\";s:7:\"check-1\";s:4:\"code\";i:60925;s:3:\"src\";s:8:\"typicons\";}i:941;a:4:{s:3:\"uid\";s:32:\"610efad3150b6959e1b3fc863f39c60c\";s:3:\"css\";s:6:\"gift-1\";s:4:\"code\";i:60926;s:3:\"src\";s:8:\"typicons\";}i:942;a:4:{s:3:\"uid\";s:32:\"5c49851100aa021825b346d16d7f3abf\";s:3:\"css\";s:11:\"temperatire\";s:4:\"code\";i:60927;s:3:\"src\";s:8:\"typicons\";}i:943;a:4:{s:3:\"uid\";s:32:\"85046e7e5a2fe685961d1423fcda0649\";s:3:\"css\";s:13:\"chart-outline\";s:4:\"code\";i:60928;s:3:\"src\";s:8:\"typicons\";}i:944;a:4:{s:3:\"uid\";s:32:\"pdnk53e9ff0ck5q3b16vcm1hh1447j7e\";s:3:\"css\";s:5:\"chart\";s:4:\"code\";i:60929;s:3:\"src\";s:8:\"typicons\";}i:945;a:4:{s:3:\"uid\";s:32:\"a55e4173e388989f16afd373b894a9f4\";s:3:\"css\";s:17:\"chart-alt-outline\";s:4:\"code\";i:60930;s:3:\"src\";s:8:\"typicons\";}i:946;a:4:{s:3:\"uid\";s:32:\"d5f287ad8e3a2db8f808bc09980ec3dc\";s:3:\"css\";s:9:\"chart-alt\";s:4:\"code\";i:60931;s:3:\"src\";s:8:\"typicons\";}i:947;a:4:{s:3:\"uid\";s:32:\"890649841b2c37d56ff90065872fecf3\";s:3:\"css\";s:17:\"chart-bar-outline\";s:4:\"code\";i:60932;s:3:\"src\";s:8:\"typicons\";}i:948;a:4:{s:3:\"uid\";s:32:\"5v7h140x5zz1acnzfzo36flbwar5tujm\";s:3:\"css\";s:11:\"chart-bar-1\";s:4:\"code\";i:60933;s:3:\"src\";s:8:\"typicons\";}i:949;a:4:{s:3:\"uid\";s:32:\"76dfadaf502e065ac7b2689948f49cb0\";s:3:\"css\";s:17:\"chart-pie-outline\";s:4:\"code\";i:60934;s:3:\"src\";s:8:\"typicons\";}i:950;a:4:{s:3:\"uid\";s:32:\"um6h7e9nfp79peah8uphjhismoa8owtu\";s:3:\"css\";s:11:\"chart-pie-1\";s:4:\"code\";i:60935;s:3:\"src\";s:8:\"typicons\";}i:951;a:4:{s:3:\"uid\";s:32:\"17bddf8c9ea5dc5b8e1f33c936d08c1a\";s:3:\"css\";s:8:\"ticket-2\";s:4:\"code\";i:60936;s:3:\"src\";s:8:\"typicons\";}i:952;a:4:{s:3:\"uid\";s:32:\"9f498adcae624d612adc3123d65abf04\";s:3:\"css\";s:13:\"credit-card-2\";s:4:\"code\";i:60937;s:3:\"src\";s:8:\"typicons\";}i:953;a:4:{s:3:\"uid\";s:32:\"1a27e6346cdf0480c9c22351378bebbb\";s:3:\"css\";s:11:\"clipboard-1\";s:4:\"code\";i:60938;s:3:\"src\";s:8:\"typicons\";}i:954;a:4:{s:3:\"uid\";s:32:\"9637f035d143cc193e71c9704ebbb513\";s:3:\"css\";s:10:\"database-1\";s:4:\"code\";i:60939;s:3:\"src\";s:8:\"typicons\";}i:955;a:4:{s:3:\"uid\";s:32:\"8cc0aaefb9860f1ccef03f63f5873361\";s:3:\"css\";s:11:\"key-outline\";s:4:\"code\";i:60940;s:3:\"src\";s:8:\"typicons\";}i:956;a:4:{s:3:\"uid\";s:32:\"upidp9k72x66utj5w89oyq65tp6r2tpe\";s:3:\"css\";s:5:\"key-1\";s:4:\"code\";i:60941;s:3:\"src\";s:8:\"typicons\";}i:957;a:4:{s:3:\"uid\";s:32:\"da6c4728f6175a4b99b122274b8f921c\";s:3:\"css\";s:10:\"flow-split\";s:4:\"code\";i:60942;s:3:\"src\";s:8:\"typicons\";}i:958;a:4:{s:3:\"uid\";s:32:\"c1bea2b4c01d1d4bd1e4e1f79e51cdd2\";s:3:\"css\";s:10:\"flow-merge\";s:4:\"code\";i:60943;s:3:\"src\";s:8:\"typicons\";}i:959;a:4:{s:3:\"uid\";s:32:\"ccfaa7f5fe179987bd366051345ba985\";s:3:\"css\";s:15:\"flow-parallel-1\";s:4:\"code\";i:60944;s:3:\"src\";s:8:\"typicons\";}i:960;a:4:{s:3:\"uid\";s:32:\"e45a44236f3f1ac013a1287bb60cd965\";s:3:\"css\";s:10:\"flow-cross\";s:4:\"code\";i:60945;s:3:\"src\";s:8:\"typicons\";}i:961;a:4:{s:3:\"uid\";s:32:\"d7b214265bfe7138768bb8b9f62b759a\";s:3:\"css\";s:19:\"certificate-outline\";s:4:\"code\";i:60946;s:3:\"src\";s:8:\"typicons\";}i:962;a:4:{s:3:\"uid\";s:32:\"1a7ed99931fee554309101d072e5363d\";s:3:\"css\";s:13:\"certificate-1\";s:4:\"code\";i:60947;s:3:\"src\";s:8:\"typicons\";}i:963;a:4:{s:3:\"uid\";s:32:\"819df9964d860125547757a693150aeb\";s:3:\"css\";s:16:\"scissors-outline\";s:4:\"code\";i:60948;s:3:\"src\";s:8:\"typicons\";}i:964;a:4:{s:3:\"uid\";s:32:\"2npqajwqwxy3kbchcht7tyupllg270hb\";s:3:\"css\";s:10:\"scissors-1\";s:4:\"code\";i:60949;s:3:\"src\";s:8:\"typicons\";}i:965;a:4:{s:3:\"uid\";s:32:\"0fg01d4656jzluy9fz6ee4ohdd3nt2pe\";s:3:\"css\";s:5:\"flask\";s:4:\"code\";i:60950;s:3:\"src\";s:8:\"typicons\";}i:966;a:4:{s:3:\"uid\";s:32:\"935dd4069330896913745bbdd9699b0e\";s:3:\"css\";s:4:\"wine\";s:4:\"code\";i:60951;s:3:\"src\";s:8:\"typicons\";}i:967;a:4:{s:3:\"uid\";s:32:\"8f73806c205d38d9412c340f93ed0c7a\";s:3:\"css\";s:8:\"coffee-1\";s:4:\"code\";i:60952;s:3:\"src\";s:8:\"typicons\";}i:968;a:4:{s:3:\"uid\";s:32:\"c2e02247804b8372740de0b76311f1ad\";s:3:\"css\";s:6:\"beer-1\";s:4:\"code\";i:60953;s:3:\"src\";s:8:\"typicons\";}i:969;a:4:{s:3:\"uid\";s:32:\"40b8b7bf3ab4931765b7d32fb625b4cd\";s:3:\"css\";s:14:\"anchor-outline\";s:4:\"code\";i:60954;s:3:\"src\";s:8:\"typicons\";}i:970;a:4:{s:3:\"uid\";s:32:\"eb707fc827e812cdcfdf25b13622fb7b\";s:3:\"css\";s:8:\"anchor-1\";s:4:\"code\";i:60955;s:3:\"src\";s:8:\"typicons\";}i:971;a:4:{s:3:\"uid\";s:32:\"8f47f269b2667fb9b661e950a9599e26\";s:3:\"css\";s:14:\"puzzle-outline\";s:4:\"code\";i:60956;s:3:\"src\";s:8:\"typicons\";}i:972;a:4:{s:3:\"uid\";s:32:\"xoidjr6q3rzi7tpw6hci1k6srz15g11l\";s:3:\"css\";s:8:\"puzzle-1\";s:4:\"code\";i:60957;s:3:\"src\";s:8:\"typicons\";}i:973;a:4:{s:3:\"uid\";s:32:\"2b8ea04aa0e500ae056f9c7934af18e6\";s:3:\"css\";s:4:\"tree\";s:4:\"code\";i:60958;s:3:\"src\";s:8:\"typicons\";}i:974;a:4:{s:3:\"uid\";s:32:\"2de0dab5fbbc467b51692895fcce11e2\";s:3:\"css\";s:10:\"calculator\";s:4:\"code\";i:60959;s:3:\"src\";s:8:\"typicons\";}i:975;a:4:{s:3:\"uid\";s:32:\"d054fe11fb18e0ac8035d0d9ad556e3b\";s:3:\"css\";s:16:\"infinity-outline\";s:4:\"code\";i:60960;s:3:\"src\";s:8:\"typicons\";}i:976;a:4:{s:3:\"uid\";s:32:\"2039c86dq3jtfwqmgow2quvuzq3k34bu\";s:3:\"css\";s:10:\"infinity-1\";s:4:\"code\";i:60961;s:3:\"src\";s:8:\"typicons\";}i:977;a:4:{s:3:\"uid\";s:32:\"ffa340a4e2c3aa6ea354787b999bced7\";s:3:\"css\";s:10:\"pi-outline\";s:4:\"code\";i:60962;s:3:\"src\";s:8:\"typicons\";}i:978;a:4:{s:3:\"uid\";s:32:\"d2d6ab0dd4fb9365b1d5756380484bbb\";s:3:\"css\";s:2:\"pi\";s:4:\"code\";i:60963;s:3:\"src\";s:8:\"typicons\";}i:979;a:4:{s:3:\"uid\";s:32:\"8bf56386082752a2acc88a1ddf6851a8\";s:3:\"css\";s:2:\"at\";s:4:\"code\";i:60964;s:3:\"src\";s:8:\"typicons\";}i:980;a:4:{s:3:\"uid\";s:32:\"aa5bd6860d8921412a6e25946991410b\";s:3:\"css\";s:10:\"at-circled\";s:4:\"code\";i:60965;s:3:\"src\";s:8:\"typicons\";}i:981;a:4:{s:3:\"uid\";s:32:\"36cd8afd434ce27844b51a9a783037e6\";s:3:\"css\";s:21:\"looped-square-outline\";s:4:\"code\";i:60966;s:3:\"src\";s:8:\"typicons\";}i:982;a:4:{s:3:\"uid\";s:32:\"6f8cc29884d86ad170e2a6e7544fdced\";s:3:\"css\";s:22:\"looped-square-interest\";s:4:\"code\";i:60967;s:3:\"src\";s:8:\"typicons\";}i:983;a:4:{s:3:\"uid\";s:32:\"ef8560a06ed46a192092bf1f08c142a6\";s:3:\"css\";s:21:\"sort-alphabet-outline\";s:4:\"code\";i:60968;s:3:\"src\";s:8:\"typicons\";}i:984;a:4:{s:3:\"uid\";s:32:\"67f793f91864e379458a92ccc61d9ccf\";s:3:\"css\";s:13:\"sort-alphabet\";s:4:\"code\";i:60969;s:3:\"src\";s:8:\"typicons\";}i:985;a:4:{s:3:\"uid\";s:32:\"03df30a09d260eb427edcd7a65c1a84c\";s:3:\"css\";s:20:\"sort-numeric-outline\";s:4:\"code\";i:60970;s:3:\"src\";s:8:\"typicons\";}i:986;a:4:{s:3:\"uid\";s:32:\"2d220a22480861b15878d1632e31ab47\";s:3:\"css\";s:12:\"sort-numeric\";s:4:\"code\";i:60971;s:3:\"src\";s:8:\"typicons\";}i:987;a:4:{s:3:\"uid\";s:32:\"11970c0d1bb67f9525844b424f0f8736\";s:3:\"css\";s:18:\"dribbble-circled-1\";s:4:\"code\";i:60972;s:3:\"src\";s:8:\"typicons\";}i:988;a:4:{s:3:\"uid\";s:32:\"758801555b61307e51e333e9d62d53ba\";s:3:\"css\";s:10:\"dribbble-2\";s:4:\"code\";i:60973;s:3:\"src\";s:8:\"typicons\";}i:989;a:4:{s:3:\"uid\";s:32:\"33cea6d7bd699348c0d593e105361a51\";s:3:\"css\";s:18:\"facebook-circled-1\";s:4:\"code\";i:60974;s:3:\"src\";s:8:\"typicons\";}i:990;a:4:{s:3:\"uid\";s:32:\"77b3693facc3d803417105997b4ffe96\";s:3:\"css\";s:10:\"facebook-2\";s:4:\"code\";i:60975;s:3:\"src\";s:8:\"typicons\";}i:991;a:4:{s:3:\"uid\";s:32:\"5a010022e299fec5a6f33a6157e8ea25\";s:3:\"css\";s:16:\"flickr-circled-1\";s:4:\"code\";i:60976;s:3:\"src\";s:8:\"typicons\";}i:992;a:4:{s:3:\"uid\";s:32:\"5006b0f71f1a3cd3c73c04f7664cc20f\";s:3:\"css\";s:8:\"flickr-2\";s:4:\"code\";i:60977;s:3:\"src\";s:8:\"typicons\";}i:993;a:4:{s:3:\"uid\";s:32:\"4a98de1ada96673f8b43a600fd50d569\";s:3:\"css\";s:16:\"github-circled-2\";s:4:\"code\";i:60978;s:3:\"src\";s:8:\"typicons\";}i:994;a:4:{s:3:\"uid\";s:32:\"b94db9f012742fbdde9cb59413e14e9b\";s:3:\"css\";s:8:\"github-2\";s:4:\"code\";i:60979;s:3:\"src\";s:8:\"typicons\";}i:995;a:4:{s:3:\"uid\";s:32:\"ae8492c61cce60c36ed9667680017e7d\";s:3:\"css\";s:16:\"lastfm-circled-1\";s:4:\"code\";i:60980;s:3:\"src\";s:8:\"typicons\";}i:996;a:4:{s:3:\"uid\";s:32:\"afe98849cb4fe253a2b30b9716f67526\";s:3:\"css\";s:8:\"lastfm-1\";s:4:\"code\";i:60981;s:3:\"src\";s:8:\"typicons\";}i:997;a:4:{s:3:\"uid\";s:32:\"b2178b8fca35bac9e4bfcea4a4c05a92\";s:3:\"css\";s:18:\"linkedin-circled-1\";s:4:\"code\";i:60982;s:3:\"src\";s:8:\"typicons\";}i:998;a:4:{s:3:\"uid\";s:32:\"25a30265650b260ef03df4cbbff80272\";s:3:\"css\";s:10:\"linkedin-2\";s:4:\"code\";i:60983;s:3:\"src\";s:8:\"typicons\";}i:999;a:4:{s:3:\"uid\";s:32:\"0a3e0e5caddaa9cb266e42b6495975e2\";s:3:\"css\";s:19:\"pinterest-circled-2\";s:4:\"code\";i:60984;s:3:\"src\";s:8:\"typicons\";}i:1000;a:4:{s:3:\"uid\";s:32:\"178c8af85364e12fe70b959c7c055bc6\";s:3:\"css\";s:11:\"pinterest-1\";s:4:\"code\";i:60985;s:3:\"src\";s:8:\"typicons\";}i:1001;a:4:{s:3:\"uid\";s:32:\"2cfac2c1a9eb4552af0eba34def4b010\";s:3:\"css\";s:13:\"skype-outline\";s:4:\"code\";i:60986;s:3:\"src\";s:8:\"typicons\";}i:1002;a:4:{s:3:\"uid\";s:32:\"f5b8e78b48e3028969a964e002daf745\";s:3:\"css\";s:7:\"skype-2\";s:4:\"code\";i:60987;s:3:\"src\";s:8:\"typicons\";}i:1003;a:4:{s:3:\"uid\";s:32:\"3e9a99df4e0ede4d8d029d6e71d597ba\";s:3:\"css\";s:15:\"tumbler-circled\";s:4:\"code\";i:60988;s:3:\"src\";s:8:\"typicons\";}i:1004;a:4:{s:3:\"uid\";s:32:\"4a0984f0fb3fd89dd5bdd923f2ff8e45\";s:3:\"css\";s:7:\"tumbler\";s:4:\"code\";i:60989;s:3:\"src\";s:8:\"typicons\";}i:1005;a:4:{s:3:\"uid\";s:32:\"b523a5bcf8d08725038873d89bb003fd\";s:3:\"css\";s:17:\"twitter-circled-1\";s:4:\"code\";i:60990;s:3:\"src\";s:8:\"typicons\";}i:1006;a:4:{s:3:\"uid\";s:32:\"4568bba1dba45522fc539c733c9b35e5\";s:3:\"css\";s:9:\"twitter-2\";s:4:\"code\";i:60991;s:3:\"src\";s:8:\"typicons\";}i:1007;a:4:{s:3:\"uid\";s:32:\"bfaa824e96fa07779bc7b130b1216ce9\";s:3:\"css\";s:15:\"vimeo-circled-1\";s:4:\"code\";i:60992;s:3:\"src\";s:8:\"typicons\";}i:1008;a:4:{s:3:\"uid\";s:32:\"3315691c918224dc4893f2e368a4e0c8\";s:3:\"css\";s:7:\"vimeo-1\";s:4:\"code\";i:60993;s:3:\"src\";s:8:\"typicons\";}i:1009;a:4:{s:3:\"uid\";s:32:\"id8wp0cygl9trzbhlbd9o0fygiesi629\";s:3:\"css\";s:8:\"search-4\";s:4:\"code\";i:60079;s:3:\"src\";s:10:\"modernpics\";}i:1010;a:4:{s:3:\"uid\";s:32:\"ae3so8q0b0n2h8esv9flua2nmwswa8fd\";s:3:\"css\";s:6:\"mail-4\";s:4:\"code\";i:60080;s:3:\"src\";s:10:\"modernpics\";}i:1011;a:4:{s:3:\"uid\";s:32:\"pt5lb2orj9ms0n4yyxjavefdukcv1scl\";s:3:\"css\";s:7:\"heart-4\";s:4:\"code\";i:60081;s:3:\"src\";s:10:\"modernpics\";}i:1012;a:4:{s:3:\"uid\";s:32:\"kfzodo12ciruwganzy6h1bee2bpyz24d\";s:3:\"css\";s:6:\"star-4\";s:4:\"code\";i:60082;s:3:\"src\";s:10:\"modernpics\";}i:1013;a:4:{s:3:\"uid\";s:32:\"ma9pq3m9ye6f33psotqr8e68yyv7fbz6\";s:3:\"css\";s:6:\"user-4\";s:4:\"code\";i:60083;s:3:\"src\";s:10:\"modernpics\";}i:1014;a:4:{s:3:\"uid\";s:32:\"99qmwsnyl7d1848xayggtcwaysc4e415\";s:3:\"css\";s:10:\"user-woman\";s:4:\"code\";i:60084;s:3:\"src\";s:10:\"modernpics\";}i:1015;a:4:{s:3:\"uid\";s:32:\"d1a7ajpi3149rk5q4861jw9f2lzg27d1\";s:3:\"css\";s:9:\"user-pair\";s:4:\"code\";i:60085;s:3:\"src\";s:10:\"modernpics\";}i:1016;a:4:{s:3:\"uid\";s:32:\"3v2lgx3os8ub377alyqm8mn2o7r4zywg\";s:3:\"css\";s:4:\"th-2\";s:4:\"code\";i:60090;s:3:\"src\";s:10:\"modernpics\";}i:1017;a:4:{s:3:\"uid\";s:32:\"cy7vw87w1slwyalc4vd8cdhrb50asud3\";s:3:\"css\";s:9:\"th-list-2\";s:4:\"code\";i:60091;s:3:\"src\";s:10:\"modernpics\";}i:1018;a:4:{s:3:\"uid\";s:32:\"in76hg99crrkpcbz2rjnmgbiw74s72y0\";s:3:\"css\";s:4:\"ok-3\";s:4:\"code\";i:60092;s:3:\"src\";s:10:\"modernpics\";}i:1019;a:4:{s:3:\"uid\";s:32:\"rrhco7mfj6ro9yzhe4a1rbln9flw47re\";s:3:\"css\";s:8:\"cancel-4\";s:4:\"code\";i:60093;s:3:\"src\";s:10:\"modernpics\";}i:1020;a:4:{s:3:\"uid\";s:32:\"wcb87qh0k9smu6zukdhbn5zip98zofkh\";s:3:\"css\";s:15:\"cancel-circle-1\";s:4:\"code\";i:60094;s:3:\"src\";s:10:\"modernpics\";}i:1021;a:4:{s:3:\"uid\";s:32:\"hbvhbnoivp3qj8xpyqrxa7dvq9ntnci3\";s:3:\"css\";s:6:\"plus-4\";s:4:\"code\";i:60095;s:3:\"src\";s:10:\"modernpics\";}i:1022;a:4:{s:3:\"uid\";s:32:\"c1d1ix1r5ldq6yl3xwvh3u3fxqale7sy\";s:3:\"css\";s:6:\"home-4\";s:4:\"code\";i:60096;s:3:\"src\";s:10:\"modernpics\";}i:1023;a:4:{s:3:\"uid\";s:32:\"ivdkw88f6me1kxmgrk3qzv6jkgxhbuj7\";s:3:\"css\";s:6:\"lock-4\";s:4:\"code\";i:60097;s:3:\"src\";s:10:\"modernpics\";}i:1024;a:4:{s:3:\"uid\";s:32:\"8u06eo32zy61toyj78of6mi7inn3xlcl\";s:3:\"css\";s:11:\"lock-open-4\";s:4:\"code\";i:60098;s:3:\"src\";s:10:\"modernpics\";}i:1025;a:4:{s:3:\"uid\";s:32:\"frauy9fser6zk9n5ih3rdpz7zzfjbrvu\";s:3:\"css\";s:5:\"eye-4\";s:4:\"code\";i:60099;s:3:\"src\";s:10:\"modernpics\";}i:1026;a:4:{s:3:\"uid\";s:32:\"9vefjlcta42r6tjjmog0mpx7mf63jgag\";s:3:\"css\";s:5:\"tag-4\";s:4:\"code\";i:60100;s:3:\"src\";s:10:\"modernpics\";}i:1027;a:4:{s:3:\"uid\";s:32:\"jwebw8rhtovm6adljbdixtj9ltdrzkvb\";s:3:\"css\";s:11:\"thumbs-up-3\";s:4:\"code\";i:60101;s:3:\"src\";s:10:\"modernpics\";}i:1028;a:4:{s:3:\"uid\";s:32:\"h9yii6q602rt4dxjmy9k9wc3jkwzk8d0\";s:3:\"css\";s:13:\"thumbs-down-3\";s:4:\"code\";i:60102;s:3:\"src\";s:10:\"modernpics\";}i:1029;a:4:{s:3:\"uid\";s:32:\"kfk635sf697exf2r3jqx06zz54e1rgx4\";s:3:\"css\";s:10:\"download-4\";s:4:\"code\";i:60103;s:3:\"src\";s:10:\"modernpics\";}i:1030;a:4:{s:3:\"uid\";s:32:\"fojo3y3ju5f4vge0bepcxl1mgmzgit9k\";s:3:\"css\";s:8:\"export-3\";s:4:\"code\";i:60104;s:3:\"src\";s:10:\"modernpics\";}i:1031;a:4:{s:3:\"uid\";s:32:\"587bjlxppui6u4japooa2foe58rsvicp\";s:3:\"css\";s:8:\"pencil-4\";s:4:\"code\";i:60105;s:3:\"src\";s:10:\"modernpics\";}i:1032;a:4:{s:3:\"uid\";s:32:\"97var6sq7rzo72ktzg1c6ph46u9pftbr\";s:3:\"css\";s:12:\"pencil-alt-1\";s:4:\"code\";i:60106;s:3:\"src\";s:10:\"modernpics\";}i:1033;a:4:{s:3:\"uid\";s:32:\"242giivkgr3e6le7b2xqi2pkdruf85mu\";s:3:\"css\";s:6:\"edit-2\";s:4:\"code\";i:60107;s:3:\"src\";s:10:\"modernpics\";}i:1034;a:4:{s:3:\"uid\";s:32:\"7idv5s1f3qkgmbwbat6xukumwqxkrook\";s:3:\"css\";s:6:\"chat-4\";s:4:\"code\";i:60108;s:3:\"src\";s:10:\"modernpics\";}i:1035;a:4:{s:3:\"uid\";s:32:\"7ssl5z5jrhu13tb13cd3gb4bdfkzbfzw\";s:3:\"css\";s:7:\"print-3\";s:4:\"code\";i:60109;s:3:\"src\";s:10:\"modernpics\";}i:1036;a:4:{s:3:\"uid\";s:32:\"uaps3vfayj05q7h4rvb10m890xvaequb\";s:3:\"css\";s:6:\"bell-3\";s:4:\"code\";i:60110;s:3:\"src\";s:10:\"modernpics\";}i:1037;a:4:{s:3:\"uid\";s:32:\"f47srtt9pew19q6kg9jniwtzsb8q1rhy\";s:3:\"css\";s:11:\"attention-3\";s:4:\"code\";i:60111;s:3:\"src\";s:10:\"modernpics\";}i:1038;a:4:{s:3:\"uid\";s:32:\"a66a6e088038a1881d532b6675bf8412\";s:3:\"css\";s:6:\"info-4\";s:4:\"code\";i:60112;s:3:\"src\";s:10:\"modernpics\";}i:1039;a:4:{s:3:\"uid\";s:32:\"23d1c53bc15ca452df9453450e94a19c\";s:3:\"css\";s:8:\"question\";s:4:\"code\";i:60113;s:3:\"src\";s:10:\"modernpics\";}i:1040;a:4:{s:3:\"uid\";s:32:\"too2rspp5e6z6m0y6lconmv23uw3qlqo\";s:3:\"css\";s:10:\"location-4\";s:4:\"code\";i:60114;s:3:\"src\";s:10:\"modernpics\";}i:1041;a:4:{s:3:\"uid\";s:32:\"z18zsyvbrpsea0f49kd61kkue1ofsafy\";s:3:\"css\";s:7:\"trash-4\";s:4:\"code\";i:60115;s:3:\"src\";s:10:\"modernpics\";}i:1042;a:4:{s:3:\"uid\";s:32:\"t7uz7sms69yuckjmkp1zqggwr4jkw0o9\";s:3:\"css\";s:5:\"doc-4\";s:4:\"code\";i:60116;s:3:\"src\";s:10:\"modernpics\";}i:1043;a:4:{s:3:\"uid\";s:32:\"573lc53801tfc96xt7fubn59tb0o5s4y\";s:3:\"css\";s:9:\"article-1\";s:4:\"code\";i:60117;s:3:\"src\";s:10:\"modernpics\";}i:1044;a:4:{s:3:\"uid\";s:32:\"pzy4lq1ak4datbxpdfj3ya74vjfhwxg1\";s:3:\"css\";s:13:\"article-alt-1\";s:4:\"code\";i:60118;s:3:\"src\";s:10:\"modernpics\";}i:1045;a:4:{s:3:\"uid\";s:32:\"33iuue66u2628uv4kz3vnmh8uee8o7rw\";s:3:\"css\";s:5:\"rss-4\";s:4:\"code\";i:60119;s:3:\"src\";s:10:\"modernpics\";}i:1046;a:4:{s:3:\"uid\";s:32:\"zc0c8s0nyweeeo9i8a3rucu7alwxt56r\";s:3:\"css\";s:8:\"wrench-3\";s:4:\"code\";i:60120;s:3:\"src\";s:10:\"modernpics\";}i:1047;a:4:{s:3:\"uid\";s:32:\"vqyhv5kmwcj9zxq28dhq5npykr2k39co\";s:3:\"css\";s:8:\"basket-3\";s:4:\"code\";i:60121;s:3:\"src\";s:10:\"modernpics\";}i:1048;a:4:{s:3:\"uid\";s:32:\"s51at1xi1fkaomxvp6dqaax5jmyhtn4h\";s:3:\"css\";s:10:\"basket-alt\";s:4:\"code\";i:60122;s:3:\"src\";s:10:\"modernpics\";}i:1049;a:4:{s:3:\"uid\";s:32:\"sz7wtylc6qrwcbsj8aowal9y22hu6lka\";s:3:\"css\";s:14:\"calendar-alt-1\";s:4:\"code\";i:60124;s:3:\"src\";s:10:\"modernpics\";}i:1050;a:4:{s:3:\"uid\";s:32:\"8pcqxtjxtvkqo3dgemy49z7fw1d8xsh9\";s:3:\"css\";s:12:\"volume-off-3\";s:4:\"code\";i:60125;s:3:\"src\";s:10:\"modernpics\";}i:1051;a:4:{s:3:\"uid\";s:32:\"ivjrs8ijaooc3a2dw4790kb2rx4l6kjh\";s:3:\"css\";s:13:\"volume-down-1\";s:4:\"code\";i:60126;s:3:\"src\";s:10:\"modernpics\";}i:1052;a:4:{s:3:\"uid\";s:32:\"rrb2e7qiu68cw7itzq0wzm2hugw1u4lu\";s:3:\"css\";s:11:\"volume-up-2\";s:4:\"code\";i:60127;s:3:\"src\";s:10:\"modernpics\";}i:1053;a:4:{s:3:\"uid\";s:32:\"uetwmlvm6z9eaot1t74vvsgrte9vwi0n\";s:3:\"css\";s:8:\"bullhorn\";s:4:\"code\";i:60128;s:3:\"src\";s:10:\"modernpics\";}i:1054;a:4:{s:3:\"uid\";s:32:\"0ohst63cgq1mf1syayvfl8mphms8dbes\";s:3:\"css\";s:7:\"clock-4\";s:4:\"code\";i:60129;s:3:\"src\";s:10:\"modernpics\";}i:1055;a:4:{s:3:\"uid\";s:32:\"9avusbdkm7q4vcmevr0x88zxewys65wr\";s:3:\"css\";s:9:\"clock-alt\";s:4:\"code\";i:60130;s:3:\"src\";s:10:\"modernpics\";}i:1056;a:4:{s:3:\"uid\";s:32:\"dsfybb9l0x5fyd7e3o5kyisqppifztfu\";s:3:\"css\";s:13:\"resize-full-4\";s:4:\"code\";i:60132;s:3:\"src\";s:10:\"modernpics\";}i:1057;a:4:{s:3:\"uid\";s:32:\"qdhvqjd167ee2byleebhw58j4omhb8pl\";s:3:\"css\";s:14:\"resize-small-3\";s:4:\"code\";i:60133;s:3:\"src\";s:10:\"modernpics\";}i:1058;a:4:{s:3:\"uid\";s:32:\"yc4vm9xepijcjyfdp6mgkvju8engb212\";s:3:\"css\";s:9:\"zoom-in-2\";s:4:\"code\";i:60134;s:3:\"src\";s:10:\"modernpics\";}i:1059;a:4:{s:3:\"uid\";s:32:\"itjusjx5w85jr0udgi40mz7x2kmj1360\";s:3:\"css\";s:10:\"zoom-out-2\";s:4:\"code\";i:60135;s:3:\"src\";s:10:\"modernpics\";}i:1060;a:4:{s:3:\"uid\";s:32:\"b2i5x0ka1m6pskm3puj9jppl672knd5c\";s:3:\"css\";s:7:\"popup-4\";s:4:\"code\";i:60136;s:3:\"src\";s:10:\"modernpics\";}i:1061;a:4:{s:3:\"uid\";s:32:\"8ax1xqcbzz1hobyd4i7f0unwib1bztip\";s:3:\"css\";s:10:\"down-dir-2\";s:4:\"code\";i:60137;s:3:\"src\";s:10:\"modernpics\";}i:1062;a:4:{s:3:\"uid\";s:32:\"am79573ydakwiicuct1odx7f2e9zv8lv\";s:3:\"css\";s:10:\"left-dir-2\";s:4:\"code\";i:60138;s:3:\"src\";s:10:\"modernpics\";}i:1063;a:4:{s:3:\"uid\";s:32:\"gypcofts1tkouwkxbv8d33eanqpreyy9\";s:3:\"css\";s:11:\"right-dir-2\";s:4:\"code\";i:60139;s:3:\"src\";s:10:\"modernpics\";}i:1064;a:4:{s:3:\"uid\";s:32:\"6ipws8y9gej6vbloufvhi5qux7rluf64\";s:3:\"css\";s:8:\"up-dir-2\";s:4:\"code\";i:60140;s:3:\"src\";s:10:\"modernpics\";}i:1065;a:4:{s:3:\"uid\";s:32:\"3iwbntpxmp0kvbvzaxrh8h30xw1l6zvn\";s:3:\"css\";s:6:\"down-4\";s:4:\"code\";i:60141;s:3:\"src\";s:10:\"modernpics\";}i:1066;a:4:{s:3:\"uid\";s:32:\"giaskl13npzvuuz2ovy3vw8s0bewik08\";s:3:\"css\";s:4:\"up-4\";s:4:\"code\";i:60142;s:3:\"src\";s:10:\"modernpics\";}i:1067;a:4:{s:3:\"uid\";s:32:\"v4mhug5rzlh2qzlo09kfx03e6e2alqql\";s:3:\"css\";s:4:\"cw-4\";s:4:\"code\";i:60143;s:3:\"src\";s:10:\"modernpics\";}i:1068;a:4:{s:3:\"uid\";s:32:\"e6t4yvmv401e9gpo2anslq4uqy2iz692\";s:3:\"css\";s:8:\"signal-3\";s:4:\"code\";i:60144;s:3:\"src\";s:10:\"modernpics\";}i:1069;a:4:{s:3:\"uid\";s:32:\"lnyme20kl7kh26it9yrqk7at10k6i0sf\";s:3:\"css\";s:7:\"award-2\";s:4:\"code\";i:60145;s:3:\"src\";s:10:\"modernpics\";}i:1070;a:4:{s:3:\"uid\";s:32:\"m3m8301t2xdy30x4lp7txm0vztl67tcl\";s:3:\"css\";s:8:\"mobile-4\";s:4:\"code\";i:60146;s:3:\"src\";s:10:\"modernpics\";}i:1071;a:4:{s:3:\"uid\";s:32:\"raxalm7kdj5at9v49bevw6r2cw7fdv9r\";s:3:\"css\";s:10:\"mobile-alt\";s:4:\"code\";i:60147;s:3:\"src\";s:10:\"modernpics\";}i:1072;a:4:{s:3:\"uid\";s:32:\"r36ey62e6pi493s139u528739kjr3o8w\";s:3:\"css\";s:8:\"tablet-2\";s:4:\"code\";i:60148;s:3:\"src\";s:10:\"modernpics\";}i:1073;a:4:{s:3:\"uid\";s:32:\"hx5rpl1lxy10jqibjq0jmu0dhruapso4\";s:3:\"css\";s:4:\"ipod\";s:4:\"code\";i:60149;s:3:\"src\";s:10:\"modernpics\";}i:1074;a:4:{s:3:\"uid\";s:32:\"80fm9zvbe9habbzvsy6w4aymkgz2vu9i\";s:3:\"css\";s:4:\"cd-2\";s:4:\"code\";i:60150;s:3:\"src\";s:10:\"modernpics\";}i:1075;a:4:{s:3:\"uid\";s:32:\"o1c30odwfvgcvi5b4jsg95sur8v6ghsp\";s:3:\"css\";s:4:\"grid\";s:4:\"code\";i:60151;s:3:\"src\";s:10:\"modernpics\";}i:1076;a:4:{s:3:\"uid\";s:32:\"dplw5xo88mzzr7b45nvjcamyyhni6drs\";s:3:\"css\";s:6:\"book-3\";s:4:\"code\";i:60152;s:3:\"src\";s:10:\"modernpics\";}i:1077;a:4:{s:3:\"uid\";s:32:\"px45pk7jgwms9zb3zcm44h8al4f3xxkd\";s:3:\"css\";s:5:\"easel\";s:4:\"code\";i:60153;s:3:\"src\";s:10:\"modernpics\";}i:1078;a:4:{s:3:\"uid\";s:32:\"i6ej1r6t84xouh0dct7g9zyx3ya9s9eg\";s:3:\"css\";s:7:\"globe-3\";s:4:\"code\";i:60154;s:3:\"src\";s:10:\"modernpics\";}i:1079;a:4:{s:3:\"uid\";s:32:\"97ylvmgyj79w96iwzdanwmf5o4cvo17w\";s:3:\"css\";s:7:\"chart-1\";s:4:\"code\";i:60155;s:3:\"src\";s:10:\"modernpics\";}i:1080;a:4:{s:3:\"uid\";s:32:\"ogmm8kz4f7y6ji50gzajnwed8h6ck2u7\";s:3:\"css\";s:11:\"chart-bar-4\";s:4:\"code\";i:60156;s:3:\"src\";s:10:\"modernpics\";}i:1081;a:4:{s:3:\"uid\";s:32:\"crns7fze53tnmwvi0wyfhq8whxfmmroz\";s:3:\"css\";s:11:\"chart-pie-3\";s:4:\"code\";i:60157;s:3:\"src\";s:10:\"modernpics\";}i:1082;a:4:{s:3:\"uid\";s:32:\"fhpup8jff2yw9kmuwavhyqxogczcbbhj\";s:3:\"css\";s:8:\"dollar-1\";s:4:\"code\";i:60158;s:3:\"src\";s:10:\"modernpics\";}i:1083;a:4:{s:3:\"uid\";s:32:\"mjbsqg8yglgu0esc6ru2vh111jmh7qng\";s:3:\"css\";s:4:\"at-2\";s:4:\"code\";i:60159;s:3:\"src\";s:10:\"modernpics\";}i:1084;a:4:{s:3:\"uid\";s:32:\"a58a5236139282f6c7f906634233157a\";s:3:\"css\";s:7:\"squares\";s:4:\"code\";i:60162;s:3:\"src\";s:10:\"modernpics\";}i:1085;a:4:{s:3:\"uid\";s:32:\"212ab54aac31030950fec3e2448ebee9\";s:3:\"css\";s:7:\"money-1\";s:4:\"code\";i:60163;s:3:\"src\";s:10:\"modernpics\";}i:1086;a:4:{s:3:\"uid\";s:32:\"w42gjpwdzqeszptpy1xqp8r77o6gcasj\";s:3:\"css\";s:10:\"facebook-3\";s:4:\"code\";i:60164;s:3:\"src\";s:10:\"modernpics\";}i:1087;a:4:{s:3:\"uid\";s:32:\"03cmb4p7niofd11yos3fpjjuvvpy7mji\";s:3:\"css\";s:13:\"facebook-rect\";s:4:\"code\";i:60165;s:3:\"src\";s:10:\"modernpics\";}i:1088;a:4:{s:3:\"uid\";s:32:\"uor1aru5x0tewrwsl36amx6hogjv61cs\";s:3:\"css\";s:9:\"twitter-3\";s:4:\"code\";i:60166;s:3:\"src\";s:10:\"modernpics\";}i:1089;a:4:{s:3:\"uid\";s:32:\"h7disbowd4v177zjlsi6anz5nkka08uy\";s:3:\"css\";s:12:\"twitter-bird\";s:4:\"code\";i:60167;s:3:\"src\";s:10:\"modernpics\";}i:1090;a:4:{s:3:\"uid\";s:32:\"gq8m9lqx2hhwxf7rz30adbr37rthzirq\";s:3:\"css\";s:12:\"twitter-rect\";s:4:\"code\";i:60168;s:3:\"src\";s:10:\"modernpics\";}i:1091;a:4:{s:3:\"uid\";s:32:\"897cd776b90c71cb80b467fd9f509775\";s:3:\"css\";s:9:\"youtube-1\";s:4:\"code\";i:60169;s:3:\"src\";s:10:\"modernpics\";}i:1092;a:4:{s:3:\"uid\";s:32:\"ec21fe3492bb04d9e29103c319556ed8\";s:3:\"css\";s:8:\"search-5\";s:4:\"code\";i:60170;s:3:\"src\";s:7:\"mfglabs\";}i:1093;a:4:{s:3:\"uid\";s:32:\"a17986e457f3d85f26c9c240dfd6a4ba\";s:3:\"css\";s:6:\"mail-5\";s:4:\"code\";i:60171;s:3:\"src\";s:7:\"mfglabs\";}i:1094;a:4:{s:3:\"uid\";s:32:\"d02a803276d9e1f42b7393964aa22ce9\";s:3:\"css\";s:7:\"heart-5\";s:4:\"code\";i:60172;s:3:\"src\";s:7:\"mfglabs\";}i:1095;a:4:{s:3:\"uid\";s:32:\"862129f833b09f3d34ae39acf8484a7b\";s:3:\"css\";s:12:\"heart-broken\";s:4:\"code\";i:60173;s:3:\"src\";s:7:\"mfglabs\";}i:1096;a:4:{s:3:\"uid\";s:32:\"b392c847bf41826598f12c02be842253\";s:3:\"css\";s:6:\"star-5\";s:4:\"code\";i:60174;s:3:\"src\";s:7:\"mfglabs\";}i:1097;a:4:{s:3:\"uid\";s:32:\"ee382df412dfdf65191b52ae33160abc\";s:3:\"css\";s:12:\"star-empty-2\";s:4:\"code\";i:60175;s:3:\"src\";s:7:\"mfglabs\";}i:1098;a:4:{s:3:\"uid\";s:32:\"3fba70399d61e886bce68721edbc71af\";s:3:\"css\";s:11:\"star-half-1\";s:4:\"code\";i:60176;s:3:\"src\";s:7:\"mfglabs\";}i:1099;a:4:{s:3:\"uid\";s:32:\"689ef8cee6655c255ffdddf5e3188165\";s:3:\"css\";s:15:\"star-half_empty\";s:4:\"code\";i:60177;s:3:\"src\";s:7:\"mfglabs\";}i:1100;a:4:{s:3:\"uid\";s:32:\"11d74f891bce30f1bdf73d3259d59ed5\";s:3:\"css\";s:6:\"user-5\";s:4:\"code\";i:60178;s:3:\"src\";s:7:\"mfglabs\";}i:1101;a:4:{s:3:\"uid\";s:32:\"e5fdc4247f1f9b3bf98d20a954e1327c\";s:3:\"css\";s:9:\"user-male\";s:4:\"code\";i:60179;s:3:\"src\";s:7:\"mfglabs\";}i:1102;a:4:{s:3:\"uid\";s:32:\"a6c0e3fce2fbe9ccf9b1c54c8f399106\";s:3:\"css\";s:11:\"user-female\";s:4:\"code\";i:60180;s:3:\"src\";s:7:\"mfglabs\";}i:1103;a:4:{s:3:\"uid\";s:32:\"05ef9b5e8742971aa85b23cfcbe71594\";s:3:\"css\";s:7:\"users-3\";s:4:\"code\";i:60181;s:3:\"src\";s:7:\"mfglabs\";}i:1104;a:4:{s:3:\"uid\";s:32:\"eea613bc40c77b7eab137b29dba0c62f\";s:3:\"css\";s:5:\"movie\";s:4:\"code\";i:60182;s:3:\"src\";s:7:\"mfglabs\";}i:1105;a:4:{s:3:\"uid\";s:32:\"40c6538b0fd40540bf78373f8a1fb7af\";s:3:\"css\";s:10:\"videocam-3\";s:4:\"code\";i:60183;s:3:\"src\";s:7:\"mfglabs\";}i:1106;a:4:{s:3:\"uid\";s:32:\"e2df3c577fceec26906169fbee71721e\";s:3:\"css\";s:6:\"isight\";s:4:\"code\";i:60184;s:3:\"src\";s:7:\"mfglabs\";}i:1107;a:4:{s:3:\"uid\";s:32:\"41c01fe7bfa79a93a2a2971a7f347fc0\";s:3:\"css\";s:8:\"camera-5\";s:4:\"code\";i:60185;s:3:\"src\";s:7:\"mfglabs\";}i:1108;a:4:{s:3:\"uid\";s:32:\"c55fdf978f617992b43ee7cbaa6ef87e\";s:3:\"css\";s:6:\"menu-3\";s:4:\"code\";i:60186;s:3:\"src\";s:7:\"mfglabs\";}i:1109;a:4:{s:3:\"uid\";s:32:\"2b6bf06e87a223ccd1ddc1874932ca86\";s:3:\"css\";s:8:\"th-thumb\";s:4:\"code\";i:60187;s:3:\"src\";s:7:\"mfglabs\";}i:1110;a:4:{s:3:\"uid\";s:32:\"5eb43711f62fb4dcbef10d0224c28065\";s:3:\"css\";s:14:\"th-thumb-empty\";s:4:\"code\";i:60188;s:3:\"src\";s:7:\"mfglabs\";}i:1111;a:4:{s:3:\"uid\";s:32:\"1b58555745e7378f7634ee7c63eada46\";s:3:\"css\";s:9:\"th-list-3\";s:4:\"code\";i:60189;s:3:\"src\";s:7:\"mfglabs\";}i:1112;a:4:{s:3:\"uid\";s:32:\"ce50292e85eb5d6ee3be61b32bf2bdf3\";s:3:\"css\";s:4:\"ok-4\";s:4:\"code\";i:60190;s:3:\"src\";s:7:\"mfglabs\";}i:1113;a:4:{s:3:\"uid\";s:32:\"5e1ef647438e2204c15197c6efc4151e\";s:3:\"css\";s:12:\"ok-circled-1\";s:4:\"code\";i:60191;s:3:\"src\";s:7:\"mfglabs\";}i:1114;a:4:{s:3:\"uid\";s:32:\"06301c50d89b5d3e651bd07ebd6d7de7\";s:3:\"css\";s:8:\"cancel-5\";s:4:\"code\";i:60192;s:3:\"src\";s:7:\"mfglabs\";}i:1115;a:4:{s:3:\"uid\";s:32:\"44eb9d69bf3b9b74629ce6852a2f9681\";s:3:\"css\";s:16:\"cancel-circled-3\";s:4:\"code\";i:60193;s:3:\"src\";s:7:\"mfglabs\";}i:1116;a:4:{s:3:\"uid\";s:32:\"63e91725cfc5751fe4d772325fd50830\";s:3:\"css\";s:6:\"plus-5\";s:4:\"code\";i:60194;s:3:\"src\";s:7:\"mfglabs\";}i:1117;a:4:{s:3:\"uid\";s:32:\"a3d734a5b4bec33fc3aa459d82092b23\";s:3:\"css\";s:14:\"help-circled-2\";s:4:\"code\";i:60195;s:3:\"src\";s:7:\"mfglabs\";}i:1118;a:4:{s:3:\"uid\";s:32:\"3e02a8849305ac80a0e36302f461f265\";s:3:\"css\";s:16:\"help-circled-alt\";s:4:\"code\";i:60196;s:3:\"src\";s:7:\"mfglabs\";}i:1119;a:4:{s:3:\"uid\";s:32:\"8f25d96c5665c84e4403538eef14ec2c\";s:3:\"css\";s:14:\"info-circled-2\";s:4:\"code\";i:60197;s:3:\"src\";s:7:\"mfglabs\";}i:1120;a:4:{s:3:\"uid\";s:32:\"15ba51cbb4d05e6fb88f03a31a7c711c\";s:3:\"css\";s:16:\"info-circled-alt\";s:4:\"code\";i:60198;s:3:\"src\";s:7:\"mfglabs\";}i:1121;a:4:{s:3:\"uid\";s:32:\"018571e697f22ca41803de480e10ed10\";s:3:\"css\";s:6:\"home-5\";s:4:\"code\";i:60199;s:3:\"src\";s:7:\"mfglabs\";}i:1122;a:4:{s:3:\"uid\";s:32:\"1fb8776fe6f1d3bbf970996fdfcf0f94\";s:3:\"css\";s:6:\"link-4\";s:4:\"code\";i:60200;s:3:\"src\";s:7:\"mfglabs\";}i:1123;a:4:{s:3:\"uid\";s:32:\"9746a4ace95e1797c94cd2fe05c22485\";s:3:\"css\";s:8:\"attach-4\";s:4:\"code\";i:60201;s:3:\"src\";s:7:\"mfglabs\";}i:1124;a:4:{s:3:\"uid\";s:32:\"7997220c4eb58edae98e04de570089c2\";s:3:\"css\";s:6:\"lock-5\";s:4:\"code\";i:60202;s:3:\"src\";s:7:\"mfglabs\";}i:1125;a:4:{s:3:\"uid\";s:32:\"b10e25220faa78c808527a4ba8b5c0f9\";s:3:\"css\";s:8:\"lock-alt\";s:4:\"code\";i:60203;s:3:\"src\";s:7:\"mfglabs\";}i:1126;a:4:{s:3:\"uid\";s:32:\"e67bcab050d99eb04d44027139ae05f5\";s:3:\"css\";s:11:\"lock-open-5\";s:4:\"code\";i:60204;s:3:\"src\";s:7:\"mfglabs\";}i:1127;a:4:{s:3:\"uid\";s:32:\"8167f6441d2557a90d717a7fc3248760\";s:3:\"css\";s:15:\"lock-open-alt-1\";s:4:\"code\";i:60205;s:3:\"src\";s:7:\"mfglabs\";}i:1128;a:4:{s:3:\"uid\";s:32:\"518ed8d836b8f75393d6d239291fedb0\";s:3:\"css\";s:5:\"eye-5\";s:4:\"code\";i:60206;s:3:\"src\";s:7:\"mfglabs\";}i:1129;a:4:{s:3:\"uid\";s:32:\"348b04ea17f646fbc6a46e20ebe4fe12\";s:3:\"css\";s:10:\"download-5\";s:4:\"code\";i:60207;s:3:\"src\";s:7:\"mfglabs\";}i:1130;a:4:{s:3:\"uid\";s:32:\"4f3b31017c63ba04dc4f78ce7a8f02b1\";s:3:\"css\";s:8:\"upload-4\";s:4:\"code\";i:60208;s:3:\"src\";s:7:\"mfglabs\";}i:1131;a:4:{s:3:\"uid\";s:32:\"74ba7c7ac7610225ab8655f50ad179b6\";s:3:\"css\";s:16:\"download-cloud-2\";s:4:\"code\";i:60209;s:3:\"src\";s:7:\"mfglabs\";}i:1132;a:4:{s:3:\"uid\";s:32:\"cb0d73e6d41217d85fc81cea45dd6e91\";s:3:\"css\";s:14:\"upload-cloud-4\";s:4:\"code\";i:60210;s:3:\"src\";s:7:\"mfglabs\";}i:1133;a:4:{s:3:\"uid\";s:32:\"00e1f929aa3c591e05de52eb94eda625\";s:3:\"css\";s:7:\"reply-3\";s:4:\"code\";i:60211;s:3:\"src\";s:7:\"mfglabs\";}i:1134;a:4:{s:3:\"uid\";s:32:\"0299bec28699eedda42f46c77239393e\";s:3:\"css\";s:8:\"pencil-5\";s:4:\"code\";i:60212;s:3:\"src\";s:7:\"mfglabs\";}i:1135;a:4:{s:3:\"uid\";s:32:\"d4824d88566b0ac66d2cdcff3408690b\";s:3:\"css\";s:8:\"export-4\";s:4:\"code\";i:60213;s:3:\"src\";s:7:\"mfglabs\";}i:1136;a:4:{s:3:\"uid\";s:32:\"60e11e35624b5012017eb10d2d7bd060\";s:3:\"css\";s:7:\"print-4\";s:4:\"code\";i:60214;s:3:\"src\";s:7:\"mfglabs\";}i:1137;a:4:{s:3:\"uid\";s:32:\"26abd5de5952c46cf3a31f70330241a0\";s:3:\"css\";s:9:\"retweet-2\";s:4:\"code\";i:60215;s:3:\"src\";s:7:\"mfglabs\";}i:1138;a:4:{s:3:\"uid\";s:32:\"51fb22f9ff9d7f60c95ef31e4c59502d\";s:3:\"css\";s:9:\"comment-4\";s:4:\"code\";i:60216;s:3:\"src\";s:7:\"mfglabs\";}i:1139;a:4:{s:3:\"uid\";s:32:\"a8ed7903f8f548da5a8084e1773f0bbb\";s:3:\"css\";s:6:\"chat-5\";s:4:\"code\";i:60217;s:3:\"src\";s:7:\"mfglabs\";}i:1140;a:4:{s:3:\"uid\";s:32:\"ebb8fb741e0b3e794c90555e5f225adf\";s:3:\"css\";s:6:\"bell-4\";s:4:\"code\";i:60218;s:3:\"src\";s:7:\"mfglabs\";}i:1141;a:4:{s:3:\"uid\";s:32:\"189edfc41118cccbeb25788fcbb403da\";s:3:\"css\";s:11:\"attention-4\";s:4:\"code\";i:60219;s:3:\"src\";s:7:\"mfglabs\";}i:1142;a:4:{s:3:\"uid\";s:32:\"55389e7d75fe0458efcb909f78e7ad3f\";s:3:\"css\";s:15:\"attention-alt-1\";s:4:\"code\";i:60220;s:3:\"src\";s:7:\"mfglabs\";}i:1143;a:4:{s:3:\"uid\";s:32:\"291e2e127efe7a6bc580af6d3ead3771\";s:3:\"css\";s:10:\"location-5\";s:4:\"code\";i:60221;s:3:\"src\";s:7:\"mfglabs\";}i:1144;a:4:{s:3:\"uid\";s:32:\"a6267a0b7262e1deffcc83076bc0e197\";s:3:\"css\";s:7:\"trash-5\";s:4:\"code\";i:60222;s:3:\"src\";s:7:\"mfglabs\";}i:1145;a:4:{s:3:\"uid\";s:32:\"7141927f949e757c7e218cf70d9dceb4\";s:3:\"css\";s:5:\"doc-5\";s:4:\"code\";i:60223;s:3:\"src\";s:7:\"mfglabs\";}i:1146;a:4:{s:3:\"uid\";s:32:\"18be7ed7a4baf5713f2de51bf83b12f2\";s:3:\"css\";s:11:\"newspaper-1\";s:4:\"code\";i:60224;s:3:\"src\";s:7:\"mfglabs\";}i:1147;a:4:{s:3:\"uid\";s:32:\"c619e17229d6c874dfc70be359b6b3f1\";s:3:\"css\";s:8:\"folder-4\";s:4:\"code\";i:60225;s:3:\"src\";s:7:\"mfglabs\";}i:1148;a:4:{s:3:\"uid\";s:32:\"8e6b311d40f1002fd6de7d1bdfdc7f17\";s:3:\"css\";s:13:\"folder-open-1\";s:4:\"code\";i:60226;s:3:\"src\";s:7:\"mfglabs\";}i:1149;a:4:{s:3:\"uid\";s:32:\"4c4bb0011585456def6562bf27186b63\";s:3:\"css\";s:14:\"folder-empty-2\";s:4:\"code\";i:60227;s:3:\"src\";s:7:\"mfglabs\";}i:1150;a:4:{s:3:\"uid\";s:32:\"8f28e6daf83e5c4f1fec8d170a7e21e7\";s:3:\"css\";s:19:\"folder-open-empty-1\";s:4:\"code\";i:60228;s:3:\"src\";s:7:\"mfglabs\";}i:1151;a:4:{s:3:\"uid\";s:32:\"7336247ba3db350dec8d6c0a47cef966\";s:3:\"css\";s:5:\"cog-4\";s:4:\"code\";i:60229;s:3:\"src\";s:7:\"mfglabs\";}i:1152;a:4:{s:3:\"uid\";s:32:\"4615d277156195624f442e69958ea863\";s:3:\"css\";s:10:\"calendar-5\";s:4:\"code\";i:60230;s:3:\"src\";s:7:\"mfglabs\";}i:1153;a:4:{s:3:\"uid\";s:32:\"5adef5b3275fcd874b0815a0637c5800\";s:3:\"css\";s:7:\"login-2\";s:4:\"code\";i:60231;s:3:\"src\";s:7:\"mfglabs\";}i:1154;a:4:{s:3:\"uid\";s:32:\"a6b6f85116fc55e4a7c83d66973035a7\";s:3:\"css\";s:8:\"logout-2\";s:4:\"code\";i:60232;s:3:\"src\";s:7:\"mfglabs\";}i:1155;a:4:{s:3:\"uid\";s:32:\"858e967d1c67608546add6beebade5b3\";s:3:\"css\";s:5:\"mic-4\";s:4:\"code\";i:60233;s:3:\"src\";s:7:\"mfglabs\";}i:1156;a:4:{s:3:\"uid\";s:32:\"5dc427ad9f0644447ca5292911c378f1\";s:3:\"css\";s:7:\"mic-off\";s:4:\"code\";i:60234;s:3:\"src\";s:7:\"mfglabs\";}i:1157;a:4:{s:3:\"uid\";s:32:\"981c9f3d44fd4fd6b37c0b5a981334ce\";s:3:\"css\";s:7:\"clock-5\";s:4:\"code\";i:60235;s:3:\"src\";s:7:\"mfglabs\";}i:1158;a:4:{s:3:\"uid\";s:32:\"53c977df16b09e3f7700a27ec90c43dc\";s:3:\"css\";s:11:\"stopwatch-1\";s:4:\"code\";i:60236;s:3:\"src\";s:7:\"mfglabs\";}i:1159;a:4:{s:3:\"uid\";s:32:\"35ce53990ec0892d7dcea2d0159f8dca\";s:3:\"css\";s:11:\"hourglass-1\";s:4:\"code\";i:60237;s:3:\"src\";s:7:\"mfglabs\";}i:1160;a:4:{s:3:\"uid\";s:32:\"baaebda77cf391a9d9ecdec4db11dcb7\";s:3:\"css\";s:9:\"zoom-in-3\";s:4:\"code\";i:60238;s:3:\"src\";s:7:\"mfglabs\";}i:1161;a:4:{s:3:\"uid\";s:32:\"3a9c5809bfc7b653c3b165b979f5d93e\";s:3:\"css\";s:10:\"zoom-out-3\";s:4:\"code\";i:60239;s:3:\"src\";s:7:\"mfglabs\";}i:1162;a:4:{s:3:\"uid\";s:32:\"d9be617b7f2fe7843118ca2d3a1b8cca\";s:3:\"css\";s:11:\"down-open-2\";s:4:\"code\";i:60240;s:3:\"src\";s:7:\"mfglabs\";}i:1163;a:4:{s:3:\"uid\";s:32:\"b714be5a812a474811604f700dfc87ce\";s:3:\"css\";s:11:\"left-open-3\";s:4:\"code\";i:60241;s:3:\"src\";s:7:\"mfglabs\";}i:1164;a:4:{s:3:\"uid\";s:32:\"37910a1398001a5ccb541cb2a253a2c7\";s:3:\"css\";s:12:\"right-open-3\";s:4:\"code\";i:60242;s:3:\"src\";s:7:\"mfglabs\";}i:1165;a:4:{s:3:\"uid\";s:32:\"440e148d0e21100118eae7036bcd2067\";s:3:\"css\";s:9:\"up-open-2\";s:4:\"code\";i:60243;s:3:\"src\";s:7:\"mfglabs\";}i:1166;a:4:{s:3:\"uid\";s:32:\"3838a5aba604532d2dbae5904615ea39\";s:3:\"css\";s:6:\"down-5\";s:4:\"code\";i:60244;s:3:\"src\";s:7:\"mfglabs\";}i:1167;a:4:{s:3:\"uid\";s:32:\"c21d309f797d3644dc8d28c4617738ce\";s:3:\"css\";s:6:\"left-4\";s:4:\"code\";i:60245;s:3:\"src\";s:7:\"mfglabs\";}i:1168;a:4:{s:3:\"uid\";s:32:\"1d35198f5190ec004dd4ec742fbe19ca\";s:3:\"css\";s:7:\"right-4\";s:4:\"code\";i:60246;s:3:\"src\";s:7:\"mfglabs\";}i:1169;a:4:{s:3:\"uid\";s:32:\"040e72500c863813088c9f9c9415f8e9\";s:3:\"css\";s:4:\"up-5\";s:4:\"code\";i:60247;s:3:\"src\";s:7:\"mfglabs\";}i:1170;a:4:{s:3:\"uid\";s:32:\"bd6176c7f1bd64eec8904241316f2f52\";s:3:\"css\";s:11:\"down-bold-1\";s:4:\"code\";i:60248;s:3:\"src\";s:7:\"mfglabs\";}i:1171;a:4:{s:3:\"uid\";s:32:\"413160f2a26366d3c1d544bf1221a6ca\";s:3:\"css\";s:11:\"left-bold-1\";s:4:\"code\";i:60249;s:3:\"src\";s:7:\"mfglabs\";}i:1172;a:4:{s:3:\"uid\";s:32:\"e26b9d4bdcd0b60ed2cafa8f41ffc6d2\";s:3:\"css\";s:12:\"right-bold-1\";s:4:\"code\";i:60250;s:3:\"src\";s:7:\"mfglabs\";}i:1173;a:4:{s:3:\"uid\";s:32:\"985defa766987e1e038c807527100b15\";s:3:\"css\";s:9:\"up-bold-1\";s:4:\"code\";i:60251;s:3:\"src\";s:7:\"mfglabs\";}i:1174;a:4:{s:3:\"uid\";s:32:\"335c443d3231b944287309aa2593c880\";s:3:\"css\";s:8:\"down-fat\";s:4:\"code\";i:60252;s:3:\"src\";s:7:\"mfglabs\";}i:1175;a:4:{s:3:\"uid\";s:32:\"fd2ed680ef900acb68836a99ec1a4de7\";s:3:\"css\";s:8:\"left-fat\";s:4:\"code\";i:60253;s:3:\"src\";s:7:\"mfglabs\";}i:1176;a:4:{s:3:\"uid\";s:32:\"54c3330bdeed0fb9042e12d16d46c9ab\";s:3:\"css\";s:9:\"right-fat\";s:4:\"code\";i:60254;s:3:\"src\";s:7:\"mfglabs\";}i:1177;a:4:{s:3:\"uid\";s:32:\"d21293ba68a7dcfec696464ae64949e1\";s:3:\"css\";s:6:\"up-fat\";s:4:\"code\";i:60255;s:3:\"src\";s:7:\"mfglabs\";}i:1178;a:4:{s:3:\"uid\";s:32:\"c74dc50bfc8aa68f0d23010ad8960cb2\";s:3:\"css\";s:5:\"ccw-2\";s:4:\"code\";i:60256;s:3:\"src\";s:7:\"mfglabs\";}i:1179;a:4:{s:3:\"uid\";s:32:\"9c3b8d8a6d477da4d3e65b92e4e9c290\";s:3:\"css\";s:9:\"shuffle-3\";s:4:\"code\";i:60257;s:3:\"src\";s:7:\"mfglabs\";}i:1180;a:4:{s:3:\"uid\";s:32:\"3711151b8b34536498e2a7f4d5188ed2\";s:3:\"css\";s:6:\"play-4\";s:4:\"code\";i:60258;s:3:\"src\";s:7:\"mfglabs\";}i:1181;a:4:{s:3:\"uid\";s:32:\"164f35b55c3346b03fa89a711a4f3980\";s:3:\"css\";s:7:\"pause-4\";s:4:\"code\";i:60259;s:3:\"src\";s:7:\"mfglabs\";}i:1182;a:4:{s:3:\"uid\";s:32:\"0a38a63796b90318b5fca493c3d4a17a\";s:3:\"css\";s:6:\"stop-5\";s:4:\"code\";i:60260;s:3:\"src\";s:7:\"mfglabs\";}i:1183;a:4:{s:3:\"uid\";s:32:\"dcda6b27f1f63fbd7b8bf8d45cc4d340\";s:3:\"css\";s:8:\"to-end-3\";s:4:\"code\";i:60261;s:3:\"src\";s:7:\"mfglabs\";}i:1184;a:4:{s:3:\"uid\";s:32:\"75b228ebc26946ca00360ca10f052e3c\";s:3:\"css\";s:10:\"to-start-3\";s:4:\"code\";i:60262;s:3:\"src\";s:7:\"mfglabs\";}i:1185;a:4:{s:3:\"uid\";s:32:\"59a3c018a7c1888658e4d93df8f7558f\";s:3:\"css\";s:14:\"fast-forward-1\";s:4:\"code\";i:60263;s:3:\"src\";s:7:\"mfglabs\";}i:1186;a:4:{s:3:\"uid\";s:32:\"ee0b543733d75a60ff5647070dc1d4f8\";s:3:\"css\";s:15:\"fast-backward-1\";s:4:\"code\";i:60264;s:3:\"src\";s:7:\"mfglabs\";}i:1187;a:4:{s:3:\"uid\";s:32:\"288c5a1dd34328f851587538998e4b3e\";s:3:\"css\";s:8:\"trophy-1\";s:4:\"code\";i:60265;s:3:\"src\";s:7:\"mfglabs\";}i:1188;a:4:{s:3:\"uid\";s:32:\"700cae9dc028202c4549471b56f516dd\";s:3:\"css\";s:9:\"monitor-1\";s:4:\"code\";i:60266;s:3:\"src\";s:7:\"mfglabs\";}i:1189;a:4:{s:3:\"uid\";s:32:\"9693479d330d4e539cebdb8a7ce398f4\";s:3:\"css\";s:8:\"tablet-3\";s:4:\"code\";i:60267;s:3:\"src\";s:7:\"mfglabs\";}i:1190;a:4:{s:3:\"uid\";s:32:\"31b90585534c8b455469d84a95f1959b\";s:3:\"css\";s:8:\"mobile-5\";s:4:\"code\";i:60268;s:3:\"src\";s:7:\"mfglabs\";}i:1191;a:4:{s:3:\"uid\";s:32:\"14c9e8bd3e747ecb08cae42f5564a671\";s:3:\"css\";s:12:\"data-science\";s:4:\"code\";i:60269;s:3:\"src\";s:7:\"mfglabs\";}i:1192;a:4:{s:3:\"uid\";s:32:\"a1bd477f92e956144558e6b6c671ed6e\";s:3:\"css\";s:16:\"data-science-inv\";s:4:\"code\";i:60270;s:3:\"src\";s:7:\"mfglabs\";}i:1193;a:4:{s:3:\"uid\";s:32:\"dcbef4ff6ce6ffc7599d23e0c2b029af\";s:3:\"css\";s:7:\"inbox-2\";s:4:\"code\";i:60271;s:3:\"src\";s:7:\"mfglabs\";}i:1194;a:4:{s:3:\"uid\";s:32:\"117d7f4e196f826847929c6550734615\";s:3:\"css\";s:7:\"globe-4\";s:4:\"code\";i:60272;s:3:\"src\";s:7:\"mfglabs\";}i:1195;a:4:{s:3:\"uid\";s:32:\"77bf693b887ab9243826db6e682ea973\";s:3:\"css\";s:9:\"globe-inv\";s:4:\"code\";i:60273;s:3:\"src\";s:7:\"mfglabs\";}i:1196;a:4:{s:3:\"uid\";s:32:\"77928c849ac2ae6e77d4eae9f2927c00\";s:3:\"css\";s:7:\"flash-4\";s:4:\"code\";i:60274;s:3:\"src\";s:7:\"mfglabs\";}i:1197;a:4:{s:3:\"uid\";s:32:\"f08fd9b6b61b3670cf88ed64da891cae\";s:3:\"css\";s:7:\"cloud-5\";s:4:\"code\";i:60275;s:3:\"src\";s:7:\"mfglabs\";}i:1198;a:4:{s:3:\"uid\";s:32:\"d3fa106db96ff869d1ad75506ba5ff50\";s:3:\"css\";s:9:\"coverflow\";s:4:\"code\";i:60276;s:3:\"src\";s:7:\"mfglabs\";}i:1199;a:4:{s:3:\"uid\";s:32:\"cf0523ff3f333523eb6e9f6642dd0ddc\";s:3:\"css\";s:15:\"coverflow-empty\";s:4:\"code\";i:60277;s:3:\"src\";s:7:\"mfglabs\";}i:1200;a:4:{s:3:\"uid\";s:32:\"c5fd68d8253e605e7a78a0c75255b692\";s:3:\"css\";s:4:\"math\";s:4:\"code\";i:60278;s:3:\"src\";s:7:\"mfglabs\";}i:1201;a:4:{s:3:\"uid\";s:32:\"b74284571c2d4d0d251bd28dace4a1ba\";s:3:\"css\";s:12:\"math-circled\";s:4:\"code\";i:60279;s:3:\"src\";s:7:\"mfglabs\";}i:1202;a:4:{s:3:\"uid\";s:32:\"ae734e5d304b9680558ab6b4449d55ee\";s:3:\"css\";s:18:\"math-circled-empty\";s:4:\"code\";i:60280;s:3:\"src\";s:7:\"mfglabs\";}i:1203;a:4:{s:3:\"uid\";s:32:\"cdb000f745167bbada14e2c1d8404d98\";s:3:\"css\";s:13:\"paper-plane-1\";s:4:\"code\";i:60281;s:3:\"src\";s:7:\"mfglabs\";}i:1204;a:4:{s:3:\"uid\";s:32:\"b50bdfb03ec13c11ff72329eb70b3e2e\";s:3:\"css\";s:15:\"paper-plane-alt\";s:4:\"code\";i:60282;s:3:\"src\";s:7:\"mfglabs\";}i:1205;a:4:{s:3:\"uid\";s:32:\"55035f2a3ae604a7c45a9e2e626aaef5\";s:3:\"css\";s:16:\"paper-plane-alt2\";s:4:\"code\";i:60283;s:3:\"src\";s:7:\"mfglabs\";}i:1206;a:4:{s:3:\"uid\";s:32:\"3b6f20ef4c4940aeaed84d973b2f6e64\";s:3:\"css\";s:8:\"fontsize\";s:4:\"code\";i:60284;s:3:\"src\";s:7:\"mfglabs\";}i:1207;a:4:{s:3:\"uid\";s:32:\"14e9aa28bf2a3531274f85194e733b71\";s:3:\"css\";s:12:\"color-adjust\";s:4:\"code\";i:60285;s:3:\"src\";s:7:\"mfglabs\";}i:1208;a:4:{s:3:\"uid\";s:32:\"cc6a79edb1e82ee90129147ba089c323\";s:3:\"css\";s:6:\"fire-1\";s:4:\"code\";i:60286;s:3:\"src\";s:7:\"mfglabs\";}i:1209;a:4:{s:3:\"uid\";s:32:\"c46c42ae95f46394bd2f9c9a9cc5f768\";s:3:\"css\";s:11:\"chart-bar-5\";s:4:\"code\";i:60287;s:3:\"src\";s:7:\"mfglabs\";}i:1210;a:4:{s:3:\"uid\";s:32:\"f6650ca3f02625f4e1fcc9d4bd9b7b93\";s:3:\"css\";s:5:\"hdd-1\";s:4:\"code\";i:60288;s:3:\"src\";s:7:\"mfglabs\";}i:1211;a:4:{s:3:\"uid\";s:32:\"8dd9284cd4fa233d3972e48b417b3ca2\";s:3:\"css\";s:16:\"connected-object\";s:4:\"code\";i:60289;s:3:\"src\";s:7:\"mfglabs\";}i:1212;a:4:{s:3:\"uid\";s:32:\"6a96c51e961a2e48dfcbe2c47fd1204e\";s:3:\"css\";s:5:\"ruler\";s:4:\"code\";i:60290;s:3:\"src\";s:7:\"mfglabs\";}i:1213;a:4:{s:3:\"uid\";s:32:\"33afa0f624ce5dae73f62a3f21a67f83\";s:3:\"css\";s:6:\"vector\";s:4:\"code\";i:60291;s:3:\"src\";s:7:\"mfglabs\";}i:1214;a:4:{s:3:\"uid\";s:32:\"134af7f39e491515cc1a6d1eb94d9d8a\";s:3:\"css\";s:13:\"vector-pencil\";s:4:\"code\";i:60292;s:3:\"src\";s:7:\"mfglabs\";}i:1215;a:4:{s:3:\"uid\";s:32:\"874694a9126e8193bca844356d1b6328\";s:3:\"css\";s:4:\"at-3\";s:4:\"code\";i:60293;s:3:\"src\";s:7:\"mfglabs\";}i:1216;a:4:{s:3:\"uid\";s:32:\"da72ab64b02d997ff0521339f2997233\";s:3:\"css\";s:6:\"hash-1\";s:4:\"code\";i:60294;s:3:\"src\";s:7:\"mfglabs\";}i:1217;a:4:{s:3:\"uid\";s:32:\"10b2be8b48bebc1974d6f94bac9de71d\";s:3:\"css\";s:8:\"female-1\";s:4:\"code\";i:60295;s:3:\"src\";s:7:\"mfglabs\";}i:1218;a:4:{s:3:\"uid\";s:32:\"23c2239369a69f752e790de95123b9e9\";s:3:\"css\";s:6:\"male-1\";s:4:\"code\";i:60296;s:3:\"src\";s:7:\"mfglabs\";}i:1219;a:4:{s:3:\"uid\";s:32:\"500cde26773d15aaac1bfaa2a33cc5a9\";s:3:\"css\";s:6:\"spread\";s:4:\"code\";i:60297;s:3:\"src\";s:7:\"mfglabs\";}i:1220;a:4:{s:3:\"uid\";s:32:\"ee8014a23bf900eae0103c7699718bc7\";s:3:\"css\";s:4:\"king\";s:4:\"code\";i:60298;s:3:\"src\";s:7:\"mfglabs\";}i:1221;a:4:{s:3:\"uid\";s:32:\"dd432b7aa4b7c276a475015a93dec8a3\";s:3:\"css\";s:8:\"anchor-2\";s:4:\"code\";i:60299;s:3:\"src\";s:7:\"mfglabs\";}i:1222;a:4:{s:3:\"uid\";s:32:\"d0df4d152daa276ccf31ac968c1dd103\";s:3:\"css\";s:8:\"joystick\";s:4:\"code\";i:60300;s:3:\"src\";s:7:\"mfglabs\";}i:1223;a:4:{s:3:\"uid\";s:32:\"fccd3ea0efb711b849045bee686b1ceb\";s:3:\"css\";s:21:\"spinner1 animate-spin\";s:4:\"code\";i:60301;s:3:\"src\";s:7:\"mfglabs\";}i:1224;a:4:{s:3:\"uid\";s:32:\"9b0229b620364d8704940e408dde73fb\";s:3:\"css\";s:21:\"spinner2 animate-spin\";s:4:\"code\";i:60302;s:3:\"src\";s:7:\"mfglabs\";}i:1225;a:4:{s:3:\"uid\";s:32:\"9ea28ba01d59a4410fa3db9c02cce157\";s:3:\"css\";s:8:\"github-3\";s:4:\"code\";i:60303;s:3:\"src\";s:7:\"mfglabs\";}i:1226;a:4:{s:3:\"uid\";s:32:\"3261112d66c6462ea20893f42b6f799b\";s:3:\"css\";s:16:\"github-circled-3\";s:4:\"code\";i:60304;s:3:\"src\";s:7:\"mfglabs\";}i:1227;a:4:{s:3:\"uid\";s:32:\"3c2cfcbad5062929d63a249f3858e38b\";s:3:\"css\";s:18:\"github-circled-alt\";s:4:\"code\";i:60305;s:3:\"src\";s:7:\"mfglabs\";}i:1228;a:4:{s:3:\"uid\";s:32:\"8669af50382b53c48b9b803692828dd0\";s:3:\"css\";s:19:\"github-circled-alt2\";s:4:\"code\";i:60306;s:3:\"src\";s:7:\"mfglabs\";}i:1229;a:4:{s:3:\"uid\";s:32:\"ec3648a34c41b70671dc38dbb72deb04\";s:3:\"css\";s:9:\"twitter-4\";s:4:\"code\";i:60307;s:3:\"src\";s:7:\"mfglabs\";}i:1230;a:4:{s:3:\"uid\";s:32:\"ccf7ed45e7f05a89376f38abaa9d7d13\";s:3:\"css\";s:17:\"twitter-circled-2\";s:4:\"code\";i:60308;s:3:\"src\";s:7:\"mfglabs\";}i:1231;a:4:{s:3:\"uid\";s:32:\"53d4dc777eeba379412efba3ee1cac9e\";s:3:\"css\";s:10:\"facebook-4\";s:4:\"code\";i:60309;s:3:\"src\";s:7:\"mfglabs\";}i:1232;a:4:{s:3:\"uid\";s:32:\"96aafeab29734d1510805687f7695f8f\";s:3:\"css\";s:18:\"facebook-circled-2\";s:4:\"code\";i:60310;s:3:\"src\";s:7:\"mfglabs\";}i:1233;a:4:{s:3:\"uid\";s:32:\"c896fd4e287aebcf79803e0ece001ec1\";s:3:\"css\";s:7:\"gplus-2\";s:4:\"code\";i:60311;s:3:\"src\";s:7:\"mfglabs\";}i:1234;a:4:{s:3:\"uid\";s:32:\"fef29532e2318a0c604f34947024b990\";s:3:\"css\";s:15:\"gplus-circled-1\";s:4:\"code\";i:60312;s:3:\"src\";s:7:\"mfglabs\";}i:1235;a:4:{s:3:\"uid\";s:32:\"f09340446e327a78969ea1bfac29c1a6\";s:3:\"css\";s:10:\"linkedin-3\";s:4:\"code\";i:60313;s:3:\"src\";s:7:\"mfglabs\";}i:1236;a:4:{s:3:\"uid\";s:32:\"d0c177a8e1688175c3445cc6b25bcc90\";s:3:\"css\";s:18:\"linkedin-circled-2\";s:4:\"code\";i:60314;s:3:\"src\";s:7:\"mfglabs\";}i:1237;a:4:{s:3:\"uid\";s:32:\"2653481d01fec1b76247dbeffb74033e\";s:3:\"css\";s:10:\"dribbble-3\";s:4:\"code\";i:60315;s:3:\"src\";s:7:\"mfglabs\";}i:1238;a:4:{s:3:\"uid\";s:32:\"c5fa38a7b77f4efad5d8691b05035c7b\";s:3:\"css\";s:18:\"dribbble-circled-2\";s:4:\"code\";i:60316;s:3:\"src\";s:7:\"mfglabs\";}i:1239;a:4:{s:3:\"uid\";s:32:\"603ebbc4040323ef53ba1dc37de67717\";s:3:\"css\";s:11:\"instagram-1\";s:4:\"code\";i:60317;s:3:\"src\";s:7:\"mfglabs\";}i:1240;a:4:{s:3:\"uid\";s:32:\"0a16125788558bcc5d70ae3f10effce5\";s:3:\"css\";s:17:\"instagram-circled\";s:4:\"code\";i:60318;s:3:\"src\";s:7:\"mfglabs\";}i:1241;a:4:{s:3:\"uid\";s:32:\"c7715df42d0413b3cae83d4bc3943a3e\";s:3:\"css\";s:12:\"soundcloud-1\";s:4:\"code\";i:60319;s:3:\"src\";s:7:\"mfglabs\";}i:1242;a:4:{s:3:\"uid\";s:32:\"a12362e50cbf1078c509d85bc3e4431f\";s:3:\"css\";s:18:\"soundcloud-circled\";s:4:\"code\";i:60320;s:3:\"src\";s:7:\"mfglabs\";}i:1243;a:4:{s:3:\"uid\";s:32:\"ca4775510f9b79d63d9ad7d258f31af9\";s:3:\"css\";s:8:\"mfg-logo\";s:4:\"code\";i:60321;s:3:\"src\";s:7:\"mfglabs\";}i:1244;a:4:{s:3:\"uid\";s:32:\"c37cda0d4ee654abafc9a896da259977\";s:3:\"css\";s:16:\"mfg-logo-circled\";s:4:\"code\";i:60322;s:3:\"src\";s:7:\"mfglabs\";}i:1245;a:4:{s:3:\"uid\";s:32:\"88a1241bcbe45c8e9616fd34d0f68a55\";s:3:\"css\";s:16:\"aboveground-rail\";s:4:\"code\";i:60323;s:3:\"src\";s:4:\"maki\";}i:1246;a:4:{s:3:\"uid\";s:32:\"ee81e35eef77c7d4d26c75258f028bff\";s:3:\"css\";s:8:\"airfield\";s:4:\"code\";i:60324;s:3:\"src\";s:4:\"maki\";}i:1247;a:4:{s:3:\"uid\";s:32:\"f7440aaf96d590adceeff59b4dcb32d0\";s:3:\"css\";s:7:\"airport\";s:4:\"code\";i:60325;s:3:\"src\";s:4:\"maki\";}i:1248;a:4:{s:3:\"uid\";s:32:\"05417ae0104ab18a0fe454358579a987\";s:3:\"css\";s:11:\"art-gallery\";s:4:\"code\";i:60326;s:3:\"src\";s:4:\"maki\";}i:1249;a:4:{s:3:\"uid\";s:32:\"5c8822b310f20896a3c55a25b71008a8\";s:3:\"css\";s:3:\"bar\";s:4:\"code\";i:60327;s:3:\"src\";s:4:\"maki\";}i:1250;a:4:{s:3:\"uid\";s:32:\"dc4eb27cd8f0cd537206d00dd85c0286\";s:3:\"css\";s:8:\"baseball\";s:4:\"code\";i:60328;s:3:\"src\";s:4:\"maki\";}i:1251;a:4:{s:3:\"uid\";s:32:\"9f5ce0d9f586e3df00449ad6ed6b0bf3\";s:3:\"css\";s:10:\"basketball\";s:4:\"code\";i:60329;s:3:\"src\";s:4:\"maki\";}i:1252;a:4:{s:3:\"uid\";s:32:\"77886ff217450e06c8ffb7c88cb41e8b\";s:3:\"css\";s:6:\"beer-2\";s:4:\"code\";i:60330;s:3:\"src\";s:4:\"maki\";}i:1253;a:4:{s:3:\"uid\";s:32:\"3fcff44d055ea3e68ea50aaa7d91947f\";s:3:\"css\";s:16:\"belowground-rail\";s:4:\"code\";i:60331;s:3:\"src\";s:4:\"maki\";}i:1254;a:4:{s:3:\"uid\";s:32:\"aab7e7622e6ee1ed8166fb73f20e8c9a\";s:3:\"css\";s:7:\"bicycle\";s:4:\"code\";i:60332;s:3:\"src\";s:4:\"maki\";}i:1255;a:4:{s:3:\"uid\";s:32:\"2b39f74a074e338a67270567e95142cb\";s:3:\"css\";s:3:\"bus\";s:4:\"code\";i:60333;s:3:\"src\";s:4:\"maki\";}i:1256;a:4:{s:3:\"uid\";s:32:\"492fe0ef4cb41d4e4de8502897685399\";s:3:\"css\";s:4:\"cafe\";s:4:\"code\";i:60334;s:3:\"src\";s:4:\"maki\";}i:1257;a:4:{s:3:\"uid\";s:32:\"244d3253e3ca5a0d602dd3574050fe93\";s:3:\"css\";s:8:\"campsite\";s:4:\"code\";i:60335;s:3:\"src\";s:4:\"maki\";}i:1258;a:4:{s:3:\"uid\";s:32:\"cc50849b33fcede3d861f5a94a22969f\";s:3:\"css\";s:8:\"cemetery\";s:4:\"code\";i:60336;s:3:\"src\";s:4:\"maki\";}i:1259;a:4:{s:3:\"uid\";s:32:\"3fe687c833fa36452029b6d57e9149bf\";s:3:\"css\";s:6:\"cinema\";s:4:\"code\";i:60337;s:3:\"src\";s:4:\"maki\";}i:1260;a:4:{s:3:\"uid\";s:32:\"020dbfb0a5a4a25775bc751e5891e161\";s:3:\"css\";s:7:\"college\";s:4:\"code\";i:60338;s:3:\"src\";s:4:\"maki\";}i:1261;a:4:{s:3:\"uid\";s:32:\"fc455b9530e0b37facc289f42a120fdd\";s:3:\"css\";s:19:\"commerical-building\";s:4:\"code\";i:60339;s:3:\"src\";s:4:\"maki\";}i:1262;a:4:{s:3:\"uid\";s:32:\"5f1e8c36dffb553902e0e5c0c71faf6b\";s:3:\"css\";s:13:\"credit-card-3\";s:4:\"code\";i:60340;s:3:\"src\";s:4:\"maki\";}i:1263;a:4:{s:3:\"uid\";s:32:\"3dfa88388f5e84f8e8fdc4f6320c8b44\";s:3:\"css\";s:7:\"cricket\";s:4:\"code\";i:60341;s:3:\"src\";s:4:\"maki\";}i:1264;a:4:{s:3:\"uid\";s:32:\"aec75ed0b4851c282824143392dde047\";s:3:\"css\";s:7:\"embassy\";s:4:\"code\";i:60342;s:3:\"src\";s:4:\"maki\";}i:1265;a:4:{s:3:\"uid\";s:32:\"d27bcf5c8638e4078aaadae1d49b6909\";s:3:\"css\";s:9:\"fast-food\";s:4:\"code\";i:60343;s:3:\"src\";s:4:\"maki\";}i:1266;a:4:{s:3:\"uid\";s:32:\"6d3728ea0e5678ab9cf6840c4a040e34\";s:3:\"css\";s:5:\"ferry\";s:4:\"code\";i:60344;s:3:\"src\";s:4:\"maki\";}i:1267;a:4:{s:3:\"uid\";s:32:\"a9d3392264236bb9fe4d60a130c662d1\";s:3:\"css\";s:12:\"fire-station\";s:4:\"code\";i:60345;s:3:\"src\";s:4:\"maki\";}i:1268;a:4:{s:3:\"uid\";s:32:\"429c0a4a7c5aba2f8a894f98b48529b3\";s:3:\"css\";s:8:\"football\";s:4:\"code\";i:60346;s:3:\"src\";s:4:\"maki\";}i:1269;a:4:{s:3:\"uid\";s:32:\"63af7ffdab0d3546333634c63554bb82\";s:3:\"css\";s:4:\"fuel\";s:4:\"code\";i:60347;s:3:\"src\";s:4:\"maki\";}i:1270;a:4:{s:3:\"uid\";s:32:\"d06b13f30947afbbdae6977413144183\";s:3:\"css\";s:6:\"garden\";s:4:\"code\";i:60348;s:3:\"src\";s:4:\"maki\";}i:1271;a:4:{s:3:\"uid\";s:32:\"8815bdcacab2495dd436f029e78a15d7\";s:3:\"css\";s:7:\"giraffe\";s:4:\"code\";i:60349;s:3:\"src\";s:4:\"maki\";}i:1272;a:4:{s:3:\"uid\";s:32:\"93f72325e13529f1673ae0c3be4b7d22\";s:3:\"css\";s:4:\"golf\";s:4:\"code\";i:60350;s:3:\"src\";s:4:\"maki\";}i:1273;a:4:{s:3:\"uid\";s:32:\"00341f8df1496285c31db5988db1d8b5\";s:3:\"css\";s:13:\"grocery-store\";s:4:\"code\";i:60351;s:3:\"src\";s:4:\"maki\";}i:1274;a:4:{s:3:\"uid\";s:32:\"484b90ec34c04b0db020143526d3c21a\";s:3:\"css\";s:6:\"harbor\";s:4:\"code\";i:60352;s:3:\"src\";s:4:\"maki\";}i:1275;a:4:{s:3:\"uid\";s:32:\"6dddcfc03d1eaa1bfee628ab291072b6\";s:3:\"css\";s:8:\"heliport\";s:4:\"code\";i:60353;s:3:\"src\";s:4:\"maki\";}i:1276;a:4:{s:3:\"uid\";s:32:\"f43389fa3f5a5b152ed0231fe7bb18a7\";s:3:\"css\";s:10:\"hospital-1\";s:4:\"code\";i:60354;s:3:\"src\";s:4:\"maki\";}i:1277;a:4:{s:3:\"uid\";s:32:\"134184de1e4f1dc3d40e0d93bb1ef15e\";s:3:\"css\";s:19:\"industrial-building\";s:4:\"code\";i:60355;s:3:\"src\";s:4:\"maki\";}i:1278;a:4:{s:3:\"uid\";s:32:\"56a766cedf13005162899b02cf9546b9\";s:3:\"css\";s:7:\"library\";s:4:\"code\";i:60356;s:3:\"src\";s:4:\"maki\";}i:1279;a:4:{s:3:\"uid\";s:32:\"de3978220965d0d1b1cbe671a5a57f9a\";s:3:\"css\";s:7:\"lodging\";s:4:\"code\";i:60357;s:3:\"src\";s:4:\"maki\";}i:1280;a:4:{s:3:\"uid\";s:32:\"0b9e9d7b951b0acaac25b9d7ed258120\";s:3:\"css\";s:18:\"london-underground\";s:4:\"code\";i:60358;s:3:\"src\";s:4:\"maki\";}i:1281;a:4:{s:3:\"uid\";s:32:\"3e98530afcd866a9d607f8be2b5aa159\";s:3:\"css\";s:9:\"minefield\";s:4:\"code\";i:60359;s:3:\"src\";s:4:\"maki\";}i:1282;a:4:{s:3:\"uid\";s:32:\"19d9ceb791d76257545e308954808fc1\";s:3:\"css\";s:8:\"monument\";s:4:\"code\";i:60360;s:3:\"src\";s:4:\"maki\";}i:1283;a:4:{s:3:\"uid\";s:32:\"192955900fa17f5677c4fdf2b3f01be7\";s:3:\"css\";s:6:\"museum\";s:4:\"code\";i:60361;s:3:\"src\";s:4:\"maki\";}i:1284;a:4:{s:3:\"uid\";s:32:\"ee10c11395b5660a1e10a19cd66ea654\";s:3:\"css\";s:8:\"pharmacy\";s:4:\"code\";i:60362;s:3:\"src\";s:4:\"maki\";}i:1285;a:4:{s:3:\"uid\";s:32:\"5040789d726273a910ac5b59e9d8227a\";s:3:\"css\";s:5:\"pitch\";s:4:\"code\";i:60363;s:3:\"src\";s:4:\"maki\";}i:1286;a:4:{s:3:\"uid\";s:32:\"2e7c67db76849147d16a6763d07a03a9\";s:3:\"css\";s:6:\"police\";s:4:\"code\";i:60364;s:3:\"src\";s:4:\"maki\";}i:1287;a:4:{s:3:\"uid\";s:32:\"3333e460aa2cf5a69989c42c334a4194\";s:3:\"css\";s:4:\"post\";s:4:\"code\";i:60365;s:3:\"src\";s:4:\"maki\";}i:1288;a:4:{s:3:\"uid\";s:32:\"0151454c6a8abec62b1b8810aca0af6a\";s:3:\"css\";s:6:\"prison\";s:4:\"code\";i:60366;s:3:\"src\";s:4:\"maki\";}i:1289;a:4:{s:3:\"uid\";s:32:\"70276caa975cb1354bc375ca334f6b4b\";s:3:\"css\";s:4:\"rail\";s:4:\"code\";i:60367;s:3:\"src\";s:4:\"maki\";}i:1290;a:4:{s:3:\"uid\";s:32:\"7f8b6c0519d85119a6f41fa3c5794806\";s:3:\"css\";s:19:\"religious-christian\";s:4:\"code\";i:60368;s:3:\"src\";s:4:\"maki\";}i:1291;a:4:{s:3:\"uid\";s:32:\"2e99947836a643225daf0336e4814bb3\";s:3:\"css\";s:15:\"religious-islam\";s:4:\"code\";i:60369;s:3:\"src\";s:4:\"maki\";}i:1292;a:4:{s:3:\"uid\";s:32:\"5604bbb863d0ea7b38dc331705aedb13\";s:3:\"css\";s:16:\"religious-jewish\";s:4:\"code\";i:60370;s:3:\"src\";s:4:\"maki\";}i:1293;a:4:{s:3:\"uid\";s:32:\"5cc58545bb38c912940470480d3df145\";s:3:\"css\";s:10:\"restaurant\";s:4:\"code\";i:60371;s:3:\"src\";s:4:\"maki\";}i:1294;a:4:{s:3:\"uid\";s:32:\"40664a3e8916bfdcc5fb5655d469723e\";s:3:\"css\";s:9:\"roadblock\";s:4:\"code\";i:60372;s:3:\"src\";s:4:\"maki\";}i:1295;a:4:{s:3:\"uid\";s:32:\"653750436fc99eeb29ccd487e6a5bfa6\";s:3:\"css\";s:6:\"school\";s:4:\"code\";i:60373;s:3:\"src\";s:4:\"maki\";}i:1296;a:4:{s:3:\"uid\";s:32:\"83a806d41893e8bc6fac601669c76cd2\";s:3:\"css\";s:4:\"shop\";s:4:\"code\";i:60374;s:3:\"src\";s:4:\"maki\";}i:1297;a:4:{s:3:\"uid\";s:32:\"ebabd8ff4b67bdbba7660952c30813ca\";s:3:\"css\";s:6:\"skiing\";s:4:\"code\";i:60375;s:3:\"src\";s:4:\"maki\";}i:1298;a:4:{s:3:\"uid\";s:32:\"d8813acae9d35ada76fda399a6000587\";s:3:\"css\";s:6:\"soccer\";s:4:\"code\";i:60376;s:3:\"src\";s:4:\"maki\";}i:1299;a:4:{s:3:\"uid\";s:32:\"d368c9b110be1daa21f992afca084b8c\";s:3:\"css\";s:8:\"swimming\";s:4:\"code\";i:60377;s:3:\"src\";s:4:\"maki\";}i:1300;a:4:{s:3:\"uid\";s:32:\"8a4eb4f98d8e0f3686a741c952b03c08\";s:3:\"css\";s:6:\"tennis\";s:4:\"code\";i:60378;s:3:\"src\";s:4:\"maki\";}i:1301;a:4:{s:3:\"uid\";s:32:\"5f89d009e91c94c7c9be2f8711d7a2eb\";s:3:\"css\";s:7:\"theatre\";s:4:\"code\";i:60379;s:3:\"src\";s:4:\"maki\";}i:1302;a:4:{s:3:\"uid\";s:32:\"0d0a49f05cb202227853f85ce5f63cdc\";s:3:\"css\";s:6:\"toilet\";s:4:\"code\";i:60380;s:3:\"src\";s:4:\"maki\";}i:1303;a:4:{s:3:\"uid\";s:32:\"4c8822c296f8b46e1b0a1c0f627be146\";s:3:\"css\";s:9:\"town-hall\";s:4:\"code\";i:60381;s:3:\"src\";s:4:\"maki\";}i:1304;a:4:{s:3:\"uid\";s:32:\"cad619ef78a5500c1e5b3d021d2fdd65\";s:3:\"css\";s:7:\"trash-6\";s:4:\"code\";i:60382;s:3:\"src\";s:4:\"maki\";}i:1305;a:4:{s:3:\"uid\";s:32:\"878dccd7b810bc231a132d86a3028afe\";s:3:\"css\";s:6:\"tree-1\";s:4:\"code\";i:60383;s:3:\"src\";s:4:\"maki\";}i:1306;a:4:{s:3:\"uid\";s:32:\"35b65a48339004a947a1dea3092e1daa\";s:3:\"css\";s:6:\"tree-2\";s:4:\"code\";i:60384;s:3:\"src\";s:4:\"maki\";}i:1307;a:4:{s:3:\"uid\";s:32:\"bc6ef9c6531c54e927e9dc18e45524b2\";s:3:\"css\";s:9:\"warehouse\";s:4:\"code\";i:60385;s:3:\"src\";s:4:\"maki\";}i:1308;a:4:{s:3:\"uid\";s:32:\"446acc3b40ca5654627ffb8bc6b906e7\";s:3:\"css\";s:10:\"duckduckgo\";s:4:\"code\";i:60424;s:3:\"src\";s:6:\"zocial\";}i:1309;a:4:{s:3:\"uid\";s:32:\"86009860c8331a1d90ae269432d6e24f\";s:3:\"css\";s:3:\"aim\";s:4:\"code\";i:60425;s:3:\"src\";s:6:\"zocial\";}i:1310;a:4:{s:3:\"uid\";s:32:\"1e2035b7cbaeb3d902cf9849e456069d\";s:3:\"css\";s:9:\"delicious\";s:4:\"code\";i:60426;s:3:\"src\";s:6:\"zocial\";}i:1311;a:4:{s:3:\"uid\";s:32:\"f5281239de27061e68f4367ba3efee15\";s:3:\"css\";s:8:\"paypal-1\";s:4:\"code\";i:60427;s:3:\"src\";s:6:\"zocial\";}i:1312;a:4:{s:3:\"uid\";s:32:\"c71d7db10ede1349b3a8ae0293b1dbf8\";s:3:\"css\";s:8:\"flattr-1\";s:4:\"code\";i:60428;s:3:\"src\";s:6:\"zocial\";}i:1313;a:4:{s:3:\"uid\";s:32:\"aaf371ab44841e9aaffebd179d324ce4\";s:3:\"css\";s:9:\"android-1\";s:4:\"code\";i:60429;s:3:\"src\";s:6:\"zocial\";}i:1314;a:4:{s:3:\"uid\";s:32:\"ca8881bd09267577150cc4637dc65572\";s:3:\"css\";s:8:\"eventful\";s:4:\"code\";i:60430;s:3:\"src\";s:6:\"zocial\";}i:1315;a:4:{s:3:\"uid\";s:32:\"5556b88a0dc630940f326ab2ffbe7ccc\";s:3:\"css\";s:8:\"smashmag\";s:4:\"code\";i:60431;s:3:\"src\";s:6:\"zocial\";}i:1316;a:4:{s:3:\"uid\";s:32:\"e566d3f1d24f22981f6552d5188e7265\";s:3:\"css\";s:7:\"gplus-3\";s:4:\"code\";i:60432;s:3:\"src\";s:6:\"zocial\";}i:1317;a:4:{s:3:\"uid\";s:32:\"64c2f859fa518d38db7ec7532855ae34\";s:3:\"css\";s:9:\"wikipedia\";s:4:\"code\";i:60433;s:3:\"src\";s:6:\"zocial\";}i:1318;a:4:{s:3:\"uid\";s:32:\"846fae80e47217662041242ee1f15a83\";s:3:\"css\";s:6:\"lanyrd\";s:4:\"code\";i:60434;s:3:\"src\";s:6:\"zocial\";}i:1319;a:4:{s:3:\"uid\";s:32:\"fe4b70ed76eb9a48877632032b33c942\";s:3:\"css\";s:10:\"calendar-6\";s:4:\"code\";i:60435;s:3:\"src\";s:6:\"zocial\";}i:1320;a:4:{s:3:\"uid\";s:32:\"76a8a77019900916d16bad3eb4ee432c\";s:3:\"css\";s:13:\"stumbleupon-1\";s:4:\"code\";i:60436;s:3:\"src\";s:6:\"zocial\";}i:1321;a:4:{s:3:\"uid\";s:32:\"d089814548af1441aa00ecec47851f38\";s:3:\"css\";s:13:\"fivehundredpx\";s:4:\"code\";i:60437;s:3:\"src\";s:6:\"zocial\";}i:1322;a:4:{s:3:\"uid\";s:32:\"799d6108751f684ac9d018983251a08f\";s:3:\"css\";s:11:\"pinterest-2\";s:4:\"code\";i:60438;s:3:\"src\";s:6:\"zocial\";}i:1323;a:4:{s:3:\"uid\";s:32:\"523e56b66e166a5bb7b823844bdf56e6\";s:3:\"css\";s:9:\"bitcoin-1\";s:4:\"code\";i:60439;s:3:\"src\";s:6:\"zocial\";}i:1324;a:4:{s:3:\"uid\";s:32:\"288a62ca532f76053c4a834ba3746ea2\";s:3:\"css\";s:3:\"w3c\";s:4:\"code\";i:60440;s:3:\"src\";s:6:\"zocial\";}i:1325;a:4:{s:3:\"uid\";s:32:\"ffecc77dcd9b9dff653ff88b508220d4\";s:3:\"css\";s:12:\"foursquare-1\";s:4:\"code\";i:60441;s:3:\"src\";s:6:\"zocial\";}i:1326;a:4:{s:3:\"uid\";s:32:\"d4d52a448819e8d5e849b8126416b640\";s:3:\"css\";s:7:\"html5-1\";s:4:\"code\";i:60442;s:3:\"src\";s:6:\"zocial\";}i:1327;a:4:{s:3:\"uid\";s:32:\"63208f7386b9384ba1291832de6ceee7\";s:3:\"css\";s:4:\"ie-1\";s:4:\"code\";i:60443;s:3:\"src\";s:6:\"zocial\";}i:1328;a:4:{s:3:\"uid\";s:32:\"eb2d71e114d99d85b2ae28ab70d981a6\";s:3:\"css\";s:4:\"call\";s:4:\"code\";i:60444;s:3:\"src\";s:6:\"zocial\";}i:1329;a:4:{s:3:\"uid\";s:32:\"c9829449672245d22b3d43d7d1a7cc90\";s:3:\"css\";s:11:\"grooveshark\";s:4:\"code\";i:60445;s:3:\"src\";s:6:\"zocial\";}i:1330;a:4:{s:3:\"uid\";s:32:\"0aeb6f0ea0d091185f5c775401708aa1\";s:3:\"css\";s:17:\"ninetyninedesigns\";s:4:\"code\";i:60446;s:3:\"src\";s:6:\"zocial\";}i:1331;a:4:{s:3:\"uid\";s:32:\"2f6ed771cf99f6826343c31ed0b08026\";s:3:\"css\";s:6:\"forrst\";s:4:\"code\";i:60447;s:3:\"src\";s:6:\"zocial\";}i:1332;a:4:{s:3:\"uid\";s:32:\"8625d6e45fba1219638069e21eedbce8\";s:3:\"css\";s:4:\"digg\";s:4:\"code\";i:60448;s:3:\"src\";s:6:\"zocial\";}i:1333;a:4:{s:3:\"uid\";s:32:\"e4b799ca3860a8276dba05b11d7e13db\";s:3:\"css\";s:9:\"spotify-1\";s:4:\"code\";i:60449;s:3:\"src\";s:6:\"zocial\";}i:1334;a:4:{s:3:\"uid\";s:32:\"b3a537446285bb3510bba57d20374818\";s:3:\"css\";s:6:\"reddit\";s:4:\"code\";i:60450;s:3:\"src\";s:6:\"zocial\";}i:1335;a:4:{s:3:\"uid\";s:32:\"e2a0b3edf53a477f66d077cb907e2ab5\";s:3:\"css\";s:5:\"guest\";s:4:\"code\";i:60451;s:3:\"src\";s:6:\"zocial\";}i:1336;a:4:{s:3:\"uid\";s:32:\"56a3e7f58bbb15252d06a4735e8299dc\";s:3:\"css\";s:7:\"gowalla\";s:4:\"code\";i:60452;s:3:\"src\";s:6:\"zocial\";}i:1337;a:4:{s:3:\"uid\";s:32:\"1dbc2b4a7f00ef209a85e4b5d9fedec4\";s:3:\"css\";s:8:\"appstore\";s:4:\"code\";i:60453;s:3:\"src\";s:6:\"zocial\";}i:1338;a:4:{s:3:\"uid\";s:32:\"2dd7e3046b63beb19616dce63c5782a6\";s:3:\"css\";s:7:\"blogger\";s:4:\"code\";i:60454;s:3:\"src\";s:6:\"zocial\";}i:1339;a:4:{s:3:\"uid\";s:32:\"959c9a2360ed00ec9c0a75562d30edc4\";s:3:\"css\";s:4:\"cc-1\";s:4:\"code\";i:60455;s:3:\"src\";s:6:\"zocial\";}i:1340;a:4:{s:3:\"uid\";s:32:\"003ba8187d6b00ec3e1ba75d00f1246a\";s:3:\"css\";s:10:\"dribbble-4\";s:4:\"code\";i:60456;s:3:\"src\";s:6:\"zocial\";}i:1341;a:4:{s:3:\"uid\";s:32:\"366510ecfb08cd0110134b1ea907fb81\";s:3:\"css\";s:10:\"evernote-1\";s:4:\"code\";i:60457;s:3:\"src\";s:6:\"zocial\";}i:1342;a:4:{s:3:\"uid\";s:32:\"231eeeedfdda9dd5d03dc8d03060007d\";s:3:\"css\";s:8:\"flickr-3\";s:4:\"code\";i:60458;s:3:\"src\";s:6:\"zocial\";}i:1343;a:4:{s:3:\"uid\";s:32:\"6d6d0efe9717ec2962ef0a77c6210df9\";s:3:\"css\";s:6:\"google\";s:4:\"code\";i:60459;s:3:\"src\";s:6:\"zocial\";}i:1344;a:4:{s:3:\"uid\";s:32:\"cf31b05e6409526bbea832ca960777ed\";s:3:\"css\";s:6:\"viadeo\";s:4:\"code\";i:60460;s:3:\"src\";s:6:\"zocial\";}i:1345;a:4:{s:3:\"uid\";s:32:\"5cf33e5f0b89834df4fb10609aec90d6\";s:3:\"css\";s:10:\"instapaper\";s:4:\"code\";i:60461;s:3:\"src\";s:6:\"zocial\";}i:1346;a:4:{s:3:\"uid\";s:32:\"3a171c02a5096c63c7c0e2e84d5eeb5a\";s:3:\"css\";s:7:\"weibo-1\";s:4:\"code\";i:60462;s:3:\"src\";s:6:\"zocial\";}i:1347;a:4:{s:3:\"uid\";s:32:\"f35cf173c6dd32fa6a83208aeb26b527\";s:3:\"css\";s:5:\"klout\";s:4:\"code\";i:60463;s:3:\"src\";s:6:\"zocial\";}i:1348;a:4:{s:3:\"uid\";s:32:\"cc4e62d1721c863fdc6944d2fd87521d\";s:3:\"css\";s:10:\"linkedin-4\";s:4:\"code\";i:60464;s:3:\"src\";s:6:\"zocial\";}i:1349;a:4:{s:3:\"uid\";s:32:\"3da502d7bf60ce54298aafe7b6dca55f\";s:3:\"css\";s:6:\"meetup\";s:4:\"code\";i:60465;s:3:\"src\";s:6:\"zocial\";}i:1350;a:4:{s:3:\"uid\";s:32:\"12db1f260b5b2ccd1aa4d8942cc7f6dd\";s:3:\"css\";s:2:\"vk\";s:4:\"code\";i:60466;s:3:\"src\";s:6:\"zocial\";}i:1351;a:4:{s:3:\"uid\";s:32:\"6cc1c059e221d7a0bf109870cc48f1a5\";s:3:\"css\";s:8:\"plancast\";s:4:\"code\";i:60467;s:3:\"src\";s:6:\"zocial\";}i:1352;a:4:{s:3:\"uid\";s:32:\"9b345d273b96183674779e05d64274af\";s:3:\"css\";s:6:\"disqus\";s:4:\"code\";i:60468;s:3:\"src\";s:6:\"zocial\";}i:1353;a:4:{s:3:\"uid\";s:32:\"2a3192d0f8fe0c7cf959168e68eb16d8\";s:3:\"css\";s:5:\"rss-5\";s:4:\"code\";i:60469;s:3:\"src\";s:6:\"zocial\";}i:1354;a:4:{s:3:\"uid\";s:32:\"1884ff7f89cc02840606d28f9bcf930a\";s:3:\"css\";s:7:\"skype-3\";s:4:\"code\";i:60470;s:3:\"src\";s:6:\"zocial\";}i:1355;a:4:{s:3:\"uid\";s:32:\"b1ec8e90c2c85cf0035849980a3789b3\";s:3:\"css\";s:9:\"twitter-5\";s:4:\"code\";i:60471;s:3:\"src\";s:6:\"zocial\";}i:1356;a:4:{s:3:\"uid\";s:32:\"57a4f84c40a0c44d47387105f162a427\";s:3:\"css\";s:9:\"youtube-2\";s:4:\"code\";i:60472;s:3:\"src\";s:6:\"zocial\";}i:1357;a:4:{s:3:\"uid\";s:32:\"e47352cd4c5e069288b29a2c9ab9d305\";s:3:\"css\";s:7:\"vimeo-2\";s:4:\"code\";i:60473;s:3:\"src\";s:6:\"zocial\";}i:1358;a:4:{s:3:\"uid\";s:32:\"01dcfef491cd3603565e4a68d1805332\";s:3:\"css\";s:9:\"windows-1\";s:4:\"code\";i:60474;s:3:\"src\";s:6:\"zocial\";}i:1359;a:4:{s:3:\"uid\";s:32:\"d2f0cf090ba9e1a4ecbf8275018a0d61\";s:3:\"css\";s:6:\"xing-1\";s:4:\"code\";i:60475;s:3:\"src\";s:6:\"zocial\";}i:1360;a:4:{s:3:\"uid\";s:32:\"aa86b5f7dd6d1087f35cbed951970cd1\";s:3:\"css\";s:5:\"yahoo\";s:4:\"code\";i:60476;s:3:\"src\";s:6:\"zocial\";}i:1361;a:4:{s:3:\"uid\";s:32:\"261a9fed5c3e5883ecc99e354d78a94b\";s:3:\"css\";s:8:\"chrome-1\";s:4:\"code\";i:60477;s:3:\"src\";s:6:\"zocial\";}i:1362;a:4:{s:3:\"uid\";s:32:\"a58032f4aafd0eec54803075f5b320d4\";s:3:\"css\";s:5:\"email\";s:4:\"code\";i:60478;s:3:\"src\";s:6:\"zocial\";}i:1363;a:4:{s:3:\"uid\";s:32:\"94b684c4b484712a2506911b68446ad9\";s:3:\"css\";s:8:\"macstore\";s:4:\"code\";i:60479;s:3:\"src\";s:6:\"zocial\";}i:1364;a:4:{s:3:\"uid\";s:32:\"916eba314d66dee45c9859d2fd146d36\";s:3:\"css\";s:7:\"myspace\";s:4:\"code\";i:60480;s:3:\"src\";s:6:\"zocial\";}i:1365;a:4:{s:3:\"uid\";s:32:\"5287c0dd80c29636f3d45b8b52cd3021\";s:3:\"css\";s:7:\"podcast\";s:4:\"code\";i:60481;s:3:\"src\";s:6:\"zocial\";}i:1366;a:4:{s:3:\"uid\";s:32:\"2f85c90013c0af641d18b167ec93d165\";s:3:\"css\";s:6:\"amazon\";s:4:\"code\";i:60482;s:3:\"src\";s:6:\"zocial\";}i:1367;a:4:{s:3:\"uid\";s:32:\"785a9b232e86ae750516adc5228a5aa7\";s:3:\"css\";s:5:\"steam\";s:4:\"code\";i:60483;s:3:\"src\";s:6:\"zocial\";}i:1368;a:4:{s:3:\"uid\";s:32:\"6c304f746d790c6749f345ac384cbd7c\";s:3:\"css\";s:8:\"cloudapp\";s:4:\"code\";i:60484;s:3:\"src\";s:6:\"zocial\";}i:1369;a:4:{s:3:\"uid\";s:32:\"d0ce443b8d7376716584f5f660a6bf72\";s:3:\"css\";s:9:\"dropbox-2\";s:4:\"code\";i:60485;s:3:\"src\";s:6:\"zocial\";}i:1370;a:4:{s:3:\"uid\";s:32:\"eae6db03eb0c9f2673a126967bf4d4ed\";s:3:\"css\";s:4:\"ebay\";s:4:\"code\";i:60486;s:3:\"src\";s:6:\"zocial\";}i:1371;a:4:{s:3:\"uid\";s:32:\"6f7586c6f99798c3c1de6123d1f6cfa9\";s:3:\"css\";s:10:\"facebook-5\";s:4:\"code\";i:60487;s:3:\"src\";s:6:\"zocial\";}i:1372;a:4:{s:3:\"uid\";s:32:\"9bba5df43e4e9419975336161e1810c3\";s:3:\"css\";s:8:\"github-4\";s:4:\"code\";i:60488;s:3:\"src\";s:6:\"zocial\";}i:1373;a:4:{s:3:\"uid\";s:32:\"ff16079eb4be12c49bf3014d2322acdd\";s:3:\"css\";s:16:\"github-circled-4\";s:4:\"code\";i:60489;s:3:\"src\";s:6:\"zocial\";}i:1374;a:4:{s:3:\"uid\";s:32:\"909f99f11c6b6551bf757b6e809f98f3\";s:3:\"css\";s:10:\"googleplay\";s:4:\"code\";i:60490;s:3:\"src\";s:6:\"zocial\";}i:1375;a:4:{s:3:\"uid\";s:32:\"d6096cb47cc4448ac68b6a2e2c52a81d\";s:3:\"css\";s:6:\"itunes\";s:4:\"code\";i:60491;s:3:\"src\";s:6:\"zocial\";}i:1376;a:4:{s:3:\"uid\";s:32:\"bc3411a07338a7ae2dc49b9720f792c5\";s:3:\"css\";s:5:\"plurk\";s:4:\"code\";i:60492;s:3:\"src\";s:6:\"zocial\";}i:1377;a:4:{s:3:\"uid\";s:32:\"df750854b73c819540447f621729fb3a\";s:3:\"css\";s:8:\"songkick\";s:4:\"code\";i:60493;s:3:\"src\";s:6:\"zocial\";}i:1378;a:4:{s:3:\"uid\";s:32:\"f3d8d921ab15972d3a29da321c5c0558\";s:3:\"css\";s:8:\"lastfm-2\";s:4:\"code\";i:60494;s:3:\"src\";s:6:\"zocial\";}i:1379;a:4:{s:3:\"uid\";s:32:\"b49fa3e57e92b38143e0fdcc5d9a904b\";s:3:\"css\";s:5:\"gmail\";s:4:\"code\";i:60495;s:3:\"src\";s:6:\"zocial\";}i:1380;a:4:{s:3:\"uid\";s:32:\"c91522256a4c3972e9a2765b995b7252\";s:3:\"css\";s:8:\"pinboard\";s:4:\"code\";i:60496;s:3:\"src\";s:6:\"zocial\";}i:1381;a:4:{s:3:\"uid\";s:32:\"1cf32a32df11230cd182b593752304b4\";s:3:\"css\";s:6:\"openid\";s:4:\"code\";i:60497;s:3:\"src\";s:6:\"zocial\";}i:1382;a:4:{s:3:\"uid\";s:32:\"6a85bc0b09a4f21d2a3ced2bdffbc770\";s:3:\"css\";s:5:\"quora\";s:4:\"code\";i:60498;s:3:\"src\";s:6:\"zocial\";}i:1383;a:4:{s:3:\"uid\";s:32:\"1e123339045e48ddd01031936b9fc2d9\";s:3:\"css\";s:12:\"soundcloud-2\";s:4:\"code\";i:60499;s:3:\"src\";s:6:\"zocial\";}i:1384;a:4:{s:3:\"uid\";s:32:\"90d3360c550556afb7e5d3ea58a34e43\";s:3:\"css\";s:8:\"tumblr-2\";s:4:\"code\";i:60500;s:3:\"src\";s:6:\"zocial\";}i:1385;a:4:{s:3:\"uid\";s:32:\"60750bcb027f99557abe2fab47f19f2e\";s:3:\"css\";s:12:\"eventasaurus\";s:4:\"code\";i:60501;s:3:\"src\";s:6:\"zocial\";}i:1386;a:4:{s:3:\"uid\";s:32:\"0636c283a9822288a767609062bbf4a4\";s:3:\"css\";s:9:\"wordpress\";s:4:\"code\";i:60502;s:3:\"src\";s:6:\"zocial\";}i:1387;a:4:{s:3:\"uid\";s:32:\"5d8165146a6d5f2784982aa955f963ce\";s:3:\"css\";s:4:\"yelp\";s:4:\"code\";i:60503;s:3:\"src\";s:6:\"zocial\";}i:1388;a:4:{s:3:\"uid\";s:32:\"67a821c2e9dbc2e439142b4aa04a9c4e\";s:3:\"css\";s:13:\"intensedebate\";s:4:\"code\";i:60504;s:3:\"src\";s:6:\"zocial\";}i:1389;a:4:{s:3:\"uid\";s:32:\"d99bb6de425328eea70522711d17596d\";s:3:\"css\";s:10:\"eventbrite\";s:4:\"code\";i:60505;s:3:\"src\";s:6:\"zocial\";}i:1390;a:4:{s:3:\"uid\";s:32:\"d549e369e55576b49f999436b9f13f44\";s:3:\"css\";s:6:\"scribd\";s:4:\"code\";i:60506;s:3:\"src\";s:6:\"zocial\";}i:1391;a:4:{s:3:\"uid\";s:32:\"0ec44644bdb6b89bbedb8929bb343a61\";s:3:\"css\";s:9:\"posterous\";s:4:\"code\";i:60507;s:3:\"src\";s:6:\"zocial\";}i:1392;a:4:{s:3:\"uid\";s:32:\"3e10dfa19399b45e9dbb9134c849334f\";s:3:\"css\";s:6:\"stripe\";s:4:\"code\";i:60508;s:3:\"src\";s:6:\"zocial\";}i:1393;a:4:{s:3:\"uid\";s:32:\"7ac996dea1fe6954e68548f0d73cd2b1\";s:3:\"css\";s:9:\"opentable\";s:4:\"code\";i:60509;s:3:\"src\";s:6:\"zocial\";}i:1394;a:4:{s:3:\"uid\";s:32:\"c1f0120c5cb9af80a2f56d7d7fb2f489\";s:3:\"css\";s:4:\"cart\";s:4:\"code\";i:60510;s:3:\"src\";s:6:\"zocial\";}i:1395;a:4:{s:3:\"uid\";s:32:\"6dd44b2efdc8c7bb99cbc75ed13b4c1e\";s:3:\"css\";s:7:\"print-5\";s:4:\"code\";i:60511;s:3:\"src\";s:6:\"zocial\";}i:1396;a:4:{s:3:\"uid\";s:32:\"bdaca8aa91638109e25d72f1dcbb58c1\";s:3:\"css\";s:9:\"angellist\";s:4:\"code\";i:60512;s:3:\"src\";s:6:\"zocial\";}i:1397;a:4:{s:3:\"uid\";s:32:\"6275b63473065457219b9e12024f95f2\";s:3:\"css\";s:11:\"instagram-2\";s:4:\"code\";i:60513;s:3:\"src\";s:6:\"zocial\";}i:1398;a:4:{s:3:\"uid\";s:32:\"f39ab571fe73e796e24bb8edc1f9d875\";s:3:\"css\";s:6:\"dwolla\";s:4:\"code\";i:60514;s:3:\"src\";s:6:\"zocial\";}i:1399;a:4:{s:3:\"uid\";s:32:\"40ff77423c882ef32d11b5aec4ab17cf\";s:3:\"css\";s:6:\"appnet\";s:4:\"code\";i:60515;s:3:\"src\";s:6:\"zocial\";}i:1400;a:4:{s:3:\"uid\";s:32:\"21a454e018faae9de83d19c65e7448d9\";s:3:\"css\";s:9:\"statusnet\";s:4:\"code\";i:60516;s:3:\"src\";s:6:\"zocial\";}i:1401;a:4:{s:3:\"uid\";s:32:\"fd1c420f4755e275d578d856d7b20c50\";s:3:\"css\";s:7:\"acrobat\";s:4:\"code\";i:60517;s:3:\"src\";s:6:\"zocial\";}i:1402;a:4:{s:3:\"uid\";s:32:\"9794e9b767f192e0d499dfc98d52e802\";s:3:\"css\";s:6:\"drupal\";s:4:\"code\";i:60518;s:3:\"src\";s:6:\"zocial\";}i:1403;a:4:{s:3:\"uid\";s:32:\"58b5f27abdf85c2b2b8db2770d61162d\";s:3:\"css\";s:6:\"buffer\";s:4:\"code\";i:60519;s:3:\"src\";s:6:\"zocial\";}i:1404;a:4:{s:3:\"uid\";s:32:\"a7632b6db17256019e34ec72fb236be0\";s:3:\"css\";s:6:\"pocket\";s:4:\"code\";i:60520;s:3:\"src\";s:6:\"zocial\";}i:1405;a:4:{s:3:\"uid\";s:32:\"5b1387fb48babf0748ea04107c9adac3\";s:3:\"css\";s:11:\"bitbucket-1\";s:4:\"code\";i:60521;s:3:\"src\";s:6:\"zocial\";}i:1406;a:4:{s:3:\"uid\";s:32:\"15a2a7646f0f7c0f129bee0f790d12fc\";s:3:\"css\";s:4:\"lego\";s:4:\"code\";i:60522;s:3:\"src\";s:6:\"zocial\";}i:1407;a:4:{s:3:\"uid\";s:32:\"1dabc07fb86333ee947c283f74ab5fc8\";s:3:\"css\";s:7:\"login-3\";s:4:\"code\";i:60523;s:3:\"src\";s:6:\"zocial\";}i:1408;a:4:{s:3:\"uid\";s:32:\"e7d17d4d07756f4ab5eb690eea1275ca\";s:3:\"css\";s:15:\"stackoverflow-1\";s:4:\"code\";i:60524;s:3:\"src\";s:6:\"zocial\";}i:1409;a:4:{s:3:\"uid\";s:32:\"054a8f79ee2dae6c1ba909cc0c6f0cf9\";s:3:\"css\";s:10:\"hackernews\";s:4:\"code\";i:60525;s:3:\"src\";s:6:\"zocial\";}i:1410;a:4:{s:3:\"uid\";s:32:\"2634442580bb3c5c7d87f30bed0227a8\";s:3:\"css\";s:5:\"lkdto\";s:4:\"code\";i:60526;s:3:\"src\";s:6:\"zocial\";}i:1411;a:4:{s:3:\"uid\";s:32:\"240979dd9fcf2e46250e66792edb8092\";s:3:\"css\";s:10:\"facebook-6\";s:4:\"code\";i:60386;s:3:\"src\";s:8:\"brandico\";}i:1412;a:4:{s:3:\"uid\";s:32:\"8045477f6a7ef0bd7caff130ad25b88d\";s:3:\"css\";s:15:\"facebook-rect-1\";s:4:\"code\";i:60387;s:3:\"src\";s:8:\"brandico\";}i:1413;a:4:{s:3:\"uid\";s:32:\"d611dd319d8c13b4551dc5bd85c1bdfd\";s:3:\"css\";s:9:\"twitter-6\";s:4:\"code\";i:60388;s:3:\"src\";s:8:\"brandico\";}i:1414;a:4:{s:3:\"uid\";s:32:\"4c01f5d3ba5fbf029bca8630cce41e6a\";s:3:\"css\";s:14:\"twitter-bird-1\";s:4:\"code\";i:60389;s:3:\"src\";s:8:\"brandico\";}i:1415;a:4:{s:3:\"uid\";s:32:\"70cdf244c51630e09038659d1dcbee87\";s:3:\"css\";s:7:\"vimeo-3\";s:4:\"code\";i:60390;s:3:\"src\";s:8:\"brandico\";}i:1416;a:4:{s:3:\"uid\";s:32:\"31483d870b3f14ac12bdfe7331a6af99\";s:3:\"css\";s:10:\"vimeo-rect\";s:4:\"code\";i:60391;s:3:\"src\";s:8:\"brandico\";}i:1417;a:4:{s:3:\"uid\";s:32:\"076f25da90f45dd112e006f2cd7ea76b\";s:3:\"css\";s:8:\"tumblr-3\";s:4:\"code\";i:60392;s:3:\"src\";s:8:\"brandico\";}i:1418;a:4:{s:3:\"uid\";s:32:\"9e6a3483242474b6a1f77739ae3fdfdc\";s:3:\"css\";s:11:\"tumblr-rect\";s:4:\"code\";i:60393;s:3:\"src\";s:8:\"brandico\";}i:1419;a:4:{s:3:\"uid\";s:32:\"626fb97a7c0c0db53a1853fb9e96e223\";s:3:\"css\";s:15:\"googleplus-rect\";s:4:\"code\";i:60394;s:3:\"src\";s:8:\"brandico\";}i:1420;a:4:{s:3:\"uid\";s:32:\"24d1008bf15b6c02a5e7a6af026987dd\";s:3:\"css\";s:11:\"github-text\";s:4:\"code\";i:60395;s:3:\"src\";s:8:\"brandico\";}i:1421;a:4:{s:3:\"uid\";s:32:\"4a0bb1ac004980bb3837560d4c9e8cee\";s:3:\"css\";s:8:\"github-5\";s:4:\"code\";i:60396;s:3:\"src\";s:8:\"brandico\";}i:1422;a:4:{s:3:\"uid\";s:32:\"5a00c877da3f63d37cdc021815e3f5a9\";s:3:\"css\";s:7:\"skype-4\";s:4:\"code\";i:60397;s:3:\"src\";s:8:\"brandico\";}i:1423;a:4:{s:3:\"uid\";s:32:\"01f67de2dc0137389f1c3aced6273acd\";s:3:\"css\";s:3:\"icq\";s:4:\"code\";i:60398;s:3:\"src\";s:8:\"brandico\";}i:1424;a:4:{s:3:\"uid\";s:32:\"b2417d1ce399577d53fff70d54976fea\";s:3:\"css\";s:6:\"yandex\";s:4:\"code\";i:60399;s:3:\"src\";s:8:\"brandico\";}i:1425;a:4:{s:3:\"uid\";s:32:\"ea0cb6bedac64ae7933b03dad3130ef6\";s:3:\"css\";s:11:\"yandex-rect\";s:4:\"code\";i:60400;s:3:\"src\";s:8:\"brandico\";}i:1426;a:4:{s:3:\"uid\";s:32:\"5b16ceef1c8638bd5389c9302ea04098\";s:3:\"css\";s:14:\"vkontakte-rect\";s:4:\"code\";i:60401;s:3:\"src\";s:8:\"brandico\";}i:1427;a:4:{s:3:\"uid\";s:32:\"229e50061df526f24f1ae884fab52101\";s:3:\"css\";s:13:\"odnoklassniki\";s:4:\"code\";i:60402;s:3:\"src\";s:8:\"brandico\";}i:1428;a:4:{s:3:\"uid\";s:32:\"4a02cc611ae9fb342d6026b2ed6cc44e\";s:3:\"css\";s:18:\"odnoklassniki-rect\";s:4:\"code\";i:60403;s:3:\"src\";s:8:\"brandico\";}i:1429;a:4:{s:3:\"uid\";s:32:\"eeec90e0e80f11e1aff10800200c9a66\";s:3:\"css\";s:10:\"friendfeed\";s:4:\"code\";i:60404;s:3:\"src\";s:8:\"brandico\";}i:1430;a:4:{s:3:\"uid\";s:32:\"41f4dd00e81111e1aff10800200c9a66\";s:3:\"css\";s:15:\"friendfeed-rect\";s:4:\"code\";i:60405;s:3:\"src\";s:8:\"brandico\";}i:1431;a:4:{s:3:\"uid\";s:36:\"303f1f30-eda7-11e1-aff1-0800200c9a66\";s:3:\"css\";s:9:\"blogger-1\";s:4:\"code\";i:60406;s:3:\"src\";s:8:\"brandico\";}i:1432;a:4:{s:3:\"uid\";s:32:\"a38dfae0ec2d11e1aff10800200c9a66\";s:3:\"css\";s:12:\"blogger-rect\";s:4:\"code\";i:60407;s:3:\"src\";s:8:\"brandico\";}i:1433;a:4:{s:3:\"uid\";s:32:\"d04790a0ec2d11e1aff10800200c9a66\";s:3:\"css\";s:10:\"deviantart\";s:4:\"code\";i:60408;s:3:\"src\";s:8:\"brandico\";}i:1434;a:4:{s:3:\"uid\";s:32:\"466d1430ec2e11e1aff10800200c9a66\";s:3:\"css\";s:6:\"jabber\";s:4:\"code\";i:60409;s:3:\"src\";s:8:\"brandico\";}i:1435;a:4:{s:3:\"uid\";s:32:\"9e237480ec2e11e1aff10800200c9a66\";s:3:\"css\";s:8:\"lastfm-3\";s:4:\"code\";i:60410;s:3:\"src\";s:8:\"brandico\";}i:1436;a:4:{s:3:\"uid\";s:32:\"53a3bbcda09740c98a1c3d2e0a6a89fb\";s:3:\"css\";s:11:\"lastfm-rect\";s:4:\"code\";i:60411;s:3:\"src\";s:8:\"brandico\";}i:1437;a:4:{s:3:\"uid\";s:32:\"542e3f055aaa4ddfb9ab3e00397db47f\";s:3:\"css\";s:10:\"linkedin-5\";s:4:\"code\";i:60412;s:3:\"src\";s:8:\"brandico\";}i:1438;a:4:{s:3:\"uid\";s:32:\"e9e96618b0f44170930f9b179237c76e\";s:3:\"css\";s:13:\"linkedin-rect\";s:4:\"code\";i:60413;s:3:\"src\";s:8:\"brandico\";}i:1439;a:4:{s:3:\"uid\";s:32:\"d93230ef6fa54fb9805ba4cc9d9af5b1\";s:3:\"css\";s:8:\"picasa-1\";s:4:\"code\";i:60414;s:3:\"src\";s:8:\"brandico\";}i:1440;a:4:{s:3:\"uid\";s:32:\"1357ba39f8dc4519949cc4da55226b62\";s:3:\"css\";s:11:\"wordpress-1\";s:4:\"code\";i:60415;s:3:\"src\";s:8:\"brandico\";}i:1441;a:4:{s:3:\"uid\";s:32:\"dad4e7f8dc2e57c92cffc0231202d9a0\";s:3:\"css\";s:11:\"instagram-3\";s:4:\"code\";i:60416;s:3:\"src\";s:8:\"brandico\";}i:1442;a:4:{s:3:\"uid\";s:32:\"cc20f2a7fa05a475130c406740bbbd26\";s:3:\"css\";s:16:\"instagram-filled\";s:4:\"code\";i:60417;s:3:\"src\";s:8:\"brandico\";}i:1443;a:4:{s:3:\"uid\";s:32:\"ca1c321a95f268ed0e54e7ba11a8264d\";s:3:\"css\";s:5:\"diigo\";s:4:\"code\";i:60418;s:3:\"src\";s:8:\"brandico\";}i:1444;a:4:{s:3:\"uid\";s:32:\"968e63a0a36311e29e960800200c9a66\";s:3:\"css\";s:5:\"box-4\";s:4:\"code\";i:60419;s:3:\"src\";s:8:\"brandico\";}i:1445;a:4:{s:3:\"uid\";s:32:\"d52050c0a36711e29e960800200c9a66\";s:3:\"css\";s:8:\"box-rect\";s:4:\"code\";i:60420;s:3:\"src\";s:8:\"brandico\";}i:1446;a:4:{s:3:\"uid\";s:32:\"5d312ed68325656686a91f6da8fa04bd\";s:3:\"css\";s:5:\"tudou\";s:4:\"code\";i:60421;s:3:\"src\";s:8:\"brandico\";}i:1447;a:4:{s:3:\"uid\";s:32:\"c874a7b43d3f61059bd6db64fc7d6cb3\";s:3:\"css\";s:5:\"youku\";s:4:\"code\";i:60422;s:3:\"src\";s:8:\"brandico\";}i:1448;a:4:{s:3:\"uid\";s:32:\"3f06cdfffd60c5968c601a2e6c8f9a1b\";s:3:\"css\";s:4:\"win8\";s:4:\"code\";i:60423;s:3:\"src\";s:8:\"brandico\";}i:1449;a:4:{s:3:\"uid\";s:32:\"bcbb9470c9ba0699d5a0e4e97b3d5be9\";s:3:\"css\";s:7:\"glass-1\";s:4:\"code\";i:60806;s:3:\"src\";s:7:\"elusive\";}i:1450;a:4:{s:3:\"uid\";s:32:\"e7ab5637425cce7dd2176302ddaf1c08\";s:3:\"css\";s:7:\"music-3\";s:4:\"code\";i:60807;s:3:\"src\";s:7:\"elusive\";}i:1451;a:4:{s:3:\"uid\";s:32:\"e45e9f27ce40ba9837cc984076d98067\";s:3:\"css\";s:8:\"search-6\";s:4:\"code\";i:60808;s:3:\"src\";s:7:\"elusive\";}i:1452;a:4:{s:3:\"uid\";s:32:\"81385e5f1fe091f3d9a20d215d444622\";s:3:\"css\";s:14:\"search-circled\";s:4:\"code\";i:60809;s:3:\"src\";s:7:\"elusive\";}i:1453;a:4:{s:3:\"uid\";s:32:\"b6ef4443ecc502136135437837d9724b\";s:3:\"css\";s:6:\"mail-6\";s:4:\"code\";i:60810;s:3:\"src\";s:7:\"elusive\";}i:1454;a:4:{s:3:\"uid\";s:32:\"7cb7e246fd23672429db603c0077dc79\";s:3:\"css\";s:12:\"mail-circled\";s:4:\"code\";i:60811;s:3:\"src\";s:7:\"elusive\";}i:1455;a:4:{s:3:\"uid\";s:32:\"628e5fc59fc5965a6b91189467b037d5\";s:3:\"css\";s:7:\"heart-6\";s:4:\"code\";i:60812;s:3:\"src\";s:7:\"elusive\";}i:1456;a:4:{s:3:\"uid\";s:32:\"5b4b9a59f7acb6839fa7fefe0d433165\";s:3:\"css\";s:13:\"heart-circled\";s:4:\"code\";i:60813;s:3:\"src\";s:7:\"elusive\";}i:1457;a:4:{s:3:\"uid\";s:32:\"7eed700d710c276569f95be26326fa5b\";s:3:\"css\";s:13:\"heart-empty-3\";s:4:\"code\";i:60814;s:3:\"src\";s:7:\"elusive\";}i:1458;a:4:{s:3:\"uid\";s:32:\"e1c372b8d386329b38dff5cd1ec46513\";s:3:\"css\";s:6:\"star-6\";s:4:\"code\";i:60815;s:3:\"src\";s:7:\"elusive\";}i:1459;a:4:{s:3:\"uid\";s:32:\"caed304a2bf6248f01e98c2aa30db1d7\";s:3:\"css\";s:12:\"star-circled\";s:4:\"code\";i:60816;s:3:\"src\";s:7:\"elusive\";}i:1460;a:4:{s:3:\"uid\";s:32:\"8346e81b88fa3c57b42978f8b137a93a\";s:3:\"css\";s:12:\"star-empty-3\";s:4:\"code\";i:60817;s:3:\"src\";s:7:\"elusive\";}i:1461;a:4:{s:3:\"uid\";s:32:\"2c576f7c6c3233c31abad0899fc9f4af\";s:3:\"css\";s:6:\"user-6\";s:4:\"code\";i:60818;s:3:\"src\";s:7:\"elusive\";}i:1462;a:4:{s:3:\"uid\";s:32:\"e36d581e4f2844db345bddc205d15dda\";s:3:\"css\";s:5:\"group\";s:4:\"code\";i:60819;s:3:\"src\";s:7:\"elusive\";}i:1463;a:4:{s:3:\"uid\";s:32:\"8d40bca7a7f11091ca865e07535fcc47\";s:3:\"css\";s:13:\"group-circled\";s:4:\"code\";i:60820;s:3:\"src\";s:7:\"elusive\";}i:1464;a:4:{s:3:\"uid\";s:32:\"6ad86a953a5a76086c5568366863bbca\";s:3:\"css\";s:5:\"torso\";s:4:\"code\";i:60821;s:3:\"src\";s:7:\"elusive\";}i:1465;a:4:{s:3:\"uid\";s:32:\"31accb20e8819b200c297df608e68830\";s:3:\"css\";s:7:\"video-4\";s:4:\"code\";i:60822;s:3:\"src\";s:7:\"elusive\";}i:1466;a:4:{s:3:\"uid\";s:32:\"529244b2b39e0c5a145506ce02271068\";s:3:\"css\";s:13:\"video-circled\";s:4:\"code\";i:60823;s:3:\"src\";s:7:\"elusive\";}i:1467;a:4:{s:3:\"uid\";s:32:\"09b251f36844ae25d58767d85d21bf88\";s:3:\"css\";s:11:\"video-alt-1\";s:4:\"code\";i:60824;s:3:\"src\";s:7:\"elusive\";}i:1468;a:4:{s:3:\"uid\";s:32:\"1e2149558b091788516ef5f589ac011e\";s:3:\"css\";s:10:\"videocam-4\";s:4:\"code\";i:60825;s:3:\"src\";s:7:\"elusive\";}i:1469;a:4:{s:3:\"uid\";s:32:\"f274acf461473025f0d75518b653ec14\";s:3:\"css\";s:10:\"video-chat\";s:4:\"code\";i:60826;s:3:\"src\";s:7:\"elusive\";}i:1470;a:4:{s:3:\"uid\";s:32:\"a1be363d4de9be39857893d4134f6215\";s:3:\"css\";s:9:\"picture-4\";s:4:\"code\";i:60827;s:3:\"src\";s:7:\"elusive\";}i:1471;a:4:{s:3:\"uid\";s:32:\"6b6e59e33915710a9f935b04a06d507d\";s:3:\"css\";s:8:\"camera-6\";s:4:\"code\";i:60828;s:3:\"src\";s:7:\"elusive\";}i:1472;a:4:{s:3:\"uid\";s:32:\"745f28cc6b06e5d131f6d650377b6cf5\";s:3:\"css\";s:7:\"photo-1\";s:4:\"code\";i:60829;s:3:\"src\";s:7:\"elusive\";}i:1473;a:4:{s:3:\"uid\";s:32:\"5aeb40ce835cfcb60727340a347bd666\";s:3:\"css\";s:13:\"photo-circled\";s:4:\"code\";i:60830;s:3:\"src\";s:7:\"elusive\";}i:1474;a:4:{s:3:\"uid\";s:32:\"76f961b11f65300838a5a78856aca30f\";s:3:\"css\";s:10:\"th-large-2\";s:4:\"code\";i:60831;s:3:\"src\";s:7:\"elusive\";}i:1475;a:4:{s:3:\"uid\";s:32:\"93faa7cec68bf69ec455bbab61e58e48\";s:3:\"css\";s:4:\"th-3\";s:4:\"code\";i:60832;s:3:\"src\";s:7:\"elusive\";}i:1476;a:4:{s:3:\"uid\";s:32:\"50e664a6f12199784c02600b2ccfd60a\";s:3:\"css\";s:9:\"th-list-4\";s:4:\"code\";i:60833;s:3:\"src\";s:7:\"elusive\";}i:1477;a:4:{s:3:\"uid\";s:32:\"630d3c819e595abc344053e18872017b\";s:3:\"css\";s:9:\"view-mode\";s:4:\"code\";i:60834;s:3:\"src\";s:7:\"elusive\";}i:1478;a:4:{s:3:\"uid\";s:32:\"ce7452abce8b55ded1c393997a51e6b3\";s:3:\"css\";s:4:\"ok-5\";s:4:\"code\";i:60835;s:3:\"src\";s:7:\"elusive\";}i:1479;a:4:{s:3:\"uid\";s:32:\"67a9d2e5512b8aa812eff7da6d36bffc\";s:3:\"css\";s:12:\"ok-circled-2\";s:4:\"code\";i:60836;s:3:\"src\";s:7:\"elusive\";}i:1480;a:4:{s:3:\"uid\";s:32:\"56b0141d7bbb0717fc6246ea145bc0bd\";s:3:\"css\";s:13:\"ok-circled2-1\";s:4:\"code\";i:60837;s:3:\"src\";s:7:\"elusive\";}i:1481;a:4:{s:3:\"uid\";s:32:\"499b745a2e2485bdd059c3a53d048e5f\";s:3:\"css\";s:8:\"cancel-6\";s:4:\"code\";i:60838;s:3:\"src\";s:7:\"elusive\";}i:1482;a:4:{s:3:\"uid\";s:32:\"fd32deda7b2f5b8cad46d13897c19ae8\";s:3:\"css\";s:16:\"cancel-circled-4\";s:4:\"code\";i:60839;s:3:\"src\";s:7:\"elusive\";}i:1483;a:4:{s:3:\"uid\";s:32:\"74415da8e36ed0afcea9b2b1454f4176\";s:3:\"css\";s:17:\"cancel-circled2-1\";s:4:\"code\";i:60840;s:3:\"src\";s:7:\"elusive\";}i:1484;a:4:{s:3:\"uid\";s:32:\"55e2ff85b1c459c383f46da6e96014b0\";s:3:\"css\";s:6:\"plus-6\";s:4:\"code\";i:60841;s:3:\"src\";s:7:\"elusive\";}i:1485;a:4:{s:3:\"uid\";s:32:\"d4aeb916de8d3aea716442778346d244\";s:3:\"css\";s:14:\"plus-circled-2\";s:4:\"code\";i:60842;s:3:\"src\";s:7:\"elusive\";}i:1486;a:4:{s:3:\"uid\";s:32:\"0fb1948386f4581c72424a69587e6471\";s:3:\"css\";s:7:\"minus-4\";s:4:\"code\";i:60843;s:3:\"src\";s:7:\"elusive\";}i:1487;a:4:{s:3:\"uid\";s:32:\"b35d6abdf5632eafeeb91377b0b6e9a1\";s:3:\"css\";s:15:\"minus-circled-2\";s:4:\"code\";i:60844;s:3:\"src\";s:7:\"elusive\";}i:1488;a:4:{s:3:\"uid\";s:32:\"a7289537a68b15b24bd4e3ee1ac20dfa\";s:3:\"css\";s:6:\"help-3\";s:4:\"code\";i:60845;s:3:\"src\";s:7:\"elusive\";}i:1489;a:4:{s:3:\"uid\";s:32:\"2105aa6ffb4434ebf82a20d97ac1ed25\";s:3:\"css\";s:14:\"help-circled-3\";s:4:\"code\";i:60575;s:3:\"src\";s:7:\"elusive\";}i:1490;a:4:{s:3:\"uid\";s:32:\"2355991b4045d64b08fb82988109c0ee\";s:3:\"css\";s:14:\"info-circled-3\";s:4:\"code\";i:60576;s:3:\"src\";s:7:\"elusive\";}i:1491;a:4:{s:3:\"uid\";s:32:\"829c06a0a3b73b02a6224f4bbb73d99c\";s:3:\"css\";s:6:\"home-6\";s:4:\"code\";i:60577;s:3:\"src\";s:7:\"elusive\";}i:1492;a:4:{s:3:\"uid\";s:32:\"d80ef118949b097868584a3b80d55ce4\";s:3:\"css\";s:12:\"home-circled\";s:4:\"code\";i:60578;s:3:\"src\";s:7:\"elusive\";}i:1493;a:4:{s:3:\"uid\";s:32:\"cb89a11fa3722b7648ce26f40aaed8f0\";s:3:\"css\";s:7:\"website\";s:4:\"code\";i:60579;s:3:\"src\";s:7:\"elusive\";}i:1494;a:4:{s:3:\"uid\";s:32:\"a7dac3a6d7b1fdf3a67a9f2530afaaed\";s:3:\"css\";s:15:\"website-circled\";s:4:\"code\";i:60580;s:3:\"src\";s:7:\"elusive\";}i:1495;a:4:{s:3:\"uid\";s:32:\"0be76e79cf83a68ecb961121c00b9f2d\";s:3:\"css\";s:8:\"attach-5\";s:4:\"code\";i:60581;s:3:\"src\";s:7:\"elusive\";}i:1496;a:4:{s:3:\"uid\";s:32:\"f7838631ee8af22feedf7358e02ef8e2\";s:3:\"css\";s:14:\"attach-circled\";s:4:\"code\";i:60582;s:3:\"src\";s:7:\"elusive\";}i:1497;a:4:{s:3:\"uid\";s:32:\"0e26e70b4aa537cc206f41b21dcf2fcc\";s:3:\"css\";s:6:\"lock-6\";s:4:\"code\";i:60583;s:3:\"src\";s:7:\"elusive\";}i:1498;a:4:{s:3:\"uid\";s:32:\"ad194658d0e68d781eb334d9c1099d6e\";s:3:\"css\";s:12:\"lock-circled\";s:4:\"code\";i:60584;s:3:\"src\";s:7:\"elusive\";}i:1499;a:4:{s:3:\"uid\";s:32:\"8f562a6dca9c14c9c8268bdb64efa89f\";s:3:\"css\";s:11:\"lock-open-6\";s:4:\"code\";i:60585;s:3:\"src\";s:7:\"elusive\";}i:1500;a:4:{s:3:\"uid\";s:32:\"780293b0d8c799ff73e17555b2ac9b4e\";s:3:\"css\";s:15:\"lock-open-alt-2\";s:4:\"code\";i:60586;s:3:\"src\";s:7:\"elusive\";}i:1501;a:4:{s:3:\"uid\";s:32:\"e45a3da2ebde8bc8e30a873f3bd51f30\";s:3:\"css\";s:5:\"eye-6\";s:4:\"code\";i:60587;s:3:\"src\";s:7:\"elusive\";}i:1502;a:4:{s:3:\"uid\";s:32:\"d218294e6f9f7191f6b0b3d1ff6239ff\";s:3:\"css\";s:9:\"eye-off-1\";s:4:\"code\";i:60588;s:3:\"src\";s:7:\"elusive\";}i:1503;a:4:{s:3:\"uid\";s:32:\"630529f03c319c01101aa167181b650e\";s:3:\"css\";s:5:\"tag-5\";s:4:\"code\";i:60589;s:3:\"src\";s:7:\"elusive\";}i:1504;a:4:{s:3:\"uid\";s:32:\"937a0ad3f6e25611bff801445d6a4885\";s:3:\"css\";s:6:\"tags-2\";s:4:\"code\";i:60590;s:3:\"src\";s:7:\"elusive\";}i:1505;a:4:{s:3:\"uid\";s:32:\"8d2b0a28ccbfc06bb840720e554d79cc\";s:3:\"css\";s:10:\"bookmark-3\";s:4:\"code\";i:60591;s:3:\"src\";s:7:\"elusive\";}i:1506;a:4:{s:3:\"uid\";s:32:\"363271b58af838dd4be5013284672322\";s:3:\"css\";s:16:\"bookmark-empty-1\";s:4:\"code\";i:60592;s:3:\"src\";s:7:\"elusive\";}i:1507;a:4:{s:3:\"uid\";s:32:\"25acee28eb78eaa800b32bb6f20ebc62\";s:3:\"css\";s:6:\"flag-3\";s:4:\"code\";i:60593;s:3:\"src\";s:7:\"elusive\";}i:1508;a:4:{s:3:\"uid\";s:32:\"3c3fa4ca801f3bdc36c35e497e0fc4fc\";s:3:\"css\";s:12:\"flag-circled\";s:4:\"code\";i:60594;s:3:\"src\";s:7:\"elusive\";}i:1509;a:4:{s:3:\"uid\";s:32:\"0464d6f35a7fe587434173f42ddace88\";s:3:\"css\";s:11:\"thumbs-up-4\";s:4:\"code\";i:60595;s:3:\"src\";s:7:\"elusive\";}i:1510;a:4:{s:3:\"uid\";s:32:\"3849753858193b4d6e07afa834aff979\";s:3:\"css\";s:13:\"thumbs-down-4\";s:4:\"code\";i:60596;s:3:\"src\";s:7:\"elusive\";}i:1511;a:4:{s:3:\"uid\";s:32:\"61a783a38ab7b1e312fc5cd9b13fd349\";s:3:\"css\";s:10:\"download-6\";s:4:\"code\";i:60597;s:3:\"src\";s:7:\"elusive\";}i:1512;a:4:{s:3:\"uid\";s:32:\"05a2f4c4839012434774cc1ceb4c0f9b\";s:3:\"css\";s:12:\"download-alt\";s:4:\"code\";i:60598;s:3:\"src\";s:7:\"elusive\";}i:1513;a:4:{s:3:\"uid\";s:32:\"4fc965c0a4abf27512ac06752c56b3b5\";s:3:\"css\";s:8:\"upload-5\";s:4:\"code\";i:60599;s:3:\"src\";s:7:\"elusive\";}i:1514;a:4:{s:3:\"uid\";s:32:\"d5937c5767642d0336ad599af0e9c992\";s:3:\"css\";s:7:\"share-2\";s:4:\"code\";i:60600;s:3:\"src\";s:7:\"elusive\";}i:1515;a:4:{s:3:\"uid\";s:32:\"34e5d8943b23023d2a9515cfa9173506\";s:3:\"css\";s:7:\"quote-1\";s:4:\"code\";i:60601;s:3:\"src\";s:7:\"elusive\";}i:1516;a:4:{s:3:\"uid\";s:32:\"173dc34e39eeb98cb748ccc1800a4fcc\";s:3:\"css\";s:13:\"quote-circled\";s:4:\"code\";i:60602;s:3:\"src\";s:7:\"elusive\";}i:1517;a:4:{s:3:\"uid\";s:32:\"3e31c5e1720a1545c5024a1796d74e5b\";s:3:\"css\";s:8:\"export-5\";s:4:\"code\";i:60603;s:3:\"src\";s:7:\"elusive\";}i:1518;a:4:{s:3:\"uid\";s:32:\"62b0580ee8edc3a3edfbf68a47c852d5\";s:3:\"css\";s:8:\"pencil-6\";s:4:\"code\";i:60604;s:3:\"src\";s:7:\"elusive\";}i:1519;a:4:{s:3:\"uid\";s:32:\"19dae18c34431934a781773e241faec2\";s:3:\"css\";s:14:\"pencil-circled\";s:4:\"code\";i:60605;s:3:\"src\";s:7:\"elusive\";}i:1520;a:4:{s:3:\"uid\";s:32:\"7b6c617d6d1e3f22db493839f0483bf6\";s:3:\"css\";s:6:\"edit-3\";s:4:\"code\";i:60606;s:3:\"src\";s:7:\"elusive\";}i:1521;a:4:{s:3:\"uid\";s:32:\"2110049635bb7cea7ef41c28d9c15b32\";s:3:\"css\";s:12:\"edit-circled\";s:4:\"code\";i:60607;s:3:\"src\";s:7:\"elusive\";}i:1522;a:4:{s:3:\"uid\";s:32:\"6059b7737287728091ce7e4c600cca56\";s:3:\"css\";s:8:\"edit-alt\";s:4:\"code\";i:60608;s:3:\"src\";s:7:\"elusive\";}i:1523;a:4:{s:3:\"uid\";s:32:\"24a1eb628343fabd6f46a0a13456c045\";s:3:\"css\";s:7:\"print-6\";s:4:\"code\";i:60609;s:3:\"src\";s:7:\"elusive\";}i:1524;a:4:{s:3:\"uid\";s:32:\"358afb4e7d145cc3384f2db0427fff92\";s:3:\"css\";s:9:\"retweet-3\";s:4:\"code\";i:60610;s:3:\"src\";s:7:\"elusive\";}i:1525;a:4:{s:3:\"uid\";s:32:\"23710230c21b4af140947e3604cc67a5\";s:3:\"css\";s:9:\"comment-5\";s:4:\"code\";i:60611;s:3:\"src\";s:7:\"elusive\";}i:1526;a:4:{s:3:\"uid\";s:32:\"afdb6de29702e88d79539d600c42d4a8\";s:3:\"css\";s:13:\"comment-alt-1\";s:4:\"code\";i:60612;s:3:\"src\";s:7:\"elusive\";}i:1527;a:4:{s:3:\"uid\";s:32:\"f84e243b91683403debed23b950f7efb\";s:3:\"css\";s:6:\"bell-5\";s:4:\"code\";i:60613;s:3:\"src\";s:7:\"elusive\";}i:1528;a:4:{s:3:\"uid\";s:32:\"3fe5b810589a16bc691e3e979b2789dc\";s:3:\"css\";s:9:\"warning-1\";s:4:\"code\";i:60614;s:3:\"src\";s:7:\"elusive\";}i:1529;a:4:{s:3:\"uid\";s:32:\"711fdb6caa365d5b69d4a72da2009cf6\";s:3:\"css\";s:11:\"exclamation\";s:4:\"code\";i:60615;s:3:\"src\";s:7:\"elusive\";}i:1530;a:4:{s:3:\"uid\";s:32:\"3ab229dd9bccaaaf6c71096da4b72c04\";s:3:\"css\";s:5:\"error\";s:4:\"code\";i:60616;s:3:\"src\";s:7:\"elusive\";}i:1531;a:4:{s:3:\"uid\";s:32:\"3c0ef77f5fbb5c933c23f2c437d8cab8\";s:3:\"css\";s:9:\"error-alt\";s:4:\"code\";i:60617;s:3:\"src\";s:7:\"elusive\";}i:1532;a:4:{s:3:\"uid\";s:32:\"22cfc7af2c4f158b37317c65c92b48c2\";s:3:\"css\";s:10:\"location-6\";s:4:\"code\";i:60618;s:3:\"src\";s:7:\"elusive\";}i:1533;a:4:{s:3:\"uid\";s:32:\"c54c00a5b7fba94b9fbc940de38a7beb\";s:3:\"css\";s:16:\"location-circled\";s:4:\"code\";i:60619;s:3:\"src\";s:7:\"elusive\";}i:1534;a:4:{s:3:\"uid\";s:32:\"d8579082214a1c550b5d1ab2fee8b02c\";s:3:\"css\";s:9:\"compass-5\";s:4:\"code\";i:60620;s:3:\"src\";s:7:\"elusive\";}i:1535;a:4:{s:3:\"uid\";s:32:\"1748e31f171a4060d1b498bf3a1af254\";s:3:\"css\";s:15:\"compass-circled\";s:4:\"code\";i:60621;s:3:\"src\";s:7:\"elusive\";}i:1536;a:4:{s:3:\"uid\";s:32:\"3ab2abf6f936d3e53ee8c184cedaed82\";s:3:\"css\";s:7:\"trash-7\";s:4:\"code\";i:60622;s:3:\"src\";s:7:\"elusive\";}i:1537;a:4:{s:3:\"uid\";s:32:\"972c9374fbfca1e9095da9f104181be9\";s:3:\"css\";s:13:\"trash-circled\";s:4:\"code\";i:60623;s:3:\"src\";s:7:\"elusive\";}i:1538;a:4:{s:3:\"uid\";s:32:\"64fb13a798e934810c303e6b07791816\";s:3:\"css\";s:5:\"doc-6\";s:4:\"code\";i:60624;s:3:\"src\";s:7:\"elusive\";}i:1539;a:4:{s:3:\"uid\";s:32:\"d932eda1eba18a387cf20f3aeea427b1\";s:3:\"css\";s:11:\"doc-circled\";s:4:\"code\";i:60625;s:3:\"src\";s:7:\"elusive\";}i:1540;a:4:{s:3:\"uid\";s:32:\"9e0404ba55575a540164db9a5ad511df\";s:3:\"css\";s:7:\"doc-new\";s:4:\"code\";i:60626;s:3:\"src\";s:7:\"elusive\";}i:1541;a:4:{s:3:\"uid\";s:32:\"3a3b9605e79d81475ebe85e9f68086cd\";s:3:\"css\";s:15:\"doc-new-circled\";s:4:\"code\";i:60627;s:3:\"src\";s:7:\"elusive\";}i:1542;a:4:{s:3:\"uid\";s:32:\"9eece2885134734c5bc085fdd4955af1\";s:3:\"css\";s:8:\"folder-5\";s:4:\"code\";i:60628;s:3:\"src\";s:7:\"elusive\";}i:1543;a:4:{s:3:\"uid\";s:32:\"f5fb170e83573af48438ea9e44f772ec\";s:3:\"css\";s:14:\"folder-circled\";s:4:\"code\";i:60629;s:3:\"src\";s:7:\"elusive\";}i:1544;a:4:{s:3:\"uid\";s:32:\"3a9aa648fce45a316e70e1613bda57ac\";s:3:\"css\";s:12:\"folder-close\";s:4:\"code\";i:60630;s:3:\"src\";s:7:\"elusive\";}i:1545;a:4:{s:3:\"uid\";s:32:\"df09e8471b1f0ffb10db52d28dd8104d\";s:3:\"css\";s:13:\"folder-open-2\";s:4:\"code\";i:60631;s:3:\"src\";s:7:\"elusive\";}i:1546;a:4:{s:3:\"uid\";s:32:\"d881e6436253ef6cffe0f3fb10562643\";s:3:\"css\";s:5:\"rss-6\";s:4:\"code\";i:60632;s:3:\"src\";s:7:\"elusive\";}i:1547;a:4:{s:3:\"uid\";s:32:\"c91098f07ff0df45b3f8666b72b75801\";s:3:\"css\";s:7:\"phone-3\";s:4:\"code\";i:60633;s:3:\"src\";s:7:\"elusive\";}i:1548;a:4:{s:3:\"uid\";s:32:\"23a1de57eb7b0c8281656a3ddadf3ee3\";s:3:\"css\";s:13:\"phone-circled\";s:4:\"code\";i:60634;s:3:\"src\";s:7:\"elusive\";}i:1549;a:4:{s:3:\"uid\";s:32:\"6083c8aa5e3345476a24a28ac1afaa61\";s:3:\"css\";s:5:\"cog-5\";s:4:\"code\";i:60635;s:3:\"src\";s:7:\"elusive\";}i:1550;a:4:{s:3:\"uid\";s:32:\"7560ca08e3d83e43c58fcbf8f16d8f03\";s:3:\"css\";s:11:\"cog-circled\";s:4:\"code\";i:60636;s:3:\"src\";s:7:\"elusive\";}i:1551;a:4:{s:3:\"uid\";s:32:\"1e32e1f8787cf3cb9f52f8850822dcb6\";s:3:\"css\";s:4:\"cogs\";s:4:\"code\";i:60637;s:3:\"src\";s:7:\"elusive\";}i:1552;a:4:{s:3:\"uid\";s:32:\"cde79a37774e5817bc68fff2464aee28\";s:3:\"css\";s:8:\"wrench-4\";s:4:\"code\";i:60638;s:3:\"src\";s:7:\"elusive\";}i:1553;a:4:{s:3:\"uid\";s:32:\"e1a8092efb690eeb6c41d58b549e9074\";s:3:\"css\";s:14:\"wrench-circled\";s:4:\"code\";i:60639;s:3:\"src\";s:7:\"elusive\";}i:1554;a:4:{s:3:\"uid\";s:32:\"f5686c8ccdc0213b081ef95678160b6d\";s:3:\"css\";s:8:\"basket-4\";s:4:\"code\";i:60640;s:3:\"src\";s:7:\"elusive\";}i:1555;a:4:{s:3:\"uid\";s:32:\"fbc62ccfe2241037d5b9abf65204aef8\";s:3:\"css\";s:14:\"basket-circled\";s:4:\"code\";i:60641;s:3:\"src\";s:7:\"elusive\";}i:1556;a:4:{s:3:\"uid\";s:32:\"64abb7c56aefca89046bb69f7251d2e2\";s:3:\"css\";s:10:\"calendar-7\";s:4:\"code\";i:60642;s:3:\"src\";s:7:\"elusive\";}i:1557;a:4:{s:3:\"uid\";s:32:\"7689d722f0cb41f16f74b8149de5f71a\";s:3:\"css\";s:16:\"calendar-circled\";s:4:\"code\";i:60643;s:3:\"src\";s:7:\"elusive\";}i:1558;a:4:{s:3:\"uid\";s:32:\"8ca5f77677a66dbe813213ca75ac1474\";s:3:\"css\";s:5:\"mic-5\";s:4:\"code\";i:60644;s:3:\"src\";s:7:\"elusive\";}i:1559;a:4:{s:3:\"uid\";s:32:\"4d2f54ceffd4645d3ce6fe82b404190d\";s:3:\"css\";s:11:\"mic-circled\";s:4:\"code\";i:60645;s:3:\"src\";s:7:\"elusive\";}i:1560;a:4:{s:3:\"uid\";s:32:\"8489d61496923b1159b01d8a0a7b2df0\";s:3:\"css\";s:12:\"volume-off-4\";s:4:\"code\";i:60646;s:3:\"src\";s:7:\"elusive\";}i:1561;a:4:{s:3:\"uid\";s:32:\"5d9730dc93976d27eb07914eab50a507\";s:3:\"css\";s:13:\"volume-down-2\";s:4:\"code\";i:60647;s:3:\"src\";s:7:\"elusive\";}i:1562;a:4:{s:3:\"uid\";s:32:\"b59b3b618699b467541f631edd5a02ed\";s:3:\"css\";s:8:\"volume-1\";s:4:\"code\";i:60648;s:3:\"src\";s:7:\"elusive\";}i:1563;a:4:{s:3:\"uid\";s:32:\"012ff5762ccb18c16bdfdd6baf187406\";s:3:\"css\";s:11:\"volume-up-3\";s:4:\"code\";i:60649;s:3:\"src\";s:7:\"elusive\";}i:1564;a:4:{s:3:\"uid\";s:32:\"7480a298ce334eef70193895e799c3fd\";s:3:\"css\";s:12:\"headphones-3\";s:4:\"code\";i:60650;s:3:\"src\";s:7:\"elusive\";}i:1565;a:4:{s:3:\"uid\";s:32:\"d1fd686179920f26e0f1e83816fb40fe\";s:3:\"css\";s:7:\"clock-6\";s:4:\"code\";i:60651;s:3:\"src\";s:7:\"elusive\";}i:1566;a:4:{s:3:\"uid\";s:32:\"15b7db710f718315e467df2502e4d592\";s:3:\"css\";s:13:\"clock-circled\";s:4:\"code\";i:60652;s:3:\"src\";s:7:\"elusive\";}i:1567;a:4:{s:3:\"uid\";s:32:\"599d6c088f4a1c64611b989459d65f6b\";s:3:\"css\";s:11:\"lightbulb-2\";s:4:\"code\";i:60653;s:3:\"src\";s:7:\"elusive\";}i:1568;a:4:{s:3:\"uid\";s:32:\"629a8f18105619d27c013109a4064b46\";s:3:\"css\";s:13:\"lightbulb-alt\";s:4:\"code\";i:60654;s:3:\"src\";s:7:\"elusive\";}i:1569;a:4:{s:3:\"uid\";s:32:\"2e3c51fc718aeb8b01604c8d039bcaeb\";s:3:\"css\";s:7:\"block-4\";s:4:\"code\";i:60655;s:3:\"src\";s:7:\"elusive\";}i:1570;a:4:{s:3:\"uid\";s:32:\"57776e51a50e3b4d92701bdbbba01588\";s:3:\"css\";s:13:\"resize-full-5\";s:4:\"code\";i:60656;s:3:\"src\";s:7:\"elusive\";}i:1571;a:4:{s:3:\"uid\";s:32:\"6707ea950c24c5b01625f7ea73b2172e\";s:3:\"css\";s:17:\"resize-full-alt-2\";s:4:\"code\";i:60657;s:3:\"src\";s:7:\"elusive\";}i:1572;a:4:{s:3:\"uid\";s:32:\"8c7e34dcc8cc90ed5f4fd59949201f41\";s:3:\"css\";s:14:\"resize-small-4\";s:4:\"code\";i:60658;s:3:\"src\";s:7:\"elusive\";}i:1573;a:4:{s:3:\"uid\";s:32:\"f8b0d36761ba4c7e51d0af49d3386713\";s:3:\"css\";s:17:\"resize-vertical-2\";s:4:\"code\";i:60659;s:3:\"src\";s:7:\"elusive\";}i:1574;a:4:{s:3:\"uid\";s:32:\"f8d887df13c5f95ede5fb0e2cdb042b1\";s:3:\"css\";s:19:\"resize-horizontal-2\";s:4:\"code\";i:60660;s:3:\"src\";s:7:\"elusive\";}i:1575;a:4:{s:3:\"uid\";s:32:\"dea46bc85920f9a05bf7c7251fb10f10\";s:3:\"css\";s:6:\"move-3\";s:4:\"code\";i:60661;s:3:\"src\";s:7:\"elusive\";}i:1576;a:4:{s:3:\"uid\";s:32:\"68c7be0f4cab6b82d5725b1ba7cec4d6\";s:3:\"css\";s:9:\"zoom-in-4\";s:4:\"code\";i:60662;s:3:\"src\";s:7:\"elusive\";}i:1577;a:4:{s:3:\"uid\";s:32:\"295287b96e50d494ba38a1ed9e06d8db\";s:3:\"css\";s:10:\"zoom-out-4\";s:4:\"code\";i:60663;s:3:\"src\";s:7:\"elusive\";}i:1578;a:4:{s:3:\"uid\";s:32:\"616b755d0f4c7d2dc7a1dcc2e5427039\";s:3:\"css\";s:11:\"down-open-3\";s:4:\"code\";i:60664;s:3:\"src\";s:7:\"elusive\";}i:1579;a:4:{s:3:\"uid\";s:32:\"c0a07aca383ff2a164a4d691fa46e35c\";s:3:\"css\";s:11:\"left-open-4\";s:4:\"code\";i:60665;s:3:\"src\";s:7:\"elusive\";}i:1580;a:4:{s:3:\"uid\";s:32:\"dc4a03854ef986d64565143bea4241aa\";s:3:\"css\";s:12:\"right-open-4\";s:4:\"code\";i:60666;s:3:\"src\";s:7:\"elusive\";}i:1581;a:4:{s:3:\"uid\";s:32:\"b91c0e6aaab5e3146732b69dd418e120\";s:3:\"css\";s:9:\"up-open-3\";s:4:\"code\";i:60667;s:3:\"src\";s:7:\"elusive\";}i:1582;a:4:{s:3:\"uid\";s:32:\"a79ef2d6f102af86440aa80238d5f4b0\";s:3:\"css\";s:6:\"down-6\";s:4:\"code\";i:60668;s:3:\"src\";s:7:\"elusive\";}i:1583;a:4:{s:3:\"uid\";s:32:\"1b2ef17b42012a1e46743f9be8384f83\";s:3:\"css\";s:6:\"left-5\";s:4:\"code\";i:60669;s:3:\"src\";s:7:\"elusive\";}i:1584;a:4:{s:3:\"uid\";s:32:\"23012c4e68769e1f133bba1f93a734d1\";s:3:\"css\";s:7:\"right-5\";s:4:\"code\";i:60670;s:3:\"src\";s:7:\"elusive\";}i:1585;a:4:{s:3:\"uid\";s:32:\"cbb11c546600a92fde108476faf5d337\";s:3:\"css\";s:4:\"up-6\";s:4:\"code\";i:60671;s:3:\"src\";s:7:\"elusive\";}i:1586;a:4:{s:3:\"uid\";s:32:\"da74e2a8125fdbca337031474a48215a\";s:3:\"css\";s:14:\"down-circled-2\";s:4:\"code\";i:60672;s:3:\"src\";s:7:\"elusive\";}i:1587;a:4:{s:3:\"uid\";s:32:\"a81de1d804430408892a8291b2372013\";s:3:\"css\";s:14:\"left-circled-2\";s:4:\"code\";i:60673;s:3:\"src\";s:7:\"elusive\";}i:1588;a:4:{s:3:\"uid\";s:32:\"4c84ab263a198ea543aff93843c5ce87\";s:3:\"css\";s:15:\"right-circled-2\";s:4:\"code\";i:60674;s:3:\"src\";s:7:\"elusive\";}i:1589;a:4:{s:3:\"uid\";s:32:\"6079b9663aede6ed5882db16bb04da3b\";s:3:\"css\";s:12:\"up-circled-2\";s:4:\"code\";i:60675;s:3:\"src\";s:7:\"elusive\";}i:1590;a:4:{s:3:\"uid\";s:32:\"36c667650817d62f4e8089280ea49774\";s:3:\"css\";s:11:\"down-hand-1\";s:4:\"code\";i:60676;s:3:\"src\";s:7:\"elusive\";}i:1591;a:4:{s:3:\"uid\";s:32:\"8216d5211b81d2a7344e2b7d76d019b0\";s:3:\"css\";s:11:\"left-hand-1\";s:4:\"code\";i:60677;s:3:\"src\";s:7:\"elusive\";}i:1592;a:4:{s:3:\"uid\";s:32:\"c38baded20e83769843f48fbbfab5db3\";s:3:\"css\";s:12:\"right-hand-1\";s:4:\"code\";i:60678;s:3:\"src\";s:7:\"elusive\";}i:1593;a:4:{s:3:\"uid\";s:32:\"86cc7238838f8a1d9d442ee34120c78e\";s:3:\"css\";s:9:\"up-hand-1\";s:4:\"code\";i:60679;s:3:\"src\";s:7:\"elusive\";}i:1594;a:4:{s:3:\"uid\";s:32:\"081a030199f3ab4e18fd3ebdac1bd367\";s:3:\"css\";s:4:\"cw-5\";s:4:\"code\";i:60680;s:3:\"src\";s:7:\"elusive\";}i:1595;a:4:{s:3:\"uid\";s:32:\"5cbd2b6707adf3ec68a36ec195efe9bd\";s:3:\"css\";s:10:\"cw-circled\";s:4:\"code\";i:60681;s:3:\"src\";s:7:\"elusive\";}i:1596;a:4:{s:3:\"uid\";s:32:\"d5fabfa46384953ae055fceacb2229a7\";s:3:\"css\";s:11:\"arrows-cw-2\";s:4:\"code\";i:60682;s:3:\"src\";s:7:\"elusive\";}i:1597;a:4:{s:3:\"uid\";s:32:\"8c23ecabc7d5df3666a038ad7c699421\";s:3:\"css\";s:9:\"shuffle-4\";s:4:\"code\";i:60683;s:3:\"src\";s:7:\"elusive\";}i:1598;a:4:{s:3:\"uid\";s:32:\"20370af73ca90f73b4bda366d92303d9\";s:3:\"css\";s:6:\"play-5\";s:4:\"code\";i:60684;s:3:\"src\";s:7:\"elusive\";}i:1599;a:4:{s:3:\"uid\";s:32:\"fc006ff27e50163bdec3a7588226171b\";s:3:\"css\";s:14:\"play-circled-1\";s:4:\"code\";i:60685;s:3:\"src\";s:7:\"elusive\";}i:1600;a:4:{s:3:\"uid\";s:32:\"7acc2dfe18c6f4548626696fab27ba8a\";s:3:\"css\";s:15:\"play-circled2-1\";s:4:\"code\";i:60686;s:3:\"src\";s:7:\"elusive\";}i:1601;a:4:{s:3:\"uid\";s:32:\"fb3f247b54ed6149e1978bc3145e239a\";s:3:\"css\";s:6:\"stop-6\";s:4:\"code\";i:60687;s:3:\"src\";s:7:\"elusive\";}i:1602;a:4:{s:3:\"uid\";s:32:\"fa2a253fba2da626ef08edcc62d1e4b6\";s:3:\"css\";s:12:\"stop-circled\";s:4:\"code\";i:60688;s:3:\"src\";s:7:\"elusive\";}i:1603;a:4:{s:3:\"uid\";s:32:\"4f805cf4ac0dd68ab439dc36859b85d3\";s:3:\"css\";s:7:\"pause-5\";s:4:\"code\";i:60689;s:3:\"src\";s:7:\"elusive\";}i:1604;a:4:{s:3:\"uid\";s:32:\"8710d1e404dcb3a55b3ab97f797355b5\";s:3:\"css\";s:13:\"pause-circled\";s:4:\"code\";i:60690;s:3:\"src\";s:7:\"elusive\";}i:1605;a:4:{s:3:\"uid\";s:32:\"14cab076c708524c1031b29ffd1c188f\";s:3:\"css\";s:8:\"record-2\";s:4:\"code\";i:60691;s:3:\"src\";s:7:\"elusive\";}i:1606;a:4:{s:3:\"uid\";s:32:\"755e3f2fc18b603c3ea62b9ee25e1322\";s:3:\"css\";s:7:\"eject-3\";s:4:\"code\";i:60692;s:3:\"src\";s:7:\"elusive\";}i:1607;a:4:{s:3:\"uid\";s:32:\"a76bd0de8b24c94f7fe0e1f93c34e65f\";s:3:\"css\";s:8:\"backward\";s:4:\"code\";i:60693;s:3:\"src\";s:7:\"elusive\";}i:1608;a:4:{s:3:\"uid\";s:32:\"705a184307d39acdb41b595fef478416\";s:3:\"css\";s:16:\"backward-circled\";s:4:\"code\";i:60694;s:3:\"src\";s:7:\"elusive\";}i:1609;a:4:{s:3:\"uid\";s:32:\"c69425891f0b3ba4883e692a55e83bfd\";s:3:\"css\";s:15:\"fast-backward-2\";s:4:\"code\";i:60695;s:3:\"src\";s:7:\"elusive\";}i:1610;a:4:{s:3:\"uid\";s:32:\"c03284ddefae90dfd5ae9f0ee03325a2\";s:3:\"css\";s:14:\"fast-forward-2\";s:4:\"code\";i:60696;s:3:\"src\";s:7:\"elusive\";}i:1611;a:4:{s:3:\"uid\";s:32:\"86bf86dba2ca65051aa87794221fee1c\";s:3:\"css\";s:9:\"forward-3\";s:4:\"code\";i:60697;s:3:\"src\";s:7:\"elusive\";}i:1612;a:4:{s:3:\"uid\";s:32:\"b9589ab3313e83200f5e16e1c0c7cfa1\";s:3:\"css\";s:15:\"forward-circled\";s:4:\"code\";i:60698;s:3:\"src\";s:7:\"elusive\";}i:1613;a:4:{s:3:\"uid\";s:32:\"1e25340c5d25e252264419f11422b5fe\";s:3:\"css\";s:13:\"step-backward\";s:4:\"code\";i:60699;s:3:\"src\";s:7:\"elusive\";}i:1614;a:4:{s:3:\"uid\";s:32:\"a5971b6a03c85ab6835c6c2418fed5c5\";s:3:\"css\";s:12:\"step-forward\";s:4:\"code\";i:60700;s:3:\"src\";s:7:\"elusive\";}i:1615;a:4:{s:3:\"uid\";s:32:\"cf772d9d1eca484c9772a98045dd39d6\";s:3:\"css\";s:8:\"target-4\";s:4:\"code\";i:60701;s:3:\"src\";s:7:\"elusive\";}i:1616;a:4:{s:3:\"uid\";s:32:\"184919c94792a0dc855d8342bb28276e\";s:3:\"css\";s:8:\"signal-4\";s:4:\"code\";i:60702;s:3:\"src\";s:7:\"elusive\";}i:1617;a:4:{s:3:\"uid\";s:32:\"abe051e31ad705400cf6226b24b6e828\";s:3:\"css\";s:9:\"desktop-2\";s:4:\"code\";i:60703;s:3:\"src\";s:7:\"elusive\";}i:1618;a:4:{s:3:\"uid\";s:32:\"54ee0df068f4afe93779eb184f9b77f2\";s:3:\"css\";s:15:\"desktop-circled\";s:4:\"code\";i:60704;s:3:\"src\";s:7:\"elusive\";}i:1619;a:4:{s:3:\"uid\";s:32:\"949f56916cd9c4f45ef76cc604f02e2e\";s:3:\"css\";s:8:\"laptop-2\";s:4:\"code\";i:60705;s:3:\"src\";s:7:\"elusive\";}i:1620;a:4:{s:3:\"uid\";s:32:\"3ccaec0f82abb6c57aa6fc8feeba9f45\";s:3:\"css\";s:14:\"laptop-circled\";s:4:\"code\";i:60706;s:3:\"src\";s:7:\"elusive\";}i:1621;a:4:{s:3:\"uid\";s:32:\"b89d4f9c40feef06ad3b2e121f95c60b\";s:3:\"css\";s:9:\"network-1\";s:4:\"code\";i:60707;s:3:\"src\";s:7:\"elusive\";}i:1622;a:4:{s:3:\"uid\";s:32:\"1a94339c1ab20395e6a1475d8745714d\";s:3:\"css\";s:7:\"inbox-3\";s:4:\"code\";i:60708;s:3:\"src\";s:7:\"elusive\";}i:1623;a:4:{s:3:\"uid\";s:32:\"79b6617cefe785018f0354965c73f87d\";s:3:\"css\";s:13:\"inbox-circled\";s:4:\"code\";i:60709;s:3:\"src\";s:7:\"elusive\";}i:1624;a:4:{s:3:\"uid\";s:32:\"967c5bc59a043f85bfce1434029c6a1c\";s:3:\"css\";s:9:\"inbox-alt\";s:4:\"code\";i:60710;s:3:\"src\";s:7:\"elusive\";}i:1625;a:4:{s:3:\"uid\";s:32:\"5403802c07a547ae140985f9e2c6bc73\";s:3:\"css\";s:7:\"globe-5\";s:4:\"code\";i:60711;s:3:\"src\";s:7:\"elusive\";}i:1626;a:4:{s:3:\"uid\";s:32:\"a92d5722d47933c1d6e20b6e6d5fd308\";s:3:\"css\";s:11:\"globe-alt-1\";s:4:\"code\";i:60712;s:3:\"src\";s:7:\"elusive\";}i:1627;a:4:{s:3:\"uid\";s:32:\"df4bad7f2eb18034fdfa1cbb3ddf8ac4\";s:3:\"css\";s:7:\"cloud-6\";s:4:\"code\";i:60713;s:3:\"src\";s:7:\"elusive\";}i:1628;a:4:{s:3:\"uid\";s:32:\"b9a3ecf978bd8c42e3d31596118d9dbc\";s:3:\"css\";s:13:\"cloud-circled\";s:4:\"code\";i:60714;s:3:\"src\";s:7:\"elusive\";}i:1629;a:4:{s:3:\"uid\";s:32:\"8d673577ce96c5c2eec7f01a251fad26\";s:3:\"css\";s:8:\"flight-2\";s:4:\"code\";i:60715;s:3:\"src\";s:7:\"elusive\";}i:1630;a:4:{s:3:\"uid\";s:32:\"a904215f9fea569335d2a8addb4356b4\";s:3:\"css\";s:6:\"leaf-3\";s:4:\"code\";i:60716;s:3:\"src\";s:7:\"elusive\";}i:1631;a:4:{s:3:\"uid\";s:32:\"3cdeca193a3d47ef93a4b45f5d88ba0c\";s:3:\"css\";s:6:\"font-2\";s:4:\"code\";i:60717;s:3:\"src\";s:7:\"elusive\";}i:1632;a:4:{s:3:\"uid\";s:32:\"2c26914ed707706773028b28e8aa5bd6\";s:3:\"css\";s:10:\"fontsize-1\";s:4:\"code\";i:60718;s:3:\"src\";s:7:\"elusive\";}i:1633;a:4:{s:3:\"uid\";s:32:\"cc1de8eafc95f6faffcd8683aa8e9aa1\";s:3:\"css\";s:6:\"bold-1\";s:4:\"code\";i:60719;s:3:\"src\";s:7:\"elusive\";}i:1634;a:4:{s:3:\"uid\";s:32:\"d88a8035fea40c4d6b934d788c2f5251\";s:3:\"css\";s:8:\"italic-1\";s:4:\"code\";i:60720;s:3:\"src\";s:7:\"elusive\";}i:1635;a:4:{s:3:\"uid\";s:32:\"7c8ccee198bdf2ba9f36c884a6c1cd95\";s:3:\"css\";s:13:\"text-height-1\";s:4:\"code\";i:60721;s:3:\"src\";s:7:\"elusive\";}i:1636;a:4:{s:3:\"uid\";s:32:\"dbcb2495fc2b934b13ac6992e0429e2f\";s:3:\"css\";s:12:\"text-width-1\";s:4:\"code\";i:60722;s:3:\"src\";s:7:\"elusive\";}i:1637;a:4:{s:3:\"uid\";s:32:\"3a3b33acd5fe66d84ff303baf9d8efa8\";s:3:\"css\";s:12:\"align-left-1\";s:4:\"code\";i:60723;s:3:\"src\";s:7:\"elusive\";}i:1638;a:4:{s:3:\"uid\";s:32:\"3c4b20e86f774f150402354b9cfeb95b\";s:3:\"css\";s:14:\"align-center-1\";s:4:\"code\";i:60724;s:3:\"src\";s:7:\"elusive\";}i:1639;a:4:{s:3:\"uid\";s:32:\"4d622484db3311a1a7322aae6b253984\";s:3:\"css\";s:13:\"align-right-1\";s:4:\"code\";i:60725;s:3:\"src\";s:7:\"elusive\";}i:1640;a:4:{s:3:\"uid\";s:32:\"55f7ab3f2bedec72e8400fa2798a7a1a\";s:3:\"css\";s:15:\"align-justify-1\";s:4:\"code\";i:60726;s:3:\"src\";s:7:\"elusive\";}i:1641;a:4:{s:3:\"uid\";s:32:\"cd9ad52ef0740bb86ff11af9646d4859\";s:3:\"css\";s:6:\"list-3\";s:4:\"code\";i:60727;s:3:\"src\";s:7:\"elusive\";}i:1642;a:4:{s:3:\"uid\";s:32:\"2a6cc3252195b53ed77ad3bdd73391b3\";s:3:\"css\";s:13:\"indent-left-1\";s:4:\"code\";i:60728;s:3:\"src\";s:7:\"elusive\";}i:1643;a:4:{s:3:\"uid\";s:32:\"9efefb69aea6de9c20e56405a6aa2fd2\";s:3:\"css\";s:14:\"indent-right-1\";s:4:\"code\";i:60729;s:3:\"src\";s:7:\"elusive\";}i:1644;a:4:{s:3:\"uid\";s:32:\"310c0c174fb8843a83ad0a7c6da85c56\";s:3:\"css\";s:11:\"briefcase-3\";s:4:\"code\";i:60730;s:3:\"src\";s:7:\"elusive\";}i:1645;a:4:{s:3:\"uid\";s:32:\"c835a3a0692cca9dffde9a8a561da938\";s:3:\"css\";s:5:\"off-1\";s:4:\"code\";i:60731;s:3:\"src\";s:7:\"elusive\";}i:1646;a:4:{s:3:\"uid\";s:32:\"7ea2f977b793b6044189122babbaa8eb\";s:3:\"css\";s:6:\"road-1\";s:4:\"code\";i:60732;s:3:\"src\";s:7:\"elusive\";}i:1647;a:4:{s:3:\"uid\";s:32:\"04f7e0bbd0bba658464ca2b49097f37f\";s:3:\"css\";s:8:\"qrcode-1\";s:4:\"code\";i:60733;s:3:\"src\";s:7:\"elusive\";}i:1648;a:4:{s:3:\"uid\";s:32:\"b622423405bcc984de6553e2f23c9fb6\";s:3:\"css\";s:9:\"barcode-1\";s:4:\"code\";i:60734;s:3:\"src\";s:7:\"elusive\";}i:1649;a:4:{s:3:\"uid\";s:32:\"39a3467af0c8c49807ec54899774319c\";s:3:\"css\";s:7:\"braille\";s:4:\"code\";i:60735;s:3:\"src\";s:7:\"elusive\";}i:1650;a:4:{s:3:\"uid\";s:32:\"a4232c4b087d715e826ba0793dab59ae\";s:3:\"css\";s:6:\"book-4\";s:4:\"code\";i:60736;s:3:\"src\";s:7:\"elusive\";}i:1651;a:4:{s:3:\"uid\";s:32:\"545d79e9787941a08fb80642102850d4\";s:3:\"css\";s:8:\"adjust-1\";s:4:\"code\";i:60737;s:3:\"src\";s:7:\"elusive\";}i:1652;a:4:{s:3:\"uid\";s:32:\"1bedd7992ce00dc412fb02b39c1e9ebf\";s:3:\"css\";s:6:\"tint-1\";s:4:\"code\";i:60738;s:3:\"src\";s:7:\"elusive\";}i:1653;a:4:{s:3:\"uid\";s:32:\"e2d87e7631c608efe71762a9f4c95e75\";s:3:\"css\";s:7:\"check-3\";s:4:\"code\";i:60739;s:3:\"src\";s:7:\"elusive\";}i:1654;a:4:{s:3:\"uid\";s:32:\"cc8e2a0eff0356811984b84a868524f8\";s:3:\"css\";s:13:\"check-empty-1\";s:4:\"code\";i:60740;s:3:\"src\";s:7:\"elusive\";}i:1655;a:4:{s:3:\"uid\";s:32:\"9de7039d5c9559926fe13880aa03ff51\";s:3:\"css\";s:10:\"asterisk-1\";s:4:\"code\";i:60741;s:3:\"src\";s:7:\"elusive\";}i:1656;a:4:{s:3:\"uid\";s:32:\"5e5a88921aa39b292bdd56c3b9c923d3\";s:3:\"css\";s:6:\"gift-2\";s:4:\"code\";i:60742;s:3:\"src\";s:7:\"elusive\";}i:1657;a:4:{s:3:\"uid\";s:32:\"dc73bee1d58539abe8c96b958bf4c931\";s:3:\"css\";s:6:\"fire-2\";s:4:\"code\";i:60743;s:3:\"src\";s:7:\"elusive\";}i:1658;a:4:{s:3:\"uid\";s:32:\"2ce7a354773ee044f3c61e616e0c34dd\";s:3:\"css\";s:8:\"magnet-2\";s:4:\"code\";i:60744;s:3:\"src\";s:7:\"elusive\";}i:1659;a:4:{s:3:\"uid\";s:32:\"08fcae555c22437a112411038ac28e16\";s:3:\"css\";s:7:\"chart-2\";s:4:\"code\";i:60745;s:3:\"src\";s:7:\"elusive\";}i:1660;a:4:{s:3:\"uid\";s:32:\"c4987116a2c796f034f0857db51fcaf5\";s:3:\"css\";s:13:\"chart-circled\";s:4:\"code\";i:60746;s:3:\"src\";s:7:\"elusive\";}i:1661;a:4:{s:3:\"uid\";s:32:\"8c9fbdd92132007cf2f5e13b7ecb38f0\";s:3:\"css\";s:13:\"credit-card-4\";s:4:\"code\";i:60747;s:3:\"src\";s:7:\"elusive\";}i:1662;a:4:{s:3:\"uid\";s:32:\"d9ca3bd7577f1110305a2ca1841826cb\";s:3:\"css\";s:11:\"megaphone-2\";s:4:\"code\";i:60748;s:3:\"src\";s:7:\"elusive\";}i:1663;a:4:{s:3:\"uid\";s:32:\"c9bef3dc67fea47e94c4a5030ea64dad\";s:3:\"css\";s:11:\"clipboard-2\";s:4:\"code\";i:60749;s:3:\"src\";s:7:\"elusive\";}i:1664;a:4:{s:3:\"uid\";s:32:\"7a2707491ef57c1e98921df65b572a66\";s:3:\"css\";s:5:\"hdd-2\";s:4:\"code\";i:60750;s:3:\"src\";s:7:\"elusive\";}i:1665;a:4:{s:3:\"uid\";s:32:\"272e08e0e16226aadf94dcbf33aab2b2\";s:3:\"css\";s:5:\"key-4\";s:4:\"code\";i:60751;s:3:\"src\";s:7:\"elusive\";}i:1666;a:4:{s:3:\"uid\";s:32:\"1a14e43d8e27f5b63fb418b586a2ade3\";s:3:\"css\";s:13:\"certificate-2\";s:4:\"code\";i:60752;s:3:\"src\";s:7:\"elusive\";}i:1667;a:4:{s:3:\"uid\";s:32:\"84ab84920cd038d5b4b003f63e59aac6\";s:3:\"css\";s:7:\"tasks-1\";s:4:\"code\";i:60753;s:3:\"src\";s:7:\"elusive\";}i:1668;a:4:{s:3:\"uid\";s:32:\"5048fb5dd929882d2bac1ad3777b0b7d\";s:3:\"css\";s:8:\"filter-1\";s:4:\"code\";i:60754;s:3:\"src\";s:7:\"elusive\";}i:1669;a:4:{s:3:\"uid\";s:32:\"c053ebe321823b081483d332b06eee54\";s:3:\"css\";s:7:\"gauge-2\";s:4:\"code\";i:60755;s:3:\"src\";s:7:\"elusive\";}i:1670;a:4:{s:3:\"uid\";s:32:\"f6d4106b0e134e9c20838a4437db2bdd\";s:3:\"css\";s:6:\"smiley\";s:4:\"code\";i:60756;s:3:\"src\";s:7:\"elusive\";}i:1671;a:4:{s:3:\"uid\";s:32:\"0a3ee424064f6ad4df821ea758d3399b\";s:3:\"css\";s:14:\"smiley-circled\";s:4:\"code\";i:60757;s:3:\"src\";s:7:\"elusive\";}i:1672;a:4:{s:3:\"uid\";s:32:\"361e7d7e271443ea2c48443142dbe404\";s:3:\"css\";s:12:\"address-book\";s:4:\"code\";i:60758;s:3:\"src\";s:7:\"elusive\";}i:1673;a:4:{s:3:\"uid\";s:32:\"7b8d4298f52e82954959c0566e9929f9\";s:3:\"css\";s:16:\"address-book-alt\";s:4:\"code\";i:60759;s:3:\"src\";s:7:\"elusive\";}i:1674;a:4:{s:3:\"uid\";s:32:\"10fdd98fb50c590b805a3ad6ff9c55f5\";s:3:\"css\";s:3:\"asl\";s:4:\"code\";i:60760;s:3:\"src\";s:7:\"elusive\";}i:1675;a:4:{s:3:\"uid\";s:32:\"a3662e0fce8c28f9b91a3889094cd1e9\";s:3:\"css\";s:7:\"glasses\";s:4:\"code\";i:60761;s:3:\"src\";s:7:\"elusive\";}i:1676;a:4:{s:3:\"uid\";s:32:\"5add73d9688b3ccd8e7e7a58197dbaeb\";s:3:\"css\";s:16:\"hearing-impaired\";s:4:\"code\";i:60762;s:3:\"src\";s:7:\"elusive\";}i:1677;a:4:{s:3:\"uid\";s:32:\"babd288a0685a4b701a934fd40679a80\";s:3:\"css\";s:11:\"iphone-home\";s:4:\"code\";i:60763;s:3:\"src\";s:7:\"elusive\";}i:1678;a:4:{s:3:\"uid\";s:32:\"d92a3efcdf848fb0abd9410b8d95813e\";s:3:\"css\";s:6:\"person\";s:4:\"code\";i:60764;s:3:\"src\";s:7:\"elusive\";}i:1679;a:4:{s:3:\"uid\";s:32:\"1e394b6cd5e0da3e10d8e4f3fe355960\";s:3:\"css\";s:5:\"adult\";s:4:\"code\";i:60765;s:3:\"src\";s:7:\"elusive\";}i:1680;a:4:{s:3:\"uid\";s:32:\"c737078cb69dfd2e8484e134ecbce791\";s:3:\"css\";s:5:\"child\";s:4:\"code\";i:60766;s:3:\"src\";s:7:\"elusive\";}i:1681;a:4:{s:3:\"uid\";s:32:\"b7685cc9e721c9430986e03e08afed83\";s:3:\"css\";s:5:\"blind\";s:4:\"code\";i:60767;s:3:\"src\";s:7:\"elusive\";}i:1682;a:4:{s:3:\"uid\";s:32:\"88ae7d00391a440ac7ccd009bcb34e4e\";s:3:\"css\";s:8:\"guidedog\";s:4:\"code\";i:60768;s:3:\"src\";s:7:\"elusive\";}i:1683;a:4:{s:3:\"uid\";s:32:\"afe93fc3d2e6e389194bb3771f00fdb1\";s:3:\"css\";s:13:\"accessibility\";s:4:\"code\";i:60769;s:3:\"src\";s:7:\"elusive\";}i:1684;a:4:{s:3:\"uid\";s:32:\"d4385b9337eeaa7feb48465b50649042\";s:3:\"css\";s:16:\"universal-access\";s:4:\"code\";i:60770;s:3:\"src\";s:7:\"elusive\";}i:1685;a:4:{s:3:\"uid\";s:32:\"51d26008d35b3c8b15a48f49e2b08860\";s:3:\"css\";s:6:\"male-2\";s:4:\"code\";i:60771;s:3:\"src\";s:7:\"elusive\";}i:1686;a:4:{s:3:\"uid\";s:32:\"471497b78b90ca63aa21b13bf4c46cf4\";s:3:\"css\";s:8:\"female-2\";s:4:\"code\";i:60772;s:3:\"src\";s:7:\"elusive\";}i:1687;a:4:{s:3:\"uid\";s:32:\"a0b54315916e54beb4737562e203f674\";s:3:\"css\";s:9:\"behance-1\";s:4:\"code\";i:60773;s:3:\"src\";s:7:\"elusive\";}i:1688;a:4:{s:3:\"uid\";s:32:\"166d4e3accccb0dfec9334cdab946db5\";s:3:\"css\";s:9:\"blogger-2\";s:4:\"code\";i:60774;s:3:\"src\";s:7:\"elusive\";}i:1689;a:4:{s:3:\"uid\";s:32:\"9019381ddbf3c1007639974a480c86c2\";s:3:\"css\";s:4:\"cc-2\";s:4:\"code\";i:60775;s:3:\"src\";s:7:\"elusive\";}i:1690;a:4:{s:3:\"uid\";s:32:\"43be174b82af7559a7550ea38650ae4f\";s:3:\"css\";s:3:\"css\";s:4:\"code\";i:60776;s:3:\"src\";s:7:\"elusive\";}i:1691;a:4:{s:3:\"uid\";s:32:\"82c1a53a806cc33aab8bdef9dabf3e42\";s:3:\"css\";s:11:\"delicious-1\";s:4:\"code\";i:60777;s:3:\"src\";s:7:\"elusive\";}i:1692;a:4:{s:3:\"uid\";s:32:\"aec2c281c91ca07d01e47f444545036f\";s:3:\"css\";s:12:\"deviantart-1\";s:4:\"code\";i:60778;s:3:\"src\";s:7:\"elusive\";}i:1693;a:4:{s:3:\"uid\";s:32:\"1a2b14f7b24937389346c858ae711f25\";s:3:\"css\";s:6:\"digg-1\";s:4:\"code\";i:60779;s:3:\"src\";s:7:\"elusive\";}i:1694;a:4:{s:3:\"uid\";s:32:\"c39ce49cb99649ba86ebc65f27335621\";s:3:\"css\";s:10:\"dribbble-5\";s:4:\"code\";i:60780;s:3:\"src\";s:7:\"elusive\";}i:1695;a:4:{s:3:\"uid\";s:32:\"c99e966e3d22ec0b9d8678fd524e5512\";s:3:\"css\";s:10:\"facebook-7\";s:4:\"code\";i:60781;s:3:\"src\";s:7:\"elusive\";}i:1696;a:4:{s:3:\"uid\";s:32:\"f9e7869be96161992f476eaa4219637d\";s:3:\"css\";s:8:\"flickr-4\";s:4:\"code\";i:60782;s:3:\"src\";s:7:\"elusive\";}i:1697;a:4:{s:3:\"uid\";s:32:\"1a4351807d92cb6b27eabb24ec239889\";s:3:\"css\";s:12:\"foursquare-2\";s:4:\"code\";i:60783;s:3:\"src\";s:7:\"elusive\";}i:1698;a:4:{s:3:\"uid\";s:32:\"818869a1eb50dbf4ad9d2655fe835201\";s:3:\"css\";s:12:\"friendfeed-1\";s:4:\"code\";i:60784;s:3:\"src\";s:7:\"elusive\";}i:1699;a:4:{s:3:\"uid\";s:32:\"72534675ded399a0fa8c73467d02101d\";s:3:\"css\";s:17:\"friendfeed-rect-1\";s:4:\"code\";i:60785;s:3:\"src\";s:7:\"elusive\";}i:1700;a:4:{s:3:\"uid\";s:32:\"aa18911cd641967c899c575aeb80cd7e\";s:3:\"css\";s:8:\"github-6\";s:4:\"code\";i:60786;s:3:\"src\";s:7:\"elusive\";}i:1701;a:4:{s:3:\"uid\";s:32:\"798f480ad47c7c7fa6c64ece88ea2180\";s:3:\"css\";s:13:\"github-text-1\";s:4:\"code\";i:60787;s:3:\"src\";s:7:\"elusive\";}i:1702;a:4:{s:3:\"uid\";s:32:\"a58fe946fe31826f0b19cb4dfaaf13d2\";s:3:\"css\";s:10:\"googleplus\";s:4:\"code\";i:60788;s:3:\"src\";s:7:\"elusive\";}i:1703;a:4:{s:3:\"uid\";s:32:\"94ca559902b8930f0b267a588ffddb0b\";s:3:\"css\";s:11:\"instagram-4\";s:4:\"code\";i:60789;s:3:\"src\";s:7:\"elusive\";}i:1704;a:4:{s:3:\"uid\";s:32:\"09cad6e46ec29b279626434802012bba\";s:3:\"css\";s:10:\"linkedin-6\";s:4:\"code\";i:60790;s:3:\"src\";s:7:\"elusive\";}i:1705;a:4:{s:3:\"uid\";s:32:\"c37b15dbb7b146c359d45b577fba6c0e\";s:3:\"css\";s:4:\"path\";s:4:\"code\";i:60791;s:3:\"src\";s:7:\"elusive\";}i:1706;a:4:{s:3:\"uid\";s:32:\"866934e4e5cfbc2d2a00d08f30257397\";s:3:\"css\";s:8:\"picasa-2\";s:4:\"code\";i:60792;s:3:\"src\";s:7:\"elusive\";}i:1707;a:4:{s:3:\"uid\";s:32:\"1b813c4a33217fc20f46f3c157a9c90c\";s:3:\"css\";s:11:\"pinterest-3\";s:4:\"code\";i:60793;s:3:\"src\";s:7:\"elusive\";}i:1708;a:4:{s:3:\"uid\";s:32:\"e7f91449144fb058ad8125e2d35b2363\";s:3:\"css\";s:8:\"reddit-1\";s:4:\"code\";i:60794;s:3:\"src\";s:7:\"elusive\";}i:1709;a:4:{s:3:\"uid\";s:32:\"eb2180f5d31d3e2fcc08856edbd3fb8f\";s:3:\"css\";s:7:\"skype-5\";s:4:\"code\";i:60795;s:3:\"src\";s:7:\"elusive\";}i:1710;a:4:{s:3:\"uid\";s:32:\"326b529aa8b8913d3bc4a632f3dcec69\";s:3:\"css\";s:10:\"slideshare\";s:4:\"code\";i:60796;s:3:\"src\";s:7:\"elusive\";}i:1711;a:4:{s:3:\"uid\";s:32:\"a5e7f5574a71d31bdf2012f0c2acb2a3\";s:3:\"css\";s:15:\"stackoverflow-2\";s:4:\"code\";i:60797;s:3:\"src\";s:7:\"elusive\";}i:1712;a:4:{s:3:\"uid\";s:32:\"f90c6acf12a82ff9c9ce6878bdffd595\";s:3:\"css\";s:13:\"stumbleupon-2\";s:4:\"code\";i:60798;s:3:\"src\";s:7:\"elusive\";}i:1713;a:4:{s:3:\"uid\";s:32:\"26969cfbd811730075e4c657cc9fda2a\";s:3:\"css\";s:9:\"twitter-7\";s:4:\"code\";i:60799;s:3:\"src\";s:7:\"elusive\";}i:1714;a:4:{s:3:\"uid\";s:32:\"a816e83fc27dae26ad37e0c209b19920\";s:3:\"css\";s:8:\"tumblr-4\";s:4:\"code\";i:60800;s:3:\"src\";s:7:\"elusive\";}i:1715;a:4:{s:3:\"uid\";s:32:\"0d024b966c51aff0cd02527eb7f21950\";s:3:\"css\";s:7:\"vimeo-4\";s:4:\"code\";i:60801;s:3:\"src\";s:7:\"elusive\";}i:1716;a:4:{s:3:\"uid\";s:32:\"34cfa573b7d6c70c298dfad4cac4d466\";s:3:\"css\";s:11:\"vkontakte-2\";s:4:\"code\";i:60802;s:3:\"src\";s:7:\"elusive\";}i:1717;a:4:{s:3:\"uid\";s:32:\"e8ac3bb8871f23096fcab025ba5373cb\";s:3:\"css\";s:5:\"w3c-1\";s:4:\"code\";i:60803;s:3:\"src\";s:7:\"elusive\";}i:1718;a:4:{s:3:\"uid\";s:32:\"c72edf6fd8549ee6b7578254145715d5\";s:3:\"css\";s:11:\"wordpress-2\";s:4:\"code\";i:60804;s:3:\"src\";s:7:\"elusive\";}i:1719;a:4:{s:3:\"uid\";s:32:\"990d39e5b7e9750c55d2593b1cc61a0a\";s:3:\"css\";s:9:\"youtube-3\";s:4:\"code\";i:60805;s:3:\"src\";s:7:\"elusive\";}i:1720;a:4:{s:3:\"uid\";s:32:\"c64623255a4a7c72436b199b05296c4f\";s:3:\"css\";s:9:\"emo-happy\";s:4:\"code\";i:59392;s:3:\"src\";s:9:\"fontelico\";}i:1721;a:4:{s:3:\"uid\";s:32:\"1ba44825e5f10920b4e3f1d0c73f79a2\";s:3:\"css\";s:8:\"emo-wink\";s:4:\"code\";i:59393;s:3:\"src\";s:9:\"fontelico\";}i:1722;a:4:{s:3:\"uid\";s:32:\"4bb2045a2aca451705fe8a23c4a576ab\";s:3:\"css\";s:9:\"emo-wink2\";s:4:\"code\";i:59394;s:3:\"src\";s:9:\"fontelico\";}i:1723;a:4:{s:3:\"uid\";s:32:\"53ed8570225581269cd7eff5795e8bea\";s:3:\"css\";s:11:\"emo-unhappy\";s:4:\"code\";i:59395;s:3:\"src\";s:9:\"fontelico\";}i:1724;a:4:{s:3:\"uid\";s:32:\"fd59eac4d575b48eb156590b63a355fd\";s:3:\"css\";s:9:\"emo-sleep\";s:4:\"code\";i:59396;s:3:\"src\";s:9:\"fontelico\";}i:1725;a:4:{s:3:\"uid\";s:32:\"142263941b9f4cd4b2b84f1f4cd13b1d\";s:3:\"css\";s:12:\"emo-thumbsup\";s:4:\"code\";i:59397;s:3:\"src\";s:9:\"fontelico\";}i:1726;a:4:{s:3:\"uid\";s:32:\"4dd56d61fd0dab19277824da301424b3\";s:3:\"css\";s:9:\"emo-devil\";s:4:\"code\";i:59398;s:3:\"src\";s:9:\"fontelico\";}i:1727;a:4:{s:3:\"uid\";s:32:\"68e298ff2d8b25dd7f647ed64f5ae690\";s:3:\"css\";s:13:\"emo-surprised\";s:4:\"code\";i:59399;s:3:\"src\";s:9:\"fontelico\";}i:1728;a:4:{s:3:\"uid\";s:32:\"bb68a13a3574b087d4350eff0b8d48e3\";s:3:\"css\";s:10:\"emo-tongue\";s:4:\"code\";i:59400;s:3:\"src\";s:9:\"fontelico\";}i:1729;a:4:{s:3:\"uid\";s:32:\"48cc210e59ff4bc56b6c8fba6eb384b8\";s:3:\"css\";s:10:\"emo-coffee\";s:4:\"code\";i:59401;s:3:\"src\";s:9:\"fontelico\";}i:1730;a:4:{s:3:\"uid\";s:32:\"078fec38562c3f83a1201a908040c141\";s:3:\"css\";s:14:\"emo-sunglasses\";s:4:\"code\";i:59402;s:3:\"src\";s:9:\"fontelico\";}i:1731;a:4:{s:3:\"uid\";s:32:\"043b585886018be7408f4c77c1a3759c\";s:3:\"css\";s:14:\"emo-displeased\";s:4:\"code\";i:59403;s:3:\"src\";s:9:\"fontelico\";}i:1732;a:4:{s:3:\"uid\";s:32:\"3a900d0e9f43f5409211f62bec557379\";s:3:\"css\";s:8:\"emo-beer\";s:4:\"code\";i:59404;s:3:\"src\";s:9:\"fontelico\";}i:1733;a:4:{s:3:\"uid\";s:32:\"cbc328d1c779a2b9e3b1199d904199a5\";s:3:\"css\";s:8:\"emo-grin\";s:4:\"code\";i:59405;s:3:\"src\";s:9:\"fontelico\";}i:1734;a:4:{s:3:\"uid\";s:32:\"f0d3ad15d020cf187d42dd3b2295b65c\";s:3:\"css\";s:9:\"emo-angry\";s:4:\"code\";i:59406;s:3:\"src\";s:9:\"fontelico\";}i:1735;a:4:{s:3:\"uid\";s:32:\"5195e2dcb4a63fbb8c09896a8058f6ab\";s:3:\"css\";s:9:\"emo-saint\";s:4:\"code\";i:59407;s:3:\"src\";s:9:\"fontelico\";}i:1736;a:4:{s:3:\"uid\";s:32:\"04688d76a33ce7a7950e40fae79c08ac\";s:3:\"css\";s:7:\"emo-cry\";s:4:\"code\";i:59408;s:3:\"src\";s:9:\"fontelico\";}i:1737;a:4:{s:3:\"uid\";s:32:\"4843d0d6050dd508d4c101a334f46db2\";s:3:\"css\";s:9:\"emo-shoot\";s:4:\"code\";i:59409;s:3:\"src\";s:9:\"fontelico\";}i:1738;a:4:{s:3:\"uid\";s:32:\"fc92480dedc439d274d4e3e4b425edf4\";s:3:\"css\";s:10:\"emo-squint\";s:4:\"code\";i:59410;s:3:\"src\";s:9:\"fontelico\";}i:1739;a:4:{s:3:\"uid\";s:32:\"2bd5f98482d86649958312ea2ab5bb40\";s:3:\"css\";s:9:\"emo-laugh\";s:4:\"code\";i:59411;s:3:\"src\";s:9:\"fontelico\";}i:1740;a:4:{s:3:\"uid\";s:32:\"72109d2fb3088d0e66ea6a9204297651\";s:3:\"css\";s:18:\"spin1 animate-spin\";s:4:\"code\";i:59412;s:3:\"src\";s:9:\"fontelico\";}i:1741;a:4:{s:3:\"uid\";s:32:\"f0c301ac841dafc38d8eb1b933fc73e5\";s:3:\"css\";s:18:\"spin2 animate-spin\";s:4:\"code\";i:59413;s:3:\"src\";s:9:\"fontelico\";}i:1742;a:4:{s:3:\"uid\";s:32:\"2a6740fc2f9d0edea54205963f662594\";s:3:\"css\";s:18:\"spin3 animate-spin\";s:4:\"code\";i:59414;s:3:\"src\";s:9:\"fontelico\";}i:1743;a:4:{s:3:\"uid\";s:32:\"9bd60140934a1eb9236fd7a8ab1ff6ba\";s:3:\"css\";s:18:\"spin4 animate-spin\";s:4:\"code\";i:59415;s:3:\"src\";s:9:\"fontelico\";}i:1744;a:4:{s:3:\"uid\";s:32:\"5d2d07f112b8de19f2c0dbfec3e42c05\";s:3:\"css\";s:18:\"spin5 animate-spin\";s:4:\"code\";i:59416;s:3:\"src\";s:9:\"fontelico\";}i:1745;a:4:{s:3:\"uid\";s:32:\"9bc2902722abb366a213a052ade360bc\";s:3:\"css\";s:18:\"spin6 animate-spin\";s:4:\"code\";i:59417;s:3:\"src\";s:9:\"fontelico\";}i:1746;a:4:{s:3:\"uid\";s:32:\"62c089cb34e74b3a1200bc7f5314eb4e\";s:3:\"css\";s:7:\"firefox\";s:4:\"code\";i:59418;s:3:\"src\";s:9:\"fontelico\";}i:1747;a:4:{s:3:\"uid\";s:32:\"9c2b737b16ae2c8d66b7bfd29ba5ecd8\";s:3:\"css\";s:6:\"chrome\";s:4:\"code\";i:59419;s:3:\"src\";s:9:\"fontelico\";}i:1748;a:4:{s:3:\"uid\";s:32:\"45861dd1e5ce4fde338bcccf01eeb808\";s:3:\"css\";s:5:\"opera\";s:4:\"code\";i:59420;s:3:\"src\";s:9:\"fontelico\";}i:1749;a:4:{s:3:\"uid\";s:32:\"2a46f1d1c9bd036e17a74e46613c1636\";s:3:\"css\";s:2:\"ie\";s:4:\"code\";i:59421;s:3:\"src\";s:9:\"fontelico\";}}}\";","yes");

INSERT IGNORE INTO `ac_options` VALUES 
("194","widget_custom-latest-projects","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("195","widget_custom-popular-projects","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("221","ls-plugin-version","6.7.1","yes"),
("222","ls-db-version","6.5.5","yes"),
("223","ls-installed","1","yes"),
("224","ls-date-installed","1525774043","yes"),
("226","revslider_servers","a:3:{i:0;s:22:\"themepunch-ext-c.tools\";i:1;s:22:\"themepunch-ext-a.tools\";i:2;s:22:\"themepunch-ext-b.tools\";}","yes"),
("227","revslider_server_refresh","1764873105","yes"),
("228","revslider-update-check-short","1765495547","yes"),
("229","revslider-templates-check","1765495548","yes"),
("233","envato_market_version","1.0.0-RC2","yes"),
("234","widget_layerslider_widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("235","widget_custom-contact-form","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("237","revslider-library-check","1764246604","yes"),
("238","rs-library","a:3:{s:4:\"hash\";s:32:\"0ce9f598b2f69328eec26a889eff9599\";s:7:\"objects\";a:179:{i:0;a:13:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14130;s:4:\"orig\";i:220294;}}i:1;a:13:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:27127;s:4:\"orig\";i:1192484;}}i:2;a:13:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:1745;s:4:\"orig\";i:36243;}}i:3;a:13:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10511;s:4:\"orig\";i:102067;}}i:4;a:13:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18581;s:4:\"orig\";i:776243;}}i:5;a:13:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4745;s:4:\"orig\";i:330658;}}i:6;a:13:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4461;s:4:\"orig\";i:109963;}}i:7;a:13:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6790;s:4:\"orig\";i:407746;}}i:8;a:13:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18710;s:4:\"orig\";i:985569;}}i:9;a:13:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6113;s:4:\"orig\";i:75865;}}i:10;a:13:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8145;s:4:\"orig\";i:400329;}}i:11;a:13:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5251;s:4:\"orig\";i:358141;}}i:12;a:13:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:127536;s:4:\"orig\";i:838279;}}i:13;a:13:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4081;s:4:\"orig\";i:22391;}}i:14;a:13:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9331;s:4:\"orig\";i:516465;}}i:15;a:13:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:463818;}}i:16;a:13:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6359;s:4:\"orig\";i:102578;}}i:17;a:13:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22078;s:4:\"orig\";i:1107904;}}i:18;a:13:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15660;s:4:\"orig\";i:355784;}}i:19;a:13:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5586;s:4:\"orig\";i:106514;}}i:20;a:13:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20909;s:4:\"orig\";i:988589;}}i:21;a:13:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6807;s:4:\"orig\";i:604409;}}i:22;a:13:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10484;s:4:\"orig\";i:229243;}}i:23;a:13:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6034;s:4:\"orig\";i:516575;}}i:24;a:13:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:30999;s:4:\"orig\";i:627862;}}i:25;a:13:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11735;s:4:\"orig\";i:658948;}}i:26;a:13:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16432;s:4:\"orig\";i:531684;}}i:27;a:13:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15860;s:4:\"orig\";i:212685;}}i:28;a:13:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12774;s:4:\"orig\";i:290128;}}i:29;a:13:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8558;s:4:\"orig\";i:264887;}}i:30;a:13:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23349;s:4:\"orig\";i:324946;}}i:31;a:13:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18439;s:4:\"orig\";i:583276;}}i:32;a:13:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8475;s:4:\"orig\";i:241613;}}i:33;a:13:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12227;s:4:\"orig\";i:465092;}}i:34;a:13:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23476;s:4:\"orig\";i:838985;}}i:35;a:13:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:128594;s:4:\"orig\";i:323284;}}i:36;a:13:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15763;s:4:\"orig\";i:606028;}}i:37;a:13:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8743;s:4:\"orig\";i:230696;}}i:38;a:13:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18213;s:4:\"orig\";i:963650;}}i:39;a:13:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9109;s:4:\"orig\";i:190560;}}i:40;a:13:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7469;s:4:\"orig\";i:161910;}}i:41;a:13:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8883;s:4:\"orig\";i:223813;}}i:42;a:13:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13021;s:4:\"orig\";i:334845;}}i:43;a:13:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20718;s:4:\"orig\";i:626836;}}i:44;a:13:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:135139;s:4:\"orig\";i:761240;}}i:45;a:13:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13099;s:4:\"orig\";i:337348;}}i:46;a:13:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13096;s:4:\"orig\";i:413010;}}i:47;a:13:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8043;s:4:\"orig\";i:146037;}}i:48;a:13:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37011;s:4:\"orig\";i:2569343;}}i:49;a:13:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:118650;s:4:\"orig\";i:83713;}}i:50;a:13:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16941;s:4:\"orig\";i:419726;}}i:51;a:13:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:23620;s:4:\"orig\";i:734047;}}i:52;a:13:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21088;s:4:\"orig\";i:683735;}}i:53;a:13:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121307;s:4:\"orig\";i:454357;}}i:54;a:13:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39586;s:4:\"orig\";i:1296460;}}i:55;a:13:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21396;s:4:\"orig\";i:835061;}}i:56;a:13:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9545;s:4:\"orig\";i:197811;}}i:57;a:13:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12033;s:4:\"orig\";i:168991;}}i:58;a:13:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:39587;s:4:\"orig\";i:1318549;}}i:59;a:13:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:137321;s:4:\"orig\";i:211275;}}i:60;a:13:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14164;s:4:\"orig\";i:731428;}}i:61;a:13:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:130362;s:4:\"orig\";i:908876;}}i:62;a:13:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:132862;s:4:\"orig\";i:925492;}}i:63;a:13:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119015;s:4:\"orig\";i:133010;}}i:64;a:13:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:28476;s:4:\"orig\";i:203448;}}i:65;a:13:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:120592;s:4:\"orig\";i:133753;}}i:66;a:13:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119554;s:4:\"orig\";i:160622;}}i:67;a:13:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14058;s:4:\"orig\";i:98209;}}i:68;a:13:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:126007;s:4:\"orig\";i:137953;}}i:69;a:13:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124418;s:4:\"orig\";i:108064;}}i:70;a:13:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125639;s:4:\"orig\";i:131820;}}i:71;a:13:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11948;s:4:\"orig\";i:74707;}}i:72;a:13:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:115633;s:4:\"orig\";i:176188;}}i:73;a:13:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121535;s:4:\"orig\";i:315586;}}i:74;a:13:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:133693;s:4:\"orig\";i:907152;}}i:75;a:13:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11689;s:4:\"orig\";i:183976;}}i:76;a:13:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:119147;s:4:\"orig\";i:164255;}}i:77;a:13:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9499;s:4:\"orig\";i:358634;}}i:78;a:13:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14203;s:4:\"orig\";i:523017;}}i:79;a:13:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10702;s:4:\"orig\";i:121030;}}i:80;a:13:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9002;s:4:\"orig\";i:338072;}}i:81;a:13:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:121622;s:4:\"orig\";i:211345;}}i:82;a:13:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:122962;s:4:\"orig\";i:353407;}}i:83;a:13:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7170;s:4:\"orig\";i:118827;}}i:84;a:13:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:125910;s:4:\"orig\";i:126452;}}i:85;a:13:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12207;s:4:\"orig\";i:177730;}}i:86;a:13:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13663;s:4:\"orig\";i:833006;}}i:87;a:13:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9899;s:4:\"orig\";i:247486;}}i:88;a:13:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7169;s:4:\"orig\";i:522980;}}i:89;a:13:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12411;s:4:\"orig\";i:1051815;}}i:90;a:13:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14974;s:4:\"orig\";i:1082610;}}i:91;a:13:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26819;s:4:\"orig\";i:1283468;}}i:92;a:13:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22713;s:4:\"orig\";i:1335327;}}i:93;a:13:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5513;s:4:\"orig\";i:477513;}}i:94;a:13:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24077;s:4:\"orig\";i:1392352;}}i:95;a:13:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11502;s:4:\"orig\";i:779077;}}i:96;a:13:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7975;s:4:\"orig\";i:323107;}}i:97;a:13:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:129564;s:4:\"orig\";i:432451;}}i:98;a:13:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6743;s:4:\"orig\";i:479348;}}i:99;a:13:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3910;s:4:\"orig\";i:246373;}}i:100;a:13:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9677;s:4:\"orig\";i:154608;}}i:101;a:13:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5998;s:4:\"orig\";i:447839;}}i:102;a:13:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10117;s:4:\"orig\";i:559800;}}i:103;a:13:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:24853;s:4:\"orig\";i:1214851;}}i:104;a:13:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:18163;s:4:\"orig\";i:1098732;}}i:105;a:13:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5457;s:4:\"orig\";i:320148;}}i:106;a:13:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13313;s:4:\"orig\";i:828871;}}i:107;a:13:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:5901;s:4:\"orig\";i:268842;}}i:108;a:13:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:37178;s:4:\"orig\";i:1972817;}}i:109;a:13:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:26589;s:4:\"orig\";i:851135;}}i:110;a:13:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13334;s:4:\"orig\";i:225651;}}i:111;a:13:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:17640;s:4:\"orig\";i:719125;}}i:112;a:13:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8897;s:4:\"orig\";i:83416;}}i:113;a:13:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29174;s:4:\"orig\";i:1663503;}}i:114;a:13:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3668;s:4:\"orig\";i:69153;}}i:115;a:13:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:3179;s:4:\"orig\";i:45340;}}i:116;a:13:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21907;s:4:\"orig\";i:937495;}}i:117;a:13:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:124560;s:4:\"orig\";i:575796;}}i:118;a:13:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:20553;s:4:\"orig\";i:734042;}}i:119;a:13:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9048;s:4:\"orig\";i:129827;}}i:260;a:13:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16088;s:4:\"orig\";i:241567;}}i:261;a:13:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8512;s:4:\"orig\";i:267430;}}i:262;a:13:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:25804;s:4:\"orig\";i:908234;}}i:263;a:13:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:4691;s:4:\"orig\";i:108160;}}i:264;a:13:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12753;s:4:\"orig\";i:218714;}}i:265;a:13:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:19312;s:4:\"orig\";i:438345;}}i:266;a:13:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16224;s:4:\"orig\";i:409547;}}i:267;a:13:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:22344;s:4:\"orig\";i:432904;}}i:268;a:13:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9431;s:4:\"orig\";i:220442;}}i:269;a:13:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:29538;s:4:\"orig\";i:733632;}}i:270;a:13:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12859;s:4:\"orig\";i:430959;}}i:271;a:13:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13413;s:4:\"orig\";i:324558;}}i:272;a:13:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11553;s:4:\"orig\";i:146076;}}i:273;a:13:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:21184;s:4:\"orig\";i:537577;}}i:274;a:13:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14134;s:4:\"orig\";i:245565;}}i:275;a:13:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16035;s:4:\"orig\";i:401592;}}i:276;a:13:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12906;s:4:\"orig\";i:483885;}}i:277;a:13:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7834;s:4:\"orig\";i:80956;}}i:278;a:13:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11452;s:4:\"orig\";i:175118;}}i:279;a:13:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12170;s:4:\"orig\";i:236860;}}i:280;a:13:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10268;s:4:\"orig\";i:117315;}}i:281;a:13:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12485;s:4:\"orig\";i:374567;}}i:282;a:13:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8401;s:4:\"orig\";i:203253;}}i:283;a:13:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12578;s:4:\"orig\";i:287796;}}i:284;a:13:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8484;s:4:\"orig\";i:199508;}}i:285;a:13:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:16659;s:4:\"orig\";i:524922;}}i:286;a:13:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9240;s:4:\"orig\";i:109310;}}i:287;a:13:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8288;s:4:\"orig\";i:216553;}}i:288;a:13:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6855;s:4:\"orig\";i:234043;}}i:289;a:13:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12347;s:4:\"orig\";i:238706;}}i:290;a:13:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7748;s:4:\"orig\";i:169462;}}i:291;a:13:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10402;s:4:\"orig\";i:358403;}}i:292;a:13:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12887;s:4:\"orig\";i:261525;}}i:293;a:13:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:2963;s:4:\"orig\";i:30890;}}i:294;a:13:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10266;s:4:\"orig\";i:183341;}}i:295;a:13:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:8156;s:4:\"orig\";i:102119;}}i:296;a:13:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10271;s:4:\"orig\";i:138495;}}i:297;a:13:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11654;s:4:\"orig\";i:171098;}}i:298;a:13:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10569;s:4:\"orig\";i:437331;}}i:299;a:13:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:15739;s:4:\"orig\";i:446809;}}i:300;a:13:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9456;s:4:\"orig\";i:206722;}}i:301;a:13:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:13833;s:4:\"orig\";i:341185;}}i:302;a:13:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:10647;s:4:\"orig\";i:193025;}}i:303;a:13:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:6239;s:4:\"orig\";i:48178;}}i:304;a:13:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:14454;s:4:\"orig\";i:454843;}}i:305;a:13:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:7734;s:4:\"orig\";i:119909;}}i:306;a:13:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:11927;s:4:\"orig\";i:209224;}}i:307;a:13:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:9609;s:4:\"orig\";i:230249;}}i:308;a:13:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";s:9:\"file_size\";a:2:{s:5:\"thumb\";i:12396;s:4:\"orig\";i:290596;}}i:359;a:14:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:20000;s:11:\"video_thumb\";i:655504;s:5:\"cover\";i:620066;s:4:\"orig\";i:13229794;}}i:360;a:14:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:23213;s:11:\"video_thumb\";i:498407;s:5:\"cover\";i:308442;s:4:\"orig\";i:11108924;}}i:361;a:14:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:21648;s:11:\"video_thumb\";i:109062;s:5:\"cover\";i:305957;s:4:\"orig\";i:6267674;}}i:362;a:14:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19198;s:11:\"video_thumb\";i:326656;s:5:\"cover\";i:554701;s:4:\"orig\";i:10151652;}}i:363;a:14:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:14725;s:11:\"video_thumb\";i:72977;s:5:\"cover\";i:72535;s:4:\"orig\";i:4938006;}}i:364;a:14:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:12165;s:11:\"video_thumb\";i:256975;s:5:\"cover\";i:340550;s:4:\"orig\";i:9691449;}}i:365;a:14:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:36900;s:11:\"video_thumb\";i:920631;s:5:\"cover\";i:949012;s:4:\"orig\";i:13422013;}}i:366;a:14:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:17289;s:11:\"video_thumb\";i:137402;s:5:\"cover\";i:300574;s:4:\"orig\";i:7528458;}}i:367;a:14:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:16562;s:11:\"video_thumb\";i:161004;s:5:\"cover\";i:291708;s:4:\"orig\";i:7596827;}}i:368;a:14:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";s:9:\"file_size\";a:4:{s:5:\"thumb\";i:19186;s:11:\"video_thumb\";i:404406;s:5:\"cover\";i:496556;s:4:\"orig\";i:15358645;}}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}","no"),
("239","revslider_checktables","1","yes"),
("240","rs_tables_created","1","yes"),
("241","revslider_table_version","1.0.6","yes"),
("242","revslider-global-settings","a:0:{}","yes"),
("247","woocommerce_store_address","https://www.aneccullera.org","yes"),
("248","woocommerce_store_address_2","","yes"),
("249","woocommerce_store_city","","yes"),
("250","woocommerce_default_country","GB","yes"),
("251","woocommerce_store_postcode","","yes"),
("252","woocommerce_allowed_countries","all","yes"),
("253","woocommerce_all_except_countries","","yes"),
("254","woocommerce_specific_allowed_countries","","yes"),
("255","woocommerce_ship_to_countries","","yes"),
("256","woocommerce_specific_ship_to_countries","","yes"),
("257","woocommerce_default_customer_address","geolocation","yes"),
("258","woocommerce_calc_taxes","no","yes"),
("259","woocommerce_currency","GBP","yes"),
("260","woocommerce_currency_pos","left","yes"),
("261","woocommerce_price_thousand_sep",",","yes"),
("262","woocommerce_price_decimal_sep",".","yes"),
("263","woocommerce_price_num_decimals","2","yes"),
("264","woocommerce_shop_page_id","","yes"),
("265","woocommerce_cart_redirect_after_add","no","yes"),
("266","woocommerce_enable_ajax_add_to_cart","yes","yes"),
("267","woocommerce_weight_unit","kg","yes"),
("268","woocommerce_dimension_unit","cm","yes"),
("269","woocommerce_enable_reviews","yes","yes"),
("270","woocommerce_review_rating_verification_label","yes","no"),
("271","woocommerce_review_rating_verification_required","no","no"),
("272","woocommerce_enable_review_rating","yes","yes"),
("273","woocommerce_review_rating_required","yes","no"),
("274","woocommerce_manage_stock","yes","yes"),
("275","woocommerce_hold_stock_minutes","60","no"),
("276","woocommerce_notify_low_stock","yes","no"),
("277","woocommerce_notify_no_stock","yes","no"),
("278","woocommerce_stock_email_recipient","davidrgb@hotmail.com","no"),
("279","woocommerce_notify_low_stock_amount","2","no"),
("280","woocommerce_notify_no_stock_amount","0","yes"),
("281","woocommerce_hide_out_of_stock_items","no","yes"),
("282","woocommerce_stock_format","","yes"),
("283","woocommerce_file_download_method","force","no"),
("284","woocommerce_downloads_require_login","no","no"),
("285","woocommerce_downloads_grant_access_after_payment","yes","no"),
("286","woocommerce_prices_include_tax","no","yes"),
("287","woocommerce_tax_based_on","shipping","yes"),
("288","woocommerce_shipping_tax_class","inherit","yes"),
("289","woocommerce_tax_round_at_subtotal","no","yes"),
("290","woocommerce_tax_classes","Tasa reducida\nTasa cero","yes"),
("291","woocommerce_tax_display_shop","excl","yes"),
("292","woocommerce_tax_display_cart","excl","no"),
("293","woocommerce_price_display_suffix","","yes"),
("294","woocommerce_tax_total_display","itemized","no"),
("295","woocommerce_enable_shipping_calc","yes","no"),
("296","woocommerce_shipping_cost_requires_address","no","no"),
("297","woocommerce_ship_to_destination","billing","no"),
("298","woocommerce_shipping_debug_mode","no","no"),
("299","woocommerce_enable_coupons","yes","yes"),
("300","woocommerce_calc_discounts_sequentially","no","no"),
("301","woocommerce_enable_guest_checkout","yes","no"),
("302","woocommerce_force_ssl_checkout","no","yes"),
("303","woocommerce_unforce_ssl_checkout","no","yes"),
("304","woocommerce_cart_page_id","","yes"),
("305","woocommerce_checkout_page_id","","yes"),
("306","woocommerce_terms_page_id","","no"),
("307","woocommerce_checkout_pay_endpoint","order-pay","yes"),
("308","woocommerce_checkout_order_received_endpoint","order-received","yes"),
("309","woocommerce_myaccount_add_payment_method_endpoint","add-payment-method","yes"),
("310","woocommerce_myaccount_delete_payment_method_endpoint","delete-payment-method","yes"),
("311","woocommerce_myaccount_set_default_payment_method_endpoint","set-default-payment-method","yes"),
("312","woocommerce_myaccount_page_id","","yes"),
("313","woocommerce_enable_signup_and_login_from_checkout","yes","no"),
("314","woocommerce_enable_myaccount_registration","no","no"),
("315","woocommerce_enable_checkout_login_reminder","yes","no"),
("316","woocommerce_registration_generate_username","yes","no"),
("317","woocommerce_registration_generate_password","no","no"),
("318","woocommerce_myaccount_orders_endpoint","orders","yes"),
("319","woocommerce_myaccount_view_order_endpoint","view-order","yes"),
("320","woocommerce_myaccount_downloads_endpoint","downloads","yes"),
("321","woocommerce_myaccount_edit_account_endpoint","edit-account","yes"),
("322","woocommerce_myaccount_edit_address_endpoint","edit-address","yes"),
("323","woocommerce_myaccount_payment_methods_endpoint","payment-methods","yes"),
("324","woocommerce_myaccount_lost_password_endpoint","lost-password","yes"),
("325","woocommerce_logout_endpoint","customer-logout","yes"),
("326","woocommerce_email_from_name","Associació de necessitats especials de Cullera","no"),
("327","woocommerce_email_from_address","davidrgb@hotmail.com","no"),
("328","woocommerce_email_header_image","","no"),
("329","woocommerce_email_footer_text","{site_title}","no"),
("330","woocommerce_email_base_color","#96588a","no"),
("331","woocommerce_email_background_color","#f7f7f7","no"),
("332","woocommerce_email_body_background_color","#ffffff","no"),
("333","woocommerce_email_text_color","#3c3c3c","no"),
("334","woocommerce_api_enabled","yes","yes"),
("335","woocommerce_permalinks","a:5:{s:12:\"product_base\";s:8:\"producto\";s:13:\"category_base\";s:18:\"categoria-producto\";s:8:\"tag_base\";s:17:\"etiqueta-producto\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}","yes"),
("336","current_theme_supports_woocommerce","yes","yes"),
("337","woocommerce_queue_flush_rewrite_rules","no","yes"),
("338","_transient_wc_attribute_taxonomies","a:0:{}","yes"),
("340","default_product_cat","15","yes"),
("343","woocommerce_version","3.3.5","yes"),
("344","woocommerce_db_version","3.3.5","yes"),
("345","wpseo","a:19:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:5:\"7.5.1\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1525774135;}","yes"),
("346","wpseo_titles","a:130:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:40:\"%%name%%, autor en %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:58:\"Has buscado %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:42:\"Página no encontrada %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:60:\"La entrada %%POSTLINK%% se publicó primero en %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:32:\"Error 404: Página no encontrada\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:10:\"Archivo de\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:7:\"Portada\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:15:\"Has buscado por\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:13:\"title-project\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-project\";s:0:\"\";s:15:\"noindex-project\";b:0;s:16:\"showdate-project\";b:0;s:26:\"display-metabox-pt-project\";b:1;s:13:\"title-profile\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-profile\";s:0:\"\";s:15:\"noindex-profile\";b:0;s:16:\"showdate-profile\";b:0;s:26:\"display-metabox-pt-profile\";b:1;s:18:\"title-tribe_events\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tribe_events\";s:0:\"\";s:20:\"noindex-tribe_events\";b:0;s:21:\"showdate-tribe_events\";b:0;s:31:\"display-metabox-pt-tribe_events\";b:1;s:13:\"title-product\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-product\";s:0:\"\";s:15:\"noindex-product\";b:0;s:16:\"showdate-product\";b:0;s:26:\"display-metabox-pt-product\";b:1;s:23:\"title-ptarchive-project\";s:51:\"%%pt_plural%% archivo %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-project\";s:0:\"\";s:25:\"bctitle-ptarchive-project\";s:0:\"\";s:25:\"noindex-ptarchive-project\";b:0;s:23:\"title-ptarchive-profile\";s:51:\"%%pt_plural%% archivo %%page%% %%sep%% %%sitename%%\";s:26:\"metadesc-ptarchive-profile\";s:0:\"\";s:25:\"bctitle-ptarchive-profile\";s:0:\"\";s:25:\"noindex-ptarchive-profile\";b:0;s:28:\"title-ptarchive-tribe_events\";s:51:\"%%pt_plural%% archivo %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-ptarchive-tribe_events\";s:0:\"\";s:30:\"bctitle-ptarchive-tribe_events\";s:0:\"\";s:30:\"noindex-ptarchive-tribe_events\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:19:\"title-tax-pj-categs\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-tax-pj-categs\";s:0:\"\";s:29:\"display-metabox-tax-pj-categs\";b:1;s:21:\"noindex-tax-pj-categs\";b:0;s:17:\"title-tax-pj-tags\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:20:\"metadesc-tax-pj-tags\";s:0:\"\";s:27:\"display-metabox-tax-pj-tags\";b:1;s:19:\"noindex-tax-pj-tags\";b:0;s:19:\"title-tax-pl-categs\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-tax-pl-categs\";s:0:\"\";s:29:\"display-metabox-tax-pl-categs\";b:1;s:21:\"noindex-tax-pl-categs\";b:0;s:21:\"title-tax-product_cat\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_cat\";s:0:\"\";s:31:\"display-metabox-tax-product_cat\";b:1;s:23:\"noindex-tax-product_cat\";b:0;s:21:\"title-tax-product_tag\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-product_tag\";s:0:\"\";s:31:\"display-metabox-tax-product_tag\";b:1;s:23:\"noindex-tax-product_tag\";b:0;s:32:\"title-tax-product_shipping_class\";s:53:\"%%term_title%% archivos %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-product_shipping_class\";s:0:\"\";s:42:\"display-metabox-tax-product_shipping_class\";b:1;s:34:\"noindex-tax-product_shipping_class\";b:0;s:23:\"post_types-post-maintax\";i:0;s:26:\"post_types-project-maintax\";i:0;s:26:\"post_types-profile-maintax\";i:0;s:31:\"post_types-tribe_events-maintax\";i:0;s:26:\"post_types-product-maintax\";i:0;s:27:\"taxonomy-pj-categs-ptparent\";i:0;s:25:\"taxonomy-pj-tags-ptparent\";i:0;s:27:\"taxonomy-pl-categs-ptparent\";i:0;s:29:\"taxonomy-product_cat-ptparent\";i:0;s:29:\"taxonomy-product_tag-ptparent\";i:0;s:40:\"taxonomy-product_shipping_class-ptparent\";i:0;}","yes"),
("347","wpseo_social","a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}","yes"),
("348","wpseo_flush_rewrite","1","yes"),
("349","recently_activated","a:0:{}","off"),
("351","woocommerce_admin_notices","a:0:{}","yes"),
("352","revslider_update_version","5.2.5.5","yes"),
("355","_transient_woocommerce_webhook_ids","a:0:{}","yes"),
("356","tribe_events_calendar_options","a:44:{s:14:\"schema-version\";s:9:\"6.15.12.2\";s:21:\"previous_ecp_versions\";a:19:{i:0;s:1:\"0\";i:1;s:8:\"4.6.14.1\";i:2;s:6:\"4.6.16\";i:3;s:6:\"4.6.17\";i:4;s:6:\"4.6.18\";i:5;s:6:\"4.6.19\";i:6;s:6:\"4.6.21\";i:7;s:8:\"4.6.22.1\";i:8;s:6:\"4.6.23\";i:9;s:5:\"4.7.1\";i:10;s:5:\"4.7.4\";i:11;s:5:\"4.8.2\";i:12;s:5:\"4.9.2\";i:13;s:5:\"4.9.2\";i:14;s:7:\"4.9.3.1\";i:15;s:6:\"4.9.13\";i:16;s:6:\"4.9.13\";i:17;s:5:\"5.1.4\";i:18;s:5:\"5.1.5\";}s:18:\"latest_ecp_version\";s:9:\"6.15.12.2\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:24:\"front_page_event_archive\";b:0;s:11:\"donate-link\";b:0;s:12:\"postsPerPage\";s:3:\"100\";s:17:\"liveFiltersUpdate\";b:1;s:12:\"showComments\";b:0;s:20:\"showEventsInMainLoop\";b:0;s:10:\"eventsSlug\";s:6:\"events\";s:15:\"singleEventSlug\";s:5:\"event\";s:14:\"multiDayCutoff\";s:5:\"00:00\";s:21:\"defaultCurrencySymbol\";s:3:\"€\";s:23:\"reverseCurrencyPosition\";b:0;s:17:\"trash-past-events\";s:0:\"\";s:18:\"delete-past-events\";s:0:\"\";s:15:\"embedGoogleMaps\";b:1;s:19:\"embedGoogleMapsZoom\";s:2:\"10\";s:11:\"debugEvents\";b:0;s:26:\"tribe_events_timezone_mode\";s:5:\"event\";s:32:\"tribe_events_timezones_show_zone\";b:0;s:16:\"stylesheetOption\";s:8:\"skeleton\";s:19:\"tribeEventsTemplate\";s:7:\"default\";s:16:\"tribeEnableViews\";a:1:{i:0;s:5:\"month\";}s:10:\"viewOption\";s:5:\"month\";s:20:\"tribeDisableTribeBar\";b:0;s:16:\"monthEventAmount\";s:1:\"3\";s:23:\"enable_month_view_cache\";b:1;s:18:\"dateWithYearFormat\";s:6:\"j F, Y\";s:21:\"dateWithoutYearFormat\";s:3:\"F j\";s:18:\"monthAndYearFormat\";s:3:\"F Y\";s:17:\"dateTimeSeparator\";s:3:\" @ \";s:18:\"timeRangeSeparator\";s:3:\" - \";s:16:\"datepickerFormat\";s:1:\"2\";s:21:\"tribeEventsBeforeHTML\";s:0:\"\";s:20:\"tribeEventsAfterHTML\";s:0:\"\";s:13:\"earliest_date\";s:19:\"2018-06-03 11:00:00\";s:21:\"earliest_date_markers\";a:1:{i:0;s:4:\"3690\";}s:11:\"latest_date\";s:19:\"2018-06-03 15:00:00\";s:19:\"latest_date_markers\";a:1:{i:0;s:4:\"3690\";}s:39:\"last-update-message-the-events-calendar\";s:6:\"4.6.16\";s:8:\"did_init\";b:1;s:18:\"tec-schema-version\";s:6:\"6.10.0\";}","yes"),
("357","widget_rev-slider-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("358","widget_woocommerce_widget_cart","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("359","widget_woocommerce_layered_nav_filters","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("360","widget_woocommerce_layered_nav","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("361","widget_woocommerce_price_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("362","widget_woocommerce_product_categories","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("363","widget_woocommerce_product_search","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("364","widget_woocommerce_product_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("365","widget_woocommerce_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("366","widget_woocommerce_recently_viewed_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("367","widget_woocommerce_top_rated_products","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("368","widget_woocommerce_recent_reviews","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("369","widget_woocommerce_rating_filter","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("370","widget_tribe-events-list-widget","a:1:{s:12:\"_multiwidget\";i:1;}","yes"),
("371","tribe_last_save_post","1765538830.2236","yes"),
("375","woocommerce_meta_box_errors","a:0:{}","yes"),
("384","envato_market_state","activated","yes"),
("387","cmsms_style_dir_writable_econature","true","yes"),
("388","cmsms_style_exists_econature","true","yes"),
("397","woocommerce_maybe_regenerate_images_hash","26e274d71df3376ae9ec28aa1be26bbd","yes"),
("401","wpseo_sitemap_1_cache_validator","3vPnf","no"),
("402","wpseo_sitemap_customize_changeset_cache_validator","3THlE","no"),
("403","ls-store-last-updated","1739440249","yes"),
("404","ls-store-data","a:0:{}","no"),
("405","revslider-valid-notice","false","yes"),
("408","layerslider_update_info","O:8:\"stdClass\":7:{s:5:\"basic\";O:8:\"stdClass\":13:{s:4:\"slug\";s:11:\"LayerSlider\";s:6:\"plugin\";s:27:\"LayerSlider/layerslider.php\";s:7:\"version\";s:5:\"8.1.2\";s:8:\"released\";s:10:\"2025-12-08\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:3:\"url\";s:24:\"https://layerslider.com/\";s:7:\"package\";s:0:\"\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:5:\"5.4.0\";s:14:\"upgrade_notice\";s:189:\"LayerSlider 8.1 introduces the new Liquify Layer Effect, major upgrades to Scroll Scenes, gradient support for slide backgrounds, and numerous critical fixes and compatibility improvements.\";s:11:\"new_version\";s:5:\"8.1.2\";}s:4:\"full\";O:8:\"stdClass\":21:{s:4:\"name\";s:14:\"LayerSlider WP\";s:8:\"homepage\";s:24:\"https://layerslider.com/\";s:5:\"p_url\";s:32:\"https://layerslider.com/pricing/\";s:7:\"version\";s:5:\"8.1.2\";s:12:\"last_updated\";s:10:\"2025-12-08\";s:8:\"requires\";s:3:\"4.4\";s:6:\"tested\";s:3:\"6.9\";s:12:\"requires_php\";s:5:\"5.4.0\";s:6:\"rating\";s:2:\"95\";s:11:\"num_ratings\";i:3208;s:14:\"upgrade_notice\";a:3:{s:6:\"stable\";s:189:\"LayerSlider 8.1 introduces the new Liquify Layer Effect, major upgrades to Scroll Scenes, gradient support for slide backgrounds, and numerous critical fixes and compatibility improvements.\";s:4:\"beta\";s:189:\"LayerSlider 8.1 introduces the new Liquify Layer Effect, major upgrades to Scroll Scenes, gradient support for slide backgrounds, and numerous critical fixes and compatibility improvements.\";s:4:\"edge\";s:189:\"LayerSlider 8.1 introduces the new Liquify Layer Effect, major upgrades to Scroll Scenes, gradient support for slide backgrounds, and numerous critical fixes and compatibility improvements.\";}s:6:\"author\";s:71:\"<a href=\"https://kreaturamedia.com/\" target=\"_blank\">Kreatura Media</a>\";s:3:\"url\";s:24:\"https://layerslider.com/\";s:8:\"external\";b:1;s:9:\"file_name\";s:10:\"plugin.zip\";s:5:\"icons\";a:3:{s:2:\"1x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-128x128.png?ver=6.9.2\";s:2:\"2x\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";s:7:\"default\";s:89:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/icon-256x256.png?ver=6.9.2\";}s:7:\"banners\";a:3:{s:3:\"low\";s:94:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-772x250.png?ver=6.9.2\";s:4:\"high\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";s:7:\"default\";s:95:\"https://repository.kreaturamedia.com/v4/updates/1362246/assets/thumbnail-1544x500.png?ver=6.9.2\";}s:8:\"sections\";a:3:{s:9:\"changelog\";s:329:\"<p style=\"text-align: justify;\">\n	<a href=\"https://layerslider.com/release-log/\" target=\"_blank\">Click here to see the release log.</a> Don’t forget, the release log and all product-related news are also integrated right into LayerSlider. Look for the “LayerSlider News” section at the bottom of its main admin screen.\n</p>\";s:12:\"installation\";s:549:\"<p style=\"text-align: justify;\">\n	Updating the plugin won’t touch your sliders or settings. New versions always have backward compatibility. You don’t have to worry about losing your work. Not sure how to update? Check the <a href=\"https://layerslider.com/documentation/#updating\" target=\"_blank\">Updating</a> section of our online documentation.\n</p>\n\n<p style=\"text-align: justify;\">\n	If you’re experiencing unwanted changes, it is always a good idea to check your settings since there are probably new options to control those changes.\n</p>\";s:3:\"faq\";s:537:\"<p style=\"text-align: justify;\">\n	Please visit our <a href=\"https://layerslider.com/help/\" target=\"_blank\">Help</a> page, where you can find all sorts of useful assets like <a href=\"https://layerslider.com/faq/\" target=\"_blank\">FAQs</a>, <a href=\"https://layerslider.com/documentation/\" target=\"_blank\">online documentation</a>, <a href=\"https://layerslider.com/documentation/#troubleshooting\" target=\"_blank\">troubleshooting</a>, and <a href=\"https://layerslider.com/documentation/#support\" target=\"_blank\">support</a> information.\n</p>\";}s:4:\"slug\";s:11:\"LayerSlider\";s:7:\"package\";s:0:\"\";s:13:\"download_link\";s:0:\"\";}s:15:\"_latest_version\";s:5:\"8.1.2\";s:17:\"_important_notice\";a:9:{s:4:\"date\";s:10:\"2025-12-07\";s:5:\"title\";s:1:\" \";s:7:\"message\";s:557:\"<b>UPDATE REQUIRED:</b> You’re using an outdated version of LayerSlider, which lacks crucial fixes needed to be secure and compatible with the latest versions of PHP, WordPress, and popular 3rd party applications. The latest updates contain important security fixes, new features, countless improvements, and bug fixes. Please see the <a target=\"_blank\" href=\"https://layerslider.kreaturamedia.com/how-to-update/\">update instructions</a> or <a target=\"_blank\" href=\"https://layerslider.kreaturamedia.com/contact/\">contact us</a> if you have any questions.\";s:5:\"image\";s:0:\"\";s:6:\"banner\";a:5:{s:5:\"class\";s:0:\"\";s:5:\"style\";s:132:\"height: auto; margin: 39px auto 0 auto !important; min-width: 700px; max-width: 1700px; padding-right: 20px; box-sizing: border-box;\";s:3:\"url\";s:0:\"\";s:6:\"target\";s:6:\"_blank\";s:7:\"content\";s:2135:\"\n\n		<style>\n			@import url(\"https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;800&display=swap\");\n		</style>\n		<style>\n\n			body .layerslider_notice_img .dashicons-dismiss {\n				top: 0 !important;\n				right: 20px !important;\n			}\n\n			#lspr-inner {\n				position: relative;\n				height: auto;\n				margin: 0 auto !importa